/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.AttachmentType;
import org.unitime.timetable.model.LocationPicture;

@MappedSuperclass
public abstract class BaseLocationPicture
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private byte[] iDataFile;
    private String iFileName;
    private String iContentType;
    private Date iTimeStamp;
    private AttachmentType iType;

    public BaseLocationPicture() {
    }

    public BaseLocationPicture(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="room_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="data_file", nullable=false)
    public byte[] getDataFile() {
        return this.iDataFile;
    }

    public void setDataFile(byte[] dataFile) {
        this.iDataFile = dataFile;
    }

    @Column(name="file_name", nullable=false, length=260)
    public String getFileName() {
        return this.iFileName;
    }

    public void setFileName(String fileName) {
        this.iFileName = fileName;
    }

    @Column(name="content_type", nullable=false, length=260)
    public String getContentType() {
        return this.iContentType;
    }

    public void setContentType(String contentType) {
        this.iContentType = contentType;
    }

    @Column(name="time_stamp", nullable=false)
    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="type_id", nullable=true)
    public AttachmentType getType() {
        return this.iType;
    }

    public void setType(AttachmentType type) {
        this.iType = type;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof LocationPicture)) {
            return false;
        }
        if (this.getUniqueId() == null || ((LocationPicture)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((LocationPicture)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "LocationPicture[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "LocationPicture[\n\tContentType: " + this.getContentType() + "\n\tDataFile: " + String.valueOf(this.getDataFile()) + "\n\tFileName: " + this.getFileName() + "\n\tTimeStamp: " + String.valueOf(this.getTimeStamp()) + "\n\tType: " + String.valueOf(this.getType()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

