/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.Preference;

@MappedSuperclass
public abstract class BaseInstructorAttributePref
extends Preference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private InstructorAttribute iAttribute;

    public BaseInstructorAttributePref() {
    }

    public BaseInstructorAttributePref(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="attribute_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public InstructorAttribute getAttribute() {
        return this.iAttribute;
    }

    public void setAttribute(InstructorAttribute attribute) {
        this.iAttribute = attribute;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof InstructorAttributePref)) {
            return false;
        }
        if (this.getUniqueId() == null || ((InstructorAttributePref)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((InstructorAttributePref)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "InstructorAttributePref[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "InstructorAttributePref[\n\tAttribute: " + String.valueOf(this.getAttribute()) + "\n\tNote: " + this.getNote() + "\n\tOwner: " + String.valueOf(this.getOwner()) + "\n\tPrefLevel: " + String.valueOf(this.getPrefLevel()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

