/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributeType;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseInstructorAttribute
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iCode;
    private String iName;
    private InstructorAttributeType iType;
    private InstructorAttribute iParentAttribute;
    private Session iSession;
    private Department iDepartment;
    private Set<InstructorAttribute> iChildAttributes;
    private Set<DepartmentalInstructor> iInstructors;

    public BaseInstructorAttribute() {
    }

    public BaseInstructorAttribute(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="code", nullable=false, length=20)
    public String getCode() {
        return this.iCode;
    }

    public void setCode(String code) {
        this.iCode = code;
    }

    @Column(name="name", nullable=false, length=60)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="type_id", nullable=false)
    public InstructorAttributeType getType() {
        return this.iType;
    }

    public void setType(InstructorAttributeType type) {
        this.iType = type;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="parent_id", nullable=true)
    public InstructorAttribute getParentAttribute() {
        return this.iParentAttribute;
    }

    public void setParentAttribute(InstructorAttribute parentAttribute) {
        this.iParentAttribute = parentAttribute;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="department_id", nullable=true)
    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    @OneToMany(mappedBy="parentAttribute")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<InstructorAttribute> getChildAttributes() {
        return this.iChildAttributes;
    }

    public void setChildAttributes(Set<InstructorAttribute> childAttributes) {
        this.iChildAttributes = childAttributes;
    }

    public void addToChildAttributes(InstructorAttribute instructorAttribute) {
        if (this.iChildAttributes == null) {
            this.iChildAttributes = new HashSet<InstructorAttribute>();
        }
        this.iChildAttributes.add(instructorAttribute);
    }

    @Deprecated
    public void addTochildAttributes(InstructorAttribute instructorAttribute) {
        this.addToChildAttributes(instructorAttribute);
    }

    @ManyToMany(mappedBy="attributes")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<DepartmentalInstructor> getInstructors() {
        return this.iInstructors;
    }

    public void setInstructors(Set<DepartmentalInstructor> instructors) {
        this.iInstructors = instructors;
    }

    public void addToInstructors(DepartmentalInstructor departmentalInstructor) {
        if (this.iInstructors == null) {
            this.iInstructors = new HashSet<DepartmentalInstructor>();
        }
        this.iInstructors.add(departmentalInstructor);
    }

    @Deprecated
    public void addToinstructors(DepartmentalInstructor departmentalInstructor) {
        this.addToInstructors(departmentalInstructor);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof InstructorAttribute)) {
            return false;
        }
        if (this.getUniqueId() == null || ((InstructorAttribute)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((InstructorAttribute)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "InstructorAttribute[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "InstructorAttribute[\n\tCode: " + this.getCode() + "\n\tDepartment: " + String.valueOf(this.getDepartment()) + "\n\tName: " + this.getName() + "\n\tParentAttribute: " + String.valueOf(this.getParentAttribute()) + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tType: " + String.valueOf(this.getType()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

