/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Formula;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TeachingRequest;

@MappedSuperclass
public abstract class BaseInstructionalOffering
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Long iInstrOfferingPermId;
    private Boolean iNotOffered;
    private Integer iEnrollment;
    private Long iUniqueIdRolledForwardFrom;
    private String iExternalUniqueId;
    private Boolean iByReservationOnly;
    private Integer iLastWeekToEnroll;
    private Integer iLastWeekToChange;
    private Integer iLastWeekToDrop;
    private String iNotes;
    private Integer iSnapshotLimit;
    private Date iSnapshotLimitDate;
    private Integer iWaitlistMode;
    private Session iSession;
    private Set<CourseOffering> iCourseOfferings;
    private Set<InstrOfferingConfig> iInstrOfferingConfigs;
    private Set<Reservation> iReservations;
    private Set<OfferingCoordinator> iOfferingCoordinators;
    private Set<TeachingRequest> iTeachingRequests;

    public BaseInstructionalOffering() {
    }

    public BaseInstructionalOffering(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="instr_offr_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="instr_offering_perm_id", nullable=false, length=20)
    public Long getInstrOfferingPermId() {
        return this.iInstrOfferingPermId;
    }

    public void setInstrOfferingPermId(Long instrOfferingPermId) {
        this.iInstrOfferingPermId = instrOfferingPermId;
    }

    @Column(name="not_offered", nullable=false)
    public Boolean isNotOffered() {
        return this.iNotOffered;
    }

    @Transient
    public Boolean getNotOffered() {
        return this.iNotOffered;
    }

    public void setNotOffered(Boolean notOffered) {
        this.iNotOffered = notOffered;
    }

    @Formula(value="(select count(distinct e.student_id) from %SCHEMA%.student_class_enrl e inner join %SCHEMA%.course_offering co on co.uniqueid = e.course_offering_id where co.instr_offr_id = uniqueid)")
    public Integer getEnrollment() {
        return this.iEnrollment;
    }

    public void setEnrollment(Integer enrollment) {
        this.iEnrollment = enrollment;
    }

    @Column(name="uid_rolled_fwd_from", nullable=true, length=20)
    public Long getUniqueIdRolledForwardFrom() {
        return this.iUniqueIdRolledForwardFrom;
    }

    public void setUniqueIdRolledForwardFrom(Long uniqueIdRolledForwardFrom) {
        this.iUniqueIdRolledForwardFrom = uniqueIdRolledForwardFrom;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="req_reservation", nullable=false)
    public Boolean isByReservationOnly() {
        return this.iByReservationOnly;
    }

    @Transient
    public Boolean getByReservationOnly() {
        return this.iByReservationOnly;
    }

    public void setByReservationOnly(Boolean byReservationOnly) {
        this.iByReservationOnly = byReservationOnly;
    }

    @Column(name="wk_enroll", nullable=true)
    public Integer getLastWeekToEnroll() {
        return this.iLastWeekToEnroll;
    }

    public void setLastWeekToEnroll(Integer lastWeekToEnroll) {
        this.iLastWeekToEnroll = lastWeekToEnroll;
    }

    @Column(name="wk_change", nullable=true)
    public Integer getLastWeekToChange() {
        return this.iLastWeekToChange;
    }

    public void setLastWeekToChange(Integer lastWeekToChange) {
        this.iLastWeekToChange = lastWeekToChange;
    }

    @Column(name="wk_drop", nullable=true)
    public Integer getLastWeekToDrop() {
        return this.iLastWeekToDrop;
    }

    public void setLastWeekToDrop(Integer lastWeekToDrop) {
        this.iLastWeekToDrop = lastWeekToDrop;
    }

    @Column(name="notes", nullable=true, length=2000)
    public String getNotes() {
        return this.iNotes;
    }

    public void setNotes(String notes) {
        this.iNotes = notes;
    }

    @Column(name="snapshot_limit", nullable=true, length=10)
    public Integer getSnapshotLimit() {
        return this.iSnapshotLimit;
    }

    public void setSnapshotLimit(Integer snapshotLimit) {
        this.iSnapshotLimit = snapshotLimit;
    }

    @Column(name="snapshot_limit_date", nullable=true)
    public Date getSnapshotLimitDate() {
        return this.iSnapshotLimitDate;
    }

    public void setSnapshotLimitDate(Date snapshotLimitDate) {
        this.iSnapshotLimitDate = snapshotLimitDate;
    }

    @Column(name="waitlist", nullable=true)
    public Integer getWaitlistMode() {
        return this.iWaitlistMode;
    }

    public void setWaitlistMode(Integer waitlistMode) {
        this.iWaitlistMode = waitlistMode;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="instructionalOffering", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<CourseOffering> getCourseOfferings() {
        return this.iCourseOfferings;
    }

    public void setCourseOfferings(Set<CourseOffering> courseOfferings) {
        this.iCourseOfferings = courseOfferings;
    }

    public void addToCourseOfferings(CourseOffering courseOffering) {
        if (this.iCourseOfferings == null) {
            this.iCourseOfferings = new HashSet<CourseOffering>();
        }
        this.iCourseOfferings.add(courseOffering);
    }

    @Deprecated
    public void addTocourseOfferings(CourseOffering courseOffering) {
        this.addToCourseOfferings(courseOffering);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="instructionalOffering", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<InstrOfferingConfig> getInstrOfferingConfigs() {
        return this.iInstrOfferingConfigs;
    }

    public void setInstrOfferingConfigs(Set<InstrOfferingConfig> instrOfferingConfigs) {
        this.iInstrOfferingConfigs = instrOfferingConfigs;
    }

    public void addToInstrOfferingConfigs(InstrOfferingConfig instrOfferingConfig) {
        if (this.iInstrOfferingConfigs == null) {
            this.iInstrOfferingConfigs = new HashSet<InstrOfferingConfig>();
        }
        this.iInstrOfferingConfigs.add(instrOfferingConfig);
    }

    @Deprecated
    public void addToinstrOfferingConfigs(InstrOfferingConfig instrOfferingConfig) {
        this.addToInstrOfferingConfigs(instrOfferingConfig);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="instructionalOffering")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Reservation> getReservations() {
        return this.iReservations;
    }

    public void setReservations(Set<Reservation> reservations) {
        this.iReservations = reservations;
    }

    public void addToReservations(Reservation reservation) {
        if (this.iReservations == null) {
            this.iReservations = new HashSet<Reservation>();
        }
        this.iReservations.add(reservation);
    }

    @Deprecated
    public void addToreservations(Reservation reservation) {
        this.addToReservations(reservation);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="offering")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<OfferingCoordinator> getOfferingCoordinators() {
        return this.iOfferingCoordinators;
    }

    public void setOfferingCoordinators(Set<OfferingCoordinator> offeringCoordinators) {
        this.iOfferingCoordinators = offeringCoordinators;
    }

    public void addToOfferingCoordinators(OfferingCoordinator offeringCoordinator) {
        if (this.iOfferingCoordinators == null) {
            this.iOfferingCoordinators = new HashSet<OfferingCoordinator>();
        }
        this.iOfferingCoordinators.add(offeringCoordinator);
    }

    @Deprecated
    public void addToofferingCoordinators(OfferingCoordinator offeringCoordinator) {
        this.addToOfferingCoordinators(offeringCoordinator);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="offering", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<TeachingRequest> getTeachingRequests() {
        return this.iTeachingRequests;
    }

    public void setTeachingRequests(Set<TeachingRequest> teachingRequests) {
        this.iTeachingRequests = teachingRequests;
    }

    public void addToTeachingRequests(TeachingRequest teachingRequest) {
        if (this.iTeachingRequests == null) {
            this.iTeachingRequests = new HashSet<TeachingRequest>();
        }
        this.iTeachingRequests.add(teachingRequest);
    }

    @Deprecated
    public void addToteachingRequests(TeachingRequest teachingRequest) {
        this.addToTeachingRequests(teachingRequest);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof InstructionalOffering)) {
            return false;
        }
        if (this.getUniqueId() == null || ((InstructionalOffering)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((InstructionalOffering)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "InstructionalOffering[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "InstructionalOffering[\n\tByReservationOnly: " + this.getByReservationOnly() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tInstrOfferingPermId: " + this.getInstrOfferingPermId() + "\n\tLastWeekToChange: " + this.getLastWeekToChange() + "\n\tLastWeekToDrop: " + this.getLastWeekToDrop() + "\n\tLastWeekToEnroll: " + this.getLastWeekToEnroll() + "\n\tNotOffered: " + this.getNotOffered() + "\n\tNotes: " + this.getNotes() + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tSnapshotLimit: " + this.getSnapshotLimit() + "\n\tSnapshotLimitDate: " + String.valueOf(this.getSnapshotLimitDate()) + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUniqueIdRolledForwardFrom: " + this.getUniqueIdRolledForwardFrom() + "\n\tWaitlistMode: " + this.getWaitlistMode() + "]";
    }
}

