/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.ExternalBuilding;
import org.unitime.timetable.model.ExternalRoom;
import org.unitime.timetable.model.ExternalRoomDepartment;
import org.unitime.timetable.model.ExternalRoomFeature;
import org.unitime.timetable.model.RoomType;

@MappedSuperclass
public abstract class BaseExternalRoom
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iRoomNumber;
    private Double iCoordinateX;
    private Double iCoordinateY;
    private Integer iCapacity;
    private Integer iExamCapacity;
    private String iClassification;
    private Boolean iIsInstructional;
    private String iDisplayName;
    private Double iArea;
    private RoomType iRoomType;
    private ExternalBuilding iBuilding;
    private Set<ExternalRoomDepartment> iRoomDepartments;
    private Set<ExternalRoomFeature> iRoomFeatures;

    public BaseExternalRoom() {
    }

    public BaseExternalRoom(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="room_number", nullable=false, length=40)
    public String getRoomNumber() {
        return this.iRoomNumber;
    }

    public void setRoomNumber(String roomNumber) {
        this.iRoomNumber = roomNumber;
    }

    @Column(name="coordinate_x", nullable=true)
    public Double getCoordinateX() {
        return this.iCoordinateX;
    }

    public void setCoordinateX(Double coordinateX) {
        this.iCoordinateX = coordinateX;
    }

    @Column(name="coordinate_y", nullable=true)
    public Double getCoordinateY() {
        return this.iCoordinateY;
    }

    public void setCoordinateY(Double coordinateY) {
        this.iCoordinateY = coordinateY;
    }

    @Column(name="capacity", nullable=false, length=6)
    public Integer getCapacity() {
        return this.iCapacity;
    }

    public void setCapacity(Integer capacity) {
        this.iCapacity = capacity;
    }

    @Column(name="exam_capacity", nullable=true, length=6)
    public Integer getExamCapacity() {
        return this.iExamCapacity;
    }

    public void setExamCapacity(Integer examCapacity) {
        this.iExamCapacity = examCapacity;
    }

    @Column(name="classification", nullable=false, length=20)
    public String getClassification() {
        return this.iClassification;
    }

    public void setClassification(String classification) {
        this.iClassification = classification;
    }

    @Column(name="instructional", nullable=false)
    public Boolean isIsInstructional() {
        return this.iIsInstructional;
    }

    @Transient
    public Boolean getIsInstructional() {
        return this.iIsInstructional;
    }

    public void setIsInstructional(Boolean isInstructional) {
        this.iIsInstructional = isInstructional;
    }

    @Column(name="display_name", nullable=true, length=100)
    public String getDisplayName() {
        return this.iDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.iDisplayName = displayName;
    }

    @Column(name="area", nullable=true)
    public Double getArea() {
        return this.iArea;
    }

    public void setArea(Double area) {
        this.iArea = area;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="room_type", nullable=false)
    public RoomType getRoomType() {
        return this.iRoomType;
    }

    public void setRoomType(RoomType roomType) {
        this.iRoomType = roomType;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="external_bldg_id", nullable=false)
    public ExternalBuilding getBuilding() {
        return this.iBuilding;
    }

    public void setBuilding(ExternalBuilding building) {
        this.iBuilding = building;
    }

    @OneToMany
    @JoinColumn(name="external_room_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ExternalRoomDepartment> getRoomDepartments() {
        return this.iRoomDepartments;
    }

    public void setRoomDepartments(Set<ExternalRoomDepartment> roomDepartments) {
        this.iRoomDepartments = roomDepartments;
    }

    public void addToRoomDepartments(ExternalRoomDepartment externalRoomDepartment) {
        if (this.iRoomDepartments == null) {
            this.iRoomDepartments = new HashSet<ExternalRoomDepartment>();
        }
        this.iRoomDepartments.add(externalRoomDepartment);
    }

    @Deprecated
    public void addToroomDepartments(ExternalRoomDepartment externalRoomDepartment) {
        this.addToRoomDepartments(externalRoomDepartment);
    }

    @OneToMany
    @JoinColumn(name="external_room_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ExternalRoomFeature> getRoomFeatures() {
        return this.iRoomFeatures;
    }

    public void setRoomFeatures(Set<ExternalRoomFeature> roomFeatures) {
        this.iRoomFeatures = roomFeatures;
    }

    public void addToRoomFeatures(ExternalRoomFeature externalRoomFeature) {
        if (this.iRoomFeatures == null) {
            this.iRoomFeatures = new HashSet<ExternalRoomFeature>();
        }
        this.iRoomFeatures.add(externalRoomFeature);
    }

    @Deprecated
    public void addToroomFeatures(ExternalRoomFeature externalRoomFeature) {
        this.addToRoomFeatures(externalRoomFeature);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExternalRoom)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ExternalRoom)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ExternalRoom)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "ExternalRoom[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "ExternalRoom[\n\tArea: " + this.getArea() + "\n\tBuilding: " + String.valueOf(this.getBuilding()) + "\n\tCapacity: " + this.getCapacity() + "\n\tClassification: " + this.getClassification() + "\n\tCoordinateX: " + this.getCoordinateX() + "\n\tCoordinateY: " + this.getCoordinateY() + "\n\tDisplayName: " + this.getDisplayName() + "\n\tExamCapacity: " + this.getExamCapacity() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tIsInstructional: " + this.getIsInstructional() + "\n\tRoomNumber: " + this.getRoomNumber() + "\n\tRoomType: " + String.valueOf(this.getRoomType()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

