/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.ExternalBuilding;
import org.unitime.timetable.model.ExternalRoom;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseExternalBuilding
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iAbbreviation;
    private Double iCoordinateX;
    private Double iCoordinateY;
    private String iDisplayName;
    private Session iSession;
    private Set<ExternalRoom> iRooms;

    public BaseExternalBuilding() {
    }

    public BaseExternalBuilding(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="abbreviation", nullable=false, length=20)
    public String getAbbreviation() {
        return this.iAbbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.iAbbreviation = abbreviation;
    }

    @Column(name="coordinate_x", nullable=true)
    public Double getCoordinateX() {
        return this.iCoordinateX;
    }

    public void setCoordinateX(Double coordinateX) {
        this.iCoordinateX = coordinateX;
    }

    @Column(name="coordinate_y", nullable=true)
    public Double getCoordinateY() {
        return this.iCoordinateY;
    }

    public void setCoordinateY(Double coordinateY) {
        this.iCoordinateY = coordinateY;
    }

    @Column(name="display_name", nullable=true, length=100)
    public String getDisplayName() {
        return this.iDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.iDisplayName = displayName;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @OneToMany
    @JoinColumn(name="external_bldg_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ExternalRoom> getRooms() {
        return this.iRooms;
    }

    public void setRooms(Set<ExternalRoom> rooms) {
        this.iRooms = rooms;
    }

    public void addToRooms(ExternalRoom externalRoom) {
        if (this.iRooms == null) {
            this.iRooms = new HashSet<ExternalRoom>();
        }
        this.iRooms.add(externalRoom);
    }

    @Deprecated
    public void addTorooms(ExternalRoom externalRoom) {
        this.addToRooms(externalRoom);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExternalBuilding)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ExternalBuilding)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ExternalBuilding)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "ExternalBuilding[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "ExternalBuilding[\n\tAbbreviation: " + this.getAbbreviation() + "\n\tCoordinateX: " + this.getCoordinateX() + "\n\tCoordinateY: " + this.getCoordinateY() + "\n\tDisplayName: " + this.getDisplayName() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

