/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.Meeting;

@MappedSuperclass
public abstract class BaseEventNote
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iNoteType;
    private String iTextNote;
    private Date iTimeStamp;
    private String iUser;
    private String iUserId;
    private String iMeetings;
    private byte[] iAttachedFile;
    private String iAttachedName;
    private String iAttachedContentType;
    private Event iEvent;
    private Set<Meeting> iAffectedMeetings;

    public BaseEventNote() {
    }

    public BaseEventNote(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="note_type", nullable=false, length=10)
    public Integer getNoteType() {
        return this.iNoteType;
    }

    public void setNoteType(Integer noteType) {
        this.iNoteType = noteType;
    }

    @Column(name="text_note", nullable=true, length=2000)
    public String getTextNote() {
        return this.iTextNote;
    }

    public void setTextNote(String textNote) {
        this.iTextNote = textNote;
    }

    @Column(name="time_stamp", nullable=false)
    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    @Column(name="uname", nullable=true, length=100)
    public String getUser() {
        return this.iUser;
    }

    public void setUser(String user) {
        this.iUser = user;
    }

    @Column(name="user_id", nullable=true, length=40)
    public String getUserId() {
        return this.iUserId;
    }

    public void setUserId(String userId) {
        this.iUserId = userId;
    }

    @Column(name="meetings", nullable=true)
    public String getMeetings() {
        return this.iMeetings;
    }

    public void setMeetings(String meetings) {
        this.iMeetings = meetings;
    }

    @Column(name="attached_file", nullable=true)
    public byte[] getAttachedFile() {
        return this.iAttachedFile;
    }

    public void setAttachedFile(byte[] attachedFile) {
        this.iAttachedFile = attachedFile;
    }

    @Column(name="attached_name", nullable=true, length=260)
    public String getAttachedName() {
        return this.iAttachedName;
    }

    public void setAttachedName(String attachedName) {
        this.iAttachedName = attachedName;
    }

    @Column(name="attached_content", nullable=true, length=260)
    public String getAttachedContentType() {
        return this.iAttachedContentType;
    }

    public void setAttachedContentType(String attachedContentType) {
        this.iAttachedContentType = attachedContentType;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="event_id", nullable=false)
    public Event getEvent() {
        return this.iEvent;
    }

    public void setEvent(Event event) {
        this.iEvent = event;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="event_note_meeting", joinColumns={@JoinColumn(name="note_id")}, inverseJoinColumns={@JoinColumn(name="meeting_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Meeting> getAffectedMeetings() {
        return this.iAffectedMeetings;
    }

    public void setAffectedMeetings(Set<Meeting> affectedMeetings) {
        this.iAffectedMeetings = affectedMeetings;
    }

    public void addToAffectedMeetings(Meeting meeting) {
        if (this.iAffectedMeetings == null) {
            this.iAffectedMeetings = new HashSet<Meeting>();
        }
        this.iAffectedMeetings.add(meeting);
    }

    @Deprecated
    public void addToaffectedMeetings(Meeting meeting) {
        this.addToAffectedMeetings(meeting);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EventNote)) {
            return false;
        }
        if (this.getUniqueId() == null || ((EventNote)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((EventNote)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "EventNote[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "EventNote[\n\tAttachedContentType: " + this.getAttachedContentType() + "\n\tAttachedFile: " + String.valueOf(this.getAttachedFile()) + "\n\tAttachedName: " + this.getAttachedName() + "\n\tEvent: " + String.valueOf(this.getEvent()) + "\n\tMeetings: " + this.getMeetings() + "\n\tNoteType: " + this.getNoteType() + "\n\tTextNote: " + this.getTextNote() + "\n\tTimeStamp: " + String.valueOf(this.getTimeStamp()) + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUser: " + this.getUser() + "\n\tUserId: " + this.getUserId() + "]";
    }
}

