/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.ClassWaitList;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.StudentSectioningPref;

@MappedSuperclass
public abstract class BaseCourseRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iOrder;
    private Boolean iAllowOverlap;
    private Integer iCredit;
    private Integer iOverrideStatus;
    private String iOverrideExternalId;
    private Date iOverrideTimeStamp;
    private Integer iOverrideIntent;
    private CourseDemand iCourseDemand;
    private CourseOffering iCourseOffering;
    private Set<CourseRequestOption> iCourseRequestOptions;
    private Set<ClassWaitList> iClassWaitLists;
    private Set<StudentSectioningPref> iPreferences;

    public BaseCourseRequest() {
    }

    public BaseCourseRequest(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="ord", nullable=false, length=10)
    public Integer getOrder() {
        return this.iOrder;
    }

    public void setOrder(Integer order) {
        this.iOrder = order;
    }

    @Column(name="allow_overlap", nullable=false)
    public Boolean isAllowOverlap() {
        return this.iAllowOverlap;
    }

    @Transient
    public Boolean getAllowOverlap() {
        return this.iAllowOverlap;
    }

    public void setAllowOverlap(Boolean allowOverlap) {
        this.iAllowOverlap = allowOverlap;
    }

    @Column(name="credit", nullable=false, length=10)
    public Integer getCredit() {
        return this.iCredit;
    }

    public void setCredit(Integer credit) {
        this.iCredit = credit;
    }

    @Column(name="req_status", nullable=true, length=10)
    public Integer getOverrideStatus() {
        return this.iOverrideStatus;
    }

    public void setOverrideStatus(Integer overrideStatus) {
        this.iOverrideStatus = overrideStatus;
    }

    @Column(name="req_extid", nullable=true, length=40)
    public String getOverrideExternalId() {
        return this.iOverrideExternalId;
    }

    public void setOverrideExternalId(String overrideExternalId) {
        this.iOverrideExternalId = overrideExternalId;
    }

    @Column(name="req_ts", nullable=true)
    public Date getOverrideTimeStamp() {
        return this.iOverrideTimeStamp;
    }

    public void setOverrideTimeStamp(Date overrideTimeStamp) {
        this.iOverrideTimeStamp = overrideTimeStamp;
    }

    @Column(name="req_intent", nullable=true, length=10)
    public Integer getOverrideIntent() {
        return this.iOverrideIntent;
    }

    public void setOverrideIntent(Integer overrideIntent) {
        this.iOverrideIntent = overrideIntent;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="course_demand_id", nullable=false)
    public CourseDemand getCourseDemand() {
        return this.iCourseDemand;
    }

    public void setCourseDemand(CourseDemand courseDemand) {
        this.iCourseDemand = courseDemand;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="course_offering_id", nullable=false)
    public CourseOffering getCourseOffering() {
        return this.iCourseOffering;
    }

    public void setCourseOffering(CourseOffering courseOffering) {
        this.iCourseOffering = courseOffering;
    }

    @OneToMany(mappedBy="courseRequest", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<CourseRequestOption> getCourseRequestOptions() {
        return this.iCourseRequestOptions;
    }

    public void setCourseRequestOptions(Set<CourseRequestOption> courseRequestOptions) {
        this.iCourseRequestOptions = courseRequestOptions;
    }

    public void addToCourseRequestOptions(CourseRequestOption courseRequestOption) {
        if (this.iCourseRequestOptions == null) {
            this.iCourseRequestOptions = new HashSet<CourseRequestOption>();
        }
        this.iCourseRequestOptions.add(courseRequestOption);
    }

    @Deprecated
    public void addTocourseRequestOptions(CourseRequestOption courseRequestOption) {
        this.addToCourseRequestOptions(courseRequestOption);
    }

    @OneToMany(mappedBy="courseRequest", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ClassWaitList> getClassWaitLists() {
        return this.iClassWaitLists;
    }

    public void setClassWaitLists(Set<ClassWaitList> classWaitLists) {
        this.iClassWaitLists = classWaitLists;
    }

    public void addToClassWaitLists(ClassWaitList classWaitList) {
        if (this.iClassWaitLists == null) {
            this.iClassWaitLists = new HashSet<ClassWaitList>();
        }
        this.iClassWaitLists.add(classWaitList);
    }

    @Deprecated
    public void addToclassWaitLists(ClassWaitList classWaitList) {
        this.addToClassWaitLists(classWaitList);
    }

    @OneToMany(mappedBy="courseRequest", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<StudentSectioningPref> getPreferences() {
        return this.iPreferences;
    }

    public void setPreferences(Set<StudentSectioningPref> preferences) {
        this.iPreferences = preferences;
    }

    public void addToPreferences(StudentSectioningPref studentSectioningPref) {
        if (this.iPreferences == null) {
            this.iPreferences = new HashSet<StudentSectioningPref>();
        }
        this.iPreferences.add(studentSectioningPref);
    }

    @Deprecated
    public void addTopreferences(StudentSectioningPref studentSectioningPref) {
        this.addToPreferences(studentSectioningPref);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CourseRequest)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CourseRequest)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CourseRequest)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "CourseRequest[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "CourseRequest[\n\tAllowOverlap: " + this.getAllowOverlap() + "\n\tCourseDemand: " + String.valueOf(this.getCourseDemand()) + "\n\tCourseOffering: " + String.valueOf(this.getCourseOffering()) + "\n\tCredit: " + this.getCredit() + "\n\tOrder: " + this.getOrder() + "\n\tOverrideExternalId: " + this.getOverrideExternalId() + "\n\tOverrideIntent: " + this.getOverrideIntent() + "\n\tOverrideStatus: " + this.getOverrideStatus() + "\n\tOverrideTimeStamp: " + String.valueOf(this.getOverrideTimeStamp()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

