/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Formula;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.DemandOfferingType;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.OverrideType;
import org.unitime.timetable.model.SubjectArea;

@MappedSuperclass
public abstract class BaseCourseOffering
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Boolean iIsControl;
    private String iPermId;
    private Integer iProjectedDemand;
    private Integer iNbrExpectedStudents;
    private Integer iDemand;
    private Integer iEnrollment;
    private Integer iReservation;
    private String iSubjectAreaAbbv;
    private String iCourseNbr;
    private String iTitle;
    private String iScheduleBookNote;
    private String iExternalUniqueId;
    private Long iUniqueIdRolledForwardFrom;
    private Integer iSnapshotProjectedDemand;
    private Date iSnapshotProjectedDemandDate;
    private SubjectArea iSubjectArea;
    private InstructionalOffering iInstructionalOffering;
    private CourseOffering iDemandOffering;
    private DemandOfferingType iDemandOfferingType;
    private CourseType iCourseType;
    private OfferingConsentType iConsentType;
    private CourseOffering iAlternativeOffering;
    private Department iFundingDept;
    private CourseOffering iParentOffering;
    private Set<CourseCreditUnitConfig> iCreditConfigs;
    private Set<OverrideType> iDisabledOverrides;

    public BaseCourseOffering() {
    }

    public BaseCourseOffering(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="crs_offr_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="is_control", nullable=false)
    public Boolean isIsControl() {
        return this.iIsControl;
    }

    @Transient
    public Boolean getIsControl() {
        return this.iIsControl;
    }

    public void setIsControl(Boolean isControl) {
        this.iIsControl = isControl;
    }

    @Column(name="perm_id", nullable=true, length=20)
    public String getPermId() {
        return this.iPermId;
    }

    public void setPermId(String permId) {
        this.iPermId = permId;
    }

    @Column(name="proj_demand", nullable=true, length=5)
    public Integer getProjectedDemand() {
        return this.iProjectedDemand;
    }

    public void setProjectedDemand(Integer projectedDemand) {
        this.iProjectedDemand = projectedDemand;
    }

    @Column(name="nbr_expected_stdents", nullable=false, length=10)
    public Integer getNbrExpectedStudents() {
        return this.iNbrExpectedStudents;
    }

    public void setNbrExpectedStudents(Integer nbrExpectedStudents) {
        this.iNbrExpectedStudents = nbrExpectedStudents;
    }

    @Column(name="lastlike_demand", nullable=false, length=10)
    public Integer getDemand() {
        return this.iDemand;
    }

    public void setDemand(Integer demand) {
        this.iDemand = demand;
    }

    @Formula(value="(select count(distinct e.student_id) from %SCHEMA%.student_class_enrl e where e.course_offering_id = uniqueid)")
    public Integer getEnrollment() {
        return this.iEnrollment;
    }

    public void setEnrollment(Integer enrollment) {
        this.iEnrollment = enrollment;
    }

    @Column(name="reservation", nullable=true, length=10)
    public Integer getReservation() {
        return this.iReservation;
    }

    public void setReservation(Integer reservation) {
        this.iReservation = reservation;
    }

    @Formula(value=" ( select sa.subject_area_abbreviation from %SCHEMA%.subject_area sa where sa.uniqueid = subject_area_id ) ")
    public String getSubjectAreaAbbv() {
        return this.iSubjectAreaAbbv;
    }

    public void setSubjectAreaAbbv(String subjectAreaAbbv) {
        this.iSubjectAreaAbbv = subjectAreaAbbv;
    }

    @Column(name="course_nbr", nullable=false, length=40)
    public String getCourseNbr() {
        return this.iCourseNbr;
    }

    public void setCourseNbr(String courseNbr) {
        this.iCourseNbr = courseNbr;
    }

    @Column(name="title", nullable=true, length=200)
    public String getTitle() {
        return this.iTitle;
    }

    public void setTitle(String title) {
        this.iTitle = title;
    }

    @Column(name="schedule_book_note", nullable=true, length=1000)
    public String getScheduleBookNote() {
        return this.iScheduleBookNote;
    }

    public void setScheduleBookNote(String scheduleBookNote) {
        this.iScheduleBookNote = scheduleBookNote;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="uid_rolled_fwd_from", nullable=true, length=20)
    public Long getUniqueIdRolledForwardFrom() {
        return this.iUniqueIdRolledForwardFrom;
    }

    public void setUniqueIdRolledForwardFrom(Long uniqueIdRolledForwardFrom) {
        this.iUniqueIdRolledForwardFrom = uniqueIdRolledForwardFrom;
    }

    @Column(name="snapshot_proj_demand", nullable=true, length=5)
    public Integer getSnapshotProjectedDemand() {
        return this.iSnapshotProjectedDemand;
    }

    public void setSnapshotProjectedDemand(Integer snapshotProjectedDemand) {
        this.iSnapshotProjectedDemand = snapshotProjectedDemand;
    }

    @Column(name="snapshot_prj_dmd_date", nullable=true)
    public Date getSnapshotProjectedDemandDate() {
        return this.iSnapshotProjectedDemandDate;
    }

    public void setSnapshotProjectedDemandDate(Date snapshotProjectedDemandDate) {
        this.iSnapshotProjectedDemandDate = snapshotProjectedDemandDate;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="subject_area_id", nullable=false)
    public SubjectArea getSubjectArea() {
        return this.iSubjectArea;
    }

    public void setSubjectArea(SubjectArea subjectArea) {
        this.iSubjectArea = subjectArea;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="instr_offr_id", nullable=false)
    public InstructionalOffering getInstructionalOffering() {
        return this.iInstructionalOffering;
    }

    public void setInstructionalOffering(InstructionalOffering instructionalOffering) {
        this.iInstructionalOffering = instructionalOffering;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="demand_offering_id", nullable=true)
    public CourseOffering getDemandOffering() {
        return this.iDemandOffering;
    }

    public void setDemandOffering(CourseOffering demandOffering) {
        this.iDemandOffering = demandOffering;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="demand_offering_type", nullable=true)
    public DemandOfferingType getDemandOfferingType() {
        return this.iDemandOfferingType;
    }

    public void setDemandOfferingType(DemandOfferingType demandOfferingType) {
        this.iDemandOfferingType = demandOfferingType;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="course_type_id", nullable=true)
    public CourseType getCourseType() {
        return this.iCourseType;
    }

    public void setCourseType(CourseType courseType) {
        this.iCourseType = courseType;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="consent_type", nullable=true)
    public OfferingConsentType getConsentType() {
        return this.iConsentType;
    }

    public void setConsentType(OfferingConsentType consentType) {
        this.iConsentType = consentType;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="alternative_offering_id", nullable=true)
    public CourseOffering getAlternativeOffering() {
        return this.iAlternativeOffering;
    }

    public void setAlternativeOffering(CourseOffering alternativeOffering) {
        this.iAlternativeOffering = alternativeOffering;
    }

    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="funding_dept_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Department getFundingDept() {
        return this.iFundingDept;
    }

    public void setFundingDept(Department fundingDept) {
        this.iFundingDept = fundingDept;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="parent_offering_id", nullable=true)
    public CourseOffering getParentOffering() {
        return this.iParentOffering;
    }

    public void setParentOffering(CourseOffering parentOffering) {
        this.iParentOffering = parentOffering;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="courseOwner", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<CourseCreditUnitConfig> getCreditConfigs() {
        return this.iCreditConfigs;
    }

    public void setCreditConfigs(Set<CourseCreditUnitConfig> creditConfigs) {
        this.iCreditConfigs = creditConfigs;
    }

    public void addToCreditConfigs(CourseCreditUnitConfig courseCreditUnitConfig) {
        if (this.iCreditConfigs == null) {
            this.iCreditConfigs = new HashSet<CourseCreditUnitConfig>();
        }
        this.iCreditConfigs.add(courseCreditUnitConfig);
    }

    @Deprecated
    public void addTocreditConfigs(CourseCreditUnitConfig courseCreditUnitConfig) {
        this.addToCreditConfigs(courseCreditUnitConfig);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="disabled_override", joinColumns={@JoinColumn(name="course_id")}, inverseJoinColumns={@JoinColumn(name="type_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<OverrideType> getDisabledOverrides() {
        return this.iDisabledOverrides;
    }

    public void setDisabledOverrides(Set<OverrideType> disabledOverrides) {
        this.iDisabledOverrides = disabledOverrides;
    }

    public void addToDisabledOverrides(OverrideType overrideType) {
        if (this.iDisabledOverrides == null) {
            this.iDisabledOverrides = new HashSet<OverrideType>();
        }
        this.iDisabledOverrides.add(overrideType);
    }

    @Deprecated
    public void addTodisabledOverrides(OverrideType overrideType) {
        this.addToDisabledOverrides(overrideType);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CourseOffering)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CourseOffering)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CourseOffering)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "CourseOffering[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "CourseOffering[\n\tAlternativeOffering: " + String.valueOf(this.getAlternativeOffering()) + "\n\tConsentType: " + String.valueOf(this.getConsentType()) + "\n\tCourseNbr: " + this.getCourseNbr() + "\n\tCourseType: " + String.valueOf(this.getCourseType()) + "\n\tDemand: " + this.getDemand() + "\n\tDemandOffering: " + String.valueOf(this.getDemandOffering()) + "\n\tDemandOfferingType: " + String.valueOf(this.getDemandOfferingType()) + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFundingDept: " + String.valueOf(this.getFundingDept()) + "\n\tInstructionalOffering: " + String.valueOf(this.getInstructionalOffering()) + "\n\tIsControl: " + this.getIsControl() + "\n\tNbrExpectedStudents: " + this.getNbrExpectedStudents() + "\n\tParentOffering: " + String.valueOf(this.getParentOffering()) + "\n\tPermId: " + this.getPermId() + "\n\tProjectedDemand: " + this.getProjectedDemand() + "\n\tReservation: " + this.getReservation() + "\n\tScheduleBookNote: " + this.getScheduleBookNote() + "\n\tSnapshotProjectedDemand: " + this.getSnapshotProjectedDemand() + "\n\tSnapshotProjectedDemandDate: " + String.valueOf(this.getSnapshotProjectedDemandDate()) + "\n\tSubjectArea: " + String.valueOf(this.getSubjectArea()) + "\n\tTitle: " + this.getTitle() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUniqueIdRolledForwardFrom: " + this.getUniqueIdRolledForwardFrom() + "]";
    }
}

