/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.AssignmentInfo;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.ConstraintInfo;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.TimePattern;

@MappedSuperclass
public abstract class BaseAssignment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iDays;
    private Integer iStartSlot;
    private String iClassName;
    private TimePattern iTimePattern;
    private DatePattern iDatePattern;
    private Solution iSolution;
    private Class_ iClazz;
    private Set<DepartmentalInstructor> iInstructors;
    private Set<Location> iRooms;
    private Set<AssignmentInfo> iAssignmentInfo;
    private Set<ConstraintInfo> iConstraintInfo;

    public BaseAssignment() {
    }

    public BaseAssignment(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="assignment_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="days", nullable=true, length=4)
    public Integer getDays() {
        return this.iDays;
    }

    public void setDays(Integer days) {
        this.iDays = days;
    }

    @Column(name="slot", nullable=true, length=4)
    public Integer getStartSlot() {
        return this.iStartSlot;
    }

    public void setStartSlot(Integer startSlot) {
        this.iStartSlot = startSlot;
    }

    @Column(name="class_name", nullable=true, length=100)
    public String getClassName() {
        return this.iClassName;
    }

    public void setClassName(String className) {
        this.iClassName = className;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="time_pattern_id", nullable=false)
    public TimePattern getTimePattern() {
        return this.iTimePattern;
    }

    public void setTimePattern(TimePattern timePattern) {
        this.iTimePattern = timePattern;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="date_pattern_id", nullable=false)
    public DatePattern getDatePattern() {
        return this.iDatePattern;
    }

    public void setDatePattern(DatePattern datePattern) {
        this.iDatePattern = datePattern;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="solution_id", nullable=false)
    public Solution getSolution() {
        return this.iSolution;
    }

    public void setSolution(Solution solution) {
        this.iSolution = solution;
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="class_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Class_ getClazz() {
        return this.iClazz;
    }

    public void setClazz(Class_ clazz) {
        this.iClazz = clazz;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="assigned_instructors", joinColumns={@JoinColumn(name="assignment_id")}, inverseJoinColumns={@JoinColumn(name="instructor_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<DepartmentalInstructor> getInstructors() {
        return this.iInstructors;
    }

    public void setInstructors(Set<DepartmentalInstructor> instructors) {
        this.iInstructors = instructors;
    }

    public void addToInstructors(DepartmentalInstructor departmentalInstructor) {
        if (this.iInstructors == null) {
            this.iInstructors = new HashSet<DepartmentalInstructor>();
        }
        this.iInstructors.add(departmentalInstructor);
    }

    @Deprecated
    public void addToinstructors(DepartmentalInstructor departmentalInstructor) {
        this.addToInstructors(departmentalInstructor);
    }

    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="assigned_rooms", joinColumns={@JoinColumn(name="assignment_id")}, inverseJoinColumns={@JoinColumn(name="room_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Location> getRooms() {
        return this.iRooms;
    }

    public void setRooms(Set<Location> rooms) {
        this.iRooms = rooms;
    }

    public void addToRooms(Location location) {
        if (this.iRooms == null) {
            this.iRooms = new HashSet<Location>();
        }
        this.iRooms.add(location);
    }

    @Deprecated
    public void addTorooms(Location location) {
        this.addToRooms(location);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="assignment", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<AssignmentInfo> getAssignmentInfo() {
        return this.iAssignmentInfo;
    }

    public void setAssignmentInfo(Set<AssignmentInfo> assignmentInfo) {
        this.iAssignmentInfo = assignmentInfo;
    }

    public void addToAssignmentInfo(AssignmentInfo assignmentInfo) {
        if (this.iAssignmentInfo == null) {
            this.iAssignmentInfo = new HashSet<AssignmentInfo>();
        }
        this.iAssignmentInfo.add(assignmentInfo);
    }

    @Deprecated
    public void addToassignmentInfo(AssignmentInfo assignmentInfo) {
        this.addToAssignmentInfo(assignmentInfo);
    }

    @ManyToMany(fetch=FetchType.LAZY, mappedBy="assignments")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<ConstraintInfo> getConstraintInfo() {
        return this.iConstraintInfo;
    }

    public void setConstraintInfo(Set<ConstraintInfo> constraintInfo) {
        this.iConstraintInfo = constraintInfo;
    }

    public void addToConstraintInfo(ConstraintInfo constraintInfo) {
        if (this.iConstraintInfo == null) {
            this.iConstraintInfo = new HashSet<ConstraintInfo>();
        }
        this.iConstraintInfo.add(constraintInfo);
    }

    @Deprecated
    public void addToconstraintInfo(ConstraintInfo constraintInfo) {
        this.addToConstraintInfo(constraintInfo);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Assignment)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Assignment)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Assignment)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Assignment[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Assignment[\n\tClassName: " + this.getClassName() + "\n\tClazz: " + String.valueOf(this.getClazz()) + "\n\tDatePattern: " + String.valueOf(this.getDatePattern()) + "\n\tDays: " + this.getDays() + "\n\tSolution: " + String.valueOf(this.getSolution()) + "\n\tStartSlot: " + this.getStartSlot() + "\n\tTimePattern: " + String.valueOf(this.getTimePattern()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

