/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BaseStudentGroup;
import org.unitime.timetable.model.dao.StudentGroupDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="student_group")
public class StudentGroup
extends BaseStudentGroup {
    private static final long serialVersionUID = 1L;
    public static String STUGRP_ATTR_NAME = "studentGroupList";

    public StudentGroup() {
    }

    public StudentGroup(Long uniqueId) {
        super(uniqueId);
    }

    public static List<StudentGroup> getStudentGroupList(Long sessionId) {
        return StudentGroupDAO.getInstance().getSession().createQuery("from StudentGroup where session.uniqueId = :sessionId order by groupName", StudentGroup.class).setParameter("sessionId", (Object)sessionId).list();
    }

    public static StudentGroup findByAbbv(Long sessionId, String abbv) {
        return (StudentGroup)StudentGroupDAO.getInstance().getSession().createQuery("select a from StudentGroup a where a.session.uniqueId=:sessionId and a.groupAbbreviation=:abbv", StudentGroup.class).setParameter("sessionId", (Object)sessionId).setParameter("abbv", (Object)abbv).setCacheable(true).uniqueResult();
    }

    public static StudentGroup findByExternalId(Session hibSession, String externalId, Long acadSessionId) {
        return (StudentGroup)hibSession.createQuery("select a from StudentGroup a where a.session.uniqueId = :acadSessionId and externalUniqueId=:eId ", StudentGroup.class).setParameter("acadSessionId", (Object)acadSessionId).setParameter("eId", (Object)externalId).setCacheable(true).uniqueResult();
    }

    public static List<StudentGroup> findByType(Session hibSession, Long sessionId, Long typeId) {
        if (typeId == null) {
            return hibSession.createQuery("from StudentGroup x where x.session.uniqueId = :sessionId and x.type is null", StudentGroup.class).setParameter("sessionId", (Object)sessionId).list();
        }
        return hibSession.createQuery("from StudentGroup x where x.session.uniqueId = :sessionId and x.type.uniqueId = :typeId", StudentGroup.class).setParameter("sessionId", (Object)sessionId).setParameter("typeId", (Object)typeId).list();
    }
}

