/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.studentsct.model.Student;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.query.Query;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.StudentSchedulingPreferencesInterface;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.WaitList;
import org.unitime.timetable.model.base.BaseStudent;
import org.unitime.timetable.model.base.BaseWaitList;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="student")
public class Student
extends BaseStudent
implements Comparable<Student>,
NameInterface,
Qualifiable {
    private static final long serialVersionUID = 1L;

    public Student() {
    }

    public Student(Long uniqueId) {
        super(uniqueId);
    }

    public static List<Student> findAll(Long sessionId) {
        return StudentDAO.getInstance().getSession().createQuery("select s from Student s where s.session.uniqueId=:sessionId", Student.class).setParameter("sessionId", (Object)sessionId).list();
    }

    public static Student findByExternalId(Long sessionId, String externalId) {
        return Student.findByExternalId(StudentDAO.getInstance().getSession(), sessionId, externalId);
    }

    public static Student findByExternalId(Session hibSession, Long sessionId, String externalId) {
        return (Student)hibSession.createQuery("select s from Student s where s.session.uniqueId=:sessionId and s.externalUniqueId=:externalId", Student.class).setParameter("sessionId", (Object)sessionId).setParameter("externalId", (Object)externalId).setCacheable(true).uniqueResult();
    }

    public static Student findByExternalIdBringBackEnrollments(Session hibSession, Long sessionId, String externalId) {
        return (Student)hibSession.createQuery("select s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch s.classEnrollments as e left join fetch s.areaClasfMajors left join fetch s.areaClasfMinors where s.session.uniqueId=:sessionId and s.externalUniqueId=:externalId", Student.class).setParameter("sessionId", (Object)sessionId).setParameter("externalId", (Object)externalId).setCacheable(true).uniqueResult();
    }

    public void removeAllEnrollments(Session hibSession) {
        HashSet<StudentClassEnrollment> enrollments = new HashSet<StudentClassEnrollment>();
        if (this.getClassEnrollments() != null) {
            enrollments.addAll(this.getClassEnrollments());
        }
        if (!enrollments.isEmpty()) {
            for (StudentClassEnrollment enrollment : enrollments) {
                this.getClassEnrollments().remove(enrollment);
                hibSession.remove((Object)enrollment);
            }
        }
    }

    @Deprecated
    public Set<Exam> getExams(Integer examType) {
        HashSet<Exam> exams = new HashSet<Exam>();
        exams.addAll(StudentDAO.getInstance().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.clazz.uniqueId and o.exam.examType.type=:examType", Exam.class).setParameter("studentId", (Object)this.getUniqueId()).setParameter("ownerType", (Object)3).setParameter("examType", (Object)examType).setCacheable(true).list());
        exams.addAll(StudentDAO.getInstance().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.clazz.schedulingSubpart.instrOfferingConfig.uniqueId and o.exam.examType.type=:examType", Exam.class).setParameter("studentId", (Object)this.getUniqueId()).setParameter("ownerType", (Object)2).setParameter("examType", (Object)examType).setCacheable(true).list());
        exams.addAll(StudentDAO.getInstance().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.courseOffering.uniqueId and o.exam.examType.type=:examType", Exam.class).setParameter("studentId", (Object)this.getUniqueId()).setParameter("ownerType", (Object)1).setParameter("examType", (Object)examType).setCacheable(true).list());
        exams.addAll(StudentDAO.getInstance().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.courseOffering.instructionalOffering.uniqueId and o.exam.examType.type=:examType", Exam.class).setParameter("studentId", (Object)this.getUniqueId()).setParameter("ownerType", (Object)0).setParameter("examType", (Object)examType).setCacheable(true).list());
        return exams;
    }

    public Set<Exam> getExams(ExamType examType) {
        HashSet<Exam> exams = new HashSet<Exam>();
        exams.addAll(StudentDAO.getInstance().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.clazz.uniqueId and o.exam.examType.uniqueId=:examType", Exam.class).setParameter("studentId", (Object)this.getUniqueId()).setParameter("ownerType", (Object)3).setParameter("examType", (Object)examType.getUniqueId()).setCacheable(true).list());
        exams.addAll(StudentDAO.getInstance().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.clazz.schedulingSubpart.instrOfferingConfig.uniqueId and o.exam.examType.uniqueId=:examType", Exam.class).setParameter("studentId", (Object)this.getUniqueId()).setParameter("ownerType", (Object)2).setParameter("examType", (Object)examType.getUniqueId()).setCacheable(true).list());
        exams.addAll(StudentDAO.getInstance().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.courseOffering.uniqueId and o.exam.examType.uniqueId=:examType", Exam.class).setParameter("studentId", (Object)this.getUniqueId()).setParameter("ownerType", (Object)1).setParameter("examType", (Object)examType.getUniqueId()).setCacheable(true).list());
        exams.addAll(StudentDAO.getInstance().getSession().createQuery("select distinct o.exam from ExamOwner o, StudentClassEnrollment e where e.student.uniqueId=:studentId and o.ownerType=:ownerType and o.ownerId=e.courseOffering.instructionalOffering.uniqueId and o.exam.examType.uniqueId=:examType", Exam.class).setParameter("studentId", (Object)this.getUniqueId()).setParameter("ownerType", (Object)0).setParameter("examType", (Object)examType.getUniqueId()).setCacheable(true).list());
        return exams;
    }

    public String getName(String instructorNameFormat) {
        return NameFormat.fromReference(instructorNameFormat).format(this);
    }

    @Override
    public int compareTo(Student student) {
        int cmp = NameFormat.LAST_FIRST.format(this).compareTo(NameFormat.LAST_FIRST.format(student));
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(student.getUniqueId() == null ? -1L : student.getUniqueId());
    }

    public static Hashtable<Long, Set<Long>> findConflictingStudents(Long classId, int startSlot, int length, List<Date> dates) {
        Hashtable<Long, Set<Long>> table = new Hashtable<Long, Set<Long>>();
        if (dates.isEmpty()) {
            return table;
        }
        Object datesStr = "";
        for (int i = 0; i < dates.size(); ++i) {
            if (i > 0) {
                datesStr = (String)datesStr + ", ";
            }
            datesStr = (String)datesStr + ":date" + i;
        }
        Query q = LocationDAO.getInstance().getSession().createQuery("select distinct e.clazz.uniqueId, e.student.uniqueId from StudentClassEnrollment e, ClassEvent c inner join c.meetings m, StudentClassEnrollment x where x.clazz.uniqueId=:classId and x.student=e.student and e.clazz=c.clazz and m.stopPeriod>:startSlot and :endSlot>m.startPeriod and m.meetingDate in (" + (String)datesStr + ") and m.approvalStatus = 1", Object[].class).setParameter("classId", (Object)classId).setParameter("startSlot", (Object)startSlot).setParameter("endSlot", (Object)(startSlot + length));
        for (int i = 0; i < dates.size(); ++i) {
            q.setParameter("date" + i, (Object)dates.get(i));
        }
        for (Object[] o : q.setCacheable(true).list()) {
            Set<Long> set = table.get((Long)o[0]);
            if (set == null) {
                set = new HashSet<Long>();
                table.put((Long)o[0], set);
            }
            set.add((Long)o[1]);
        }
        return table;
    }

    public boolean hasSectioningStatusOption(StudentSectioningStatus.Option option) {
        StudentSectioningStatus status = this.getEffectiveStatus();
        return status != null && status.hasOption(option);
    }

    @Override
    @Transient
    public String getAcademicTitle() {
        return null;
    }

    @Override
    @Transient
    public Serializable getQualifierId() {
        return this.getUniqueId();
    }

    @Override
    @Transient
    public String getQualifierType() {
        return this.getClass().getSimpleName();
    }

    @Override
    @Transient
    public String getQualifierReference() {
        return this.getExternalUniqueId();
    }

    @Override
    @Transient
    public String getQualifierLabel() {
        return NameFormat.LAST_FIRST_MIDDLE.format(this);
    }

    @Transient
    public CourseRequest.CourseRequestOverrideStatus getMaxCreditOverrideStatus() {
        if (this.getOverrideStatus() == null) {
            return CourseRequest.CourseRequestOverrideStatus.APPROVED;
        }
        return CourseRequest.CourseRequestOverrideStatus.values()[this.getOverrideStatus()];
    }

    public void setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus status) {
        this.setOverrideStatus(status == null ? null : Integer.valueOf(status.ordinal()));
    }

    @Transient
    public boolean isRequestApproved() {
        return this.getOverrideStatus() == null || this.getOverrideStatus().intValue() == CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal();
    }

    @Transient
    public boolean isRequestPending() {
        return this.getOverrideStatus() != null && this.getOverrideStatus().intValue() == CourseRequest.CourseRequestOverrideStatus.PENDING.ordinal();
    }

    @Transient
    public boolean isRequestCancelled() {
        return this.getOverrideStatus() != null && this.getOverrideStatus().intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal();
    }

    @Transient
    public boolean isRequestRejected() {
        return this.getOverrideStatus() != null && this.getOverrideStatus().intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal();
    }

    @Transient
    public StudentSectioningStatus getEffectiveStatus() {
        StudentSectioningStatus fallback;
        int depth;
        if (this.getSectioningStatus() != null) {
            if (this.getSectioningStatus().isEffectiveNow()) {
                return this.getSectioningStatus();
            }
            depth = 10;
            for (fallback = this.getSectioningStatus().getFallBackStatus(); fallback != null && depth-- > 0; fallback = fallback.getFallBackStatus()) {
                if (!fallback.isEffectiveNow()) continue;
                return fallback;
            }
        }
        if (this.getSession().getDefaultSectioningStatus() != null) {
            if (this.getSession().getDefaultSectioningStatus().isEffectiveNow()) {
                return this.getSession().getDefaultSectioningStatus();
            }
            depth = 10;
            for (fallback = this.getSession().getDefaultSectioningStatus().getFallBackStatus(); fallback != null && depth-- > 0; fallback = fallback.getFallBackStatus()) {
                if (!fallback.isEffectiveNow()) continue;
                return fallback;
            }
        }
        return null;
    }

    @Transient
    public OnlineSectioningInterface.WaitListMode getWaitListMode() {
        StudentSectioningStatus status = this.getEffectiveStatus();
        if (CustomStudentEnrollmentHolder.isAllowWaitListing() && (status == null || status.hasOption(StudentSectioningStatus.Option.waitlist))) {
            return OnlineSectioningInterface.WaitListMode.WaitList;
        }
        if (status != null && status.hasOption(StudentSectioningStatus.Option.nosubs)) {
            return OnlineSectioningInterface.WaitListMode.NoSubs;
        }
        return OnlineSectioningInterface.WaitListMode.None;
    }

    @Transient
    public Date getLastChangedByStudent() {
        Date ret = null;
        if (this.getCourseDemands() != null) {
            for (CourseDemand cd : this.getCourseDemands()) {
                if (this.getExternalUniqueId() == null || !this.getExternalUniqueId().equals(cd.getChangedBy())) continue;
                if (ret == null || ret.before(cd.getTimestamp())) {
                    ret = cd.getTimestamp();
                }
                if (cd.getWaitlistedTimeStamp() == null || ret != null && !ret.before(cd.getWaitlistedTimeStamp())) continue;
                ret = cd.getWaitlistedTimeStamp();
            }
        }
        if (this.getClassEnrollments() != null) {
            for (StudentClassEnrollment e : this.getClassEnrollments()) {
                if (this.getExternalUniqueId() == null || !this.getExternalUniqueId().equals(e.getChangedBy()) || ret != null && !ret.before(e.getTimestamp())) continue;
                ret = e.getTimestamp();
            }
        }
        return ret;
    }

    public boolean hasReleasedPin() {
        return this.getPin() != null && !this.getPin().isEmpty() && this.isPinReleased() != null && this.isPinReleased() != false;
    }

    @Transient
    public String getReleasedPin() {
        return this.hasReleasedPin() ? this.getPin() : null;
    }

    public Set<Long> getAdvisorWaitListedCourseIds(boolean useWaitLists, boolean useNoSubs) {
        if (!useWaitLists && !useNoSubs) {
            return null;
        }
        if (this.getAdvisorCourseRequests() == null || this.getAdvisorCourseRequests().isEmpty()) {
            return null;
        }
        HashSet<Long> courseIds = new HashSet<Long>();
        for (AdvisorCourseRequest acr : this.getAdvisorCourseRequests()) {
            if (useWaitLists && acr.getWaitlist() != null && acr.getWaitlist().booleanValue() && acr.getCourseOffering() != null) {
                courseIds.add(acr.getCourseOffering().getUniqueId());
            }
            if (!useNoSubs || acr.getNoSub() == null || !acr.getNoSub().booleanValue() || acr.getCourseOffering() == null) continue;
            courseIds.add(acr.getCourseOffering().getUniqueId());
        }
        return courseIds;
    }

    public Set<Long> getAdvisorWaitListedCourseIds(OnlineSectioningServer server) {
        if (server == null) {
            return this.getAdvisorWaitListedCourseIds(ApplicationProperty.OnlineSchedulingParameter.isTrue("Load.UseAdvisorWaitLists"), ApplicationProperty.OnlineSchedulingParameter.isTrue("Load.UseAdvisorNoSubs"));
        }
        return this.getAdvisorWaitListedCourseIds(server.getConfig().getPropertyBoolean("Load.UseAdvisorWaitLists", false), server.getConfig().getPropertyBoolean("Load.UseAdvisorNoSubs", false));
    }

    public void setMaxCreditOverrideIntent(CourseRequest.CourseRequestOverrideIntent intent) {
        if (intent == null) {
            this.setOverrideIntent(null);
        } else {
            this.setOverrideIntent(intent.ordinal());
        }
    }

    @Transient
    public CourseRequest.CourseRequestOverrideIntent getMaxCreditOverrideIntent() {
        return this.getOverrideIntent() == null ? null : CourseRequest.CourseRequestOverrideIntent.values()[this.getOverrideIntent()];
    }

    @Transient
    public StudentAreaClassificationMajor getPrimaryAreaClasfMajor() {
        if (this.getAreaClasfMajors() == null) {
            return null;
        }
        StudentAreaClassificationMajor major = null;
        for (StudentAreaClassificationMajor m : this.getAreaClasfMajors()) {
            if (major != null && m.compareTo(major) >= 0) continue;
            major = m;
        }
        return major;
    }

    public CourseRequest getCourseRequest(CourseOffering co) {
        for (CourseDemand cd : this.getCourseDemands()) {
            for (CourseRequest cr : cd.getCourseRequests()) {
                if (!cr.getCourseOffering().equals(co)) continue;
                return cr;
            }
        }
        return null;
    }

    public boolean isEnrolled(CourseOffering co) {
        if (co == null) {
            return false;
        }
        for (StudentClassEnrollment e : this.getClassEnrollments()) {
            if (!e.getCourseOffering().equals(co)) continue;
            return true;
        }
        return false;
    }

    public WaitList addWaitList(CourseOffering co, WaitList.WaitListType type, boolean waitListed, String changedBy, Date timeStamp, Session hibSession) {
        CourseOffering swap;
        CourseOffering enrolled;
        if (ApplicationProperty.WaitListLogging.isFalse()) {
            return null;
        }
        if (co == null) {
            return null;
        }
        BaseWaitList last = null;
        CourseRequest cr = this.getCourseRequest(co);
        if (this.getWaitlists() != null && !this.getWaitlists().isEmpty()) {
            for (WaitList wl : this.getWaitlists()) {
                if (last != null && ((WaitList)last).compareTo(wl) >= 0 || !wl.getCourseOffering().equals(co) && !wl.hasMatchingCourse(cr)) continue;
                last = wl;
            }
        }
        boolean lastWaitListed = last == null ? false : last.isWaitListed();
        CourseOffering lastEnrolled = last == null ? null : last.getEnrolledCourse();
        CourseOffering courseOffering = enrolled = cr == null ? null : cr.getCourseDemand().getEnrolledCourse();
        if (enrolled != null && cr != null && enrolled.equals(cr.getCourseDemand().getWaitListSwapWithCourseOffering()) && !cr.isRequired()) {
            enrolled = null;
        }
        CourseOffering lastSwap = last == null ? null : last.getSwapCourseOffering();
        CourseOffering courseOffering2 = swap = cr == null ? null : cr.getCourseDemand().getWaitListSwapWithCourseOffering();
        if (lastWaitListed != waitListed || !(lastEnrolled == null ? enrolled == null : lastEnrolled.equals(enrolled)) || !(lastSwap == null ? swap == null : lastSwap.equals(swap)) || type == WaitList.WaitListType.RE_BATCH_ON_RELOAD || type == WaitList.WaitListType.RE_BATCH_ON_CHECK) {
            WaitList wl = new WaitList();
            wl.setChangedBy(changedBy);
            wl.setCourseOffering(cr == null ? co : cr.getCourseDemand().getFirstChoiceCourseOffering());
            wl.setEnrolledCourse(enrolled);
            wl.setTimestamp(timeStamp);
            wl.setWaitListType(type);
            wl.setWaitListed(waitListed);
            wl.setWaitListedTimeStamp(cr == null ? null : cr.getCourseDemand().getWaitlistedTimeStamp());
            wl.setStudent(this);
            wl.setCourseDemand(cr == null ? null : cr.getCourseDemand());
            wl.setSwapCourseOffering(cr == null ? null : cr.getCourseDemand().getWaitListSwapWithCourseOffering());
            wl.fillInNotes();
            this.addToWaitlists(wl);
            if (hibSession != null) {
                hibSession.persist((Object)wl);
            }
            return wl;
        }
        return null;
    }

    public void resetWaitLists(WaitList.WaitListType type, String changedBy, Date timeStamp, Session hibSession) {
        WaitList wl;
        WaitList old;
        CourseOffering co;
        if (ApplicationProperty.WaitListLogging.isFalse()) {
            return;
        }
        if (timeStamp == null) {
            timeStamp = new Date();
        }
        HashMap<CourseOffering, WaitList> waitlists = new HashMap<CourseOffering, WaitList>();
        if (this.getWaitlists() != null) {
            for (WaitList waitList : this.getWaitlists()) {
                WaitList other = (WaitList)waitlists.get(waitList.getCourseOffering());
                if (other != null && other.compareTo(waitList) >= 0) continue;
                waitlists.put(waitList.getCourseOffering(), waitList);
            }
        }
        for (StudentClassEnrollment studentClassEnrollment : this.getClassEnrollments()) {
            CourseRequest cr;
            WaitList wl3 = (WaitList)waitlists.remove(studentClassEnrollment.getCourseOffering());
            if (wl3 == null || !wl3.isWaitListed().booleanValue()) continue;
            if (studentClassEnrollment.getCourseOffering().equals(wl3.getSwapCourseOffering()) && (cr = this.getCourseRequest(studentClassEnrollment.getCourseOffering())) != null && !cr.isRequired()) {
                waitlists.put(studentClassEnrollment.getCourseOffering(), wl3);
                continue;
            }
            wl3 = new WaitList();
            wl3.setChangedBy(changedBy);
            wl3.setTimestamp(timeStamp);
            cr = this.getCourseRequest(studentClassEnrollment.getCourseOffering());
            wl3.setCourseOffering(cr != null ? cr.getCourseDemand().getFirstChoiceCourseOffering() : studentClassEnrollment.getCourseOffering());
            wl3.setCourseDemand(cr == null ? null : cr.getCourseDemand());
            wl3.setEnrolledCourse(studentClassEnrollment.getCourseOffering());
            wl3.setWaitListType(type);
            wl3.setWaitListed(false);
            wl3.setStudent(this);
            wl3.setWaitListedTimeStamp(cr == null ? null : cr.getCourseDemand().getWaitlistedTimeStamp());
            wl3.setSwapCourseOffering(cr == null ? null : cr.getCourseDemand().getWaitListSwapWithCourseOffering());
            wl3.fillInNotes();
            this.addToWaitlists(wl3);
            if (hibSession == null) continue;
            hibSession.persist((Object)wl3);
        }
        for (CourseDemand courseDemand : this.getCourseDemands()) {
            if (!courseDemand.isWaitlist().booleanValue() || courseDemand.isEnrolled(true) || (co = courseDemand.getFirstChoiceCourseOffering()) == null || (old = (WaitList)waitlists.remove(co)) != null && old.isWaitListed().booleanValue() && WaitList.computeRequest(courseDemand).equals(old.getRequest()) && (old.getSwapCourseOffering() != null ? old.getSwapCourseOffering().equals(courseDemand.getWaitListSwapWithCourseOffering()) : courseDemand.getWaitListSwapWithCourseOffering() == null)) continue;
            wl = new WaitList();
            wl.setChangedBy(changedBy);
            wl.setTimestamp(timeStamp);
            wl.setCourseOffering(co);
            wl.setCourseDemand(courseDemand);
            wl.setWaitListType(type);
            wl.setWaitListed(true);
            wl.setStudent(this);
            wl.setWaitListedTimeStamp(courseDemand.getWaitlistedTimeStamp());
            wl.setSwapCourseOffering(courseDemand.getWaitListSwapWithCourseOffering());
            wl.fillInNotes();
            this.addToWaitlists(wl);
            if (hibSession == null) continue;
            hibSession.persist((Object)wl);
        }
        for (Map.Entry entry : waitlists.entrySet()) {
            co = (CourseOffering)entry.getKey();
            old = (WaitList)entry.getValue();
            if (!old.isWaitListed().booleanValue()) continue;
            wl = new WaitList();
            wl.setChangedBy(changedBy);
            wl.setTimestamp(timeStamp);
            wl.setCourseOffering(co);
            CourseRequest cr = this.getCourseRequest(co);
            wl.setCourseDemand(cr == null ? null : cr.getCourseDemand());
            wl.setWaitListType(type);
            wl.setWaitListed(false);
            wl.setStudent(this);
            wl.setWaitListedTimeStamp(old.getWaitListedTimeStamp());
            wl.setSwapCourseOffering(old.getSwapCourseOffering());
            wl.fillInNotes();
            this.addToWaitlists(wl);
            if (hibSession == null) continue;
            hibSession.persist((Object)wl);
        }
    }

    @Transient
    public StudentSchedulingPreferencesInterface.ClassModality getPreferredClassModality() {
        if (this.getSchedulePreference() == null) {
            return StudentSchedulingPreferencesInterface.ClassModality.NoPreference;
        }
        return StudentSchedulingPreferencesInterface.ClassModality.values()[this.getSchedulePreference()];
    }

    public void setPreferredClassModality(StudentSchedulingPreferencesInterface.ClassModality modality) {
        if (modality == null) {
            this.setSchedulePreference(null);
        } else {
            this.setSchedulePreference(modality.ordinal());
        }
    }

    @Transient
    public Student.ModalityPreference getModalityPreference() {
        switch (this.getPreferredClassModality()) {
            case DiscouragedOnline: {
                return Student.ModalityPreference.ONILNE_DISCOURAGED;
            }
            case PreferredOnline: {
                return Student.ModalityPreference.ONLINE_PREFERRED;
            }
            case RequiredOnline: {
                return Student.ModalityPreference.ONLINE_REQUIRED;
            }
        }
        return Student.ModalityPreference.NO_PREFERENCE;
    }

    @Transient
    public StudentSchedulingPreferencesInterface.ScheduleGaps getPreferredScheduleGaps() {
        if (this.getFreeTimeCategory() == null) {
            return StudentSchedulingPreferencesInterface.ScheduleGaps.NoPreference;
        }
        return StudentSchedulingPreferencesInterface.ScheduleGaps.values()[this.getFreeTimeCategory()];
    }

    public void setPreferredScheduleGaps(StudentSchedulingPreferencesInterface.ScheduleGaps gaps) {
        if (gaps == null) {
            this.setFreeTimeCategory(null);
        } else {
            this.setFreeTimeCategory(gaps.ordinal());
        }
    }

    @Transient
    public Student.BackToBackPreference getBackToBackPreference() {
        switch (this.getPreferredScheduleGaps()) {
            case DiscourageBackToBack: {
                return Student.BackToBackPreference.BTB_DISCOURAGED;
            }
            case PreferBackToBack: {
                return Student.BackToBackPreference.BTB_PREFERRED;
            }
        }
        return Student.BackToBackPreference.NO_PREFERENCE;
    }
}

