/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.interfaces.AcademicSessionLookup;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.base.BaseSession;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.updates.CheckOfferingAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadOfferingAction;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.spring.SpringApplicationContextHolder;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.ReferenceList;

@Entity
@Table(name="sessions")
public class Session
extends BaseSession
implements Comparable<Session>,
Qualifiable {
    protected static GwtConstants CONST = Localization.create(GwtConstants.class);
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    public static final int sHolidayTypeNone = 0;
    public static final int sHolidayTypeHoliday = 1;
    public static final int sHolidayTypeBreak = 2;
    public static String[] sHolidayTypeColors = new String[]{"rgb(240,240,240)", "rgb(200,30,20)", "rgb(240,50,240)"};
    private static final long serialVersionUID = 3691040980400813366L;

    @Transient
    public static String[] getHolidayNames() {
        return new String[]{MSG.legendNoHoliday(), MSG.legendHoliday(), MSG.legendBreak()};
    }

    @Transient
    public static TreeSet<Session> getAllSessions() throws HibernateException {
        TreeSet<Session> ret = new TreeSet<Session>();
        for (Session session : SessionDAO.getInstance().findAll()) {
            if (session.getStatusType() == null || session.getStatusType().isTestSession()) continue;
            ret.add(session);
        }
        return ret;
    }

    public static Session getSessionById(Long id) throws HibernateException {
        return (Session)SessionDAO.getInstance().get(id);
    }

    private static void deleteObjects(org.hibernate.Session hibSession, String objectName, Iterator<Long> idIterator) {
        StringBuffer ids = new StringBuffer();
        int idx = 0;
        while (idIterator.hasNext()) {
            ids.append(idIterator.next());
            if (++idx == 100) {
                hibSession.createMutationQuery("delete " + objectName + " as x where x.uniqueId in (" + String.valueOf(ids) + ")").executeUpdate();
                ids = new StringBuffer();
                idx = 0;
                continue;
            }
            if (!idIterator.hasNext()) continue;
            ids.append(",");
        }
        if (idx > 0) {
            hibSession.createMutationQuery("delete " + objectName + " as x where x.uniqueId in (" + String.valueOf(ids) + ")").executeUpdate();
        }
    }

    public static void deleteSessionById(Long id) throws HibernateException {
        org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();
        Transaction tx = null;
        try {
            String[] a;
            tx = hibSession.beginTransaction();
            for (Location loc : hibSession.createQuery("from Location where session.uniqueId = :sessionId", Location.class).setParameter("sessionId", (Object)id).list()) {
                loc.getFeatures().clear();
                loc.getRoomGroups().clear();
                hibSession.merge((Object)loc);
            }
            hibSession.flush();
            hibSession.createMutationQuery("delete DistributionPref p where p.owner in (select s from Session s where s.uniqueId=:sessionId)").setParameter("sessionId", (Object)id).executeUpdate();
            hibSession.createMutationQuery("delete InstructionalOffering o where o.session.uniqueId=:sessionId").setParameter("sessionId", (Object)id).executeUpdate();
            hibSession.createMutationQuery("delete Department d where d.session.uniqueId=:sessionId").setParameter("sessionId", (Object)id).executeUpdate();
            hibSession.createMutationQuery("delete Session s where s.uniqueId=:sessionId").setParameter("sessionId", (Object)id).executeUpdate();
            for (String str : a = new String[]{"DistributionPref", "RoomPref", "RoomGroupPref", "RoomFeaturePref", "BuildingPref", "TimePref", "DatePatternPref", "ExamPeriodPref"}) {
                hibSession.createMutationQuery("delete " + str + " p where owner not in (from PreferenceGroup)").executeUpdate();
            }
            Session.deleteObjects(hibSession, "ExamConflict", hibSession.createQuery("select x.uniqueId from ExamConflict x where x.exams is empty", Long.class).list().iterator());
            tx.commit();
        }
        catch (HibernateException e) {
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        HibernateUtil.clearCache();
    }

    @Transient
    public String getAcademicYearTerm() {
        return this.getAcademicYear() + this.getAcademicTerm();
    }

    @Transient
    public String getTermLabel() {
        return this.getAcademicTerm();
    }

    @Transient
    public String getLabel() {
        return this.getAcademicTerm() + " " + this.getAcademicYear() + " (" + this.getAcademicInitiative() + ")";
    }

    @Transient
    public String getReference() {
        return this.getAcademicTerm() + this.getAcademicYear() + this.getAcademicInitiative();
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @Transient
    public int getSessionStartYear() {
        if (this.getSessionBeginDateTime() != null) {
            Calendar c = Calendar.getInstance(Locale.US);
            c.setTime(this.getSessionBeginDateTime());
            return c.get(1);
        }
        return Integer.parseInt(this.getAcademicYear());
    }

    public static int getYear(String acadYrTerm) {
        return Integer.parseInt(acadYrTerm.substring(0, 4));
    }

    public Building building(String bldgUniqueId) {
        for (Building bldg : this.getBuildings()) {
            if (!bldg.getExternalUniqueId().equals(bldgUniqueId)) continue;
            return bldg;
        }
        return null;
    }

    public String academicInitiativeDisplayString() {
        return this.getAcademicInitiative();
    }

    public String statusDisplayString() {
        return this.getStatusType().getLabel();
    }

    public static ReferenceList getSessionStatusList(boolean includeTestSessions) {
        ReferenceList ref = new ReferenceList();
        ref.addAll(DepartmentStatusType.findAllForSession(includeTestSessions));
        return ref;
    }

    public static Session getSessionUsingInitiativeYearTerm(String academicInitiative, String academicYear, String academicTerm) {
        return Session.getSessionUsingInitiativeYearTerm(academicInitiative, academicYear, academicTerm, SessionDAO.getInstance().getSession());
    }

    public static Session getSessionUsingInitiativeYearTerm(String academicInitiative, String academicYear, String academicTerm, org.hibernate.Session hibSession) {
        return (Session)hibSession.createQuery("from Session s where s.academicInitiative = :academicInitiative and s.academicYear = :academicYear and s.academicTerm = :academicTerm", Session.class).setParameter("academicInitiative", (Object)academicInitiative).setParameter("academicYear", (Object)academicYear).setParameter("academicTerm", (Object)academicTerm).setCacheable(true).uniqueResult();
    }

    public static Session getSessionUsingCampusYearTerm(String campus, String year, String term, org.hibernate.Session hibSession) {
        String className = ApplicationProperty.AcademicSessionLookupImplementation.value();
        AcademicSessionLookup academicSessionLookup = null;
        try {
            academicSessionLookup = (AcademicSessionLookup)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return Session.getSessionUsingInitiativeYearTerm(campus, year, term, hibSession);
        }
        return academicSessionLookup.findAcademicSession(campus, year, term, hibSession);
    }

    @Transient
    public Session getLastLikeSession() {
        String lastYr = Integer.valueOf(this.getSessionStartYear() - 1).toString();
        return Session.getSessionUsingInitiativeYearTerm(this.getAcademicInitiative(), lastYr, this.getAcademicTerm());
    }

    @Transient
    public Session getNextLikeSession() {
        String nextYr = Integer.valueOf(this.getSessionStartYear() + 1).toString();
        return Session.getSessionUsingInitiativeYearTerm(this.getAcademicInitiative(), nextYr, this.getAcademicTerm());
    }

    public String loadInstrAndCrsOffering() throws Exception {
        return "done";
    }

    @Transient
    public Long getSessionId() {
        return this.getUniqueId();
    }

    public void setSessionId(Long sessionId) {
        this.setUniqueId(sessionId);
    }

    @Override
    public String htmlLabel() {
        return this.getLabel();
    }

    public Date earliestSessionRelatedDate() {
        return this.getEventBeginDate() != null && this.getEventBeginDate().before(this.getSessionBeginDateTime()) ? this.getEventBeginDate() : this.getSessionBeginDateTime();
    }

    public Date latestSessionRelatedDate() {
        return this.getEventEndDate() != null && this.getEventEndDate().after(this.getSessionEndDateTime()) ? this.getEventEndDate() : this.getSessionEndDateTime();
    }

    @Transient
    public int getStartMonth() {
        return DateUtils.getStartMonth(this.earliestSessionRelatedDate(), this.getSessionStartYear(), ApplicationProperty.SessionNrExcessDays.intValue());
    }

    @Transient
    public int getEndMonth() {
        return DateUtils.getEndMonth(this.latestSessionRelatedDate(), this.getSessionStartYear(), ApplicationProperty.SessionNrExcessDays.intValue());
    }

    @Transient
    public int getPatternStartMonth() {
        return this.getStartMonth() - ApplicationProperty.DatePatternNrExessMonth.intValue();
    }

    @Transient
    public int getPatternEndMonth() {
        return this.getEndMonth() + ApplicationProperty.DatePatternNrExessMonth.intValue();
    }

    public int getDayOfYear(int day, int month) {
        return DateUtils.getDayOfYear(day, month, this.getSessionStartYear());
    }

    public int getHoliday(int day, int month) {
        return Session.getHoliday(day, month, this.getSessionStartYear(), this.getStartMonth(), this.getHolidays());
    }

    public static int getHoliday(int day, int month, int year, int startMonth, String holidays) {
        try {
            if (holidays == null) {
                return 0;
            }
            int idx = DateUtils.getDayOfYear(day, month, year) - DateUtils.getDayOfYear(1, startMonth, year);
            if (idx < 0 || idx >= holidays.length()) {
                return 0;
            }
            return holidays.charAt(idx) - 48;
        }
        catch (IndexOutOfBoundsException e) {
            return 0;
        }
    }

    @Transient
    public String getHolidaysHtml() {
        return this.getHolidaysHtml(true);
    }

    public String getHolidaysHtml(boolean editable) {
        return Session.getHolidaysHtml(this.getSessionBeginDateTime(), this.getSessionEndDateTime(), this.getClassesEndDateTime(), this.getExamBeginDate(), this.getEventBeginDate(), this.getEventEndDate(), this.getSessionStartYear(), this.getHolidays(), editable, EventDateMapping.getMapping(this.getUniqueId()));
    }

    public Date getDate(int index) {
        Calendar sessionBeginDate = Calendar.getInstance(Locale.US);
        sessionBeginDate.setTime(this.getSessionBeginDateTime());
        sessionBeginDate.add(6, index);
        return sessionBeginDate.getTime();
    }

    public static String getHolidaysHtml(Date sessionBeginTime, Date sessionEndTime, Date classesEndTime, Date examBeginTime, Date eventBeginTime, Date eventEndTime, int acadYear, String holidays, boolean editable, EventDateMapping.Class2EventDateMap class2eventDateMap) {
        int i;
        StringBuffer prefTable = new StringBuffer();
        StringBuffer prefNames = new StringBuffer();
        StringBuffer prefColors = new StringBuffer();
        String[] names = Session.getHolidayNames();
        for (int i2 = 0; i2 < sHolidayTypeColors.length; ++i2) {
            prefTable.append((i2 == 0 ? "" : ",") + "'" + i2 + "'");
            prefNames.append((i2 == 0 ? "" : ",") + "'" + names[i2] + "'");
            prefColors.append((i2 == 0 ? "" : ",") + "'" + sHolidayTypeColors[i2] + "'");
        }
        StringBuffer holidayArray = new StringBuffer();
        StringBuffer borderArray = new StringBuffer();
        StringBuffer colorArray = new StringBuffer();
        Calendar sessionBeginDate = Calendar.getInstance(Locale.US);
        sessionBeginDate.setTime(sessionBeginTime);
        Calendar sessionEndDate = Calendar.getInstance(Locale.US);
        sessionEndDate.setTime(sessionEndTime);
        Calendar classesEndDate = Calendar.getInstance(Locale.US);
        classesEndDate.setTime(classesEndTime);
        Calendar examBeginDate = Calendar.getInstance(Locale.US);
        if (examBeginTime != null) {
            examBeginDate.setTime(examBeginTime);
        }
        Calendar eventBeginDate = Calendar.getInstance(Locale.US);
        if (eventBeginTime != null) {
            eventBeginDate.setTime(eventBeginTime);
        }
        Calendar eventEndDate = Calendar.getInstance(Locale.US);
        if (eventEndTime != null) {
            eventEndDate.setTime(eventEndTime);
        }
        int startMonth = DateUtils.getStartMonth(eventBeginTime != null && eventBeginTime.before(sessionBeginTime) ? eventBeginTime : sessionBeginTime, acadYear, ApplicationProperty.SessionNrExcessDays.intValue());
        int endMonth = DateUtils.getEndMonth(eventEndTime != null && eventEndTime.after(sessionEndTime) ? eventEndTime : sessionEndTime, acadYear, ApplicationProperty.SessionNrExcessDays.intValue());
        for (int m = startMonth; m <= endMonth; ++m) {
            int yr = DateUtils.calculateActualYear(m, acadYear);
            if (m != startMonth) {
                holidayArray.append(",");
                borderArray.append(",");
                colorArray.append(",");
            }
            holidayArray.append("[");
            borderArray.append("[");
            colorArray.append("[");
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, acadYear);
            for (int d = 1; d <= daysOfMonth; ++d) {
                if (d > 1) {
                    holidayArray.append(",");
                    borderArray.append(",");
                    colorArray.append(",");
                }
                holidayArray.append("'" + Session.getHoliday(d, m, acadYear, startMonth, holidays) + "'");
                String color = "null";
                if (class2eventDateMap != null) {
                    if (class2eventDateMap.hasClassDate(DateUtils.getDate(d, m, acadYear))) {
                        color = "'#c0c'";
                    } else if (class2eventDateMap.hasEventDate(DateUtils.getDate(d, m, acadYear))) {
                        color = "'#0cc'";
                    }
                }
                colorArray.append(color);
                if (d == sessionBeginDate.get(5) && m % 12 == sessionBeginDate.get(2) && yr == sessionBeginDate.get(1)) {
                    borderArray.append("'#660000 2px solid'");
                    continue;
                }
                if (d == sessionEndDate.get(5) && m % 12 == sessionEndDate.get(2) && yr == sessionEndDate.get(1)) {
                    borderArray.append("'#333399 2px solid'");
                    continue;
                }
                if (d == classesEndDate.get(5) && m % 12 == classesEndDate.get(2) && yr == classesEndDate.get(1)) {
                    borderArray.append("'#339933 2px solid'");
                    continue;
                }
                if (d == examBeginDate.get(5) && m % 12 == examBeginDate.get(2) && yr == examBeginDate.get(1)) {
                    borderArray.append("'#999933 2px solid'");
                    continue;
                }
                if (d == eventBeginDate.get(5) && m % 12 == eventBeginDate.get(2) && yr == eventBeginDate.get(1)) {
                    borderArray.append("'yellow 2px solid'");
                    continue;
                }
                if (d == eventEndDate.get(5) && m % 12 == eventEndDate.get(2) && yr == eventEndDate.get(1)) {
                    borderArray.append("'red 2px solid'");
                    continue;
                }
                borderArray.append("null");
            }
            holidayArray.append("]");
            borderArray.append("]");
            colorArray.append("]");
        }
        StringBuffer table = new StringBuffer();
        table.append("<script language='JavaScript' type='text/javascript' src='scripts/datepatt.js'></script>\n");
        table.append("<script language='JavaScript'>\n");
        table.append("var CAL_WEEKDAYS = [");
        for (i = 0; i < 7; ++i) {
            if (i > 0) {
                table.append(", ");
            }
            table.append("\"" + CONST.days()[(i + 6) % 7] + "\"");
        }
        table.append("];\n");
        table.append("var CAL_MONTHS = [");
        for (i = 0; i < 12; ++i) {
            if (i > 0) {
                table.append(", ");
            }
            table.append("\"" + Month.of(1 + i).getDisplayName(TextStyle.FULL_STANDALONE, Localization.getJavaLocale()) + "\"");
        }
        table.append("];\n");
        table.append("calGenerate2(" + acadYear + "," + startMonth + ",\n\t" + endMonth + ",\n\t[" + String.valueOf(holidayArray) + "],\n\t[" + String.valueOf(prefTable) + "],\n\t[" + String.valueOf(prefNames) + "],\n\t[" + String.valueOf(prefColors) + "],\n\t'0',\n\t[" + String.valueOf(borderArray) + "],\n\t[" + String.valueOf(colorArray) + "],\n\t" + editable + "," + editable + ");\n");
        table.append("</script>\n");
        return table.toString();
    }

    @Override
    public void setHolidays(String holidays) {
        super.setHolidays(holidays);
    }

    public void setHolidays(HttpServletRequest request) {
        int startMonth = this.getStartMonth();
        int endMonth = this.getEndMonth();
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(this.earliestSessionRelatedDate());
        int startYear = this.getSessionStartYear();
        StringBuffer sb = new StringBuffer();
        for (int m = startMonth; m <= endMonth; ++m) {
            int year = DateUtils.calculateActualYear(m, startYear);
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, startYear);
            for (int d = 1; d <= daysOfMonth; ++d) {
                String holiday = request.getParameter("cal_val_" + year + "_" + (12 + m) % 12 + "_" + d);
                sb.append(holiday == null ? String.valueOf(0) : holiday);
            }
        }
        this.setHolidays(sb.toString());
    }

    @Override
    public int compareTo(Session s) {
        if (s == null) {
            return -1;
        }
        int cmp = this.getAcademicInitiative().compareTo(s.getAcademicInitiative());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getSessionBeginDateTime().compareTo(s.getSessionBeginDateTime());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(s.getUniqueId() == null ? -1L : s.getUniqueId());
    }

    @Transient
    public DatePattern getDefaultDatePatternNotNull() {
        DatePattern dp = super.getDefaultDatePattern();
        if (dp == null) {
            dp = DatePattern.findByName(this, "Full Term");
        }
        return dp;
    }

    @Transient
    public int getNrWeeks() {
        Calendar sessionBeginDate = Calendar.getInstance(Locale.US);
        sessionBeginDate.setTime(this.getSessionBeginDateTime());
        Calendar sessionEndDate = Calendar.getInstance(Locale.US);
        sessionEndDate.setTime(this.getSessionEndDateTime());
        int beginDay = this.getDayOfYear(sessionBeginDate.get(5), sessionBeginDate.get(2)) - this.getDayOfYear(1, this.getStartMonth());
        int endDay = this.getDayOfYear(sessionEndDate.get(5), sessionEndDate.get(2)) - this.getDayOfYear(1, this.getStartMonth());
        int nrDays = 0;
        for (int i = beginDay; i <= endDay; ++i) {
            if (this.getHolidays() != null && i < this.getHolidays().length() && this.getHolidays().charAt(i) - 48 != 0) continue;
            ++nrDays;
        }
        return (6 + (nrDays -= 7)) / 7;
    }

    @Transient
    public int getExamBeginOffset() {
        return (int)Math.round((double)(this.getSessionBeginDateTime().getTime() - this.getExamBeginDate().getTime()) / 8.64E7);
    }

    public String getBorder(int day, int month) {
        int holiday;
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.getSessionBeginDateTime());
        if (day == cal.get(5) && (12 + month) % 12 == cal.get(2)) {
            return "'blue 2px solid'";
        }
        cal.setTime(this.getClassesEndDateTime());
        if (day == cal.get(5) && (12 + month) % 12 == cal.get(2)) {
            return "'blue 2px solid'";
        }
        if (this.getExamBeginDate() != null) {
            cal.setTime(this.getExamBeginDate());
            if (day == cal.get(5) && (12 + month) % 12 == cal.get(2)) {
                return "'green 2px solid'";
            }
        }
        if ((holiday = this.getHoliday(day, month)) != 0) {
            return "'" + sHolidayTypeColors[holiday] + " 2px solid'";
        }
        return "null";
    }

    @Transient
    public String getColorArray() {
        EventDateMapping.Class2EventDateMap class2EventDateMap = EventDateMapping.getMapping(this.getUniqueId());
        int startMonth = this.getSession().getPatternStartMonth();
        int endMonth = this.getSession().getPatternEndMonth();
        int year = this.getSession().getSessionStartYear();
        StringBuffer sb = new StringBuffer("[");
        for (int m = startMonth; m <= endMonth; ++m) {
            if (m != startMonth) {
                sb.append(",");
            }
            sb.append("[");
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, year);
            for (int d = 1; d <= daysOfMonth; ++d) {
                if (d > 1) {
                    sb.append(",");
                }
                String color = "null";
                if (class2EventDateMap != null) {
                    if (class2EventDateMap.hasClassDate(DateUtils.getDate(d, m, year))) {
                        color = "'#c0c'";
                    } else if (class2EventDateMap.hasEventDate(DateUtils.getDate(d, m, year))) {
                        color = "'#0cc'";
                    }
                }
                sb.append(color);
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public long getDistance(Date date) {
        if (date.compareTo(this.getEventBeginDate()) < 0) {
            return this.getEventBeginDate().getTime() - date.getTime();
        }
        if (date.compareTo(this.getEventEndDate()) > 0) {
            return date.getTime() - this.getEventEndDate().getTime();
        }
        return 0L;
    }

    public boolean hasStudentSchedule() {
        return Session.hasStudentSchedule(this.getUniqueId());
    }

    public static boolean hasStudentSchedule(Long sessionId) {
        return ((Number)ExamDAO.getInstance().getSession().createQuery("select count(x) from StudentClassEnrollment x where x.student.session.uniqueId=:sessionId", Number.class).setParameter("sessionId", (Object)sessionId).uniqueResult()).longValue() > 0L;
    }

    @Transient
    private OnlineSectioningServer getInstance() {
        if (this.getUniqueId() == null) {
            return null;
        }
        return ((SolverServerService)SpringApplicationContextHolder.getBean("solverServerService")).getOnlineStudentSchedulingContainer().getSolver(this.getUniqueId().toString());
    }

    @Transient
    public Collection<Long> getLockedOfferings() {
        if (!this.getStatusType().canLockOfferings()) {
            return null;
        }
        OnlineSectioningServer server = this.getInstance();
        return server == null || !server.isReady() ? null : server.getLockedOfferings();
    }

    public boolean isOfferingLocked(Long offeringId) {
        if (!this.getStatusType().canLockOfferings()) {
            return false;
        }
        OnlineSectioningServer server = this.getInstance();
        return server != null && server.isOfferingLocked(offeringId);
    }

    public void lockOffering(Long offeringId) {
        OnlineSectioningServer server;
        if (this.getStatusType().canLockOfferings() && (server = this.getInstance()) != null) {
            server.lockOffering(offeringId);
        }
    }

    public void unlockOffering(InstructionalOffering offering, UserContext user) {
        OnlineSectioningServer server = this.getInstance();
        if (server != null) {
            if (server instanceof DatabaseServer) {
                server.unlockOffering(offering.getUniqueId());
                server.execute(server.createAction(CheckOfferingAction.class).forOfferings(offering.getUniqueId()), user == null ? null : OnlineSectioningLog.Entity.newBuilder().setExternalId(user.getExternalUserId()).setName(user.getName()).setType(OnlineSectioningLog.Entity.EntityType.MANAGER).build());
            } else {
                server.execute(server.createAction(ReloadOfferingAction.class).forOfferings(offering.getUniqueId()), user == null ? null : OnlineSectioningLog.Entity.newBuilder().setExternalId(user.getExternalUserId()).setName(user.getName()).setType(OnlineSectioningLog.Entity.EntityType.MANAGER).build());
                server.unlockOffering(offering.getUniqueId());
            }
        }
        try {
            SessionFactory hibSessionFactory = SessionDAO.getInstance().getSession().getSessionFactory();
            hibSessionFactory.getCache().evictEntityData(InstructionalOffering.class, (Object)offering.getUniqueId());
            for (CourseOffering course : offering.getCourseOfferings()) {
                hibSessionFactory.getCache().evictEntityData(CourseOffering.class, (Object)course.getUniqueId());
            }
            for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                    for (Class_ clazz : subpart.getClasses()) {
                        hibSessionFactory.getCache().evictEntityData(Class_.class, (Object)clazz.getUniqueId());
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.error("Failed to evict cache: " + e.getMessage());
        }
    }

    @Override
    @Transient
    public Session getSession() {
        return this;
    }

    @Override
    @Transient
    public Serializable getQualifierId() {
        return this.getUniqueId();
    }

    @Override
    @Transient
    public String getQualifierType() {
        return this.getClass().getSimpleName();
    }

    @Override
    @Transient
    public String getQualifierReference() {
        return this.getReference();
    }

    @Override
    @Transient
    public String getQualifierLabel() {
        return this.getLabel();
    }

    @Override
    @Transient
    public Department getDepartment() {
        return null;
    }

    public boolean canNoRoleReportExamFinal() {
        return ((Number)ExamDAO.getInstance().getSession().createQuery("select count(e) from FinalExamEvent e inner join e.exam.session s where s.uniqueId = :sessionId and ((e.examStatus is null and bitand(s.statusType.status, :flag) > 0) or bitand(e.examStatus, :flag) > 0)", Number.class).setParameter("sessionId", (Object)this.getUniqueId()).setParameter("flag", (Object)DepartmentStatusType.Status.ReportExamsFinal.toInt()).setCacheable(true).uniqueResult()).longValue() > 0L;
    }

    public boolean canNoRoleReportExamMidterm() {
        return ((Number)ExamDAO.getInstance().getSession().createQuery("select count(e) from MidtermExamEvent e inner join e.exam.session s where s.uniqueId = :sessionId and ((e.examStatus is null and bitand(s.statusType.status, :flag) > 0) or bitand(e.examStatus, :flag) > 0)", Number.class).setParameter("sessionId", (Object)this.getUniqueId()).setParameter("flag", (Object)DepartmentStatusType.Status.ReportExamsMidterm.toInt()).setCacheable(true).uniqueResult()).longValue() > 0L;
    }

    public boolean canNoRoleReportClass() {
        return this.getStatusType() != null && this.getStatusType().can(DepartmentStatusType.Status.ReportClasses) && Solution.hasTimetable(this.getUniqueId());
    }

    public boolean canNoRoleReportExam() {
        return this.canNoRoleReportExamFinal() || this.canNoRoleReportExamMidterm();
    }

    public boolean canNoRoleReport() {
        return this.canNoRoleReportClass() || this.canNoRoleReportExam();
    }

    public boolean canOnlineSectionStudents() {
        return this.getStatusType() != null && this.getStatusType().canOnlineSectionStudents() && !this.getStatusType().isTestSession();
    }

    @Transient
    public Date getCurrentSnapshotDate() {
        return (Date)InstructionalOfferingDAO.getInstance().getSession().createQuery("select max(io.snapshotLimitDate) from InstructionalOffering io where io.session.uniqueId = :sessId", Date.class).setParameter("sessId", (Object)this.getUniqueId()).uniqueResult();
    }
}

