/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.base.BaseRoomTypeOption;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="room_type_option")
public class RoomTypeOption
extends BaseRoomTypeOption {
    private static final long serialVersionUID = 1L;

    public RoomTypeOption() {
    }

    public RoomTypeOption(RoomType roomType, Department department) {
        this.setRoomType(roomType);
        this.setDepartment(department);
    }

    @Transient
    public static int getDefaultStatus() {
        return Status.NoEventManagement.ordinal();
    }

    @Transient
    public Status getEventStatus() {
        return Status.values()[this.getStatus() == null ? RoomTypeOption.getDefaultStatus() : this.getStatus()];
    }

    @Deprecated
    public boolean canScheduleEvents() {
        switch (Status.values()[this.getStatus() == null ? RoomTypeOption.getDefaultStatus() : this.getStatus()]) {
            case NoEventManagement: {
                return false;
            }
        }
        return true;
    }

    public static enum Status {
        NoEventManagement(false, false, false, false),
        AuthenticatedUsersCanRequestEventsManagersCanApprove(true, true, true, true),
        DepartmentalUsersCanRequestEventsManagersCanApprove(false, true, true, true),
        EventManagersCanRequestOrApproveEvents(false, false, true, true),
        AuthenticatedUsersCanRequestEventsNoApproval(true, true, true, false),
        DepartmentalUsersCanRequestEventsNoApproval(false, true, true, false),
        EventManagersCanRequestEventsNoApproval(false, false, true, false),
        AuthenticatedUsersCanRequestAutomaticApproval(true, true, true, true, true),
        DepartmentalUsersCanRequestAutomaticApproval(false, true, true, true, true),
        EventManagersCanRequestAutomaticApproval(false, false, true, true, true);

        private boolean iUserRequest;
        private boolean iDeptRequest;
        private boolean iMgrRequest;
        private boolean iMgrApproval;
        private boolean iAutoApproval;

        private Status(boolean userRequest, boolean deptRequest, boolean mgrRequest, boolean mgrApproval, boolean autoApproval) {
            this.iUserRequest = userRequest;
            this.iDeptRequest = deptRequest;
            this.iMgrRequest = mgrRequest;
            this.iMgrApproval = mgrApproval;
            this.iAutoApproval = autoApproval;
        }

        private Status(boolean userRequest, boolean deptRequest, boolean mgrRequest, boolean mgrApproval) {
            this(userRequest, deptRequest, mgrRequest, mgrApproval, false);
        }

        @Transient
        public boolean isAuthenticatedUsersCanRequestEvents() {
            return this.iUserRequest;
        }

        @Transient
        public boolean isDepartmentalUsersCanRequestEvents() {
            return this.iDeptRequest;
        }

        @Transient
        public boolean isEventManagersCanApprove() {
            return this.iMgrApproval;
        }

        @Transient
        public boolean isEventManagersCanRequestEvents() {
            return this.iMgrRequest;
        }

        @Transient
        public boolean isAutomaticApproval() {
            return this.iAutoApproval;
        }

        public String toString() {
            return this.name().replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2");
        }
    }
}

