/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.PitClassInstructor;
import org.unitime.timetable.model.base.BasePitDepartmentalInstructor;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="pit_dept_instructor")
public class PitDepartmentalInstructor
extends BasePitDepartmentalInstructor
implements NameInterface {
    private static final long serialVersionUID = 7035406494022531331L;
    private float organizedWeeklyContactHours = -1.0f;
    private float organizedWeeklyStudentContactHours = -1.0f;
    private float allWeeklyContactHours = -1.0f;
    private float allWeeklyStudentContactHours = -1.0f;

    public float getOrganizedWeeklyContactHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.organizedWeeklyContactHours < 0.0f) {
            for (PitClassInstructor pci : this.getPitClassesInstructing()) {
                this.organizedWeeklyContactHours += pci.getOrganizedWeeklyContactHours(standardMinutesInReportingHour, standardWeeksInReportingTerm);
            }
        }
        return this.organizedWeeklyContactHours;
    }

    public float getOrganizedWeeklyStudentContactHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.organizedWeeklyStudentContactHours < 0.0f) {
            for (PitClassInstructor pci : this.getPitClassesInstructing()) {
                this.organizedWeeklyStudentContactHours += pci.getAllWeeklyStudentContactHours(standardMinutesInReportingHour, standardWeeksInReportingTerm);
            }
        }
        return this.organizedWeeklyStudentContactHours;
    }

    public float getAllWeeklyContactHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.allWeeklyContactHours < 0.0f) {
            for (PitClassInstructor pci : this.getPitClassesInstructing()) {
                this.allWeeklyContactHours += pci.getAllWeeklyContactHours(standardMinutesInReportingHour, standardWeeksInReportingTerm);
            }
        }
        return this.allWeeklyContactHours;
    }

    public float getAllWeeklyStudentContactHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.allWeeklyStudentContactHours < 0.0f) {
            for (PitClassInstructor pci : this.getPitClassesInstructing()) {
                this.allWeeklyStudentContactHours += pci.getAllWeeklyStudentContactHours(standardMinutesInReportingHour, standardWeeksInReportingTerm);
            }
        }
        return this.allWeeklyStudentContactHours;
    }

    @Override
    @Transient
    public String getAcademicTitle() {
        return null;
    }

    public String getName(String instructorNameFormat) {
        return NameFormat.fromReference(instructorNameFormat).format(this);
    }
}

