/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.PitClassEvent;
import org.unitime.timetable.model.PitClassInstructor;
import org.unitime.timetable.model.PitClassMeeting;
import org.unitime.timetable.model.PitClassMeetingUtilPeriod;
import org.unitime.timetable.model.base.BasePitClass;
import org.unitime.timetable.util.Constants;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="pit_class")
public class PitClass
extends BasePitClass {
    private static final long serialVersionUID = 642241232877633526L;
    private float weeklyClassHours = -1.0f;
    private float weeklyStudentClassHours = -1.0f;
    private HashMap<Long, HashSet<Date>> locationPeriodUseMap = null;
    private Set<Long> locationPermanentIdList = null;
    private HashSet<Date> uniquePeriods = null;

    private float calculateWCHforLocationFromPeriods(Long location, Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        float minutesInReportingHour = standardMinutesInReportingHour == null ? ApplicationProperty.StandardMinutesInReportingHour.floatValue().floatValue() : standardMinutesInReportingHour.floatValue();
        float weeksInReportingTerm = (standardWeeksInReportingTerm == null ? ApplicationProperty.StandardWeeksInReportingTerm.floatValue() : standardWeeksInReportingTerm).floatValue();
        HashSet<Date> periods = this.getLocationPeriodUseMap().get(location);
        if (periods != null) {
            return (float)periods.size() * ((float)Constants.SLOT_LENGTH_MIN * 1.0f) / minutesInReportingHour / weeksInReportingTerm;
        }
        return 0.0f;
    }

    @Transient
    public HashMap<Long, HashSet<Date>> getLocationPeriodUseMap() {
        if (this.locationPeriodUseMap == null) {
            this.initializeRoomData();
        }
        return this.locationPeriodUseMap;
    }

    @Transient
    public HashSet<Date> getUniquePeriods() {
        if (this.uniquePeriods == null) {
            this.initializeRoomData();
        }
        return this.uniquePeriods;
    }

    private void initializeRoomData() {
        this.locationPeriodUseMap = new HashMap();
        for (PitClassEvent pitClassEvent : this.getPitClassEvents()) {
            for (PitClassMeeting pcm : pitClassEvent.getPitClassMeetings()) {
                if (this.getPitSchedulingSubpart().getPitInstrOfferingConfig().getPitInstructionalOffering().getPointInTimeData().getSession().getSessionBeginDateTime().compareTo(pcm.getMeetingDate()) > 0 || this.getPitSchedulingSubpart().getPitInstrOfferingConfig().getPitInstructionalOffering().getPointInTimeData().getSession().getClassesEndDateTime().compareTo(pcm.getMeetingDate()) < 0) continue;
                for (PitClassMeetingUtilPeriod pcmup : pcm.getPitClassMeetingUtilPeriods()) {
                    HashSet<Date> periods = this.locationPeriodUseMap.get(pcm.getLocationPermanentId());
                    if (periods == null) {
                        periods = new HashSet();
                        this.locationPeriodUseMap.put(pcm.getLocationPermanentId(), periods);
                    }
                    periods.add(pcmup.periodDateTime());
                }
            }
        }
        this.locationPermanentIdList = this.locationPeriodUseMap.keySet();
        this.uniquePeriods = new HashSet();
        for (HashSet hashSet : this.locationPeriodUseMap.values()) {
            this.uniquePeriods.addAll(hashSet);
        }
    }

    @Transient
    public Set<Long> getLocationPermanentIdList() {
        if (this.locationPermanentIdList == null) {
            this.initializeRoomData();
        }
        return this.locationPermanentIdList;
    }

    public HashSet<Date> getPeriodsForLocation(Long location) {
        return this.getLocationPeriodUseMap().get(location);
    }

    @Transient
    public boolean isOrganized() {
        return this.getPitSchedulingSubpart().getItype().isOrganized();
    }

    public float countRoomsForPeriod(Date period) {
        float cnt = 0.0f;
        for (HashSet<Date> periods : this.getLocationPeriodUseMap().values()) {
            if (!periods.contains(period)) continue;
            cnt += 1.0f;
        }
        return cnt;
    }

    private float calculateWSCHfromPeriodsForLocation(Long location, Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        float minutesInReportingHour = standardMinutesInReportingHour == null ? ApplicationProperty.StandardMinutesInReportingHour.floatValue().floatValue() : standardMinutesInReportingHour.floatValue();
        float weeksInReportingTerm = (standardWeeksInReportingTerm == null ? ApplicationProperty.StandardWeeksInReportingTerm.floatValue() : standardWeeksInReportingTerm).floatValue();
        HashSet<Date> periods = this.getLocationPeriodUseMap().get(location);
        float wrm = 0.0f;
        for (Date period : periods) {
            wrm += (float)Constants.SLOT_LENGTH_MIN * 1.0f / this.countRoomsForPeriod(period);
        }
        return wrm * (float)this.getStudentEnrollments().size() / minutesInReportingHour / weeksInReportingTerm;
    }

    private float calculateWCH(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        float minutesInReportingHour = standardMinutesInReportingHour == null ? ApplicationProperty.StandardMinutesInReportingHour.floatValue().floatValue() : standardMinutesInReportingHour.floatValue();
        float weeksInReportingTerm = (standardWeeksInReportingTerm == null ? ApplicationProperty.StandardWeeksInReportingTerm.floatValue() : standardWeeksInReportingTerm).floatValue();
        return (float)Constants.SLOT_LENGTH_MIN * 1.0f * (float)this.getUniquePeriods().size() / minutesInReportingHour / weeksInReportingTerm;
    }

    private float calculateWSCH(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        return this.getAllWeeklyClassHours(standardMinutesInReportingHour, standardWeeksInReportingTerm) * (float)this.getStudentEnrollments().size();
    }

    public float getOrganizedWeeklyRoomHoursFromUtilPeriodsForLocation(Long location, Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.getPitSchedulingSubpart().getItype().isOrganized().booleanValue()) {
            return this.calculateWCHforLocationFromPeriods(location, standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return 0.0f;
    }

    public float getAllWeeklyRoomHoursFromUtilPeriodsForLocation(Long location, Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        return this.calculateWCHforLocationFromPeriods(location, standardMinutesInReportingHour, standardWeeksInReportingTerm);
    }

    public float getNotOrganizedWeeklyRoomHoursFromUtilPeriodsForLocation(Long location, Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (!this.getPitSchedulingSubpart().getItype().isOrganized().booleanValue()) {
            return this.calculateWCHforLocationFromPeriods(location, standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return 0.0f;
    }

    public float getOrganizedWeeklyClassHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.getPitSchedulingSubpart().getItype().isOrganized().booleanValue()) {
            return this.getAllWeeklyClassHours(standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return 0.0f;
    }

    public float getNotOrganizedWeeklyClassHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (!this.getPitSchedulingSubpart().getItype().isOrganized().booleanValue()) {
            return this.getAllWeeklyClassHours(standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return 0.0f;
    }

    public float getOrganizedWeeklyStudentClassHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.getPitSchedulingSubpart().getItype().isOrganized().booleanValue()) {
            return this.getAllWeeklyStudentClassHours(standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return 0.0f;
    }

    public float getNotOrganizedWeeklyStudentClassHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (!this.getPitSchedulingSubpart().getItype().isOrganized().booleanValue()) {
            return this.getAllWeeklyStudentClassHours(standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return 0.0f;
    }

    public float getAllWeeklyClassHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.weeklyClassHours < 0.0f) {
            this.weeklyClassHours = this.calculateWCH(standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return this.weeklyClassHours;
    }

    public float getAllWeeklyStudentClassHours(Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.weeklyStudentClassHours < 0.0f) {
            this.weeklyStudentClassHours = this.calculateWSCH(standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return this.weeklyStudentClassHours;
    }

    public float getAllWeeklyStudentClassHoursForLocation(Long location, Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        return this.calculateWSCHfromPeriodsForLocation(location, standardMinutesInReportingHour, standardWeeksInReportingTerm);
    }

    public float getOrganizedWeeklyStudentClassHoursForLocation(Long location, Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (this.getPitSchedulingSubpart().getItype().isOrganized().booleanValue()) {
            return this.getAllWeeklyStudentClassHoursForLocation(location, standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return 0.0f;
    }

    public float getNotOrganizedWeeklyStudentClassHoursForLocation(Long location, Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
        if (!this.getPitSchedulingSubpart().getItype().isOrganized().booleanValue()) {
            return this.getAllWeeklyStudentClassHoursForLocation(location, standardMinutesInReportingHour, standardWeeksInReportingTerm);
        }
        return 0.0f;
    }

    public HashMap<Date, Float> findPeriodEnrollmentsForCriteria(HashSet<Long> validRoomPermanentIds, ArrayList<Long> positionTypes) {
        HashMap<Date, Float> periodEnrollmentMap = new HashMap<Date, Float>();
        float ratio = 0.0f;
        if (positionTypes != null && !positionTypes.isEmpty()) {
            if (this.getPitClassInstructors() == null || this.getPitClassInstructors().isEmpty()) {
                if (positionTypes.contains(-1L)) {
                    ratio = 1.0f;
                }
            } else {
                for (PitClassInstructor pci : this.getPitClassInstructors()) {
                    if (pci.getPitDepartmentalInstructor().getPositionType() != null && positionTypes.contains(pci.getPitDepartmentalInstructor().getPositionType().getUniqueId())) {
                        ratio += (float)pci.getNormalizedPercentShare().intValue() / 100.0f;
                        continue;
                    }
                    if (pci.getPitDepartmentalInstructor().getPositionType() != null || !positionTypes.contains(-1L)) continue;
                    ratio += (float)pci.getNormalizedPercentShare().intValue() / 100.0f;
                }
            }
        } else {
            ratio = 1.0f;
        }
        HashSet<Long> applicableLocationPermananetIds = new HashSet<Long>();
        for (Long permId : this.getLocationPermanentIdList()) {
            if (!validRoomPermanentIds.contains(permId)) continue;
            applicableLocationPermananetIds.add(permId);
        }
        if (applicableLocationPermananetIds.size() == this.getLocationPermanentIdList().size()) {
            for (Date period : this.uniquePeriods) {
                periodEnrollmentMap.put(period, Float.valueOf((float)this.getEnrollment().intValue() * ratio));
            }
        } else {
            for (PitClassEvent pce : this.getPitClassEvents()) {
                for (PitClassMeeting pcm : pce.getPitClassMeetings()) {
                    if (this.getPitSchedulingSubpart().getPitInstrOfferingConfig().getPitInstructionalOffering().getPointInTimeData().getSession().getSessionBeginDateTime().compareTo(pcm.getMeetingDate()) > 0 || this.getPitSchedulingSubpart().getPitInstrOfferingConfig().getPitInstructionalOffering().getPointInTimeData().getSession().getClassesEndDateTime().compareTo(pcm.getMeetingDate()) < 0 || !applicableLocationPermananetIds.contains(pcm.getLocationPermanentId())) continue;
                    for (PitClassMeetingUtilPeriod pcmup : pcm.getPitClassMeetingUtilPeriods()) {
                        periodEnrollmentMap.put(pcmup.periodDateTime(), Float.valueOf((float)this.getEnrollment().intValue() * (1.0f / this.countRoomsForPeriod(pcmup.periodDateTime())) * ratio));
                    }
                }
            }
        }
        return periodEnrollmentMap;
    }
}

