/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.List;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseLearningManagementSystemInfo;
import org.unitime.timetable.model.dao.LearningManagementSystemInfoDAO;
import org.unitime.timetable.security.UserContext;

@Entity
@Table(name="learn_mgmt_sys_info")
public class LearningManagementSystemInfo
extends BaseLearningManagementSystemInfo {
    private static final long serialVersionUID = 45964274048126169L;
    public static String LEARNING_MANAGEMENT_SYSTEM_LIST_ATTR = "lmsList";

    public boolean isUsed(org.hibernate.Session hibSession) {
        if (this.isDefaultLms().booleanValue()) {
            return true;
        }
        return ((Number)(hibSession == null ? LearningManagementSystemInfoDAO.getInstance().getSession() : hibSession).createQuery("select count(c) from Class_ c where c.lmsInfo.uniqueId = :lmsId", Number.class).setParameter("lmsId", (Object)this.getUniqueId()).setCacheable(true).uniqueResult()).intValue() > 0;
    }

    public static List<LearningManagementSystemInfo> findAll(UserContext user) {
        return LearningManagementSystemInfo.findAll(user.getCurrentAcademicSessionId());
    }

    public static List<LearningManagementSystemInfo> findAll(Long sessionId) {
        List list = LearningManagementSystemInfoDAO.getInstance().getSession().createQuery("select distinct lms from LearningManagementSystemInfo as lms where lms.session.uniqueId=:sessionId", LearningManagementSystemInfo.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
        return list;
    }

    public static LearningManagementSystemInfo findBySessionIdAndReference(Long sessionId, String reference) {
        LearningManagementSystemInfo lms = (LearningManagementSystemInfo)LearningManagementSystemInfoDAO.getInstance().getSession().createQuery("select distinct lms from LearningManagementSystemInfo as lms where lms.session.uniqueId=:sessionId and lms.reference = :ref", LearningManagementSystemInfo.class).setParameter("sessionId", (Object)sessionId).setParameter("ref", (Object)reference).setCacheable(true).uniqueResult();
        return lms;
    }

    public static LearningManagementSystemInfo getDefaultIfExists(Long sessionId) {
        return (LearningManagementSystemInfo)LearningManagementSystemInfoDAO.getInstance().getSession().createQuery("select distinct lms from LearningManagementSystemInfo as lms where lms.session.uniqueId=:sessionId and lms.defaultLms = true", LearningManagementSystemInfo.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).uniqueResult();
    }

    public static boolean isLmsInfoDefinedForSession(Long sessionId) {
        LearningManagementSystemInfoDAO lmsdao = LearningManagementSystemInfoDAO.getInstance();
        return lmsdao.findBySession(lmsdao.getSession(), sessionId).size() > 0;
    }

    public static boolean isLmsInfoDefinedForSession(Session hibSession, Long sessionId) {
        return LearningManagementSystemInfo.isLmsInfoDefinedForSession(hibSession, sessionId);
    }

    public Object clone() {
        LearningManagementSystemInfo newLms = new LearningManagementSystemInfo();
        newLms.setReference(this.getReference());
        newLms.setLabel(this.getLabel());
        newLms.setExternalUniqueId(this.getExternalUniqueId());
        newLms.setDefaultLms(this.getDefaultLms());
        newLms.setSession(this.getSession());
        return newLms;
    }
}

