/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.base.BaseIndividualReservation;

@Entity
@DiscriminatorValue(value="0")
public class IndividualReservation
extends BaseIndividualReservation {
    private static final long serialVersionUID = 1L;

    public IndividualReservation() {
    }

    public IndividualReservation(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public boolean isApplicable(Student student, CourseRequest request) {
        return this.getStudents().contains(student);
    }

    @Override
    @Transient
    public int getPriority() {
        return ApplicationProperty.ReservationPriorityIndividual.intValue();
    }

    @Override
    @Transient
    public boolean isCanAssignOverLimit() {
        return ApplicationProperty.ReservationCanOverLimitIndividual.isTrue();
    }

    @Override
    @Transient
    public boolean isMustBeUsed() {
        return ApplicationProperty.ReservationMustBeUsedIndividual.isTrue();
    }

    @Override
    @Transient
    public boolean isAllowOverlap() {
        return ApplicationProperty.ReservationAllowOverlapIndividual.isTrue();
    }

    @Override
    @Transient
    public int getReservationLimit() {
        return this.getStudents().size();
    }
}

