/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.List;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseExternalRoom;
import org.unitime.timetable.model.dao.ExternalRoomDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="external_room")
public class ExternalRoom
extends BaseExternalRoom {
    private static final long serialVersionUID = 1L;

    public ExternalRoom() {
    }

    public ExternalRoom(Long uniqueId) {
        super(uniqueId);
    }

    public static ExternalRoom findExternalRoomForSession(String externalUniqueId, Session session) {
        return (ExternalRoom)ExternalRoomDAO.getInstance().getSession().createQuery("from ExternalRoom where externalUniqueId = :externalUniqueId and building.session.uniqueId = :sessionId", ExternalRoom.class).setParameter("externalUniqueId", (Object)externalUniqueId).setParameter("sessionId", (Object)session.getUniqueId()).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    public static List<ExternalRoom> findAll(Long sessionId) {
        return ExternalRoomDAO.getInstance().getSession().createQuery("select r from ExternalRoom r where r.building.session.uniqueId=:sessionId", ExternalRoom.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    public static ExternalRoom findByBldgAbbvRoomNbr(Long sessionId, String bldgAbbv, String roomNbr) {
        return (ExternalRoom)ExternalRoomDAO.getInstance().getSession().createQuery("select r from ExternalRoom r where r.building.session.uniqueId=:sessionId and r.building.abbreviation=:bldgAbbv and r.roomNumber=:roomNbr", ExternalRoom.class).setParameter("sessionId", (Object)sessionId).setParameter("bldgAbbv", (Object)bldgAbbv).setParameter("roomNbr", (Object)roomNbr).uniqueResult();
    }
}

