/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseExamPeriod;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.ExamPeriodDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="exam_period")
public class ExamPeriod
extends BaseExamPeriod
implements Comparable<ExamPeriod> {
    private static final long serialVersionUID = 1L;
    public static String PERIOD_ATTR_NAME = "periodList";

    public ExamPeriod() {
    }

    public ExamPeriod(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public Date getStartDate() {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.getSession().getExamBeginDate());
        c.add(6, this.getDateOffset());
        return c.getTime();
    }

    public void setStartDate(Date startDate) {
        long diff = startDate.getTime() - this.getSession().getExamBeginDate().getTime();
        this.setDateOffset((int)Math.round((double)diff / 8.64E7));
    }

    @Transient
    public int getStartHour() {
        return (Constants.SLOT_LENGTH_MIN * this.getStartSlot() + Constants.FIRST_SLOT_TIME_MIN) / 60;
    }

    @Transient
    public int getStartMinute() {
        return (Constants.SLOT_LENGTH_MIN * this.getStartSlot() + Constants.FIRST_SLOT_TIME_MIN) % 60;
    }

    @Transient
    public Date getStartTime() {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.getSession().getExamBeginDate());
        c.add(6, this.getDateOffset());
        c.set(10, this.getStartHour());
        c.set(12, this.getStartMinute());
        return c.getTime();
    }

    @Transient
    public int getEndSlot() {
        return this.getStartSlot() + this.getLength();
    }

    @Transient
    public int getEndHour() {
        return (Constants.SLOT_LENGTH_MIN * this.getEndSlot() + Constants.FIRST_SLOT_TIME_MIN) / 60;
    }

    @Transient
    public int getEndMinute() {
        return (Constants.SLOT_LENGTH_MIN * this.getEndSlot() + Constants.FIRST_SLOT_TIME_MIN) % 60;
    }

    @Transient
    public Date getEndTime() {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.getSession().getExamBeginDate());
        c.add(6, this.getDateOffset());
        c.set(10, this.getEndHour());
        c.set(12, this.getEndMinute());
        return c.getTime();
    }

    @Transient
    public String getStartDateLabel() {
        return Formats.getDateFormat(Formats.Pattern.DATE_EXAM_PERIOD).format(this.getStartDate());
    }

    @Transient
    public String getStartTimeLabel() {
        int min = this.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        return Constants.toTime(min);
    }

    public String getStartTimeLabel(int printOffset) {
        int min = this.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + printOffset;
        return Constants.toTime(min);
    }

    @Transient
    public String getEndTimeLabel() {
        int min = (this.getStartSlot() + this.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        return Constants.toTime(min);
    }

    public String getEndTimeLabel(int length, int printOffset) {
        int min = this.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + length + printOffset;
        return Constants.toTime(min);
    }

    @Transient
    public String getName() {
        return this.getStartDateLabel() + " " + this.getStartTimeLabel() + " - " + this.getEndTimeLabel();
    }

    @Transient
    public String getAbbreviation() {
        return this.getStartDateLabel() + " " + this.getStartTimeLabel();
    }

    @Override
    public int compareTo(ExamPeriod period) {
        int cmp = this.getExamType().compareTo(period.getExamType());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getDateOffset().compareTo(period.getDateOffset());
        if (cmp != 0) {
            return cmp;
        }
        return this.getStartSlot().compareTo(period.getStartSlot());
    }

    public static TreeSet<ExamPeriod> findAll(Long sessionId, ExamType type) {
        return ExamPeriod.findAll(sessionId, type == null ? null : type.getUniqueId());
    }

    public static TreeSet<ExamPeriod> findAll(Long sessionId, Long examTypeId) {
        TreeSet<ExamPeriod> ret = new TreeSet<ExamPeriod>();
        if (examTypeId == null) {
            ret.addAll(ExamPeriodDAO.getInstance().getSession().createQuery("select ep from ExamPeriod ep where ep.session.uniqueId=:sessionId", ExamPeriod.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list());
        } else {
            ret.addAll(ExamPeriodDAO.getInstance().getSession().createQuery("select ep from ExamPeriod ep where ep.session.uniqueId=:sessionId and ep.examType.uniqueId=:typeId", ExamPeriod.class).setParameter("sessionId", (Object)sessionId).setParameter("typeId", (Object)examTypeId).setCacheable(true).list());
        }
        return ret;
    }

    public static ExamPeriod findByDateStart(Long sessionId, int dateOffset, int startSlot, Long examTypeId) {
        return (ExamPeriod)ExamPeriodDAO.getInstance().getSession().createQuery("select ep from ExamPeriod ep where ep.session.uniqueId = :sessionId and ep.dateOffset = :dateOffset and ep.startSlot = :startSlot and ep.examType.uniqueId = :typeId", ExamPeriod.class).setParameter("sessionId", (Object)sessionId).setParameter("dateOffset", (Object)dateOffset).setParameter("startSlot", (Object)startSlot).setParameter("typeId", (Object)examTypeId).setCacheable(true).uniqueResult();
    }

    public static ExamPeriod findByIndex(Long sessionId, ExamType type, Integer idx) {
        if (idx == null || idx < 0) {
            return null;
        }
        int x = 0;
        TreeSet<ExamPeriod> periods = ExamPeriod.findAll(sessionId, type);
        for (ExamPeriod period : periods) {
            if (x == idx) {
                return period;
            }
            ++x;
        }
        return periods.isEmpty() ? null : periods.last();
    }

    @Override
    public String toString() {
        return this.getAbbreviation();
    }

    public boolean isBackToBack(ExamPeriod period, boolean isDayBreakBackToBack) {
        if (!isDayBreakBackToBack && !period.getDateOffset().equals(this.getDateOffset())) {
            return false;
        }
        for (ExamPeriod p : ExamPeriod.findAll(this.getSession().getUniqueId(), this.getExamType())) {
            if (this.compareTo(p) < 0 && p.compareTo(period) < 0) {
                return false;
            }
            if (this.compareTo(p) <= 0 || p.compareTo(period) <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean overlap(Assignment assignment) {
        return this.overlap(assignment, (int)ApplicationProperty.ExaminationTravelTimeClass.intValue());
    }

    public boolean overlap(Assignment assignment, int nrTravelSlots) {
        DatePattern dp = assignment.getDatePattern();
        int dpIndex = this.getDateOffset() - this.getSession().getExamBeginOffset() - (dp.getOffset() == null ? 0 : dp.getOffset());
        if (dp.getPattern() == null || dpIndex < 0 || dpIndex >= dp.getPattern().length() || dp.getPattern().charAt(dpIndex) != '1') {
            return false;
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.getSession().getExamBeginDate());
        cal.add(6, this.getDateOffset());
        switch (cal.get(7)) {
            case 2: {
                if ((assignment.getDays() & Constants.DAY_CODES[0]) != 0) break;
                return false;
            }
            case 3: {
                if ((assignment.getDays() & Constants.DAY_CODES[1]) != 0) break;
                return false;
            }
            case 4: {
                if ((assignment.getDays() & Constants.DAY_CODES[2]) != 0) break;
                return false;
            }
            case 5: {
                if ((assignment.getDays() & Constants.DAY_CODES[3]) != 0) break;
                return false;
            }
            case 6: {
                if ((assignment.getDays() & Constants.DAY_CODES[4]) != 0) break;
                return false;
            }
            case 7: {
                if ((assignment.getDays() & Constants.DAY_CODES[5]) != 0) break;
                return false;
            }
            case 1: {
                if ((assignment.getDays() & Constants.DAY_CODES[6]) != 0) break;
                return false;
            }
        }
        return this.getStartSlot() - nrTravelSlots < assignment.getStartSlot() + assignment.getSlotPerMtg() && assignment.getStartSlot() < this.getStartSlot() + this.getLength() + nrTravelSlots;
    }

    public boolean overlap(Meeting meeting) {
        return this.overlap(meeting, (int)ApplicationProperty.ExaminationTravelTimeClass.intValue());
    }

    public boolean overlap(Meeting meeting, int nrTravelSlots) {
        if (!meeting.getMeetingDate().equals(this.getStartDate())) {
            return false;
        }
        return this.getStartSlot() - nrTravelSlots < meeting.getStopPeriod() && meeting.getStartPeriod() < this.getStartSlot() + this.getLength() + nrTravelSlots;
    }

    @Transient
    protected int getStartMins() {
        return Constants.SLOT_LENGTH_MIN * this.getStartSlot() + Constants.FIRST_SLOT_TIME_MIN;
    }

    public boolean overlap(Exam x1, Exam x2, ExamPeriod period) {
        if (this.equals(period)) {
            return false;
        }
        if (!this.getStartDate().equals(period.getStartDate())) {
            return false;
        }
        return this.getStartMins() < period.getStartMins() + x2.getLength() && period.getStartMins() < this.getStartMins() + x1.getLength();
    }

    public List<Meeting> findOverlappingClassMeetings() {
        return this.findOverlappingClassMeetings(ApplicationProperty.ExaminationTravelTimeClass.intValue());
    }

    public List<Meeting> findOverlappingClassMeetings(int nrTravelSlots) {
        return ExamPeriodDAO.getInstance().getSession().createQuery("select m from ClassEvent e inner join e.meetings m where m.meetingDate=:startDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot", Meeting.class).setParameter("startDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setCacheable(true).list();
    }

    public List<Meeting> findOverlappingClassMeetings(Long classId) {
        return this.findOverlappingClassMeetings(classId, ApplicationProperty.ExaminationTravelTimeClass.intValue());
    }

    public List<Meeting> findOverlappingClassMeetings(Long classId, int nrTravelSlots) {
        return ExamPeriodDAO.getInstance().getSession().createQuery("select m from ClassEvent e inner join e.meetings m where m.meetingDate=:startDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and e.clazz.uniqueId=:classId", Meeting.class).setParameter("startDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("classId", (Object)classId).setCacheable(true).list();
    }

    public Hashtable<Meeting, Set<Long>> findOverlappingCourseMeetingsWithReqAttendence(Set<Long> studentIds) {
        return this.findOverlappingCourseMeetingsWithReqAttendence(studentIds, ApplicationProperty.ExaminationTravelTimeCourse.intValue());
    }

    public Hashtable<Meeting, Set<Long>> findOverlappingCourseMeetingsWithReqAttendence(Set<Long> studentIds, int nrTravelSlots) {
        Hashtable<Meeting, Set<Long>> ret = new Hashtable<Meeting, Set<Long>>();
        if (studentIds == null || studentIds.isEmpty()) {
            return ret;
        }
        Object students = "";
        int nrStudents = 0;
        for (Long studentId : studentIds) {
            Set<Long> conf;
            long xstudentId;
            Meeting meeting;
            students = (String)students + (((String)students).length() == 0 ? "" : ",") + studentId;
            if (++nrStudents != 1000) continue;
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from CourseEvent e inner join e.meetings m inner join e.relatedCourses o, StudentClassEnrollment s where e.reqAttendance=true and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:classType and s.clazz.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("classType", (Object)3).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                xstudentId = (Long)o[1];
                conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from CourseEvent e inner join e.meetings m inner join e.relatedCourses o, StudentClassEnrollment s where e.reqAttendance=true and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:configType and s.clazz.schedulingSubpart.instrOfferingConfig.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("configType", (Object)2).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                xstudentId = (Long)o[1];
                conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from CourseEvent e inner join e.meetings m inner join e.relatedCourses o, StudentClassEnrollment s where e.reqAttendance=true and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:courseType and s.courseOffering.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("courseType", (Object)1).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                xstudentId = (Long)o[1];
                conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from CourseEvent e inner join e.meetings m inner join e.relatedCourses o, StudentClassEnrollment s where e.reqAttendance=true and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:offeringType and s.courseOffering.instructionalOffering.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("offeringType", (Object)0).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                xstudentId = (Long)o[1];
                conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            students = "";
            nrStudents = 0;
        }
        if (nrStudents > 0 && ((String)students).trim().length() > 0) {
            Meeting meeting;
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from CourseEvent e inner join e.meetings m inner join e.relatedCourses o, StudentClassEnrollment s where e.reqAttendance=true and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:classType and s.clazz.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("classType", (Object)3).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                long xstudentId = (Long)o[1];
                Set<Long> conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from CourseEvent e inner join e.meetings m inner join e.relatedCourses o, StudentClassEnrollment s where e.reqAttendance=true and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:configType and s.clazz.schedulingSubpart.instrOfferingConfig.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("configType", (Object)2).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                long xstudentId = (Long)o[1];
                Set<Long> conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from CourseEvent e inner join e.meetings m inner join e.relatedCourses o, StudentClassEnrollment s where e.reqAttendance=true and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:courseType and s.courseOffering.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("courseType", (Object)1).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                long xstudentId = (Long)o[1];
                Set<Long> conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from CourseEvent e inner join e.meetings m inner join e.relatedCourses o, StudentClassEnrollment s where e.reqAttendance=true and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:offeringType and s.courseOffering.instructionalOffering.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("offeringType", (Object)0).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                long xstudentId = (Long)o[1];
                Set<Long> conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
        }
        return ret;
    }

    public Hashtable<Meeting, Set<Long>> findOverlappingExamMeetingsOfDifferentProblem(Set<Long> studentIds) {
        return this.findOverlappingExamMeetingsOfDifferentProblem(studentIds, ApplicationProperty.ExaminationTravelTimeCourse.intValue());
    }

    public Hashtable<Meeting, Set<Long>> findOverlappingExamMeetingsOfDifferentProblem(Set<Long> studentIds, int nrTravelSlots) {
        Hashtable<Meeting, Set<Long>> ret = new Hashtable<Meeting, Set<Long>>();
        if (studentIds == null || studentIds.isEmpty()) {
            return ret;
        }
        Object students = "";
        int nrStudents = 0;
        for (Long studentId : studentIds) {
            Set<Long> conf;
            long xstudentId;
            Meeting meeting;
            students = (String)students + (((String)students).length() == 0 ? "" : ",") + studentId;
            if (++nrStudents != 1000) continue;
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from ExamEvent e inner join e.meetings m inner join e.exam.owners o, StudentClassEnrollment s where e.exam.examType.uniqueId!=:examTypeId and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:classType and s.clazz.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("classType", (Object)3).setParameter("examTypeId", (Object)this.getExamType().getUniqueId()).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                xstudentId = (Long)o[1];
                conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from ExamEvent e inner join e.meetings m inner join e.exam.owners o, StudentClassEnrollment s where e.exam.examType.uniqueId!=:examTypeId and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:configType and s.clazz.schedulingSubpart.instrOfferingConfig.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("configType", (Object)2).setParameter("examTypeId", (Object)this.getExamType().getUniqueId()).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                xstudentId = (Long)o[1];
                conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from ExamEvent e inner join e.meetings m inner join e.exam.owners o, StudentClassEnrollment s where e.exam.examType.uniqueId!=:examTypeId and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:courseType and s.courseOffering.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("courseType", (Object)1).setParameter("examTypeId", (Object)this.getExamType().getUniqueId()).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                xstudentId = (Long)o[1];
                conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from ExamEvent e inner join e.meetings m inner join e.exam.owners o, StudentClassEnrollment s where e.exam.examType.uniqueId!=:examTypeId and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:offeringType and s.courseOffering.instructionalOffering.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("offeringType", (Object)0).setParameter("examTypeId", (Object)this.getExamType().getUniqueId()).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                xstudentId = (Long)o[1];
                conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            students = "";
            nrStudents = 0;
        }
        if (nrStudents > 0 && ((String)students).trim().length() > 0) {
            Meeting meeting;
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from ExamEvent e inner join e.meetings m inner join e.exam.owners o, StudentClassEnrollment s where e.exam.examType.uniqueId!=:examTypeId and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:classType and s.clazz.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("classType", (Object)3).setParameter("examTypeId", (Object)this.getExamType().getUniqueId()).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                long xstudentId = (Long)o[1];
                Set<Long> conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from ExamEvent e inner join e.meetings m inner join e.exam.owners o, StudentClassEnrollment s where e.exam.examType.uniqueId!=:examTypeId and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:configType and s.clazz.schedulingSubpart.instrOfferingConfig.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("configType", (Object)2).setParameter("examTypeId", (Object)this.getExamType().getUniqueId()).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                long xstudentId = (Long)o[1];
                Set<Long> conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from ExamEvent e inner join e.meetings m inner join e.exam.owners o, StudentClassEnrollment s where e.exam.examType.uniqueId!=:examTypeId and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:courseType and s.courseOffering.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("courseType", (Object)1).setParameter("examTypeId", (Object)this.getExamType().getUniqueId()).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                long xstudentId = (Long)o[1];
                Set<Long> conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m, s.student.uniqueId from ExamEvent e inner join e.meetings m inner join e.exam.owners o, StudentClassEnrollment s where e.exam.examType.uniqueId!=:examTypeId and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and o.ownerType=:offeringType and s.courseOffering.instructionalOffering.uniqueId=o.ownerId", Object[].class).setParameter("meetingDate", (Object)this.getStartDate()).setParameter("startSlot", (Object)(this.getStartSlot() - nrTravelSlots)).setParameter("endSlot", (Object)(this.getEndSlot() + nrTravelSlots)).setParameter("offeringType", (Object)0).setParameter("examTypeId", (Object)this.getExamType().getUniqueId()).setCacheable(true).list()) {
                meeting = (Meeting)o[0];
                long xstudentId = (Long)o[1];
                Set<Long> conf = ret.get(meeting);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(meeting, conf);
                }
                conf.add(xstudentId);
            }
        }
        return ret;
    }

    @Transient
    public int getIndex() {
        int index = 0;
        Iterator<ExamPeriod> i = ExamPeriod.findAll(this.getSession().getUniqueId(), this.getExamType()).iterator();
        while (i.hasNext()) {
            if (this.compareTo(i.next()) <= 0) continue;
            ++index;
        }
        return index;
    }

    public Object clone() {
        ExamPeriod newExamPeriod = new ExamPeriod();
        newExamPeriod.setExamType(this.getExamType());
        newExamPeriod.setDateOffset(this.getDateOffset());
        newExamPeriod.setLength(this.getLength());
        newExamPeriod.setPrefLevel(this.getPrefLevel());
        newExamPeriod.setStartSlot(this.getStartSlot());
        newExamPeriod.setSession(this.getSession());
        newExamPeriod.setEventStartOffset(this.getEventStartOffset());
        newExamPeriod.setEventStopOffset(this.getEventStopOffset());
        return newExamPeriod;
    }

    public ExamPeriod findSameExamPeriodInSession(Session session) {
        if (session == null) {
            return null;
        }
        return (ExamPeriod)ExamPeriodDAO.getInstance().getSession().createQuery("select distinct ep from ExamPeriod ep where ep.session.uniqueId = :sessionId and ep.examType.uniqueId = :examTypeId and ep.dateOffset = :dateOffset and ep.length = :length and ep.prefLevel.uniqueId = :prefLevelId and ep.startSlot = :startSlot", ExamPeriod.class).setParameter("sessionId", (Object)session.getUniqueId()).setParameter("examTypeId", (Object)this.getExamType().getUniqueId()).setParameter("dateOffset", (Object)this.getDateOffset()).setParameter("length", (Object)this.getLength()).setParameter("prefLevelId", (Object)this.getPrefLevel().getUniqueId()).setParameter("startSlot", (Object)this.getStartSlot()).setCacheable(true).uniqueResult();
    }

    @Transient
    public int getDayOfWeek() {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.getSession().getExamBeginDate());
        c.add(6, this.getDateOffset());
        return c.get(7);
    }

    public boolean weakOverlap(Meeting meeting) {
        return this.getDayOfWeek() == meeting.getDayOfWeek() && this.getStartSlot() < meeting.getStopPeriod() && meeting.getStartPeriod() < this.getStartSlot() + this.getLength();
    }

    public boolean overlap(RoomAvailabilityInterface.TimeBlock time) {
        int breakTimeStart = this.getEventStartOffset() * Constants.SLOT_LENGTH_MIN;
        int breakTimeStop = this.getEventStopOffset() * Constants.SLOT_LENGTH_MIN;
        Date start = time.getStartTime();
        if (breakTimeStart != 0) {
            Calendar c = Calendar.getInstance(Locale.US);
            c.setTime(start);
            c.add(12, -breakTimeStart);
            start = c.getTime();
        }
        Date stop = time.getEndTime();
        if (breakTimeStop != 0) {
            Calendar c = Calendar.getInstance(Locale.US);
            c.setTime(stop);
            c.add(12, breakTimeStop);
            stop = c.getTime();
        }
        return this.getStartTime().compareTo(stop) < 0 && start.compareTo(this.getEndTime()) < 0;
    }

    public static Date[] getBounds(Session session, Long examTypeId) {
        return ExamPeriod.getBounds(session.getUniqueId(), session.getExamBeginDate(), examTypeId);
    }

    public static Date[] getBounds(Long sessionId, Date examBeginDate, Long examTypeId) {
        Object[] bounds = (Object[])ExamPeriodDAO.getInstance().getSession().createQuery("select min(ep.dateOffset), min(ep.startSlot - ep.eventStartOffset), max(ep.dateOffset), max(ep.startSlot+ep.length+ep.eventStopOffset) from ExamPeriod ep where ep.session.uniqueId = :sessionId and ep.examType.uniqueId = :examTypeId", Object[].class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).uniqueResult();
        if (bounds == null || bounds[0] == null) {
            return null;
        }
        int minDateOffset = ((Number)bounds[0]).intValue();
        int minSlot = ((Number)bounds[1]).intValue();
        int minHour = (Constants.SLOT_LENGTH_MIN * minSlot + Constants.FIRST_SLOT_TIME_MIN) / 60;
        int minMin = (Constants.SLOT_LENGTH_MIN * minSlot + Constants.FIRST_SLOT_TIME_MIN) % 60;
        int maxDateOffset = ((Number)bounds[2]).intValue();
        int maxSlot = ((Number)bounds[3]).intValue();
        int maxHour = (Constants.SLOT_LENGTH_MIN * maxSlot + Constants.FIRST_SLOT_TIME_MIN) / 60;
        int maxMin = (Constants.SLOT_LENGTH_MIN * maxSlot + Constants.FIRST_SLOT_TIME_MIN) % 60;
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(examBeginDate);
        c.add(6, minDateOffset);
        c.set(10, minHour);
        c.set(12, minMin);
        Date min = c.getTime();
        c.setTime(examBeginDate);
        c.add(6, maxDateOffset);
        c.set(10, maxHour);
        c.set(12, maxMin);
        Date max = c.getTime();
        return new Date[]{min, max};
    }

    @Transient
    public int getExamEventStartSlot() {
        return this.getStartSlot() - this.getEventStartOffset();
    }

    public int getExamEventStopSlot(Exam exam) {
        if (ApplicationProperty.ExamEventAllocatedTimeBasedExamLength.isTrue(this.getExamType().getReference())) {
            return this.getStartSlot() + exam.getLength() / Constants.SLOT_LENGTH_MIN + this.getEventStopOffset();
        }
        return this.getEndSlot() + this.getEventStopOffset();
    }

    public int getExamEventStartOffsetForExam(Exam exam) {
        int startOffset = this.getEventStartOffset() * Constants.SLOT_LENGTH_MIN;
        if (exam.getPrintOffset() != null && exam.getPrintOffset() > 0) {
            startOffset += exam.getPrintOffset().intValue();
        }
        return startOffset;
    }

    @Transient
    public boolean isUsed() {
        return ((Number)ExamPeriodDAO.getInstance().getSession().createQuery("select count(x) from Exam x where x.assignedPeriod.uniqueId = :id", Number.class).setParameter("id", (Object)this.getUniqueId()).setCacheable(true).uniqueResult()).intValue() > 0;
    }

    public int getExamEventStopOffsetForExam(Exam exam) {
        if (ApplicationProperty.ExamEventAllocatedTimeBasedExamLength.isTrue(this.getExamType().getReference())) {
            return exam.examOffset() - Constants.SLOT_LENGTH_MIN * this.getEventStopOffset() + exam.getLength() % Constants.SLOT_LENGTH_MIN;
        }
        return exam.getLength() - Constants.SLOT_LENGTH_MIN * this.getLength() - this.getEventStopOffset() * Constants.SLOT_LENGTH_MIN + exam.examOffset();
    }
}

