/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.LazyInitializationException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.Query;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingAddAction;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LastLikeCourseDemand;
import org.unitime.timetable.model.OverrideType;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseCourseOffering;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.OverrideTypeDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.util.ComboBoxLookup;
import org.unitime.timetable.util.InstrOfferingPermIdGenerator;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="course_offering")
public class CourseOffering
extends BaseCourseOffering
implements Comparable {
    private static final long serialVersionUID = 1L;
    public static final String CRS_OFFERING_LIST_ATTR_NAME = "crsOfferingList";

    public CourseOffering() {
    }

    public CourseOffering(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public String getCourseName() {
        return this.getSubjectAreaAbbv() + " " + this.getCourseNbr();
    }

    @Transient
    public String getCourseNameWithTitle() {
        return this.getSubjectAreaAbbv() + " " + this.getCourseNbr() + (String)(this.getTitle() != null && !this.getTitle().isEmpty() ? " - " + this.getTitle() : "");
    }

    @Transient
    public String getCourseNumberWithTitle() {
        return this.getCourseNbr() + (String)(this.getTitle() != null && !this.getTitle().isEmpty() ? " - " + this.getTitle() : "");
    }

    @Override
    public String toString() {
        return this.getSubjectAreaAbbv() + " " + this.getCourseNbr() + (String)(this.getTitle() != null ? " - " + this.getTitle().replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("'", "&quot;").replaceAll("&", "&amp;") : "");
    }

    @Override
    @Transient
    public Boolean getIsControl() {
        return this.isIsControl();
    }

    public static CourseOffering findBySessionSubjAreaIdCourseNbr(Long acadSessionId, Long subjAreaId, String courseNbr) {
        return (CourseOffering)CourseOfferingDAO.getInstance().getSession().createQuery("from CourseOffering co where co.subjectArea.uniqueId = :subjArea and co.courseNbr = :crsNbr and co.instructionalOffering.session.uniqueId = :acadSessionId", CourseOffering.class).setParameter("crsNbr", (Object)courseNbr).setParameter("subjArea", (Object)subjAreaId).setParameter("acadSessionId", (Object)acadSessionId).setMaxResults(1).uniqueResult();
    }

    public static CourseOffering findBySessionSubjAreaAbbvCourseNbr(Long acadSessionId, String subjAreaAbbv, String courseNbr) {
        return (CourseOffering)CourseOfferingDAO.getInstance().getSession().createQuery("from CourseOffering co where co.subjectArea.subjectAreaAbbreviation = :subjArea and co.courseNbr = :crsNbr and co.instructionalOffering.session.uniqueId = :acadSessionId", CourseOffering.class).setParameter("crsNbr", (Object)courseNbr).setParameter("subjArea", (Object)subjAreaAbbv).setParameter("acadSessionId", (Object)acadSessionId).setMaxResults(1).uniqueResult();
    }

    public static CourseOffering findBySessionSubjAreaAbbvCourseNbrTitle(Long acadSessionId, String subjAreaAbbv, String courseNbr, String title) {
        InstructionalOfferingDAO iDao = InstructionalOfferingDAO.getInstance();
        org.hibernate.Session hibSession = iDao.getSession();
        String sql = " from CourseOffering co  where co.subjectArea.subjectAreaAbbreviation=:subjArea and co.courseNbr = :crsNbr and co.title = :title and co.instructionalOffering.session.uniqueId = :acadSessionId";
        Query query = hibSession.createQuery(sql, CourseOffering.class);
        query.setParameter("crsNbr", (Object)courseNbr);
        query.setParameter("subjArea", (Object)subjAreaAbbv);
        query.setParameter("acadSessionId", (Object)acadSessionId);
        query.setParameter("title", (Object)title);
        return (CourseOffering)query.uniqueResult();
    }

    public static synchronized CourseOffering addNew(Long subjAreaId, String courseNbr) throws Exception {
        CourseOffering co = null;
        InstructionalOfferingDAO idao = InstructionalOfferingDAO.getInstance();
        org.hibernate.Session hibSession = idao.getSession();
        try {
            SubjectArea subjArea = (SubjectArea)SubjectAreaDAO.getInstance().get(subjAreaId);
            Session acadSession = subjArea.getSession();
            CourseOfferingDAO cdao = CourseOfferingDAO.getInstance();
            co = new CourseOffering();
            co.setSubjectArea(subjArea);
            co.setCourseNbr(courseNbr);
            co.setProjectedDemand(0);
            co.setDemand(0);
            co.setNbrExpectedStudents(0);
            co.setIsControl(true);
            co.setPermId(InstrOfferingPermIdGenerator.getGenerator().generate((SharedSessionContractImplementor)((SessionImplementor)CourseOfferingDAO.getInstance().getSession()), co).toString());
            HashSet<CourseOffering> s = new HashSet<CourseOffering>();
            s.add(co);
            InstructionalOffering io = new InstructionalOffering();
            io.setNotOffered(false);
            io.setSession(acadSession);
            io.generateInstrOfferingPermId();
            io.setByReservationOnly(false);
            cdao.getSession().persist((Object)io);
            idao.getSession().refresh((Object)io);
            co.setInstructionalOffering(io);
            io.addToCourseOfferings(co);
            cdao.getSession().persist((Object)co);
            cdao.getSession().flush();
            cdao.getSession().refresh((Object)co);
            cdao.getSession().refresh((Object)subjArea);
            String className = ApplicationProperty.ExternalActionInstructionalOfferingAdd.value();
            if (className != null && className.trim().length() > 0) {
                ExternalInstructionalOfferingAddAction addAction = (ExternalInstructionalOfferingAddAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                addAction.performExternalInstructionalOfferingAddAction(io, hibSession);
            }
        }
        catch (Exception e) {
            Debug.error(e);
            throw new Exception("Could not create new course offering: " + e.getMessage());
        }
        return co;
    }

    public static List<ComboBoxLookup> getControllingCourses(Long sessionId) {
        ArrayList<ComboBoxLookup> l = new ArrayList<ComboBoxLookup>();
        for (Object[] o : CourseOfferingDAO.getInstance().getSession().createQuery("select co.uniqueId, co.subjectAreaAbbv, co.courseNbr from CourseOffering co where co.isControl=true and co.subjectArea.session.uniqueId=:sessionId", Object[].class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
            l.add(new ComboBoxLookup(o[0].toString(), String.valueOf(o[1]) + " " + String.valueOf(o[2])));
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transient
    public Department getDepartment() {
        Department dept = null;
        try {
            dept = this.getSubjectArea().getDepartment();
            if (dept.toString() != null) return dept;
        }
        catch (LazyInitializationException lie) {
            new _RootDAO().getSession().refresh((Object)this);
            return this.getSubjectArea().getDepartment();
        }
        return dept;
    }

    @Transient
    public Department getManagingDept() {
        Department dept = null;
        for (InstrOfferingConfig config : this.getInstructionalOffering().getInstrOfferingConfigs()) {
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                Department mgr = subpart.getManagingDept();
                if (mgr == null) continue;
                if (dept == null) {
                    dept = mgr;
                    continue;
                }
                if (dept.equals(mgr)) continue;
                return this.getDepartment();
            }
        }
        return dept == null ? this.getDepartment() : dept;
    }

    @Transient
    public List<LastLikeCourseDemand> getCourseOfferingDemands() {
        if (this.getPermId() != null) {
            return CourseOfferingDAO.getInstance().getSession().createQuery("select d from LastLikeCourseDemand d where d.coursePermId=:permId and d.subjectArea.session.uniqueId=:sessionId", LastLikeCourseDemand.class).setParameter("permId", (Object)this.getPermId()).setParameter("sessionId", (Object)this.getSubjectArea().getSessionId()).setCacheable(true).list();
        }
        return CourseOfferingDAO.getInstance().getSession().createQuery("select d from LastLikeCourseDemand d where d.subjectArea.uniqueId=:subjectAreaId and d.courseNbr=:courseNbr", LastLikeCourseDemand.class).setParameter("subjectAreaId", (Object)this.getSubjectArea().getUniqueId()).setParameter("courseNbr", (Object)this.getCourseNbr()).setCacheable(true).list();
    }

    @Transient
    public List getLastLikeSemesterCourseOfferingDemands() {
        return this.getCourseOfferingDemands();
    }

    public Object clone() {
        CourseOffering co = new CourseOffering();
        co.setCourseNbr(this.getCourseNbr());
        co.setDemand(this.getDemand());
        co.setPermId(this.getPermId());
        co.setNbrExpectedStudents(this.getNbrExpectedStudents());
        co.setProjectedDemand(this.getProjectedDemand());
        co.setSubjectArea(this.getSubjectArea());
        co.setSubjectAreaAbbv(this.getSubjectAreaAbbv());
        co.setTitle(this.getTitle());
        co.setDemandOffering(this.getDemandOffering());
        co.setDemandOfferingType(this.getDemandOfferingType());
        co.setExternalUniqueId(this.getExternalUniqueId());
        co.setScheduleBookNote(this.getScheduleBookNote());
        co.setIsControl(this.getIsControl());
        co.setFundingDept(this.getFundingDept());
        co.setAlternativeOffering(this.getAlternativeOffering());
        co.setParentOffering(this.getParentOffering());
        return co;
    }

    public static List<CourseOffering> findAll(Long sessionId) {
        return CourseOfferingDAO.getInstance().getSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId=:sessionId", CourseOffering.class).setParameter("sessionId", (Object)sessionId).list();
    }

    public static CourseOffering findBySubjectAreaCourseNbr(Long sessionId, String subjectAreaAbbv, String courseNbr) {
        return (CourseOffering)CourseOfferingDAO.getInstance().getSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId=:sessionId and c.subjectArea.subjectAreaAbbreviation=:subjectAreaAbbv and c.courseNbr=:courseNbr", CourseOffering.class).setParameter("sessionId", (Object)sessionId).setParameter("subjectAreaAbbv", (Object)subjectAreaAbbv).setParameter("courseNbr", (Object)courseNbr).setCacheable(true).uniqueResult();
    }

    public static CourseOffering findByExternalId(Long sessionId, String externalId) {
        return (CourseOffering)CourseOfferingDAO.getInstance().getSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId=:sessionId and c.externalUniqueId=:externalId", CourseOffering.class).setParameter("sessionId", (Object)sessionId).setParameter("externalId", (Object)externalId).setCacheable(true).uniqueResult();
    }

    public static CourseOffering findByUniqueId(Long uniqueId) {
        return (CourseOffering)CourseOfferingDAO.getInstance().get(uniqueId);
    }

    public static CourseOffering findBySubjectCourseNbrInstrOffUniqueId(String subjectAreaAbbv, String courseNbr, Long instrOffrUniqueId) {
        return (CourseOffering)CourseOfferingDAO.getInstance().getSession().createQuery("select c from InstructionalOffering io inner join io.courseOfferings c where io.uniqueId=:instrOffrUniqueId and c.subjectArea.subjectAreaAbbreviation=:subjectAreaAbbv and c.courseNbr=:courseNbr", CourseOffering.class).setParameter("instrOffrUniqueId", (Object)instrOffrUniqueId).setParameter("subjectAreaAbbv", (Object)subjectAreaAbbv).setParameter("courseNbr", (Object)courseNbr).setCacheable(true).uniqueResult();
    }

    public static CourseOffering findByName(String name, Long sessionId) {
        return (CourseOffering)CourseOfferingDAO.getInstance().getSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :name", CourseOffering.class).setParameter("sessionId", (Object)sessionId).setParameter("name", (Object)name.toLowerCase()).setCacheable(true).uniqueResult();
    }

    public static CourseOffering findByIdRolledForwardFrom(Long sessionId, Long uniqueIdRolledForwardFrom) {
        return (CourseOffering)CourseOfferingDAO.getInstance().getSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId=:sessionId and c.uniqueIdRolledForwardFrom=:uniqueIdRolledForwardFrom", CourseOffering.class).setParameter("sessionId", (Object)sessionId).setParameter("uniqueIdRolledForwardFrom", (Object)uniqueIdRolledForwardFrom).setCacheable(true).uniqueResult();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof CourseOffering)) {
            return -1;
        }
        CourseOffering co = (CourseOffering)o;
        int cmp = this.getSubjectAreaAbbv().compareTo(co.getSubjectAreaAbbv());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getCourseNbr().compareTo(co.getCourseNbr());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(co.getUniqueId() == null ? -1L : co.getUniqueId());
    }

    @Transient
    public CourseCreditUnitConfig getCredit() {
        if (this.getCreditConfigs() == null || this.getCreditConfigs().size() != 1) {
            return null;
        }
        return this.getCreditConfigs().iterator().next();
    }

    public void setCredit(CourseCreditUnitConfig courseCreditUnitConfig) {
        if (this.getCreditConfigs() == null || this.getCreditConfigs().size() == 0) {
            this.addToCreditConfigs(courseCreditUnitConfig);
        } else if (!this.getCreditConfigs().contains(courseCreditUnitConfig)) {
            this.getCreditConfigs().clear();
            this.getCreditConfigs().add(courseCreditUnitConfig);
        }
    }

    @Transient
    public boolean isAllowStudentScheduling() {
        return this.getSubjectArea().getDepartment().isAllowStudentScheduling();
    }

    public List<StudentClassEnrollment> getClassEnrollments(Student s) {
        ArrayList<StudentClassEnrollment> ret = new ArrayList<StudentClassEnrollment>();
        for (StudentClassEnrollment e : s.getClassEnrollments()) {
            if (!this.equals(e.getCourseOffering())) continue;
            ret.add(e);
        }
        return ret;
    }

    @Transient
    public Set<OverrideType> getEnabledOverrides() {
        TreeSet<OverrideType> ret = new TreeSet<OverrideType>();
        for (OverrideType override : OverrideTypeDAO.getInstance().findAll()) {
            if (this.getDisabledOverrides().contains(override)) continue;
            ret.add(override);
        }
        return ret;
    }

    @Transient
    public Department getEffectiveFundingDept() {
        if (this.getFundingDept() == null) {
            return this.getSubjectArea().getEffectiveFundingDept();
        }
        return this.getFundingDept();
    }
}

