/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import org.unitime.timetable.model.base.BaseCourseCreditFormat;
import org.unitime.timetable.model.dao.CourseCreditFormatDAO;
import org.unitime.timetable.model.dao.CourseCreditUnitTypeDAO;

@Entity
@Table(name="crse_credit_format")
public class CourseCreditFormat
extends BaseCourseCreditFormat {
    private static final long serialVersionUID = 1L;
    public static String COURSE_CREDIT_FORMAT_ATTR_NAME = "courseCreditFormatList";

    public CourseCreditFormat() {
    }

    public CourseCreditFormat(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public static List<CourseCreditFormat> getCourseCreditFormatList() {
        return CourseCreditFormatDAO.getInstance().getSession().createQuery("from CourseCreditFormat order by label", CourseCreditFormat.class).setCacheable(true).list();
    }

    public static CourseCreditFormat getCourseCreditForReference(String referenceString) {
        if (referenceString == null || referenceString.isEmpty()) {
            return null;
        }
        return (CourseCreditFormat)CourseCreditUnitTypeDAO.getInstance().getSession().createQuery("from CourseCreditFormat where reference = :reference", CourseCreditFormat.class).setParameter("reference", (Object)referenceString).setMaxResults(1).setCacheable(true).uniqueResult();
    }

    public static CourseCreditFormat getCourseCreditForUniqueId(Long uniqueId) {
        return uniqueId == null ? null : (CourseCreditFormat)CourseCreditFormatDAO.getInstance().get(uniqueId);
    }

    @Transient
    public String getAbbv() {
        if (this.getAbbreviation() == null) {
            return "";
        }
        return this.getAbbreviation();
    }
}

