/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.model.AdvisorClassPref;
import org.unitime.timetable.model.AdvisorInstrMthPref;
import org.unitime.timetable.model.AdvisorSectioningPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.base.BaseAdvisorCourseRequest;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.InstructionalMethodDAO;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="advisor_crsreq")
public class AdvisorCourseRequest
extends BaseAdvisorCourseRequest
implements Comparable<AdvisorCourseRequest> {
    private static final long serialVersionUID = 1L;

    public boolean updatePreferences(CourseRequestInterface.RequestedCourse rc, Session hibSession) {
        AdvisorSectioningPref r;
        Iterator i;
        ArrayList<AdvisorSectioningPref> remain = null;
        boolean changed = false;
        if (this.getPreferences() == null) {
            this.setPreferences(new HashSet<AdvisorSectioningPref>());
        } else {
            remain = new ArrayList<AdvisorSectioningPref>(this.getPreferences());
        }
        if (rc != null && rc.hasSelectedClasses()) {
            block0: for (CourseRequestInterface.Preference preference : rc.getSelectedClasses()) {
                Class_ clazz = (Class_)Class_DAO.getInstance().get(preference.getId(), hibSession);
                if (clazz == null) continue;
                if (remain != null) {
                    i = remain.iterator();
                    while (i.hasNext()) {
                        r = (AdvisorSectioningPref)i.next();
                        if (!(r instanceof AdvisorClassPref) || !((AdvisorClassPref)r).getClazz().equals(clazz)) continue;
                        i.remove();
                        if (r.getRequired().booleanValue() == preference.isRequired()) continue block0;
                        r.setRequired(preference.isRequired());
                        hibSession.merge((Object)r);
                        changed = true;
                        continue block0;
                    }
                }
                AdvisorClassPref scp = new AdvisorClassPref();
                scp.setCourseRequest(this);
                scp.setRequired(preference.isRequired());
                scp.setClazz(clazz);
                scp.setLabel(clazz.getClassPrefLabel(this.getCourseOffering()));
                this.getPreferences().add(scp);
                changed = true;
            }
        }
        if (rc != null && rc.hasSelectedIntructionalMethods()) {
            block2: for (CourseRequestInterface.Preference preference : rc.getSelectedIntructionalMethods()) {
                InstructionalMethod im = (InstructionalMethod)InstructionalMethodDAO.getInstance().get(preference.getId(), hibSession);
                if (im == null) continue;
                if (remain != null) {
                    i = remain.iterator();
                    while (i.hasNext()) {
                        r = (AdvisorSectioningPref)i.next();
                        if (!(r instanceof AdvisorInstrMthPref) || !((AdvisorInstrMthPref)r).getInstructionalMethod().equals(im)) continue;
                        i.remove();
                        if (r.getRequired().booleanValue() == preference.isRequired()) continue block2;
                        r.setRequired(preference.isRequired());
                        hibSession.merge((Object)r);
                        changed = true;
                        continue block2;
                    }
                }
                AdvisorInstrMthPref imp = new AdvisorInstrMthPref();
                imp.setCourseRequest(this);
                imp.setRequired(preference.isRequired());
                imp.setInstructionalMethod(im);
                imp.setLabel(im.getLabel());
                this.getPreferences().add(imp);
                changed = true;
            }
        }
        if (remain != null) {
            for (AdvisorSectioningPref advisorSectioningPref : remain) {
                hibSession.remove((Object)advisorSectioningPref);
                this.getPreferences().remove(advisorSectioningPref);
                changed = true;
            }
        }
        return changed;
    }

    public int isCritical(CriticalCoursesProvider.CriticalCourses cc) {
        if (cc == null) {
            return 0;
        }
        if (cc instanceof CriticalCoursesProvider.AdvisorCriticalCourses) {
            return ((CriticalCoursesProvider.AdvisorCriticalCourses)((Object)cc)).isCritical(this);
        }
        if (this.getCourseOffering() == null || this.isSubstitute().booleanValue()) {
            return 0;
        }
        return cc.isCritical(this.getCourseOffering());
    }

    @Transient
    public float getCreditMin() {
        if (this.getCredit() == null || this.getCredit().isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(this.getCredit().replaceAll("\\s", ""));
        }
        catch (NumberFormatException numberFormatException) {
            if (this.getCredit().contains("-")) {
                try {
                    return Float.parseFloat(this.getCredit().substring(0, this.getCredit().indexOf(45)).replaceAll("\\s", ""));
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            return 0.0f;
        }
    }

    @Transient
    public float getCreditMax() {
        if (this.getCredit() == null || this.getCredit().isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(this.getCredit().replaceAll("\\s", ""));
        }
        catch (NumberFormatException numberFormatException) {
            if (this.getCredit().contains("-")) {
                try {
                    return Float.parseFloat(this.getCredit().substring(1 + this.getCredit().indexOf(45)).replaceAll("\\s", ""));
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            return 0.0f;
        }
    }

    @Override
    public int compareTo(AdvisorCourseRequest r) {
        int cmp = this.getPriority().compareTo(r.getPriority());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getAlternative().compareTo(r.getAlternative());
        if (cmp != 0) {
            return cmp;
        }
        return this.getUniqueId().compareTo(r.getUniqueId());
    }

    @Transient
    public CourseDemand.Critical getEffectiveCritical() {
        if (this.getCritical() != null) {
            return CourseDemand.Critical.values()[this.getCritical()];
        }
        return CourseDemand.Critical.NORMAL;
    }

    @Transient
    public boolean isCriticalOrImportant() {
        switch (this.getEffectiveCritical()) {
            case CRITICAL: {
                return true;
            }
            case IMPORTANT: {
                return true;
            }
            case VITAL: {
                return true;
            }
        }
        return false;
    }
}

