/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BaseAcademicArea;
import org.unitime.timetable.model.dao.AcademicAreaDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="academic_area")
public class AcademicArea
extends BaseAcademicArea {
    private static final long serialVersionUID = 1L;
    public static final String ACAD_AREA_REQUEST_ATTR = "academicAreas";

    public AcademicArea() {
    }

    public AcademicArea(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public static ArrayList getAll() throws HibernateException {
        return (ArrayList)AcademicAreaDAO.getInstance().findAll();
    }

    public static List<AcademicArea> getAcademicAreaList(Long sessionId) throws HibernateException {
        return AcademicAreaDAO.getInstance().getSession().createQuery("select a from AcademicArea as a where a.session.uniqueId=:sessionId order by a.academicAreaAbbreviation", AcademicArea.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    @Transient
    public String getLabelAbbrTitle() {
        return this.getAcademicAreaAbbreviation() + " : " + this.getTitle();
    }

    @Transient
    public String getLabelTitleAbbr() {
        return this.getTitle() + " : " + this.getAcademicAreaAbbreviation();
    }

    @Transient
    public Long getSessionId() {
        if (this.getSession() != null) {
            return this.getSession().getUniqueId();
        }
        return null;
    }

    public static AcademicArea findByAbbv(Long sessionId, String abbv) {
        return AcademicArea.findByAbbv(AcademicAreaDAO.getInstance().getSession(), sessionId, abbv);
    }

    public static AcademicArea findByAbbv(Session hibSession, Long sessionId, String abbv) {
        return (AcademicArea)hibSession.createQuery("select a from AcademicArea a where a.session.uniqueId=:sessionId and a.academicAreaAbbreviation=:abbv", AcademicArea.class).setParameter("sessionId", (Object)sessionId).setParameter("abbv", (Object)abbv).setCacheable(true).uniqueResult();
    }

    public static AcademicArea findByExternalId(Long sessionId, String externalId) {
        return AcademicArea.findByExternalId(AcademicAreaDAO.getInstance().getSession(), sessionId, externalId);
    }

    public static AcademicArea findByExternalId(Session hibSession, Long sessionId, String externalId) {
        return (AcademicArea)hibSession.createQuery("select a from AcademicArea a where a.session.uniqueId=:sessionId and a.externalUniqueId=:externalId", AcademicArea.class).setParameter("sessionId", (Object)sessionId).setParameter("externalId", (Object)externalId).setCacheable(true).uniqueResult();
    }

    public Object clone() {
        AcademicArea area = new AcademicArea();
        area.setExternalUniqueId(this.getExternalUniqueId());
        area.setAcademicAreaAbbreviation(this.getAcademicAreaAbbreviation());
        area.setTitle(this.getTitle());
        return area;
    }

    public boolean isUsed(Session hibSession) {
        return ((Number)(hibSession == null ? AcademicAreaDAO.getInstance().getSession() : hibSession).createQuery("select count(c) from Curriculum c inner join c.academicArea a where a.uniqueId = :areaId", Number.class).setParameter("areaId", (Object)this.getUniqueId()).setCacheable(true).uniqueResult()).intValue() > 0;
    }
}

