/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;

public class ClassSetupInterface
implements IsSerializable,
Serializable,
GwtRpcResponse,
GwtRpcRequest<ClassSetupInterface> {
    private static final long serialVersionUID = 5836074172101388912L;
    private List<ClassLine> iClassLines = new ArrayList<ClassLine>();
    private List<Reference> iDepartments;
    private List<Reference> iInstructionalMethods;
    private List<Reference> iLMSs;
    private List<Reference> iDatePatterns;
    private List<Reference> iStdSchedDisclaimers;
    private List<Subpart> iSubparts;
    private Long iConfigId;
    private Integer iLimit;
    private Boolean iUnlimited;
    private Long iOfferingId;
    private Boolean iDisplayOptionForMaxLimit;
    private Boolean iDisplayMaxLimit;
    private Boolean iDisplayInstructors;
    private Boolean iDisplayEnabledForStudentScheduling;
    private Boolean iDisplayExternalId;
    private Boolean iEditExternalId;
    private Boolean iEditSnapshotLimits;
    private Long iInstructionalMethodId;
    private Boolean iInstructionalMethodEditable;
    private Boolean iDisplayLms;
    private String iName;
    private Boolean iDisplayEnrollments;
    private Boolean iEditUnlimited;
    private Boolean iDisplaySnapshotLimit;
    private Boolean iValidateLimits;
    private Operation iOperation;
    private long iLastGeneratedId = 0L;
    private Boolean iHasTimeRooms;
    private Boolean iHasInstructors;
    public String iSchedulingDisclaimer;
    private Boolean iCanEditSchedulingDisclaimer;

    public ClassSetupInterface() {
    }

    public ClassSetupInterface(Operation op, Long configId) {
        this.iOperation = op;
        this.iConfigId = configId;
    }

    public Long addClassLine(ClassLine classLine) {
        if (classLine.getClassId() == null) {
            classLine.setClassId(--this.iLastGeneratedId);
        }
        this.iClassLines.add(classLine);
        return classLine.getClassId();
    }

    public ClassLine copy(ClassLine classLine) {
        Reference p;
        Reference l;
        ClassLine copy = new ClassLine(classLine);
        copy.setClassId(--this.iLastGeneratedId);
        copy.setLabel(copy.getSubpartLabel() + " New" + this.iLastGeneratedId);
        Reference d = this.getDepartment(copy.getDepartmentId());
        if (d == null || !d.isSelectable()) {
            copy.setDepartmentId(null);
        }
        if ((l = this.getLMS(copy.getLMS())) == null || !l.isSelectable()) {
            copy.setLMS(-1L);
        }
        if ((p = this.getDatePattern(copy.getDatePatternId())) == null || !p.isSelectable()) {
            copy.setDatePatternId(null);
        }
        return copy;
    }

    public List<ClassLine> getClassLines() {
        return this.iClassLines;
    }

    public void addDepartment(Long id, String ref, String label, boolean selectable) {
        if (this.iDepartments == null) {
            this.iDepartments = new ArrayList<Reference>();
        }
        this.iDepartments.add(new Reference(id, ref, label, selectable));
    }

    public void addDepartment(Long id, String ref, String label) {
        this.addDepartment(id, ref, label, true);
    }

    public boolean hasDepartments() {
        return this.iDepartments != null && !this.iDepartments.isEmpty();
    }

    public List<Reference> getDepartments() {
        return this.iDepartments;
    }

    public Reference getDepartment(Long id) {
        if (this.iDepartments == null || id == null) {
            return null;
        }
        for (Reference ref : this.iDepartments) {
            if (!ref.getId().equals(id)) continue;
            return ref;
        }
        return null;
    }

    public void addInstructionalMethod(Long id, String ref, String label) {
        if (this.iInstructionalMethods == null) {
            this.iInstructionalMethods = new ArrayList<Reference>();
        }
        this.iInstructionalMethods.add(new Reference(id, ref, label, true));
    }

    public boolean hasInstructionalMethods() {
        return this.iInstructionalMethods != null && !this.iInstructionalMethods.isEmpty();
    }

    public List<Reference> getInstructionalMethods() {
        return this.iInstructionalMethods;
    }

    public Reference getInstructionalMethod(Long id) {
        if (this.iInstructionalMethods == null || id == null) {
            return null;
        }
        for (Reference ref : this.iInstructionalMethods) {
            if (!ref.getId().equals(id)) continue;
            return ref;
        }
        return null;
    }

    public void addLMS(Long id, String ref, String label) {
        if (this.iLMSs == null) {
            this.iLMSs = new ArrayList<Reference>();
        }
        this.iLMSs.add(new Reference(id, ref, label, true));
    }

    public boolean hasLMSs() {
        return this.iLMSs != null && !this.iLMSs.isEmpty();
    }

    public List<Reference> getLMSs() {
        return this.iLMSs;
    }

    public Reference getLMS(Long id) {
        if (this.iLMSs == null || id == null) {
            return null;
        }
        for (Reference ref : this.iLMSs) {
            if (!ref.getId().equals(id)) continue;
            return ref;
        }
        return null;
    }

    public void addStdSchedDisclaimer(Long id, String ref, String label) {
        if (this.iStdSchedDisclaimers == null) {
            this.iStdSchedDisclaimers = new ArrayList<Reference>();
        }
        this.iStdSchedDisclaimers.add(new Reference(id, ref, label, true));
    }

    public boolean hasStdSchedDisclaimers() {
        return this.iStdSchedDisclaimers != null && !this.iStdSchedDisclaimers.isEmpty();
    }

    public List<Reference> getStdSchedDisclaimers() {
        return this.iStdSchedDisclaimers;
    }

    public Reference getStdSchedDisclaimer(Long id) {
        if (this.iStdSchedDisclaimers == null || id == null) {
            return null;
        }
        for (Reference ref : this.iStdSchedDisclaimers) {
            if (!ref.getId().equals(id)) continue;
            return ref;
        }
        return null;
    }

    public void addDatePattern(Long id, String ref, String label, boolean selectable) {
        if (this.iDatePatterns == null) {
            this.iDatePatterns = new ArrayList<Reference>();
        }
        this.iDatePatterns.add(new Reference(id, ref, label, selectable));
    }

    public boolean hasDatePatterns() {
        return this.iDatePatterns != null && !this.iDatePatterns.isEmpty();
    }

    public List<Reference> getDatePatterns() {
        return this.iDatePatterns;
    }

    public Reference getDatePattern(Long id) {
        if (this.iDatePatterns == null || id == null) {
            return null;
        }
        for (Reference ref : this.iDatePatterns) {
            if (!ref.getId().equals(id)) continue;
            return ref;
        }
        return null;
    }

    public void addSubpart(Long id, String ref, String label, String defaultDatePatternName) {
        if (this.iSubparts == null) {
            this.iSubparts = new ArrayList<Subpart>();
        }
        this.iSubparts.add(new Subpart(id, ref, label, true, defaultDatePatternName));
    }

    public boolean hasSubparts() {
        return this.iSubparts != null && !this.iSubparts.isEmpty();
    }

    public List<Subpart> getSubparts() {
        return this.iSubparts;
    }

    public Subpart getSubpart(Long id) {
        if (this.iSubparts == null || id == null) {
            return null;
        }
        for (Subpart ref : this.iSubparts) {
            if (!ref.getId().equals(id)) continue;
            return ref;
        }
        return null;
    }

    public int getSubpartIndex(Long id) {
        if (this.iSubparts == null || id == null) {
            return -1;
        }
        for (int i = 0; i < this.iSubparts.size(); ++i) {
            if (!this.iSubparts.get(i).getId().equals(id)) continue;
            return i;
        }
        return -1;
    }

    public Operation getOperation() {
        return this.iOperation;
    }

    public void setOperation(Operation operation) {
        this.iOperation = operation;
    }

    public void setConfigId(Long configId) {
        this.iConfigId = configId;
    }

    public Long getConfigId() {
        return this.iConfigId;
    }

    public void setLimit(Integer limit) {
        this.iLimit = limit;
    }

    public Integer getLimit() {
        return this.iLimit;
    }

    public void setUnlimited(Boolean unlimited) {
        this.iUnlimited = unlimited;
    }

    public Boolean isUnlimited() {
        return this.iUnlimited;
    }

    public void setOfferingId(Long offeringId) {
        this.iOfferingId = offeringId;
    }

    public Long getOfferingId() {
        return this.iOfferingId;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getName() {
        return this.iName;
    }

    public void setDisplayOptionForMaxLimit(boolean displayOptionForMaxLimit) {
        this.iDisplayOptionForMaxLimit = displayOptionForMaxLimit;
    }

    public boolean isDisplayOptionForMaxLimit() {
        return Boolean.TRUE.equals(this.iDisplayOptionForMaxLimit);
    }

    public void setDisplayMaxLimit(boolean displayMaxLimit) {
        this.iDisplayMaxLimit = displayMaxLimit;
    }

    public boolean isDisplayMaxLimit() {
        return Boolean.TRUE.equals(this.iDisplayMaxLimit);
    }

    public void setDisplayInstructors(boolean displayInstructors) {
        this.iDisplayInstructors = displayInstructors;
    }

    public boolean isDisplayInstructors() {
        return Boolean.TRUE.equals(this.iDisplayInstructors);
    }

    public void setDisplayEnabledForStudentScheduling(boolean displayEnabledForStudentScheduling) {
        this.iDisplayEnabledForStudentScheduling = displayEnabledForStudentScheduling;
    }

    public boolean isDisplayEnabledForStudentScheduling() {
        return Boolean.TRUE.equals(this.iDisplayEnabledForStudentScheduling);
    }

    public void setDisplayExternalId(boolean displayExternalId) {
        this.iDisplayExternalId = displayExternalId;
    }

    public boolean isDisplayExternalId() {
        return Boolean.TRUE.equals(this.iDisplayExternalId);
    }

    public void setEditExternalId(boolean editExternalId) {
        this.iEditExternalId = editExternalId;
    }

    public boolean isEditExternalId() {
        return Boolean.TRUE.equals(this.iEditExternalId);
    }

    public void setEditSnapshotLimits(boolean editSnapshotLimits) {
        this.iEditSnapshotLimits = editSnapshotLimits;
    }

    public boolean isEditSnapshotLimits() {
        return Boolean.TRUE.equals(this.iEditSnapshotLimits);
    }

    public void setInstructionalMethodEditable(boolean instructionalMethodEditable) {
        this.iInstructionalMethodEditable = instructionalMethodEditable;
    }

    public boolean isInstructionalMethodEditable() {
        return Boolean.TRUE.equals(this.iInstructionalMethodEditable);
    }

    public void setDisplayLms(boolean displayLms) {
        this.iDisplayLms = displayLms;
    }

    public boolean isDisplayLms() {
        return this.iDisplayLms;
    }

    public void setDisplayEnrollments(boolean displayEnrollments) {
        this.iDisplayEnrollments = displayEnrollments;
    }

    public boolean isDisplayEnrollments() {
        return Boolean.TRUE.equals(this.iDisplayEnrollments);
    }

    public void setEditUnlimited(boolean editUnlimited) {
        this.iEditUnlimited = editUnlimited;
    }

    public boolean isEditUnlimited() {
        return Boolean.TRUE.equals(this.iEditUnlimited);
    }

    public void setDisplaySnapshotLimit(boolean displaySnapshotLimit) {
        this.iDisplaySnapshotLimit = displaySnapshotLimit;
    }

    public boolean isDisplaySnapshotLimit() {
        return Boolean.TRUE.equals(this.iDisplaySnapshotLimit);
    }

    public void setValidateLimits(boolean validateLimits) {
        this.iValidateLimits = validateLimits;
    }

    public boolean isValidateLimits() {
        return Boolean.TRUE.equals(this.iValidateLimits);
    }

    public void setHasTimeRooms(boolean hasTimeRooms) {
        this.iHasTimeRooms = hasTimeRooms;
    }

    public boolean isHasTimeRooms() {
        return Boolean.TRUE.equals(this.iHasTimeRooms);
    }

    public void setHasInstructors(boolean hasInstructors) {
        this.iHasInstructors = hasInstructors;
    }

    public boolean isHasInstructors() {
        return Boolean.TRUE.equals(this.iHasInstructors);
    }

    public void setInstructionalMethodId(Long instructionalMethodId) {
        this.iInstructionalMethodId = instructionalMethodId;
    }

    public Long getInstructionalMethodId() {
        return this.iInstructionalMethodId;
    }

    public String getSchedulingDisclaimer() {
        return this.iSchedulingDisclaimer;
    }

    public void setSchedulingDisclaimer(String schedulingDisclaimer) {
        this.iSchedulingDisclaimer = schedulingDisclaimer;
    }

    public boolean hasSchedulingDisclaimer() {
        return this.iSchedulingDisclaimer != null && !this.iSchedulingDisclaimer.isEmpty();
    }

    public boolean isCanEditSchedulingDisclaimer() {
        return this.iCanEditSchedulingDisclaimer != null && this.iCanEditSchedulingDisclaimer != false;
    }

    public void setCanEditSchedulingDisclaimer(boolean canEditSchedulingDisclaimer) {
        this.iCanEditSchedulingDisclaimer = canEditSchedulingDisclaimer;
    }

    protected boolean canCancelChildren(ClassLine line) {
        if (line == null || !line.isEditable() || !line.isCanCancel()) {
            return false;
        }
        boolean cancel = line.getCancelled() == false;
        for (ClassLine child : this.iClassLines) {
            if (!line.getClassId().equals(child.getParentId()) || cancel == child.getCancelled() || this.canCancelChildren(child)) continue;
            return false;
        }
        return true;
    }

    public ClassLine getClassLine(Long id) {
        if (id == null) {
            return null;
        }
        for (ClassLine line : this.iClassLines) {
            if (!id.equals(line.getClassId())) continue;
            return line;
        }
        return null;
    }

    public List<ClassLine> getLines(ClassLine l) {
        if (l == null) {
            return null;
        }
        HashSet<Long> ids = new HashSet<Long>();
        ArrayList<ClassLine> ret = new ArrayList<ClassLine>();
        for (ClassLine line : this.iClassLines) {
            if (l.getClassId().equals(line.getClassId())) {
                ids.add(line.getClassId());
                ret.add(line);
            }
            if (line.getParentId() == null || !ids.contains(line.getParentId())) continue;
            ids.add(line.getClassId());
            ret.add(line);
        }
        return ret;
    }

    public ClassLine getLastLine(ClassLine l) {
        if (l == null) {
            return null;
        }
        HashSet<Long> ids = new HashSet<Long>();
        ClassLine last = null;
        for (ClassLine line : this.iClassLines) {
            if (l.getClassId().equals(line.getClassId())) {
                ids.add(line.getClassId());
                last = line;
            }
            if (line.getParentId() == null || !ids.contains(line.getParentId())) continue;
            ids.add(line.getClassId());
            last = line;
        }
        return last;
    }

    public boolean canCancel(ClassLine line) {
        if (line == null || !line.isCanCancel()) {
            return false;
        }
        boolean cancel = line.getCancelled() == false;
        ClassLine parent = this.getClassLine(line.getParentId());
        if (parent != null && cancel && !parent.getCancelled().booleanValue() && this.countNotCancelledChildren(parent.getClassId(), line.getSubpartId()) <= 1) {
            return false;
        }
        if (parent != null) {
            if (!cancel && parent.getCancelled().booleanValue()) {
                return false;
            }
            if (cancel && !parent.getCancelled().booleanValue() && this.countNotCancelledChildren(parent.getClassId(), line.getSubpartId()) == 1) {
                return false;
            }
        }
        for (ClassLine l : this.getLines(line)) {
            if (cancel == l.getCancelled() || l.isCanCancel()) continue;
            return false;
        }
        return true;
    }

    public boolean canDelete(ClassLine line) {
        if (line == null || !line.isCanDelete()) {
            return false;
        }
        return !this.isLastOfSubpart(line) && !this.isLastChild(line);
    }

    public boolean canMoveAway(ClassLine line) {
        if (line == null || !line.isEditable()) {
            return false;
        }
        return !this.isLastChild(line);
    }

    public Long getPreviousParentId(ClassLine line) {
        if (line == null || line.getParentId() == null) {
            return null;
        }
        ClassLine parent = this.getClassLine(line.getParentId());
        if (parent == null) {
            return null;
        }
        Long prevId = null;
        for (ClassLine l : this.iClassLines) {
            if (l.getClassId().equals(parent.getClassId())) {
                return prevId;
            }
            if (!l.getSubpartId().equals(parent.getSubpartId()) || !line.getCancelled().booleanValue() && l.getCancelled().booleanValue()) continue;
            prevId = l.getClassId();
        }
        return prevId;
    }

    public Long getNextParentId(ClassLine line) {
        if (line == null || line.getParentId() == null) {
            return null;
        }
        ClassLine parent = this.getClassLine(line.getParentId());
        if (parent == null) {
            return null;
        }
        boolean match = false;
        for (ClassLine l : this.iClassLines) {
            if (l.getClassId().equals(parent.getClassId())) {
                match = true;
                continue;
            }
            if (!match || !l.getSubpartId().equals(parent.getSubpartId()) || !line.getCancelled().booleanValue() && l.getCancelled().booleanValue()) continue;
            return l.getClassId();
        }
        return null;
    }

    public List<ClassLine> getChildren(Long id) {
        if (id == null) {
            return null;
        }
        ArrayList<ClassLine> ret = new ArrayList<ClassLine>();
        for (ClassLine line : this.iClassLines) {
            if (!id.equals(line.getParentId())) continue;
            ret.add(line);
        }
        return ret;
    }

    public boolean hasChildren(Long id) {
        if (id == null) {
            return false;
        }
        for (ClassLine line : this.iClassLines) {
            if (!id.equals(line.getParentId())) continue;
            return true;
        }
        return false;
    }

    public int countNotCancelledChildren(Long id, Long subpartId) {
        if (id == null) {
            return 0;
        }
        int count = 0;
        for (ClassLine line : this.iClassLines) {
            if (!id.equals(line.getParentId()) || !subpartId.equals(line.getSubpartId()) || line.getCancelled().booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public boolean isLastOfSubpart(ClassLine child) {
        if (child == null) {
            return false;
        }
        Long subpartId = child.getSubpartId();
        if (subpartId == null) {
            return false;
        }
        int opened = 0;
        int count = 0;
        for (ClassLine line : this.iClassLines) {
            if (!subpartId.equals(line.getSubpartId())) continue;
            ++count;
            if (line.getCancelled().booleanValue()) continue;
            ++opened;
        }
        if (child.getCancelled().booleanValue()) {
            return count == 1;
        }
        return opened == 1;
    }

    public boolean isLastChild(ClassLine child) {
        if (child == null) {
            return false;
        }
        Long subpartId = child.getSubpartId();
        Long parentId = child.getParentId();
        if (parentId == null || subpartId == null) {
            return false;
        }
        int opened = 0;
        int count = 0;
        for (ClassLine line : this.iClassLines) {
            if (!subpartId.equals(line.getSubpartId()) || !parentId.equals(line.getParentId())) continue;
            ++count;
            if (line.getCancelled().booleanValue()) continue;
            ++opened;
        }
        if (child.getCancelled().booleanValue()) {
            return count == 1;
        }
        return opened == 1;
    }

    public static enum Operation implements IsSerializable,
    Serializable
    {
        LOAD,
        SAVE;

    }

    public static class ClassLine
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 8206025602292396756L;
        private Long iClassId;
        private Long iSubpartId;
        private Integer iIType;
        private boolean iEditable = true;
        private boolean iEditableDatePattern = true;
        private boolean iCanCancel = true;
        private boolean iCanDelete = true;
        private Integer iEnrollment;
        private Integer iSnapshotLimit;
        private Integer iMinClassLimit;
        private Integer iMaxClassLimit;
        private Integer iNumberOfRooms;
        private Boolean iDisplayInstructors;
        private Boolean iEnabledForStudentScheduling;
        private Float iRoomRatio;
        private Long iParentId;
        private Long iDepartmentId;
        private Long iDatePatternId;
        private Boolean iCancelled;
        private Long iLMS;
        private Boolean iSplitAttendance;
        private String iTime;
        private String iDate;
        private List<Reference> iRooms;
        private String iInstructor;
        private String iExternalId;
        private Integer iIndent;
        private String iLabel;
        private String iSubpartLabel;
        private String iError;

        public ClassLine() {
        }

        public ClassLine(ClassLine line) {
            this.iSubpartId = line.getSubpartId();
            this.iIType = line.getIType();
            this.iEditable = true;
            this.iEditableDatePattern = true;
            this.iCanCancel = false;
            this.iCanDelete = true;
            this.iEnrollment = line.getEnrollment() == null ? null : Integer.valueOf(0);
            this.iMinClassLimit = line.getMinClassLimit();
            this.iMaxClassLimit = line.getMaxClassLimit();
            this.iSnapshotLimit = null;
            this.iNumberOfRooms = line.getNumberOfRooms();
            this.iDisplayInstructors = line.getDisplayInstructors();
            this.iEnabledForStudentScheduling = line.getEnabledForStudentScheduling();
            this.iRoomRatio = line.getRoomRatio();
            this.iParentId = line.getParentId();
            this.iDepartmentId = line.getDepartmentId();
            this.iDatePatternId = line.getDatePatternId();
            this.iCancelled = false;
            this.iLMS = line.getLMS();
            this.iSplitAttendance = line.getSplitAttendance();
            this.iIndent = line.getIndent();
            this.iSubpartLabel = line.getSubpartLabel();
        }

        public boolean hasClassId() {
            return this.iClassId != null;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getSubpartId() {
            return this.iSubpartId;
        }

        public void setSubpartId(Long subpartId) {
            this.iSubpartId = subpartId;
        }

        public Integer getIType() {
            return this.iIType;
        }

        public void setIType(Integer itype) {
            this.iIType = itype;
        }

        public boolean isEditable() {
            return this.iEditable;
        }

        public void setEditable(boolean editable) {
            this.iEditable = editable;
        }

        public boolean isEditableDatePattern() {
            return this.iEditableDatePattern;
        }

        public void setEditableDatePattern(boolean editableDatePattern) {
            this.iEditableDatePattern = editableDatePattern;
        }

        public boolean isCanCancel() {
            return this.iCanCancel;
        }

        public void setCanCancel(boolean canCancel) {
            this.iCanCancel = canCancel;
        }

        public boolean isCanDelete() {
            return this.iCanDelete;
        }

        public void setCanDelete(boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public Integer getEnrollment() {
            return this.iEnrollment;
        }

        public void setEnrollment(Integer enrollment) {
            this.iEnrollment = enrollment;
        }

        public Integer getSnapshotLimit() {
            return this.iSnapshotLimit;
        }

        public void setSnapshotLimit(Integer snapshotLimit) {
            this.iSnapshotLimit = snapshotLimit;
        }

        public Integer getMinClassLimit() {
            return this.iMinClassLimit;
        }

        public void setMinClassLimit(Integer minClassLimit) {
            this.iMinClassLimit = minClassLimit;
        }

        public Integer getMaxClassLimit() {
            return this.iMaxClassLimit;
        }

        public void setMaxClassLimit(Integer maxClassLimit) {
            this.iMaxClassLimit = maxClassLimit;
        }

        public Integer getNumberOfRooms() {
            return this.iNumberOfRooms;
        }

        public void setNumberOfRooms(Integer numberOfRooms) {
            this.iNumberOfRooms = numberOfRooms;
        }

        public Boolean getDisplayInstructors() {
            return this.iDisplayInstructors;
        }

        public void setDisplayInstructors(Boolean displayInstructors) {
            this.iDisplayInstructors = displayInstructors;
        }

        public Boolean getEnabledForStudentScheduling() {
            return this.iEnabledForStudentScheduling;
        }

        public void setEnabledForStudentScheduling(Boolean enabledForStudentScheduling) {
            this.iEnabledForStudentScheduling = enabledForStudentScheduling;
        }

        public Float getRoomRatio() {
            return this.iRoomRatio;
        }

        public void setRoomRatio(Float roomRatio) {
            this.iRoomRatio = roomRatio;
        }

        public Long getParentId() {
            return this.iParentId;
        }

        public void setParentId(Long parentId) {
            this.iParentId = parentId;
        }

        public Long getDepartmentId() {
            return this.iDepartmentId;
        }

        public void setDepartmentId(Long departmentId) {
            this.iDepartmentId = departmentId;
        }

        public Long getDatePatternId() {
            return this.iDatePatternId;
        }

        public void setDatePatternId(Long datePatternId) {
            this.iDatePatternId = datePatternId;
        }

        public Boolean getCancelled() {
            return this.iCancelled;
        }

        public void setCancelled(Boolean cancelled) {
            this.iCancelled = cancelled;
        }

        public Long getLMS() {
            return this.iLMS;
        }

        public void setLMS(Long lms) {
            this.iLMS = lms;
        }

        public Boolean getSplitAttendance() {
            return this.iSplitAttendance;
        }

        public void setSplitAttendance(Boolean splitAttendance) {
            this.iSplitAttendance = splitAttendance;
        }

        public String getTime() {
            return this.iTime;
        }

        public void setTime(String time) {
            this.iTime = time;
        }

        public String getDate() {
            return this.iDate;
        }

        public void setDate(String date) {
            this.iDate = date;
        }

        public boolean hasRooms() {
            return this.iRooms != null && !this.iRooms.isEmpty();
        }

        public List<Reference> getRooms() {
            return this.iRooms;
        }

        public void addRoom(Long id, String name, Integer capacity) {
            if (this.iRooms == null) {
                this.iRooms = new ArrayList<Reference>();
            }
            this.iRooms.add(new Reference(id, capacity == null ? "" : capacity.toString(), name, false));
        }

        public String getInstructor() {
            return this.iInstructor;
        }

        public void setInstructor(String instructor) {
            this.iInstructor = instructor;
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public Integer getIndent() {
            return this.iIndent;
        }

        public void setIndent(Integer indent) {
            this.iIndent = indent;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getSubpartLabel() {
            return this.iSubpartLabel;
        }

        public void setSubpartLabel(String label) {
            this.iSubpartLabel = label;
        }

        public void setError(String error) {
            this.iError = error;
        }

        public void addError(String error) {
            this.iError = this.iError == null || this.iError.isEmpty() ? error : this.iError + "\n" + error;
        }

        public boolean hasError() {
            return this.iError != null && !this.iError.isEmpty();
        }

        public String getError() {
            return this.iError;
        }

        public int hashCode() {
            return this.getClassId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ClassLine)) {
                return false;
            }
            return this.getClassId().equals(((ClassLine)o).getClassId());
        }
    }

    public static class Reference
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = -7003516910478521868L;
        private Long iId;
        private String iReference;
        private String iLabel;
        private boolean iSelectable = true;

        public Reference() {
        }

        public Reference(Long id, String ref, String label, boolean selectable) {
            this.iId = id;
            this.iReference = ref;
            this.iLabel = label;
            this.iSelectable = selectable;
        }

        public Long getId() {
            return this.iId;
        }

        public String getReference() {
            return this.iReference;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public boolean isSelectable() {
            return this.iSelectable;
        }

        public void setSelectable(boolean selectable) {
            this.iSelectable = selectable;
        }

        public String toString() {
            return this.getReference() + " - " + this.getLabel();
        }
    }

    public static class Subpart
    extends Reference
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 5252024032132689730L;
        private String iDefaultDatePatternName;

        public Subpart() {
        }

        public Subpart(Long id, String ref, String label, boolean selectable, String defaultDatePatternName) {
            super(id, ref, label, selectable);
            this.iDefaultDatePatternName = defaultDatePatternName;
        }

        public String getDefaultDatePatternName() {
            return this.iDefaultDatePatternName;
        }

        public boolean hasDefaultDatePatternName() {
            return this.iDefaultDatePatternName != null && !this.iDefaultDatePatternName.isEmpty();
        }

        public void setDefaultDatePatternName(String defaultDatePatternName) {
            this.iDefaultDatePatternName = defaultDatePatternName;
        }
    }

    public static enum ClassSetupColumn {
        ERROR,
        CLASS_NAME,
        EXTERNAL_ID,
        BUTTONS,
        ENROLLMENT,
        LIMIT,
        CANCELLED,
        SNAPSHOT,
        NBR_ROOMS,
        SPLIT_ATTENDANCE,
        ROOM_RATIO,
        DEPARTMENT,
        DATE_PATTERN,
        LMS,
        DISPLAY_INSTRUCTOR,
        STUDENT_SCHEDULING,
        TIME,
        DATE,
        ROOM,
        ROOM_CAP,
        INSTRUCTOR;

    }
}

