/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.aria.client.Id;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;

public class UniTimeWidget<T extends Widget>
extends P
implements HasAriaLabel {
    private T iWidget;
    private Widget iReadOnly = null;
    private P iPrint = null;
    private P iHint;
    private Element iAriaLabel = null;

    public UniTimeWidget(T widget, String hint) {
        super("unitime-Widget");
        this.iWidget = widget;
        this.iWidget.addStyleName("widget");
        this.add((Widget)this.iWidget);
        this.iHint = new P();
        this.iHint.setStyleName("hint");
        if (hint == null || hint.isEmpty()) {
            this.iHint.setVisible(false);
        } else {
            this.iHint.setHTML(hint);
        }
        this.add((Widget)this.iHint);
        this.iHint.getElement().setId(DOM.createUniqueId());
    }

    @Override
    public void setAriaLabel(String text) {
        if (this.iWidget instanceof HasAriaLabel) {
            ((HasAriaLabel)this.iWidget).setAriaLabel(text);
        } else {
            if (this.iAriaLabel == null) {
                this.iAriaLabel = DOM.createLabel();
                this.iAriaLabel.setId(DOM.createUniqueId());
                this.iAriaLabel.setClassName("hidden-label");
                DOM.appendChild((Element)this.getElement(), (Element)this.iAriaLabel);
                Element e = ToolBox.firstInputElement((Element)this.iWidget.getElement());
                if (e != null) {
                    Roles.getCheckboxRole().setAriaLabelledbyProperty(e, new Id[]{Id.of((Element)this.iAriaLabel)});
                } else {
                    Roles.getCheckboxRole().setAriaLabelledbyProperty((Element)this.iWidget.getElement(), new Id[]{Id.of((Element)this.iAriaLabel)});
                }
            }
            this.iAriaLabel.setInnerText(text);
        }
    }

    @Override
    public String getAriaLabel() {
        if (this.iWidget instanceof HasAriaLabel) {
            return ((HasAriaLabel)this.iWidget).getAriaLabel();
        }
        return this.iAriaLabel == null ? "" : this.iAriaLabel.getInnerText();
    }

    @Override
    public void setText(String html) {
        if (this.iReadOnly == null) {
            this.iReadOnly = new P("label");
            this.iReadOnly.setVisible(!this.getWidget().isVisible());
            if (this.iPrint != null) {
                this.iReadOnly.addStyleName("unitime-NoPrint");
            }
            this.insert(this.iReadOnly, 1);
        }
        if (this.iReadOnly instanceof HasHTML) {
            ((HasHTML)this.iReadOnly).setHTML(html);
        } else if (this.iReadOnly instanceof HasText) {
            ((HasText)this.iReadOnly).setText(html);
        }
    }

    public Widget getReadOnlyWidget() {
        return this.iReadOnly;
    }

    public void setReadOnlyWidget(Widget readOnly) {
        if (this.iReadOnly != null) {
            this.remove(this.iReadOnly);
        }
        this.iReadOnly = readOnly;
        this.iReadOnly.setVisible(!this.getWidget().isVisible());
        if (this.iPrint != null) {
            this.iReadOnly.addStyleName("unitime-NoPrint");
        }
        this.insert(this.iReadOnly, 1);
    }

    public void setPrintText(String html) {
        if (this.iPrint == null) {
            this.iPrint = new P("label");
            this.iPrint.setHTML(html);
            this.iPrint.addStyleName("unitime-Print");
            if (this.iReadOnly != null) {
                this.iReadOnly.addStyleName("unitime-NoPrint");
            }
            this.getWidget().addStyleName("unitime-NoPrint");
            this.insert((Widget)this.iPrint, 1);
        } else {
            this.iPrint.setHTML(html);
        }
    }

    public boolean showReadOnly() {
        return this.iWidget instanceof ListBox;
    }

    public UniTimeWidget(T widget) {
        this(widget, null);
    }

    public T getWidget() {
        return this.iWidget;
    }

    public void clearHint() {
        this.iHint.setHTML("");
        this.iHint.setVisible(false);
        Roles.getTextboxRole().removeAriaDescribedbyProperty((Element)this.iWidget.getElement());
    }

    public void setErrorHint(String error) {
        if (error == null || error.isEmpty()) {
            this.clearHint();
        } else {
            this.iHint.setStyleName("error-hint");
            this.iHint.setHTML(error);
            this.iHint.setVisible(true);
            Roles.getTextboxRole().setAriaDescribedbyProperty((Element)this.iWidget.getElement(), new Id[]{Id.of((Element)this.iHint.getElement())});
        }
    }

    public void setHint(String hint) {
        if (hint == null || hint.isEmpty()) {
            this.clearHint();
        } else {
            this.iHint.setStyleName("hint");
            this.iHint.setHTML(hint);
            this.iHint.setVisible(true);
            Roles.getTextboxRole().setAriaDescribedbyProperty((Element)this.iWidget.getElement(), new Id[]{Id.of((Element)this.iHint.getElement())});
        }
    }

    @Deprecated
    public void setVisible(boolean visible) {
        this.getWidget().setVisible(visible);
        if (this.iReadOnly != null) {
            this.iReadOnly.setVisible(!visible);
        }
    }

    @Deprecated
    public void clear() {
        if (this.getWidget() instanceof ListBox) {
            ((ListBox)this.getWidget()).clear();
        }
        if (this.getWidget() instanceof Panel) {
            ((Panel)this.getWidget()).clear();
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (this.getWidget() instanceof UniTimeTextBox) {
            ((UniTimeTextBox)this.getWidget()).setReadOnly(readOnly);
        } else {
            this.getWidget().setVisible(!readOnly);
            if (this.iReadOnly != null) {
                this.iReadOnly.setVisible(readOnly);
            }
        }
    }

    public boolean isReadOnly() {
        if (this.getWidget() instanceof UniTimeTextBox) {
            return ((UniTimeTextBox)this.getWidget()).isReadOnly();
        }
        return this.iReadOnly != null && this.iReadOnly.isVisible();
    }

    public P getPanel() {
        return this;
    }
}

