/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.BodyElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasAllFocusHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

public class CourseFinderFilter
extends SimpleForm
implements HasValue<CourseRequestInterface.Filter> {
    protected static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static DateTimeFormat sDF = DateTimeFormat.getFormat((String)CONSTANTS.patternDateFormat());
    private SingleDateSelector iDateFrom;
    private SingleDateSelector iDateTo;
    private NumberBox iCreditFrom;
    private NumberBox iCreditTo;
    private OnlineSectioningInterface.StudentSectioningContext iContext;
    private AriaTextBox iInstructor;
    private Timer iChangeTimer;
    private FilterButton iFilterButton;
    private P iFilterLabel;
    AbsolutePanel iCredits;
    AbsolutePanel iDates;
    private P iFilterText;
    private boolean iClassFilter = true;

    public CourseFinderFilter(OnlineSectioningInterface.StudentSectioningContext context) {
        this.iContext = context;
        this.iFilterButton = new FilterButton();
        this.iFilterButton.addStyleName("filter-button");
        this.iFilterLabel = new P("filter-label");
        this.iFilterLabel.setText(MESSAGES.sectCourseFinderFilter());
        P filter = new P("filter-header");
        filter.add((Widget)this.iFilterButton);
        filter.add((Widget)this.iFilterLabel);
        this.iFilterButton.addValueChangeHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (((Boolean)event.getValue()).booleanValue()) {
                    CourseFinderFilter.this.iFilterLabel.setText(MESSAGES.propCourseFinderFilterCredit());
                    for (int row = 1; row < CourseFinderFilter.this.getRowCount(); ++row) {
                        CourseFinderFilter.this.getRowFormatter().setVisible(row, CourseFinderFilter.this.iClassFilter);
                    }
                    CourseFinderFilter.this.setWidget(0, 1, (Widget)CourseFinderFilter.this.iCredits);
                } else {
                    CourseFinderFilter.this.iFilterLabel.setText(MESSAGES.sectCourseFinderFilter());
                    CourseFinderFilter.this.setWidget(0, 1, (Widget)CourseFinderFilter.this.iFilterText);
                    CourseFinderFilter.this.iFilterText.setText(CourseFinderFilter.this.getFilterText());
                    for (int row = 1; row < CourseFinderFilter.this.getRowCount(); ++row) {
                        CourseFinderFilter.this.getRowFormatter().setVisible(row, false);
                    }
                }
            }
        });
        this.iFilterText = new P("filter-text");
        this.iCredits = new AbsolutePanel();
        this.iCredits.setStyleName("credit");
        P from = new P("from");
        from.setText(MESSAGES.propCourseFinderFilterCreditFrom());
        this.iCredits.add((Widget)from);
        this.iCreditFrom = new NumberBox();
        this.iCredits.add((Widget)this.iCreditFrom);
        this.iCreditFrom.setAriaLabel(ARIA.inpurtCourseFinderFilterMinCredit());
        P to = new P("to");
        to.setText(MESSAGES.propCourseFinderFilterCreditTo());
        this.iCredits.add((Widget)to);
        this.iCreditTo = new NumberBox();
        this.iCredits.add((Widget)this.iCreditTo);
        this.iCreditTo.setAriaLabel(ARIA.inpurtCourseFinderFilterMaxCredit());
        this.addRow((Widget)filter, (Widget)this.iCredits);
        this.addStyleName("filter");
        this.iDates = new AbsolutePanel();
        this.iDates.setStyleName("dates");
        from = new P("from");
        from.setText(MESSAGES.propSchedulingPrefDatesFrom());
        this.iDates.add((Widget)from);
        this.iDateFrom = new SingleDateSelector(null);
        this.iDateFrom.setAriaLabel(ARIA.inpurtCourseFinderFilterClassStartDate());
        this.iDates.add((Widget)this.iDateFrom);
        to = new P("to");
        to.setText(MESSAGES.propSchedulingPrefDatesTo());
        this.iDates.add((Widget)to);
        this.iDateTo = new SingleDateSelector(null);
        this.iDateFrom.setAriaLabel(ARIA.inpurtCourseFinderFilterClassEndDate());
        this.iDates.add((Widget)this.iDateTo);
        this.addRow(MESSAGES.propSchedulingPrefDates(), (Widget)this.iDates);
        this.iInstructor = new AriaTextBox();
        this.iInstructor.setStyleName("gwt-SuggestBox");
        this.iInstructor.addStyleName("instructor");
        this.iInstructor.setAriaLabel(ARIA.inpurtCourseFinderFilterInstructor());
        this.addRow(MESSAGES.propCourseFinderFilterInstructor(), (Widget)this.iInstructor);
        this.iFilterButton.setValue(false, true);
        this.iChangeTimer = new Timer(){

            public void run() {
                ValueChangeEvent.fire((HasValueChangeHandlers)CourseFinderFilter.this, (Object)CourseFinderFilter.this.getValue());
            }
        };
        this.iDateTo.addValueChangeHandler(new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                CourseFinderFilter.this.iChangeTimer.schedule(500);
            }
        });
        this.iDateFrom.addValueChangeHandler(new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                CourseFinderFilter.this.iChangeTimer.schedule(500);
            }
        });
        this.iCreditFrom.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                CourseFinderFilter.this.iChangeTimer.schedule(500);
            }
        });
        this.iCreditTo.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                CourseFinderFilter.this.iChangeTimer.schedule(500);
            }
        });
        this.iInstructor.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                CourseFinderFilter.this.iChangeTimer.schedule(500);
            }
        });
    }

    public String getFilterText() {
        CourseRequestInterface.Filter filter = this.getValue();
        Object ret = "";
        if (filter.hasDates()) {
            ret = filter.getClassFrom() != null && filter.getClassTo() != null ? (String)ret + MESSAGES.filterClassesBetweenDates(sDF.format(filter.getClassFrom()), sDF.format(filter.getClassTo())) : (filter.getClassFrom() != null ? (String)ret + MESSAGES.filterClassesFromDate(sDF.format(filter.getClassFrom())) : (String)ret + MESSAGES.filterClassesToDate(sDF.format(filter.getClassTo())));
        }
        if (filter.getCreditMin() != null) {
            if (!((String)ret).isEmpty()) {
                ret = (String)ret + ", ";
            }
            ret = filter.getCreditMax() != null ? (filter.getCreditMin().equals(filter.getCreditMax()) ? (String)ret + MESSAGES.filterCreditEquals(filter.getCreditMin().floatValue()) : (String)ret + MESSAGES.filterCreditBetween(filter.getCreditMin().floatValue(), filter.getCreditMax().floatValue())) : (String)ret + MESSAGES.filterCreditFrom(filter.getCreditMin().floatValue());
        } else if (filter.getCreditMax() != null) {
            if (!((String)ret).isEmpty()) {
                ret = (String)ret + ", ";
            }
            ret = (String)ret + MESSAGES.filterCreditTo(filter.getCreditMax().floatValue());
        }
        if (filter.hasInstructor()) {
            if (!((String)ret).isEmpty()) {
                ret = (String)ret + ", ";
            }
            ret = (String)ret + MESSAGES.filterInstructor(filter.getInstructor());
        }
        if (!((String)ret).isEmpty()) {
            return MESSAGES.messageCourseFinderFilterText((String)ret);
        }
        return ret;
    }

    public void init() {
        String showFilter = ToolBox.getSessionCookie("UniTime:CourseFinderFilter");
        this.iFilterButton.setValue("1".equals(showFilter), true);
        if (this.iContext.hasSessionDates()) {
            this.iDateFrom.init(this.iContext);
            this.iDateTo.init(this.iContext);
            this.iDateFrom.setAriaLabel(ARIA.inpurtCourseFinderFilterClassStartDate());
            this.iDateTo.setAriaLabel(ARIA.inpurtCourseFinderFilterClassEndDate());
        } else if (this.iContext.getAcademicSessionId() != null) {
            final Long sessionId = this.iContext.getAcademicSessionId();
            RPC.execute(new EventInterface.RequestSessionDetails(sessionId), new AsyncCallback<GwtRpcResponseList<EventInterface.SessionMonth>>(){

                public void onFailure(Throwable caught) {
                    CourseFinderFilter.this.iDateFrom.setErrorHint(caught.getMessage());
                    CourseFinderFilter.this.iDateTo.setErrorHint(caught.getMessage());
                }

                public void onSuccess(GwtRpcResponseList<EventInterface.SessionMonth> result) {
                    if (sessionId.equals(CourseFinderFilter.this.iContext.getAcademicSessionId())) {
                        CourseFinderFilter.this.iContext.setSessionDates(result);
                    }
                    CourseFinderFilter.this.iDateFrom.init(result);
                    CourseFinderFilter.this.iDateTo.init(result);
                    CourseFinderFilter.this.iDateFrom.setAriaLabel(ARIA.inpurtCourseFinderFilterClassStartDate());
                    CourseFinderFilter.this.iDateTo.setAriaLabel(ARIA.inpurtCourseFinderFilterClassEndDate());
                }
            });
        }
        boolean bl = this.iClassFilter = this.iContext == null || !this.iContext.isClassScheduleNotAvailable();
        if (this.iClassFilter) {
            for (int row = 1; row < this.getRowCount(); ++row) {
                this.getRowFormatter().setVisible(row, this.iFilterButton.getValue().booleanValue());
            }
        } else {
            for (int row = 1; row < this.getRowCount(); ++row) {
                this.getRowFormatter().setVisible(row, false);
            }
            this.iDateFrom.setValue(null);
            this.iDateTo.setValue(null);
            this.iInstructor.setValue("");
            this.iFilterText.setText(this.getFilterText());
        }
    }

    public CourseRequestInterface.Filter getValue() {
        CourseRequestInterface.Filter filter = new CourseRequestInterface.Filter();
        filter.setClassFrom(this.iDateFrom.getValueInServerTimeZone());
        filter.setClassTo(this.iDateTo.getValueInServerTimeZone());
        filter.setCreditMin(this.iCreditFrom.toFloat());
        filter.setCreditMax(this.iCreditTo.toFloat());
        filter.setInstructor(this.iInstructor.getValue());
        return filter;
    }

    public void setValue(CourseRequestInterface.Filter filter) {
        if (filter == null) {
            this.iDateFrom.setValue(null);
            this.iDateTo.setValue(null);
            this.iCreditFrom.setValue(null);
            this.iCreditTo.setValue(null);
            this.iInstructor.setValue("");
        } else {
            this.iDateFrom.setValueInServerTimeZone(filter.getClassFrom());
            this.iDateTo.setValueInServerTimeZone(filter.getClassTo());
            this.iCreditFrom.setValue(filter.getCreditMin());
            this.iCreditTo.setValue(filter.getCreditMax());
            this.iInstructor.setValue(filter.hasInstructor() ? filter.getInstructor() : "");
        }
        this.iFilterText.setText(this.getFilterText());
    }

    public void setValue(CourseRequestInterface.Filter value, boolean fireEvents) {
        this.setValue(value);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    public boolean isPopupShowing() {
        return this.iDateFrom.isPopupShowing() || this.iDateTo.isPopupShowing();
    }

    public boolean isCanSubmit(Event.NativePreviewEvent event) {
        if (this.iDateFrom.isPopupShowing()) {
            return false;
        }
        if (this.iDateTo.isPopupShowing()) {
            return false;
        }
        return InputElement.is((JavaScriptObject)event.getNativeEvent().getEventTarget()) || BodyElement.is((JavaScriptObject)event.getNativeEvent().getEventTarget());
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CourseRequestInterface.Filter> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    static class FilterButton
    extends Image
    implements HasValue<Boolean>,
    Focusable,
    HasAllFocusHandlers {
        private boolean iOpened = false;

        public FilterButton() {
            super(RESOURCES.treeClosed());
            Roles.getButtonRole().set((Element)this.getElement());
            this.sinkEvents(512);
            this.setAltText(MESSAGES.descCourseFinderFilterClosed());
            this.setTabIndex(0);
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    this.setValue(this.getValue() == false, true);
                    ToolBox.setSessionCookie("UniTime:CourseFinderFilter", this.getValue() != false ? "1" : "0");
                }
            });
        }

        public void onBrowserEvent(Event event) {
            super.onBrowserEvent(event);
            if (event.getTypeInt() == 512 && (event.getKeyCode() == 13 || event.getKeyCode() == 32)) {
                this.onClick();
            }
        }

        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Boolean> handler) {
            return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
        }

        public Boolean getValue() {
            return this.iOpened;
        }

        public void setValue(Boolean value) {
            this.iOpened = value;
            this.setResource(this.iOpened ? RESOURCES.treeOpen() : RESOURCES.treeClosed());
            this.setAltText(this.iOpened ? MESSAGES.descCourseFinderFilterOpened() : MESSAGES.descCourseFinderFilterClosed());
        }

        public void setValue(Boolean value, boolean fireEvents) {
            this.setValue(value);
            if (fireEvents) {
                ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
            }
        }

        public int getTabIndex() {
            return this.getElement().getTabIndex();
        }

        public void setAccessKey(char key) {
            this.setAccessKey((Element)this.getElement(), key);
        }

        private native void setAccessKey(Element var1, char var2);

        public void setFocus(boolean focused) {
            if (focused) {
                this.getElement().focus();
            } else {
                this.getElement().blur();
            }
        }

        public void setTabIndex(int index) {
            this.getElement().setTabIndex(index);
        }

        public HandlerRegistration addFocusHandler(FocusHandler handler) {
            return this.addDomHandler((EventHandler)handler, FocusEvent.getType());
        }

        public HandlerRegistration addBlurHandler(BlurHandler handler) {
            return this.addDomHandler((EventHandler)handler, BlurEvent.getType());
        }

        public void setAltText(String altText) {
            super.setAltText(altText);
            if (this.getTitle() == null || this.getTitle().isEmpty()) {
                this.setTitle(altText);
            }
        }

        protected void onClick() {
            this.getElement().dispatchEvent(Document.get().createClickEvent(1, 0, 0, 0, 0, false, false, false, false));
        }
    }
}

