/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.solver.PageFilter;
import org.unitime.timetable.gwt.client.solver.PreferenceLegend;
import org.unitime.timetable.gwt.client.solver.SolverCookie;
import org.unitime.timetable.gwt.client.solver.suggestions.ConflictBasedStatisticsTree;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;

public class ConflictBasedStatisticsPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private PageFilter iFilter = new PageFilter();
    private SimplePanel iRootPanel;
    private SimpleForm iPanel;
    private FilterInterface iLastFilter;
    private GwtRpcResponseList<SuggestionsInterface.CBSNode> iLastResponse;
    private CourseTimetablingSolverInterface.ConflictStatisticsFilterResponse iFilterResponse;
    private ConflictBasedStatisticsTree iTree;
    private PreferenceLegend iLegend;

    public ConflictBasedStatisticsPage() {
        this.iFilter.getHeader().setCollapsible(SolverCookie.getInstance().isShowCBSFilter());
        this.iFilter.getHeader().addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (event.getValue() != null) {
                    SolverCookie.getInstance().setShowCBSFilter((Boolean)event.getValue());
                }
            }
        });
        this.iPanel = new SimpleForm(2);
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iPanel.addRow((Widget)this.iFilter);
        this.iFilter.getFooter().addButton("search", MESSAGES.buttonSearch(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                String token = ConflictBasedStatisticsPage.this.iFilter.getQuery();
                if (!History.getToken().equals(token)) {
                    History.newItem((String)token, (boolean)false);
                }
                ConflictBasedStatisticsPage.this.search(null);
            }
        });
        this.iFilter.getFooter().setEnabled("search", false);
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-ConflictBasedStatisticsPage");
        this.initWidget((Widget)this.iRootPanel);
        this.init();
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ConflictBasedStatisticsPage.this.iFilter.setQuery((String)event.getValue(), true);
                if (ConflictBasedStatisticsPage.this.iPanel.getRowCount() > 1) {
                    ConflictBasedStatisticsPage.this.search(null);
                }
            }
        });
    }

    protected void init() {
        RPC.execute(new CourseTimetablingSolverInterface.ConflictStatisticsFilterRequest(), new AsyncCallback<CourseTimetablingSolverInterface.ConflictStatisticsFilterResponse>(){

            public void onFailure(Throwable caught) {
                ConflictBasedStatisticsPage.this.iFilter.getFooter().setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(CourseTimetablingSolverInterface.ConflictStatisticsFilterResponse result) {
                ConflictBasedStatisticsPage.this.iLegend = new PreferenceLegend(result.getSuggestionProperties().getPreferences());
                ConflictBasedStatisticsPage.this.iFilterResponse = result;
                ConflictBasedStatisticsPage.this.iFilter.getFooter().clearMessage();
                ConflictBasedStatisticsPage.this.iFilter.setValue(result);
                ConflictBasedStatisticsPage.this.iFilter.getFooter().setEnabled("search", true);
                ConflictBasedStatisticsPage.createTriggers();
                if (ConflictBasedStatisticsPage.this.iFilter.getHeader().isCollapsible() != null && !ConflictBasedStatisticsPage.this.iFilter.getHeader().isCollapsible().booleanValue()) {
                    ConflictBasedStatisticsPage.this.search(null);
                }
            }
        });
    }

    public static native void createTriggers();

    protected void search(final AsyncCallback<Boolean> callback) {
        SuggestionsInterface.ConflictBasedStatisticsRequest request = new SuggestionsInterface.ConflictBasedStatisticsRequest();
        final FilterInterface filter = this.iFilter.getValue();
        try {
            request.setLimit(Double.valueOf(filter.getParameterValue("limit", "25.0")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        request.setVariableOriented("0".equals(filter.getParameterValue("mode", "0")));
        this.iFilter.getFooter().clearMessage();
        for (int row = this.iPanel.getRowCount() - 1; row > 0; --row) {
            this.iPanel.removeRow(row);
        }
        this.iFilter.getFooter().showLoading();
        this.iFilter.getFooter().setEnabled("search", false);
        LoadingWidget.showLoading(MESSAGES.waitLoadingData());
        RPC.execute(request, new AsyncCallback<GwtRpcResponseList<SuggestionsInterface.CBSNode>>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.hideLoading();
                ConflictBasedStatisticsPage.this.iFilter.getFooter().setErrorMessage(MESSAGES.failedToLoadConflictStatistics(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadConflictStatistics(caught.getMessage()), caught);
                ConflictBasedStatisticsPage.this.iFilter.getFooter().setEnabled("search", true);
                if (callback != null) {
                    callback.onFailure(caught);
                }
            }

            public void onSuccess(GwtRpcResponseList<SuggestionsInterface.CBSNode> result) {
                LoadingWidget.hideLoading();
                ConflictBasedStatisticsPage.this.iFilter.getFooter().clearMessage();
                ConflictBasedStatisticsPage.this.populate(filter, result);
                ConflictBasedStatisticsPage.this.iFilter.getFooter().setEnabled("search", true);
                if (callback != null) {
                    callback.onSuccess((Object)(result != null && !result.isEmpty() ? 1 : 0));
                }
            }
        });
    }

    protected void populate(FilterInterface filter, GwtRpcResponseList<SuggestionsInterface.CBSNode> response) {
        this.iLastFilter = filter;
        this.iLastResponse = response;
        for (int row = this.iPanel.getRowCount() - 1; row > 0; --row) {
            this.iPanel.removeRow(row);
        }
        RootPanel cpm = RootPanel.get((String)"UniTimeGWT:CustomPageMessages");
        if (cpm != null && this.iFilterResponse != null) {
            cpm.clear();
            if (this.iFilterResponse.hasPageMessages()) {
                for (final SolverInterface.PageMessage pm : this.iFilterResponse.getPageMessages()) {
                    P p = new P(pm.getType() == SolverInterface.PageMessageType.ERROR ? "unitime-PageError" : (pm.getType() == SolverInterface.PageMessageType.WARNING ? "unitime-PageWarn" : "unitime-PageMessage"));
                    p.setHTML(pm.getMessage());
                    if (pm.hasUrl()) {
                        p.addStyleName("unitime-ClickablePageMessage");
                        p.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                if (pm.hasUrl()) {
                                    ToolBox.open(GWT.getHostPageBaseURL() + pm.getUrl());
                                }
                            }
                        });
                    }
                    cpm.add((Widget)p);
                }
            }
        }
        if (response == null || response.isEmpty()) {
            this.iFilter.getFooter().setMessage(MESSAGES.errorConflictStatisticsNoDataReturned());
            return;
        }
        if (this.iTree == null) {
            this.iTree = new ConflictBasedStatisticsTree(this.iFilterResponse.getSuggestionProperties());
        }
        this.iTree.setValue(response);
        this.iPanel.addRow((Widget)this.iTree);
        this.iPanel.addRow((Widget)this.iLegend);
    }
}

