/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.solver.DataTable;
import org.unitime.timetable.gwt.client.solver.PageFilter;
import org.unitime.timetable.gwt.client.solver.PreferenceLegend;
import org.unitime.timetable.gwt.client.solver.SolverCookie;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;

public class AssignmentHistoryPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private PageFilter iFilter = new PageFilter();
    private SimplePanel iRootPanel;
    private SimpleForm iPanel;
    private FilterInterface iLastFilter;
    private CourseTimetablingSolverInterface.AssignmentHistoryResponse iLastResponse;
    private DataTable iTable;
    private PreferenceLegend iLegend;

    public AssignmentHistoryPage() {
        this.iFilter.getHeader().setCollapsible(SolverCookie.getInstance().isAssignmentHistoryFilter());
        this.iFilter.getHeader().addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                SolverCookie.getInstance().setAssignmentHistoryFilter((Boolean)event.getValue());
            }
        });
        this.iPanel = new SimpleForm(2);
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iPanel.addRow((Widget)this.iFilter);
        this.iFilter.getFooter().addButton("search", MESSAGES.buttonSearch(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                String token = AssignmentHistoryPage.this.iFilter.getQuery();
                if (!History.getToken().equals(token)) {
                    History.newItem((String)token, (boolean)false);
                }
                AssignmentHistoryPage.this.search(null);
            }
        });
        this.iFilter.getFooter().setEnabled("search", false);
        this.iFilter.getFooter().addButton("print", MESSAGES.buttonPrint(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                AssignmentHistoryPage.this.print();
            }
        });
        this.iFilter.getFooter().setEnabled("print", false);
        this.iFilter.getFooter().addButton("exportCSV", MESSAGES.buttonExportCSV(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                AssignmentHistoryPage.this.exportData("csv");
            }
        });
        this.iFilter.getFooter().setEnabled("exportCSV", false);
        this.iFilter.getFooter().addButton("exportPDF", MESSAGES.buttonExportPDF(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                AssignmentHistoryPage.this.exportData("pdf");
            }
        });
        this.iFilter.getFooter().setEnabled("exportPDF", false);
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-AssignmentHistoryPage");
        this.initWidget((Widget)this.iRootPanel);
        this.init();
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                AssignmentHistoryPage.this.iFilter.setQuery((String)event.getValue(), true);
                if (AssignmentHistoryPage.this.iPanel.getRowCount() > 1) {
                    AssignmentHistoryPage.this.search(null);
                }
            }
        });
    }

    protected void init() {
        RPC.execute(new CourseTimetablingSolverInterface.AssignmentHistoryFilterRequest(), new AsyncCallback<CourseTimetablingSolverInterface.AssignmentHistoryFilterResponse>(){

            public void onFailure(Throwable caught) {
                AssignmentHistoryPage.this.iFilter.getFooter().setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(CourseTimetablingSolverInterface.AssignmentHistoryFilterResponse result) {
                AssignmentHistoryPage.this.iLegend = new PreferenceLegend(result.getPreferences());
                AssignmentHistoryPage.this.iFilter.getFooter().clearMessage();
                AssignmentHistoryPage.this.iFilter.setValue(result);
                AssignmentHistoryPage.this.iFilter.getFooter().setEnabled("search", true);
                AssignmentHistoryPage.createTriggers();
                if (AssignmentHistoryPage.this.iFilter.getHeader().isCollapsible() != null && !AssignmentHistoryPage.this.iFilter.getHeader().isCollapsible().booleanValue()) {
                    AssignmentHistoryPage.this.search(null);
                }
            }
        });
    }

    public static native void createTriggers();

    public static void __search() {
        final int left = Window.getScrollLeft();
        final int top = Window.getScrollTop();
        AssignmentHistoryPage page = (AssignmentHistoryPage)RootPanel.get((String)"UniTimeGWT:Body").getWidget(0);
        page.search(new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Boolean result) {
                if (result.booleanValue()) {
                    Window.scrollTo((int)left, (int)top);
                }
            }
        });
    }

    protected void search(final AsyncCallback<Boolean> callback) {
        final CourseTimetablingSolverInterface.AssignmentHistoryRequest request = new CourseTimetablingSolverInterface.AssignmentHistoryRequest();
        request.setFilter(this.iFilter.getValue());
        this.iFilter.getFooter().clearMessage();
        for (int row = this.iPanel.getRowCount() - 1; row > 0; --row) {
            this.iPanel.removeRow(row);
        }
        this.iFilter.getFooter().showLoading();
        this.iFilter.getFooter().setEnabled("search", false);
        LoadingWidget.showLoading(MESSAGES.waitLoadingData());
        RPC.execute(request, new AsyncCallback<CourseTimetablingSolverInterface.AssignmentHistoryResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.hideLoading();
                AssignmentHistoryPage.this.iFilter.getFooter().setErrorMessage(MESSAGES.failedToLoadAssignmentHistory(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadAssignmentHistory(caught.getMessage()), caught);
                AssignmentHistoryPage.this.iFilter.getFooter().setEnabled("search", true);
                if (callback != null) {
                    callback.onFailure(caught);
                }
            }

            public void onSuccess(CourseTimetablingSolverInterface.AssignmentHistoryResponse result) {
                LoadingWidget.hideLoading();
                AssignmentHistoryPage.this.iFilter.getFooter().clearMessage();
                AssignmentHistoryPage.this.populate(request.getFilter(), result);
                AssignmentHistoryPage.this.iFilter.getFooter().setEnabled("search", true);
                if (callback != null) {
                    callback.onSuccess((Object)(!result.getRows().isEmpty() ? 1 : 0));
                }
            }
        });
    }

    protected void print() {
        final DataTable table = new DataTable(this.iLastResponse);
        com.google.gwt.user.client.Element headerRow = table.getRowFormatter().getElement(0);
        com.google.gwt.user.client.Element tableElement = table.getElement();
        com.google.gwt.user.client.Element thead = DOM.createTHead();
        tableElement.insertFirst((Node)thead);
        headerRow.getParentElement().removeChild((Node)headerRow);
        thead.appendChild((Node)headerRow);
        ToolBox.Page page = new ToolBox.Page(){

            @Override
            public String getName() {
                return MESSAGES.sectAssignmentHistory();
            }

            @Override
            public String getUser() {
                return "";
            }

            @Override
            public String getSession() {
                return "";
            }

            @Override
            public Element getBody() {
                return table.getElement();
            }
        };
        ToolBox.print(page);
    }

    private void exportData(String format) {
        String query = "output=assignment-history." + format + this.iFilter.getQuery() + "&sort=" + SolverCookie.getInstance().getSolutionChangesSort();
        RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(query), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
            }
        });
    }

    protected void populate(FilterInterface filter, CourseTimetablingSolverInterface.AssignmentHistoryResponse response) {
        this.iLastFilter = filter;
        this.iLastResponse = response;
        this.iFilter.getFooter().setEnabled("print", false);
        this.iFilter.getFooter().setEnabled("exportCSV", false);
        this.iFilter.getFooter().setEnabled("exportPDF", false);
        for (int row = this.iPanel.getRowCount() - 1; row > 0; --row) {
            this.iPanel.removeRow(row);
        }
        RootPanel cpm = RootPanel.get((String)"UniTimeGWT:CustomPageMessages");
        if (cpm != null) {
            cpm.clear();
            if (response.hasPageMessages()) {
                for (final SolverInterface.PageMessage pm : response.getPageMessages()) {
                    P p = new P(pm.getType() == SolverInterface.PageMessageType.ERROR ? "unitime-PageError" : (pm.getType() == SolverInterface.PageMessageType.WARNING ? "unitime-PageWarn" : "unitime-PageMessage"));
                    p.setHTML(pm.getMessage());
                    if (pm.hasUrl()) {
                        p.addStyleName("unitime-ClickablePageMessage");
                        p.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                if (pm.hasUrl()) {
                                    ToolBox.open(GWT.getHostPageBaseURL() + pm.getUrl());
                                }
                            }
                        });
                    }
                    cpm.add((Widget)p);
                }
            }
        }
        if (response.hasMessage()) {
            this.iFilter.getFooter().setMessage(response.getMessage());
        }
        if (response.getRows().isEmpty()) {
            if (!response.hasMessage()) {
                this.iFilter.getFooter().setMessage(MESSAGES.errorAssignmentHistoryNoDataReturned());
            }
            return;
        }
        UniTimeHeaderPanel header = new UniTimeHeaderPanel(MESSAGES.sectAssignmentHistory());
        this.iPanel.addHeaderRow((Widget)header);
        if (this.iTable == null) {
            this.iTable = new DataTable(response);
            this.iTable.addValueChangeHandler(new ValueChangeHandler<Integer>(){

                public void onValueChange(ValueChangeEvent<Integer> event) {
                    SolverCookie.getInstance().setAssignmentHistorySort(event.getValue() == null ? 0 : (Integer)event.getValue());
                }
            });
        } else {
            this.iTable.populate(response);
        }
        this.iTable.setValue(SolverCookie.getInstance().getAssignmentHistorySort());
        this.iPanel.addRow((Widget)this.iTable);
        this.iPanel.addRow((Widget)this.iLegend);
        this.iFilter.getFooter().setEnabled("print", true);
        this.iFilter.getFooter().setEnabled("exportCSV", true);
        this.iFilter.getFooter().setEnabled("exportPDF", true);
    }
}

