/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.sectioning.SectioningCookie;
import org.unitime.timetable.gwt.client.widgets.OpenCloseSectionImage;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

public class WaitListsPanel
extends P {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private static DateTimeFormat sModifiedDateFormat = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    private UniTimeTable<CourseRequestInterface.RequestedCourse> iTable;
    private FocusPanel iPanel;
    private Image iWaiting = null;
    private OpenCloseSectionImage iOpenCloseImage;
    private CourseRequestInterface iRequests;
    private SpecialRegistrationInterface.SpecialRegistrationContext iSpecReg;

    public WaitListsPanel(SpecialRegistrationInterface.SpecialRegistrationContext specReg) {
        this.iSpecReg = specReg;
        this.addStyleName("unitime-WaitListsPanel");
        P title = new P("waitlists-header");
        this.iWaiting = new Image(RESOURCES.loading_small());
        this.iWaiting.addStyleName("icon");
        this.iWaiting.setVisible(false);
        title.add((Widget)this.iWaiting);
        this.iOpenCloseImage = new OpenCloseSectionImage(true);
        this.iOpenCloseImage.addStyleName("open-close-icon");
        this.iOpenCloseImage.setVisible(true);
        title.add((Widget)this.iOpenCloseImage);
        P label = new P("title");
        label.setText(MESSAGES.panelWaitListedCourses());
        title.add((Widget)label);
        this.add((Widget)title);
        this.iTable = new UniTimeTable();
        this.iTable.addStyleName("waitlists-table");
        this.iPanel = new FocusPanel(this.iTable);
        this.iPanel.addStyleName("waitlists-panel");
        this.add((Widget)this.iPanel);
        this.iOpenCloseImage.addValueChangeHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                WaitListsPanel.this.iPanel.setVisible((Boolean)event.getValue() != false && WaitListsPanel.this.iTable.getRowCount() > 1);
                SectioningCookie.getInstance().setWaitListsOpened((Boolean)event.getValue());
            }
        });
        label.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (WaitListsPanel.this.iOpenCloseImage.isVisible()) {
                    WaitListsPanel.this.iOpenCloseImage.setValue(WaitListsPanel.this.iOpenCloseImage.getValue() == false, true);
                }
            }
        });
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        header.add(new UniTimeTableHeader(""));
        header.add(new UniTimeTableHeader(MESSAGES.colWaitListedTimeStamp()));
        header.add(new UniTimeTableHeader(MESSAGES.colCourse()));
        header.add(new UniTimeTableHeader(MESSAGES.colTitle()));
        header.add(new UniTimeTableHeader(MESSAGES.colCredit()));
        header.add(new UniTimeTableHeader(MESSAGES.colWaitListSwapWithCourseOffering()));
        header.add(new UniTimeTableHeader(MESSAGES.colWaitListPosition()));
        header.add(new UniTimeTableHeader(MESSAGES.colRequirements()));
        header.add(new UniTimeTableHeader(MESSAGES.colWaitListErrors()));
        this.iTable.addRow(null, header);
        this.iOpenCloseImage.setValue(SectioningCookie.getInstance().isWaitListsOpened());
        this.iPanel.setVisible(this.iOpenCloseImage.getValue().booleanValue());
        this.setVisible(false);
    }

    public UniTimeTable<CourseRequestInterface.RequestedCourse> getTable() {
        return this.iTable;
    }

    public void showWaiting() {
        this.iWaiting.setVisible(true);
        this.iOpenCloseImage.setVisible(false);
        this.iPanel.setVisible(false);
        this.setVisible(true);
    }

    public void hideWaiting() {
        this.iWaiting.setVisible(false);
        this.iOpenCloseImage.setVisible(true);
        this.iPanel.setVisible(this.iOpenCloseImage.getValue() != false && this.iTable.getRowCount() > 1);
        this.setVisible(this.iTable.getRowCount() > 1);
    }

    public void populate(CourseRequestInterface value, ClassAssignmentInterface saved) {
        this.iRequests = value;
        this.iTable.clearTable(1);
        if (this.iRequests != null && this.iRequests.getWaitListMode() == OnlineSectioningInterface.WaitListMode.WaitList) {
            NumberFormat df = NumberFormat.getFormat((String)"0.#");
            boolean hasSwap = false;
            boolean hasPrefs = false;
            boolean hasPosition = false;
            block17: for (CourseRequestInterface.Request request : this.iRequests.getCourses()) {
                if (!request.isWaitList() || !request.hasRequestedCourse()) continue;
                boolean firstLine = true;
                for (final CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                    if (rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.ENROLLED || request.getWaitListSwapWithCourseOfferingId() != null && request.getWaitListSwapWithCourseOfferingId().equals(rc.getCourseId())) continue;
                    continue block17;
                }
                for (final CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                    if (!rc.hasCourseId() || !rc.isCanWaitList()) continue;
                    P p = new P("icons");
                    String style = "pending";
                    if (rc.getStatus() != null) {
                        switch (rc.getStatus()) {
                            case OVERRIDE_APPROVED: {
                                p.add((Widget)new Icon(RESOURCES.specRegApproved(), MESSAGES.hintSpecRegApproved()));
                                style = "approved";
                                break;
                            }
                            case OVERRIDE_CANCELLED: {
                                p.add((Widget)new Icon(RESOURCES.specRegCancelled(), MESSAGES.hintSpecRegCancelled()));
                                style = "cancelled";
                                break;
                            }
                            case OVERRIDE_PENDING: {
                                p.add((Widget)new Icon(RESOURCES.specRegPending(), MESSAGES.hintSpecRegPending()));
                                style = "pending";
                                break;
                            }
                            case OVERRIDE_REJECTED: {
                                p.add((Widget)new Icon(RESOURCES.specRegRejected(), MESSAGES.hintSpecRegRejected()));
                                style = "rejected";
                                break;
                            }
                            case OVERRIDE_NEEDED: 
                            case NEW_REQUEST: {
                                p.add((Widget)new Icon(RESOURCES.requestNeeded(), MESSAGES.reqStatusNeeded()));
                                style = "needed";
                                break;
                            }
                            case WAITLIST_INACTIVE: {
                                p.add((Widget)new Icon(RESOURCES.waitListNotActive(), MESSAGES.waitListInactive(rc.getCourseName())));
                                style = "cancelled";
                                break;
                            }
                            case SAVED: 
                            case ENROLLED: {
                                p.add((Widget)new Icon(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed()));
                                style = "saved";
                            }
                        }
                    } else {
                        p.add((Widget)new Icon(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed()));
                        style = "saved";
                    }
                    ArrayList<Object> row = new ArrayList<Object>();
                    row.add((Object)p);
                    String reqNote = rc.getRequestorNote();
                    if ((reqNote == null || reqNote.isEmpty()) && this.iSpecReg.isAllowChangeRequestNote() && rc.getStatus() == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING) {
                        reqNote = MESSAGES.noRequestNoteClickToChange();
                    }
                    DateAndNoteCell date = new DateAndNoteCell(firstLine ? request.getWaitListedTimeStamp() : null, reqNote);
                    if (this.iSpecReg.isAllowChangeRequestNote() && rc.getStatus() == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING) {
                        date.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                        date.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                WaitListsPanel.this.iSpecReg.getChangeRequestorNoteInterface().changeRequestorNote(rc);
                                event.stopPropagation();
                            }
                        });
                    }
                    row.add((Object)date);
                    row.add(new Label(rc.getCourseName()));
                    row.add(new Label(rc.hasCourseTitle() ? rc.getCourseTitle() : ""));
                    row.add(new Label((String)(rc.hasCredit() ? (rc.getCreditMin().equals(rc.getCreditMax()) ? df.format((Number)rc.getCreditMin()) : df.format((Number)rc.getCreditMin()) + " - " + df.format((Number)rc.getCreditMax())) : "")));
                    if (firstLine && request.getWaitListSwapWithCourseOfferingId() != null && saved != null) {
                        Label swap = null;
                        for (ClassAssignmentInterface.CourseAssignment course : saved.getCourseAssignments()) {
                            if (!request.getWaitListSwapWithCourseOfferingId().equals(course.getCourseId()) || course.isTeachingAssignment() || !course.isAssigned()) continue;
                            swap = new Label(course.getCourseName());
                            swap.setTitle(MESSAGES.conflictWaitListSwapWithNoCourseOffering(course.getCourseNameWithTitle()));
                            hasSwap = true;
                            break;
                        }
                        row.add(swap == null ? new Label("") : swap);
                    } else {
                        row.add(new Label(""));
                    }
                    if (rc.hasWaitListPosition() && rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.NEW_REQUEST && rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED) {
                        hasPosition = true;
                        row.add(new Label(rc.getWaitListPosition()));
                    } else {
                        row.add(new Label());
                    }
                    AbstractCollection prefs = null;
                    if (rc.hasSelectedIntructionalMethods()) {
                        if (rc.hasSelectedClasses()) {
                            prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                            prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                            prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                        } else {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                        }
                    } else if (rc.hasSelectedClasses()) {
                        prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                    }
                    if (prefs != null && !prefs.isEmpty()) {
                        Iterator i = prefs.iterator();
                        while (i.hasNext()) {
                            CourseRequestInterface.Preference pr = (CourseRequestInterface.Preference)i.next();
                            if (pr.isRequired()) continue;
                            i.remove();
                        }
                    }
                    row.add(new Label(ToolBox.toString(prefs)));
                    if (prefs != null && !prefs.isEmpty()) {
                        hasPrefs = true;
                    }
                    String note = null;
                    if (this.iRequests.hasConfirmations()) {
                        for (CourseRequestInterface.CourseMessage m : this.iRequests.getConfirmations()) {
                            if ("NO_ALT".equals(m.getCode()) || "CREDIT".equals(m.getCode()) || "WL-CREDIT".equals(m.getCode()) || "REQUEST_NOTE".equals(m.getCode()) || !m.hasCourse() || !rc.getCourseId().equals(m.getCourseId())) continue;
                            if (note == null) {
                                note = (String)(m.isError() ? "<span class='error'>" : "<span class='" + style + "'>") + m.getMessage() + "</span>";
                                continue;
                            }
                            note = (String)note + "\n" + (String)(m.isError() ? "<span class='error'>" : "<span class='" + style + "'>") + m.getMessage() + "</span>";
                        }
                    }
                    if (rc.hasStatusNote()) {
                        note = (String)(note == null ? "" : note + "<br>") + "<span class='note'>" + rc.getStatusNote() + "</span>";
                    }
                    HTML errorsLabel = new HTML((String)(note == null ? "" : note));
                    errorsLabel.addStyleName("waitlists-errors");
                    row.add(errorsLabel);
                    int idx = this.iTable.addRow(rc, row);
                    if (firstLine && idx > 1) {
                        for (int c = 0; c < this.iTable.getCellCount(idx); ++c) {
                            this.iTable.getCellFormatter().addStyleName(idx, c, "top-border-dashed");
                        }
                    }
                    firstLine = false;
                }
            }
            if (this.iRequests.hasMaxCreditOverride() && this.iRequests.getRequestId() != null) {
                P p = new P("icons");
                String style = "pending";
                if (this.iRequests.getMaxCreditOverrideStatus() != null) {
                    switch (this.iRequests.getMaxCreditOverrideStatus()) {
                        case OVERRIDE_APPROVED: {
                            p.add((Widget)new Icon(RESOURCES.specRegApproved(), MESSAGES.hintSpecRegApproved()));
                            style = "approved";
                            break;
                        }
                        case OVERRIDE_CANCELLED: {
                            p.add((Widget)new Icon(RESOURCES.specRegCancelled(), MESSAGES.hintSpecRegCancelled()));
                            style = "cancelled";
                            break;
                        }
                        case OVERRIDE_PENDING: {
                            p.add((Widget)new Icon(RESOURCES.specRegPending(), MESSAGES.hintSpecRegPending()));
                            style = "pending";
                            break;
                        }
                        case OVERRIDE_REJECTED: {
                            p.add((Widget)new Icon(RESOURCES.specRegRejected(), MESSAGES.hintSpecRegRejected()));
                            style = "rejected";
                            break;
                        }
                        case OVERRIDE_NEEDED: 
                        case NEW_REQUEST: {
                            p.add((Widget)new Icon(RESOURCES.requestNeeded(), MESSAGES.reqStatusNeeded()));
                            style = "needed";
                            break;
                        }
                        case SAVED: {
                            p.add((Widget)new Icon(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed()));
                            style = "saved";
                        }
                    }
                } else {
                    p.add((Widget)new Icon(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed()));
                    style = "saved";
                }
                ArrayList<Object> row = new ArrayList<Object>();
                row.add((Object)p);
                String reqNote = this.iRequests.getRequestorNote();
                if ((reqNote == null || reqNote.isEmpty()) && this.iSpecReg.isAllowChangeRequestNote() && this.iRequests.getMaxCreditOverrideStatus() == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING) {
                    reqNote = MESSAGES.noRequestNoteClickToChange();
                }
                DateAndNoteCell date = new DateAndNoteCell(this.iRequests.getMaxCreditOverrideTimeStamp(), reqNote);
                if (this.iSpecReg.isAllowChangeRequestNote() && this.iRequests.getMaxCreditOverrideStatus() == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING) {
                    date.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    date.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            WaitListsPanel.this.iSpecReg.getChangeRequestorNoteInterface().changeRequestorCreditNote(WaitListsPanel.this.iRequests);
                            event.stopPropagation();
                        }
                    });
                }
                row.add((Object)date);
                row.add(new Label(""));
                row.add(new Label(""));
                row.add(new Label(df.format((Number)this.iRequests.getMaxCreditOverride())));
                row.add(new Label(""));
                row.add(new Label(""));
                row.add(new Label(""));
                String note = null;
                note = this.iRequests.hasCreditWarning() ? "<span class='" + style + "'>" + this.iRequests.getCreditWarning() + "</span>" : "<span class='" + style + "'>" + MESSAGES.creditWarning(this.iRequests.getMaxCredit().floatValue()) + "</span>";
                if (this.iRequests.hasCreditNote()) {
                    note = note + "\n<span class='note'>" + this.iRequests.getCreditNote() + "</span>";
                }
                HTML errorsLabel = new HTML(note);
                errorsLabel.addStyleName("waitlists-errors");
                row.add(errorsLabel);
                int idx = this.iTable.addRow(null, row);
                if (idx > 1) {
                    for (int c = 0; c < this.iTable.getCellCount(idx); ++c) {
                        this.iTable.getCellFormatter().addStyleName(idx, c, "top-border-dashed");
                    }
                }
            }
            this.iTable.setColumnVisible(5, hasSwap);
            this.iTable.setColumnVisible(6, hasPosition);
            this.iTable.setColumnVisible(7, hasPrefs);
        }
        this.setVisible(this.iTable.getRowCount() > 1);
        this.iPanel.setVisible(this.iOpenCloseImage.getValue() != false && this.iTable.getRowCount() > 1);
    }

    public CourseRequestInterface getRequest() {
        return this.iRequests;
    }

    protected class Icon
    extends Image {
        public Icon(ImageResource image, final String text) {
            super(image);
            if (text != null && !text.isEmpty()) {
                this.setAltText(text);
                this.setTitle(text);
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        event.preventDefault();
                        event.stopPropagation();
                        UniTimeConfirmationDialog.info(text);
                    }
                });
            }
        }
    }

    protected class DateAndNoteCell
    extends Label {
        public DateAndNoteCell(Date date, String note) {
            super((String)(date == null ? (note == null ? "" : note) : sModifiedDateFormat.format(date) + (String)(note == null || note.isEmpty() ? "" : "\n" + note)));
            this.addStyleName("date-and-note");
        }
    }
}

