/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusCookie;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

public class StudentStatusDialog
extends UniTimeDialogBox {
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final GwtMessages GWT_MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private UniTimeTextBox iSubject;
    private UniTimeTextBox iCC;
    private CheckBox iCourseRequests;
    private CheckBox iClassSchedule;
    private CheckBox iAdvisorRequests;
    private CheckBox iOptionalEmailToggle = null;
    private TextArea iMessage;
    private TextArea iNote;
    private Set<OnlineSectioningInterface.StudentStatusInfo> iStates;
    private ListBox iStatus;
    private int iStatusRow;
    private UniTimeHeaderPanel iButtons;
    private SimpleForm iForm;
    private Command iCommand;
    private StudentStatusConfirmation iConfirmation = null;

    public StudentStatusDialog(Set<OnlineSectioningInterface.StudentStatusInfo> states, StudentStatusConfirmation confirmation) {
        super(true, false);
        this.iStates = states;
        this.iConfirmation = confirmation;
        this.addStyleName("unitime-StudentStatusDialog");
        this.setEscapeToHide(true);
        this.iAdvisorRequests = new CheckBox(MESSAGES.mailIncludeAdvisorRequests());
        this.iAdvisorRequests.setValue(Boolean.valueOf(SectioningStatusCookie.getInstance().isEmailIncludeAdvisorRequests()));
        this.iCourseRequests = new CheckBox(MESSAGES.mailIncludeCourseRequests());
        this.iCourseRequests.setValue(Boolean.valueOf(SectioningStatusCookie.getInstance().isEmailIncludeCourseRequests()));
        this.iClassSchedule = new CheckBox(MESSAGES.mailIncludeClassSchedule());
        this.iClassSchedule.setValue(Boolean.valueOf(SectioningStatusCookie.getInstance().isEmailIncludeClassSchedule()));
        this.iSubject = new UniTimeTextBox(512, 473);
        this.iSubject.setText(MESSAGES.defaulSubject());
        if (SectioningStatusCookie.getInstance().hasEmailSubject()) {
            this.iSubject.setText(SectioningStatusCookie.getInstance().getEmailSubject());
        }
        this.iCC = new UniTimeTextBox(512, 473);
        if (SectioningStatusCookie.getInstance().hasEmailCC()) {
            this.iCC.setText(SectioningStatusCookie.getInstance().getEmailCC());
        }
        this.iMessage = new TextArea();
        this.iMessage.setStyleName("unitime-TextArea");
        this.iMessage.setVisibleLines(10);
        this.iMessage.setCharacterWidth(80);
        this.iNote = new TextArea();
        this.iNote.setStyleName("unitime-TextArea");
        this.iNote.setVisibleLines(10);
        this.iNote.setCharacterWidth(80);
        this.iStatus = new ListBox();
        this.iStatus.addItem(MESSAGES.statusNoChange(), "-");
        this.iStatus.setSelectedIndex(0);
        for (OnlineSectioningInterface.StudentStatusInfo s : this.iStates) {
            this.iStatus.addItem(s.getLabel(), s.getReference());
        }
        this.iStatus.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                StudentStatusDialog.this.statusChanged();
            }
        });
        this.iButtons = new UniTimeHeaderPanel();
        this.iButtons.addButton("set-note", MESSAGES.buttonSetNote(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                StudentStatusDialog.this.hide();
                if (StudentStatusDialog.this.iConfirmation != null && !StudentStatusDialog.this.iConfirmation.isAllMyStudents()) {
                    if (StudentStatusDialog.this.iStatus.getSelectedIndex() > 0) {
                        UniTimeConfirmationDialog.confirmFocusNo(MESSAGES.confirmStatusNoteChange(StudentStatusDialog.this.iStatus.getItemText(StudentStatusDialog.this.iStatus.getSelectedIndex()), StudentStatusDialog.this.iConfirmation.getStudentCount()), StudentStatusDialog.this.iCommand);
                    } else {
                        UniTimeConfirmationDialog.confirmFocusNo(MESSAGES.confirmNoteChange(StudentStatusDialog.this.iConfirmation.getStudentCount()), StudentStatusDialog.this.iCommand);
                    }
                } else {
                    StudentStatusDialog.this.iCommand.execute();
                }
            }
        });
        this.iButtons.addButton("send-email", MESSAGES.emailSend(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                StudentStatusDialog.this.hide();
                SectioningStatusCookie.getInstance().setEmailDefaults(StudentStatusDialog.this.getIncludeCourseRequests(), StudentStatusDialog.this.getIncludeClassSchedule(), StudentStatusDialog.this.getIncludeAdvisorRequests(), StudentStatusDialog.this.getCC(), StudentStatusDialog.this.getSubject(), StudentStatusDialog.this.isOptionalEmailToggle());
                if (StudentStatusDialog.this.iConfirmation != null && !StudentStatusDialog.this.iConfirmation.isAllMyStudents()) {
                    UniTimeConfirmationDialog.confirmFocusNo(MESSAGES.confirmSendEmail(StudentStatusDialog.this.iConfirmation.getStudentCount()), StudentStatusDialog.this.iCommand);
                } else {
                    StudentStatusDialog.this.iCommand.execute();
                }
            }
        });
        this.iButtons.addButton("mass-cancel", MESSAGES.buttonMassCancel(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                StudentStatusDialog.this.hide();
                StudentStatusDialog.this.iCommand.execute();
            }
        });
        this.iButtons.addButton("set-status", MESSAGES.buttonSetStatus(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                StudentStatusDialog.this.hide();
                if (StudentStatusDialog.this.iConfirmation != null && StudentStatusDialog.this.iStatus.getSelectedIndex() > 0 && !StudentStatusDialog.this.iConfirmation.isAllMyStudents()) {
                    UniTimeConfirmationDialog.confirmFocusNo(MESSAGES.confirmStatusChange(StudentStatusDialog.this.iStatus.getItemText(StudentStatusDialog.this.iStatus.getSelectedIndex()), StudentStatusDialog.this.iConfirmation.getStudentCount()), StudentStatusDialog.this.iCommand);
                } else {
                    StudentStatusDialog.this.iCommand.execute();
                }
            }
        });
        this.iButtons.addButton("close", MESSAGES.buttonClose(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                StudentStatusDialog.this.hide();
            }
        });
        this.iForm = new SimpleForm();
        this.iForm.removeStyleName("unitime-NotPrintableBottomLine");
        this.setWidget((Widget)this.iForm);
    }

    protected void statusChanged() {
        while (this.iForm.getRowCount() > this.iStatusRow + 1) {
            this.iForm.removeRow(this.iStatusRow + 1);
        }
        String statusRef = this.iStatus.getValue(this.iStatus.getSelectedIndex());
        OnlineSectioningInterface.StudentStatusInfo status = null;
        for (OnlineSectioningInterface.StudentStatusInfo s : this.iStates) {
            if (!statusRef.equals(s.getReference())) continue;
            status = s;
            break;
        }
        if (status != null) {
            WebTable table = new WebTable();
            table.addStyleName("unitime-StatusAccess");
            table.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colPage(), 1, "75px"), new WebTable.Cell(MESSAGES.colCanOpen(), 1, "50px"), new WebTable.Cell(MESSAGES.colCanStudentChange(), 1, "50px"), new WebTable.Cell(MESSAGES.colCanAdvisorChange(), 1, "50px"), new WebTable.Cell(MESSAGES.colCanAdminChange(), 1, "50px")));
            table.setData(new WebTable.Row(new WebTable.Cell(GWT_MESSAGES.pageStudentCourseRequests()), new WebTable.IconCell(status.isCanAccessRequestsPage() ? RESOURCES.on() : RESOURCES.off(), status.isCanAccessRequestsPage() ? MESSAGES.messageStatusCanAccessCourseRequests() : MESSAGES.messageStatusCanNotAccessCourseRequests(), null), new WebTable.IconCell(status.isCanStudentRegister() ? RESOURCES.on() : RESOURCES.off(), status.isCanStudentRegister() ? MESSAGES.messageStatusStudentsCanRegister() : MESSAGES.messageStatusStudentsCanNotRegister(), null), new WebTable.IconCell(status.isCanAdvisorRegister() ? RESOURCES.on() : RESOURCES.off(), status.isCanAdvisorRegister() ? MESSAGES.messageStatusAdvisorsCanRegister() : MESSAGES.messageStatusAdvisorsCanNotRegister(), null), new WebTable.IconCell(status.isCanAdminRegister() ? RESOURCES.on() : RESOURCES.off(), status.isCanAdminRegister() ? MESSAGES.messageStatusAdminsCanRegister() : MESSAGES.messageStatusAdminsCanNotRegister(), null)), new WebTable.Row(new WebTable.Cell(GWT_MESSAGES.pageStudentSchedulingAssistant()), new WebTable.IconCell(status.isCanAccessAssistantPage() ? RESOURCES.on() : RESOURCES.off(), status.isCanAccessAssistantPage() ? MESSAGES.messageStatusCanAccessSchedulingAssistant() : MESSAGES.messageStatusCanNotAccessSchedulingAssistant(), null), new WebTable.IconCell(status.isCanStudentEnroll() ? RESOURCES.on() : RESOURCES.off(), status.isCanStudentEnroll() ? MESSAGES.messageStatusStudentsCanEnroll() : MESSAGES.messageStatusStudentsCanNotEnroll(), null), new WebTable.IconCell(status.isCanAdvisorEnroll() ? RESOURCES.on() : RESOURCES.off(), status.isCanAdvisorEnroll() ? MESSAGES.messageStatusAdvisorsCanEnroll() : MESSAGES.messageStatusAdvisorsCanNotEnroll(), null), new WebTable.IconCell(status.isCanAdminEnroll() ? RESOURCES.on() : RESOURCES.off(), status.isCanAdminEnroll() ? MESSAGES.messageStatusAdminsCanEnroll() : MESSAGES.messageStatusAdminsCanNotEnroll(), null)));
            this.iForm.addRow(MESSAGES.propPermissions(), (Widget)table);
            this.iForm.addRow(MESSAGES.propWaitLists(), new WebTable.IconCell(status.isWaitList() ? RESOURCES.on() : RESOURCES.off(), status.isWaitList() ? MESSAGES.messageStatusCanWaitList() : MESSAGES.messageStatusCanNotWaitList(), null).getWidget());
            this.iForm.addRow(MESSAGES.propNoSubs(), new WebTable.IconCell(status.isNoSubs() ? RESOURCES.on() : RESOURCES.off(), status.isNoSubs() ? MESSAGES.messageStatusCanNoSubs() : MESSAGES.messageStatusCanNotNoSubs(), null).getWidget());
            this.iForm.addRow(MESSAGES.propEmailNotification(), new WebTable.IconCell(status.isEmail() ? RESOURCES.on() : RESOURCES.off(), status.isEmail() ? MESSAGES.messageStatusCanEmail() : MESSAGES.messageStatusCanNotEmail(), null).getWidget());
            if (status.isEmail() && status.hasNotifications()) {
                this.iForm.addRow(MESSAGES.propEnabledStudentNotifications(), (Widget)new Label(status.getNotifications()));
            }
            this.iForm.addRow(MESSAGES.propCourseRequestValidation(), new WebTable.IconCell(status.isRequestValiadtion() ? RESOURCES.on() : RESOURCES.off(), status.isRequestValiadtion() ? MESSAGES.messageStatusCanRequestValidation() : MESSAGES.messageStatusCanNotRequestValidation(), null).getWidget());
            this.iForm.addRow(MESSAGES.propSpecialRegistration(), new WebTable.IconCell(status.isSpecialRegistration() ? RESOURCES.on() : RESOURCES.off(), status.isSpecialRegistration() ? MESSAGES.messageStatusCanSpecialRegistration() : MESSAGES.messageStatusCanNotSpecialRegistration(), null).getWidget());
            this.iForm.addRow(MESSAGES.propCanRequire(), new WebTable.IconCell(status.isCanRequire() ? RESOURCES.on() : RESOURCES.off(), status.isCanRequire() ? MESSAGES.messageStatusCanRequire() : MESSAGES.messageStatusCanNotRequire(), null).getWidget());
            this.iForm.addRow(MESSAGES.propStatusSchedule(), new WebTable.IconCell(status.isNoSchedule() ? RESOURCES.off() : RESOURCES.on(), status.isNoSchedule() ? MESSAGES.messageStatusNoSchedule() : MESSAGES.messageStatusSchedule(), null).getWidget());
            this.iForm.addRow(MESSAGES.propStatusReSchedule(), new WebTable.IconCell(status.isReSchedule() ? RESOURCES.on() : RESOURCES.off(), status.isReSchedule() ? MESSAGES.messageStatusReSchedule() : MESSAGES.messageStatusNoReSchedule(), null).getWidget());
            if (status.hasMessage()) {
                P m = new P("status-message");
                m.setText(status.getMessage());
                this.iForm.addRow(MESSAGES.propStatusMessage(), (Widget)m);
            }
            if (status.hasEffectiveStart() || status.hasEffectiveStop()) {
                if (!status.hasEffectiveStart()) {
                    this.iForm.addRow(MESSAGES.propEffectivePeriod(), (Widget)new Label(MESSAGES.messageEffectivePeriodBefore(status.getEffectiveStop())));
                } else if (!status.hasEffectiveStop()) {
                    this.iForm.addRow(MESSAGES.propEffectivePeriod(), (Widget)new Label(MESSAGES.messageEffectivePeriodAfter(status.getEffectiveStart())));
                } else {
                    this.iForm.addRow(MESSAGES.propEffectivePeriod(), (Widget)new Label(MESSAGES.messageEffectivePeriodBetween(status.getEffectiveStart(), status.getEffectiveStop())));
                }
            }
            if (status.hasFallback()) {
                this.iForm.addRow(MESSAGES.propFallbackStatus(), (Widget)new Label(status.getFallback()));
            }
            if (status.hasCourseTypes()) {
                this.iForm.addRow(MESSAGES.propCourseTypes(), (Widget)new Label(status.getCourseTypes()));
            }
        }
        this.iForm.addBottomRow((Widget)this.iButtons);
    }

    public Set<OnlineSectioningInterface.StudentStatusInfo> getStatuses() {
        return this.iStates;
    }

    public void setStudentNote(Command command) {
        this.iCommand = command;
        this.iForm.clear();
        this.iForm.addRow(MESSAGES.propNote(), (Widget)this.iNote);
        this.iStatusRow = this.iForm.addRow(MESSAGES.newStatus(), (Widget)this.iStatus);
        this.iStatus.setSelectedIndex(0);
        this.iForm.addBottomRow((Widget)this.iButtons);
        this.iButtons.setEnabled("set-note", true);
        this.iButtons.setEnabled("send-email", false);
        this.iButtons.setEnabled("mass-cancel", false);
        this.iButtons.setEnabled("set-status", false);
        this.setText(MESSAGES.setStudentNote());
        this.statusChanged();
        this.center();
    }

    public void sendStudentEmail(Command command, String optionalToggleCaption, boolean optionalToggleDefault) {
        this.iCommand = command;
        this.iForm.clear();
        this.iForm.addRow(MESSAGES.emailSubject(), (Widget)this.iSubject);
        if (this.iSubject.getText().isEmpty() || this.iSubject.getText().equals(MESSAGES.defaulSubjectMassCancel())) {
            this.iSubject.setText(MESSAGES.defaulSubject());
            if (SectioningStatusCookie.getInstance().hasEmailSubject()) {
                this.iSubject.setText(SectioningStatusCookie.getInstance().getEmailSubject());
            }
        }
        this.iForm.addRow(MESSAGES.emailCC(), (Widget)this.iCC);
        this.iForm.addRow(MESSAGES.emailBody(), (Widget)this.iMessage);
        P panel = new P();
        panel.add((Widget)this.iAdvisorRequests);
        panel.add((Widget)this.iCourseRequests);
        panel.add((Widget)this.iClassSchedule);
        this.iForm.addRow(MESSAGES.emailInclude(), (Widget)panel);
        if (optionalToggleCaption != null && !optionalToggleCaption.isEmpty()) {
            this.iOptionalEmailToggle = new CheckBox(optionalToggleCaption, true);
            this.iOptionalEmailToggle.setValue(Boolean.valueOf(SectioningStatusCookie.getInstance().isOptionalEmailToggle(optionalToggleDefault)));
            this.iForm.addRow(MESSAGES.emailCustom(), (Widget)this.iOptionalEmailToggle);
        } else {
            this.iOptionalEmailToggle = null;
        }
        this.iForm.addBottomRow((Widget)this.iButtons);
        this.iButtons.setEnabled("set-note", false);
        this.iButtons.setEnabled("send-email", true);
        this.iButtons.setEnabled("mass-cancel", false);
        this.iButtons.setEnabled("set-status", false);
        this.setText(MESSAGES.sendStudentEmail());
        this.center();
        this.iSubject.focus();
    }

    public void massCancel(Command command) {
        this.iCommand = command;
        this.iForm.clear();
        if (this.iSubject.getText().isEmpty() || this.iSubject.getText().equals(MESSAGES.defaulSubject()) || this.iSubject.getText().equals(SectioningStatusCookie.getInstance().getEmailSubject())) {
            this.iSubject.setText(MESSAGES.defaulSubjectMassCancel());
        }
        this.iForm.addRow(MESSAGES.emailSubject(), (Widget)this.iSubject);
        this.iForm.addRow(MESSAGES.emailCC(), (Widget)this.iCC);
        this.iForm.addRow(MESSAGES.emailBody(), (Widget)this.iMessage);
        this.iStatus.setSelectedIndex(0);
        for (int i = 0; i < this.iStatus.getItemCount(); ++i) {
            if (!"Cancelled".equalsIgnoreCase(this.iStatus.getValue(i))) continue;
            this.iStatus.setSelectedIndex(i);
            break;
        }
        this.iStatusRow = this.iForm.addRow(MESSAGES.newStatus(), (Widget)this.iStatus);
        this.iForm.addBottomRow((Widget)this.iButtons);
        this.iButtons.setEnabled("set-note", false);
        this.iButtons.setEnabled("send-email", false);
        this.iButtons.setEnabled("mass-cancel", true);
        this.iButtons.setEnabled("set-status", false);
        this.setText(MESSAGES.massCancel());
        this.statusChanged();
        this.center();
    }

    public void setStatus(Command command) {
        this.iCommand = command;
        this.iForm.clear();
        this.iStatusRow = this.iForm.addRow(MESSAGES.newStatus(), (Widget)this.iStatus);
        this.iForm.addBottomRow((Widget)this.iButtons);
        this.iButtons.setEnabled("set-note", false);
        this.iButtons.setEnabled("send-email", false);
        this.iButtons.setEnabled("mass-cancel", false);
        this.iButtons.setEnabled("set-status", true);
        this.setText(MESSAGES.setStudentStatus());
        this.statusChanged();
        this.center();
    }

    public String getStatus() {
        return this.iStatus.getValue(this.iStatus.getSelectedIndex());
    }

    public OnlineSectioningInterface.StudentStatusInfo getStudentStatusInfo(String ref) {
        for (OnlineSectioningInterface.StudentStatusInfo status : this.iStates) {
            if (!status.getReference().equals(ref)) continue;
            return status;
        }
        return null;
    }

    public String getNote() {
        return this.iNote.getText();
    }

    public String getSubject() {
        return this.iSubject.getText();
    }

    public void setSubject(String subject) {
        this.iSubject.setText(subject);
    }

    public String getCC() {
        return this.iCC.getText();
    }

    public void setCC(String cc) {
        this.iCC.setText(cc);
    }

    public String getMessage() {
        return this.iMessage.getText();
    }

    public Boolean getIncludeCourseRequests() {
        return this.iCourseRequests.getValue();
    }

    public void setIncludeCourseRequests(boolean value) {
        this.iCourseRequests.setValue(Boolean.valueOf(value));
    }

    public Boolean getIncludeClassSchedule() {
        return this.iClassSchedule.getValue();
    }

    public void setIncludeClassSchedule(boolean value) {
        this.iClassSchedule.setValue(Boolean.valueOf(value));
    }

    public Boolean getIncludeAdvisorRequests() {
        return this.iAdvisorRequests.getValue();
    }

    public void setIncludeAdvisorRequests(boolean value) {
        this.iAdvisorRequests.setValue(Boolean.valueOf(value));
    }

    public CheckBox getCourseRequestsCheckBox() {
        return this.iCourseRequests;
    }

    public CheckBox getClassScheduleCheckBox() {
        return this.iClassSchedule;
    }

    public CheckBox getAdvisorRequestsCheckBox() {
        return this.iAdvisorRequests;
    }

    public Boolean isOptionalEmailToggle() {
        if (this.iOptionalEmailToggle == null) {
            return null;
        }
        return this.iOptionalEmailToggle.getValue();
    }

    public static interface StudentStatusConfirmation {
        public boolean isAllMyStudents();

        public int getStudentCount();
    }
}

