/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.sectioning.CourseRequestsConfirmationDialog;
import org.unitime.timetable.gwt.client.sectioning.SectioningCookie;
import org.unitime.timetable.gwt.client.widgets.OpenCloseSectionImage;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

public class SpecialRegistrationsPanel
extends P {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static GwtMessages GWT_MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static DateTimeFormat sModifiedDateFormat = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    protected static final GwtResources GWT_RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private UniTimeTable<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> iTable;
    private FocusPanel iPanel;
    private SpecialRegistrationInterface.SpecialRegistrationContext iSpecReg;
    private Image iWaiting = null;
    private CheckBox iShowAllChanges = null;
    private List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> iRegistrations = new ArrayList<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse>();
    private ClassAssignmentInterface iLastSaved = null;
    private OpenCloseSectionImage iOpenCloseImage;
    private boolean iHasOneOrMoreFullyApproved = false;
    private Label iAllRequestsApplied = null;

    public SpecialRegistrationsPanel(SpecialRegistrationInterface.SpecialRegistrationContext specReg) {
        this.addStyleName("unitime-SpecialRegistrationsPanel");
        this.iSpecReg = specReg;
        P title = new P("registrations-header");
        this.iWaiting = new Image(RESOURCES.loading_small());
        this.iWaiting.addStyleName("icon");
        this.iWaiting.setVisible(false);
        title.add((Widget)this.iWaiting);
        this.iOpenCloseImage = new OpenCloseSectionImage(true);
        this.iOpenCloseImage.addStyleName("open-close-icon");
        this.iOpenCloseImage.setVisible(true);
        title.add((Widget)this.iOpenCloseImage);
        P label = new P("title");
        label.setText(MESSAGES.dialogSpecialRegistrations());
        title.add((Widget)label);
        this.add((Widget)title);
        this.iTable = new Table<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse>();
        this.iTable.addStyleName("registrations-table");
        this.iTable.setAllowSelection(true);
        this.iTable.setAllowMultiSelect(true);
        this.iAllRequestsApplied = new Label(MESSAGES.specRegAllRequestsFullyApplied());
        this.iAllRequestsApplied.setVisible(false);
        this.iAllRequestsApplied.addStyleName("all-requests-applied");
        this.add((Widget)this.iAllRequestsApplied);
        this.iPanel = new FocusPanel(this.iTable);
        this.iPanel.addStyleName("registrations-panel");
        this.add((Widget)this.iPanel);
        this.iShowAllChanges = new CheckBox(MESSAGES.checkOverridesShowAllChanges());
        this.iShowAllChanges.setValue(Boolean.valueOf(SectioningCookie.getInstance().isShowAllChanges()));
        this.iShowAllChanges.addStyleName("registrations-toggle");
        this.add((Widget)this.iShowAllChanges);
        this.iPanel.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 38) {
                    int row;
                    SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse prev = null;
                    SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse selected = null;
                    SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse last = null;
                    for (row = 0; row < SpecialRegistrationsPanel.this.iTable.getRowCount(); ++row) {
                        SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse d = SpecialRegistrationsPanel.this.iTable.getData(row);
                        if (d == null) continue;
                        if (SpecialRegistrationsPanel.this.iTable.isSelected(row)) {
                            selected = d;
                        } else if (selected == null) {
                            prev = d;
                        }
                        last = d;
                    }
                    row = SpecialRegistrationsPanel.this.setSelected(prev == null ? last : prev);
                    if (row >= 0) {
                        SpecialRegistrationsPanel.this.iTable.getRowFormatter().getElement(row).scrollIntoView();
                    }
                    SpecialRegistrationsPanel.this.updateAriaStatus();
                    event.preventDefault();
                    event.stopPropagation();
                    SpecialRegistrationsPanel.this.iPanel.setFocus(true);
                } else if (event.getNativeKeyCode() == 40) {
                    int row;
                    SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse first = null;
                    SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse selected = null;
                    SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse next = null;
                    for (row = 0; row < SpecialRegistrationsPanel.this.iTable.getRowCount(); ++row) {
                        SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse d = SpecialRegistrationsPanel.this.iTable.getData(row);
                        if (d == null) continue;
                        if (first == null) {
                            first = d;
                        }
                        if (SpecialRegistrationsPanel.this.iTable.isSelected(row)) {
                            selected = d;
                            continue;
                        }
                        if (selected == null || next != null) continue;
                        next = d;
                    }
                    row = SpecialRegistrationsPanel.this.setSelected(next == null ? first : next);
                    if (row >= 0) {
                        SpecialRegistrationsPanel.this.iTable.getRowFormatter().getElement(row).scrollIntoView();
                    }
                    SpecialRegistrationsPanel.this.updateAriaStatus();
                    event.preventDefault();
                    event.stopPropagation();
                    SpecialRegistrationsPanel.this.iPanel.setFocus(true);
                } else if (event.getNativeKeyCode() == 13 || event.getNativeKeyCode() == 32) {
                    if (SpecialRegistrationsPanel.this.iTable.getSelectedRow() > 0) {
                        SpecialRegistrationsPanel.this.doSubmit(SpecialRegistrationsPanel.this.iTable.getData(SpecialRegistrationsPanel.this.iTable.getSelectedRow()));
                    }
                    event.preventDefault();
                    event.stopPropagation();
                    SpecialRegistrationsPanel.this.iPanel.setFocus(true);
                } else if (event.getNativeKeyCode() == 46 && SpecialRegistrationsPanel.this.iTable.getSelectedRow() > 0) {
                    SpecialRegistrationsPanel.this.cancel(SpecialRegistrationsPanel.this.iTable.getData(SpecialRegistrationsPanel.this.iTable.getSelectedRow()));
                }
            }
        });
        this.iShowAllChanges.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                SectioningCookie.getInstance().setShowAllChanges((Boolean)event.getValue());
                if (SpecialRegistrationsPanel.this.iLastSaved != null) {
                    SpecialRegistrationsPanel.this.populate(SpecialRegistrationsPanel.this.getRegistrations(), SpecialRegistrationsPanel.this.iLastSaved);
                }
            }
        });
        this.iOpenCloseImage.addValueChangeHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                SpecialRegistrationsPanel.this.iPanel.setVisible((Boolean)event.getValue() != false && SpecialRegistrationsPanel.this.iTable.getRowCount() > 1);
                SpecialRegistrationsPanel.this.iAllRequestsApplied.setVisible((Boolean)event.getValue() != false && SpecialRegistrationsPanel.this.iTable.getRowCount() <= 1);
                SpecialRegistrationsPanel.this.iShowAllChanges.setVisible(((Boolean)event.getValue()).booleanValue());
                SectioningCookie.getInstance().setRequestOverridesOpened((Boolean)event.getValue());
            }
        });
        label.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SpecialRegistrationsPanel.this.iOpenCloseImage.isVisible()) {
                    SpecialRegistrationsPanel.this.iOpenCloseImage.setValue(SpecialRegistrationsPanel.this.iOpenCloseImage.getValue() == false, true);
                }
            }
        });
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        header.add(new UniTimeTableHeader(""));
        header.add(new UniTimeTableHeader(MESSAGES.colSpecRegSubmitted()));
        header.add(new UniTimeTableHeader(MESSAGES.colSubject()));
        header.add(new UniTimeTableHeader(MESSAGES.colCourse()));
        header.add(new UniTimeTableHeader(MESSAGES.colSubpart()));
        header.add(new UniTimeTableHeader(MESSAGES.colClass()));
        header.add(new UniTimeTableHeader(MESSAGES.colLimit()));
        header.add(new UniTimeTableHeader(MESSAGES.colCredit()));
        header.add(new UniTimeTableHeader(MESSAGES.colGradeMode()));
        header.add(new UniTimeTableHeader(MESSAGES.colSpecRegErrors()));
        header.add(new UniTimeTableHeader(""));
        header.add(new UniTimeTableHeader(""));
        this.iTable.addRow(null, header);
        this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> event) {
                if (event.getData() != null) {
                    SpecialRegistrationsPanel.this.doSubmit(event.getData());
                }
            }
        });
        this.iOpenCloseImage.setValue(SectioningCookie.getInstance().isRequestOverridesOpened());
        this.iPanel.setVisible(this.iOpenCloseImage.getValue().booleanValue());
        this.iShowAllChanges.setVisible(this.iOpenCloseImage.getValue().booleanValue());
        this.setVisible(false);
    }

    public void showWaiting() {
        this.iWaiting.setVisible(true);
        this.iOpenCloseImage.setVisible(false);
        this.iAllRequestsApplied.setVisible(false);
        this.iPanel.setVisible(false);
        this.iShowAllChanges.setVisible(false);
        this.setVisible(true);
    }

    public void hideWaiting() {
        this.iWaiting.setVisible(false);
        this.iOpenCloseImage.setVisible(true);
        this.iAllRequestsApplied.setVisible(this.iOpenCloseImage.getValue() != false && this.iTable.getRowCount() <= 1);
        this.iPanel.setVisible(this.iOpenCloseImage.getValue() != false && this.iTable.getRowCount() > 1);
        this.iShowAllChanges.setVisible(this.iOpenCloseImage.getValue().booleanValue());
        this.setVisible(!this.iRegistrations.isEmpty());
    }

    public void clearRegistrations() {
        this.iRegistrations = new ArrayList<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse>();
        this.iLastSaved = null;
        this.iTable.clearTable(1);
        this.setVisible(false);
    }

    public List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> getRegistrations() {
        return this.iRegistrations;
    }

    /*
     * WARNING - void declaration
     */
    public void populate(List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> registrations, ClassAssignmentInterface saved) {
        this.iRegistrations = registrations;
        this.iLastSaved = saved;
        this.iTable.clearTable(1);
        this.iHasOneOrMoreFullyApproved = false;
        Collections.sort(registrations);
        for (final SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse reg : registrations) {
            void var10_17;
            P p = new P("icons");
            if (reg.isFullyApplied(saved)) {
                p.add((Widget)new Icon(RESOURCES.specRegApplied(), MESSAGES.hintSpecRegApplied()));
            } else if (reg.getStatus() != null) {
                switch (reg.getStatus()) {
                    case Approved: {
                        if (reg.isGradeModeChange() || reg.isVariableTitleCourseChange() || reg.isExtended()) {
                            p.add((Widget)new Icon(RESOURCES.specRegApproved(), MESSAGES.hintSpecRegApproved()));
                            break;
                        }
                        p.add((Widget)new Icon(RESOURCES.specRegApproved(), MESSAGES.hintSpecRegApprovedNoteApply()));
                        break;
                    }
                    case Cancelled: {
                        p.add((Widget)new Icon(RESOURCES.specRegCancelled(), MESSAGES.hintSpecRegCancelled()));
                        break;
                    }
                    case Pending: {
                        if (reg.isHonorsGradeModeNotFullyMatching(saved)) {
                            p.add((Widget)new Icon(RESOURCES.specRegCancelled(), MESSAGES.hintSpecRegHonorsGradeModeNotMatchingSchedule()));
                            break;
                        }
                        p.add((Widget)new Icon(RESOURCES.specRegPending(), MESSAGES.hintSpecRegPending()));
                        break;
                    }
                    case Rejected: {
                        p.add((Widget)new Icon(RESOURCES.specRegRejected(), MESSAGES.hintSpecRegRejected()));
                        break;
                    }
                    case Draft: {
                        p.add((Widget)new Icon(RESOURCES.specRegDraft(), MESSAGES.hintSpecRegDraft()));
                    }
                }
            }
            ImageButton delete = null;
            if (reg.canCancel() && this.iSpecReg.isEnabled()) {
                delete = new ImageButton(RESOURCES.delete(), RESOURCES.delete_Down(), RESOURCES.delete_Over());
                delete.addStyleName("unitime-NoPrint");
                delete.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        for (int row = 1; row < SpecialRegistrationsPanel.this.iTable.getRowCount(); ++row) {
                            SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse data = SpecialRegistrationsPanel.this.iTable.getData(row);
                            SpecialRegistrationsPanel.this.iTable.setSelected(row, data != null && data.equals(reg));
                        }
                        SpecialRegistrationsPanel.this.cancel(reg);
                        event.preventDefault();
                        event.stopPropagation();
                    }
                });
                delete.addStyleName("delete");
                delete.setAltText(ARIA.altCancelOverrideRequest());
            }
            if (reg.hasChanges()) {
                HTML errorsLabel;
                if (!this.iShowAllChanges.getValue().booleanValue() && reg.isFullyApplied(saved)) continue;
                Long lastCourseId = null;
                ArrayList<ClassAssignmentInterface.ClassAssignment> rows = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
                for (ClassAssignmentInterface.ClassAssignment classAssignment : reg.getChanges()) {
                    if (!this.iShowAllChanges.getValue().booleanValue() && (reg.isApplied(classAssignment.getCourseId(), saved) || !reg.hasErrors(classAssignment.getCourseId()) && !reg.isDrop(classAssignment.getCourseId())) || !this.iShowAllChanges.getValue().booleanValue() && reg.isChange(classAssignment.getCourseId()) && !classAssignment.hasError() || classAssignment.getParentSection() != null && classAssignment.getParentSection().equals(classAssignment.getSection())) continue;
                    rows.add(classAssignment);
                }
                for (int r = 0; r < rows.size(); ++r) {
                    ClassAssignmentInterface.ClassAssignment classAssignment = (ClassAssignmentInterface.ClassAssignment)rows.get(r);
                    ArrayList<Object> row = new ArrayList<Object>();
                    if (lastCourseId == null) {
                        row.add((Object)p);
                    } else {
                        row.add((Object)new P("icons"));
                    }
                    Label label = new Label();
                    label.addStyleName("date-and-note");
                    if (lastCourseId == null || !lastCourseId.equals(classAssignment.getCourseId())) {
                        String course = ((ClassAssignmentInterface.ClassAssignment)rows.get(r)).getCourseName();
                        String note = reg.getNote(course);
                        if (this.iSpecReg.isAllowChangeRequestNote() && reg.getStatus() == SpecialRegistrationInterface.SpecialRegistrationStatus.Pending && reg.hasErrors(course) && (note == null || note.isEmpty())) {
                            note = MESSAGES.noRequestNoteClickToChange();
                        }
                        label.setText((String)(r > 0 || reg.getSubmitDate() == null ? (note == null ? "" : note) : sModifiedDateFormat.format(reg.getSubmitDate()) + (String)(note == null || note.isEmpty() ? "" : "\n" + note)));
                        if (this.iSpecReg.isAllowChangeRequestNote() && reg.getStatus() == SpecialRegistrationInterface.SpecialRegistrationStatus.Pending && reg.hasErrors(course)) {
                            label.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                            final String courseName = ((ClassAssignmentInterface.ClassAssignment)rows.get(r)).getCourseName();
                            final Long courseId = ((ClassAssignmentInterface.ClassAssignment)rows.get(r)).getCourseId();
                            label.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    SpecialRegistrationsPanel.this.iSpecReg.getChangeRequestorNoteInterface().changeRequestorNote(reg, courseName, courseId);
                                    event.stopPropagation();
                                }
                            });
                        }
                    }
                    row.add(label);
                    if (lastCourseId == null || !lastCourseId.equals(classAssignment.getCourseId())) {
                        row.add(new Label(classAssignment.getSubject(), false));
                        row.add(new Label(classAssignment.getCourseNbr(), false));
                    } else {
                        row.add(new Label());
                        row.add(new Label());
                    }
                    row.add(new Label(classAssignment.getSubpart(), false));
                    row.add(new Label(classAssignment.getSection(), false));
                    row.add(new HTML(classAssignment.getLimitString(), false));
                    if (classAssignment.getCreditHour() != null) {
                        row.add(new Label(MESSAGES.credit(classAssignment.getCreditHour().floatValue())));
                    } else {
                        row.add((Object)new CreditCell(classAssignment.getCredit()));
                    }
                    if (classAssignment.getGradeMode() != null) {
                        Label gm = new Label(classAssignment.getGradeMode().getCode());
                        if (classAssignment.getGradeMode().getLabel() != null) {
                            gm.setTitle(classAssignment.getGradeMode().getLabel());
                        }
                        row.add(gm);
                    } else {
                        row.add(new Label());
                    }
                    errorsLabel = new HTML(classAssignment.hasError() ? classAssignment.getError() : "");
                    errorsLabel.addStyleName("registration-errors");
                    row.add(errorsLabel);
                    P s = new P("icons");
                    switch (classAssignment.getSpecRegOperation()) {
                        case Add: {
                            s.add((Widget)new Icon(RESOURCES.assignment(), MESSAGES.specRegAssignment(classAssignment.getSubject() + " " + classAssignment.getCourseNbr() + " " + classAssignment.getSubpart() + " " + classAssignment.getSection())));
                            break;
                        }
                        case Drop: {
                            s.add((Widget)new Icon(RESOURCES.unassignment(), MESSAGES.specRegRemoved(classAssignment.getSubject() + " " + classAssignment.getCourseNbr() + " " + classAssignment.getSubpart() + " " + classAssignment.getSection())));
                            break;
                        }
                        case Keep: {
                            if (classAssignment.getGradeMode() != null && classAssignment.getGradeMode().isHonor()) {
                                boolean found = false;
                                for (ClassAssignmentInterface.ClassAssignment x : saved.getClassAssignments()) {
                                    if (!x.isSaved() || !classAssignment.getClassId().equals(x.getClassId())) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    s.add((Widget)new Icon(RESOURCES.unassignment(), MESSAGES.specRegRemoved(classAssignment.getSubject() + " " + classAssignment.getCourseNbr() + " " + classAssignment.getSubpart() + " " + classAssignment.getSection())));
                                }
                            }
                        }
                        default: {
                            s.add((Widget)new Label());
                        }
                    }
                    row.add((Object)s);
                    if (delete != null) {
                        row.add(delete);
                        delete = null;
                    } else {
                        row.add(new Label());
                    }
                    int idx = this.iTable.addRow(reg, row);
                    if (reg.getStatus() == SpecialRegistrationInterface.SpecialRegistrationStatus.Approved) {
                        this.iTable.setBackGroundColor(idx, "#D7FFD7");
                        if (!(reg.isFullyApplied(saved) || reg.isExtended() || reg.isGradeModeChange())) {
                            this.iHasOneOrMoreFullyApproved = true;
                        }
                    }
                    if (reg.getRequestId().equals(this.iSpecReg.getRequestId())) {
                        this.iTable.setSelected(idx, true);
                    }
                    if (idx > 1 && lastCourseId == null) {
                        for (int c = 0; c < this.iTable.getCellCount(idx); ++c) {
                            this.iTable.getCellFormatter().addStyleName(idx, c, "top-border-solid");
                        }
                    }
                    if (lastCourseId != null && !lastCourseId.equals(classAssignment.getCourseId())) {
                        for (int c = 2; c < this.iTable.getCellCount(idx) - 1; ++c) {
                            this.iTable.getCellFormatter().addStyleName(idx, c, "top-border-dashed");
                        }
                    }
                    if (!classAssignment.isCourseAssigned()) {
                        for (c = 2; c < this.iTable.getCellCount(idx) - 1; ++c) {
                            this.iTable.getCellFormatter().addStyleName(idx, c, classAssignment.hasError() ? "change-drop-with-errors" : "change-drop");
                        }
                    } else {
                        for (c = 2; c < this.iTable.getCellCount(idx) - 1; ++c) {
                            this.iTable.getCellFormatter().addStyleName(idx, c, "change-add");
                        }
                    }
                    lastCourseId = classAssignment.getCourseId();
                }
                Object noCourseErrors = "";
                if (reg.hasErrors()) {
                    for (ClassAssignmentInterface.ErrorMessage e : reg.getErrors()) {
                        if (e.getCourse() != null && !e.getCourse().isEmpty()) continue;
                        noCourseErrors = (String)noCourseErrors + (((String)noCourseErrors).isEmpty() ? "" : "\n") + e.getMessage();
                    }
                }
                if (((String)noCourseErrors).isEmpty()) continue;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add((Object)new P("icons"));
                String note = reg.getNote("MAXI");
                DateAndNoteCell dateAndNote = new DateAndNoteCell(null, note);
                if (this.iSpecReg.isAllowChangeRequestNote() && reg.getStatus() == SpecialRegistrationInterface.SpecialRegistrationStatus.Pending && reg.hasErrorCode("MAXI")) {
                    if (note == null || note.isEmpty()) {
                        dateAndNote = new DateAndNoteCell(null, MESSAGES.noRequestNoteClickToChange());
                    }
                    dateAndNote.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    dateAndNote.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            SpecialRegistrationsPanel.this.iSpecReg.getChangeRequestorNoteInterface().changeRequestorNote(reg, null, null);
                            event.stopPropagation();
                        }
                    });
                }
                arrayList.add((Object)dateAndNote);
                arrayList.add(new DescriptionCell(null));
                errorsLabel = new HTML((String)noCourseErrors);
                errorsLabel.addStyleName("registration-errors");
                arrayList.add(errorsLabel);
                arrayList.add(new Label());
                arrayList.add(new Label());
                int idx = this.iTable.addRow(reg, arrayList);
                if (reg.getStatus() == SpecialRegistrationInterface.SpecialRegistrationStatus.Approved) {
                    this.iTable.setBackGroundColor(idx, "#D7FFD7");
                }
                if (reg.getRequestId().equals(this.iSpecReg.getRequestId())) {
                    this.iTable.setSelected(idx, true);
                }
                for (int c = 2; c < this.iTable.getCellCount(idx) - 1; ++c) {
                    this.iTable.getCellFormatter().addStyleName(idx, c, "top-border-dashed");
                }
                continue;
            }
            if (!reg.hasErrors()) continue;
            ArrayList<Object> row = new ArrayList<Object>();
            row.add((Object)p);
            String note = reg.getNote("MAXI");
            DateAndNoteCell dateAndNote = new DateAndNoteCell(reg.getSubmitDate(), note);
            if (this.iSpecReg.isAllowChangeRequestNote() && reg.getStatus() == SpecialRegistrationInterface.SpecialRegistrationStatus.Pending && reg.hasErrorCode("MAXI")) {
                if (note == null || note.isEmpty()) {
                    dateAndNote = new DateAndNoteCell(reg.getSubmitDate(), MESSAGES.noRequestNoteClickToChange());
                }
                dateAndNote.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                dateAndNote.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        SpecialRegistrationsPanel.this.iSpecReg.getChangeRequestorNoteInterface().changeRequestorNote(reg, null, null);
                        event.stopPropagation();
                    }
                });
            }
            row.add((Object)dateAndNote);
            row.add(new DescriptionCell(reg.getDescription()));
            String string = "";
            for (ClassAssignmentInterface.ErrorMessage e : reg.getErrors()) {
                String string2 = (String)var10_17 + (var10_17.isEmpty() ? "" : "\n") + e.getMessage();
            }
            HTML errorsLabel = new HTML((String)var10_17);
            errorsLabel.addStyleName("registration-errors");
            row.add(errorsLabel);
            row.add(new Label());
            if (delete != null) {
                row.add(delete);
            } else {
                row.add(new Label());
            }
            int idx = this.iTable.addRow(reg, row);
            if (reg.getStatus() == SpecialRegistrationInterface.SpecialRegistrationStatus.Approved) {
                this.iTable.setBackGroundColor(idx, "#D7FFD7");
            }
            if (reg.getRequestId().equals(this.iSpecReg.getRequestId())) {
                this.iTable.setSelected(idx, true);
            }
            if (idx <= 1) continue;
            for (int c = 0; c < this.iTable.getCellCount(idx); ++c) {
                this.iTable.getCellFormatter().addStyleName(idx, c, "top-border-solid");
            }
        }
        this.setVisible(!this.iRegistrations.isEmpty());
        this.iAllRequestsApplied.setVisible(this.iOpenCloseImage.getValue() != false && this.iTable.getRowCount() <= 1);
        this.iPanel.setVisible(this.iOpenCloseImage.getValue() != false && this.iTable.getRowCount() > 1);
    }

    public boolean hasOneOrMoreFullyApproved() {
        return this.iHasOneOrMoreFullyApproved;
    }

    protected int setSelected(SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse data) {
        int row = -1;
        for (int i = 0; i < this.iTable.getRowCount(); ++i) {
            SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse d = this.iTable.getData(i);
            if (d == null) continue;
            if (row < 0 && d.equals(data)) {
                row = i;
            }
            this.iTable.setSelected(i, d.equals(data));
        }
        return row;
    }

    protected void updateAriaStatus() {
        int row = this.iTable.getSelectedRow();
        SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse reg = this.iTable.getData(row);
        if (row >= 0 && reg != null) {
            AriaStatus.getInstance().setText(ARIA.showingSpecReg(row, this.iTable.getRowCount() - 1, reg.getDescription(), reg.getSubmitDate()));
        }
    }

    public void doCancel(String requestId, AsyncCallback<Boolean> callback) {
    }

    public void doSubmit(SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse reg) {
        if (reg != null) {
            AriaStatus.getInstance().setText(ARIA.selectedSpecReg(reg.getDescription()));
        }
        for (int row = 1; row < this.iTable.getRowCount(); ++row) {
            SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse data = this.iTable.getData(row);
            this.iTable.setSelected(row, data != null && data.equals(reg));
        }
    }

    public SpecialRegistrationInterface.SpecialRegistrationStatus getStatus(ClassAssignmentInterface.ClassAssignment a) {
        if (a.getSpecRegStatus() != null) {
            return a.getSpecRegStatus();
        }
        if (this.iRegistrations != null && a.getClassId() != null) {
            for (SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse response : this.iRegistrations) {
                if (!response.hasChanges() || response.isFullyApplied(this.iLastSaved) || response.isApplied(a.getCourseId(), this.iLastSaved)) continue;
                for (ClassAssignmentInterface.ClassAssignment ch : response.getChanges()) {
                    if (!(ch.getGradeMode() != null ? a.getCourseId().equals(ch.getCourseId()) && a.getGradeMode() != null && !ch.getGradeMode().equals(a.getGradeMode()) && response.getRequestId().equals(this.iSpecReg.getRequestId()) : (ch.getCreditHour() != null ? a.getCourseId().equals(ch.getCourseId()) && a.getCreditHour() != null && !ch.getCreditHour().equals(a.getCreditHour()) && response.getRequestId().equals(this.iSpecReg.getRequestId()) : a.getCourseId().equals(ch.getCourseId()) && a.getSection().equals(ch.getSection())))) continue;
                    return ch.getSpecRegStatus();
                }
            }
        }
        return null;
    }

    public String getError(ClassAssignmentInterface.ClassAssignment a) {
        if (a.getSpecRegStatus() != null) {
            return a.hasError() ? a.getError() : null;
        }
        if (this.iRegistrations != null && a.getClassId() != null) {
            for (SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse response : this.iRegistrations) {
                if (!response.hasChanges()) continue;
                for (ClassAssignmentInterface.ClassAssignment ch : response.getChanges()) {
                    if (!(ch.getGradeMode() != null ? a.getCourseId().equals(ch.getCourseId()) && a.getGradeMode() != null && !ch.getGradeMode().equals(a.getGradeMode()) && response.getRequestId().equals(this.iSpecReg.getRequestId()) && ch.hasError() : (ch.getCreditHour() != null ? a.getCourseId().equals(ch.getCourseId()) && a.getCreditHour() != null && !ch.getCreditHour().equals(a.getCreditHour()) && response.getRequestId().equals(this.iSpecReg.getRequestId()) && ch.hasError() : a.getCourseId().equals(ch.getCourseId()) && a.getSection().equals(ch.getSection()) && ch.hasError()))) continue;
                    return ch.getError();
                }
            }
        }
        return null;
    }

    public OnlineSectioningInterface.GradeMode getGradeMode(ClassAssignmentInterface.ClassAssignment a) {
        if (this.iRegistrations != null && a.getClassId() != null) {
            for (SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse response : this.iRegistrations) {
                if (!response.hasChanges()) continue;
                for (ClassAssignmentInterface.ClassAssignment ch : response.getChanges()) {
                    if (!a.getCourseId().equals(ch.getCourseId()) || ch.getGradeMode() == null) continue;
                    return ch.getGradeMode();
                }
            }
        }
        return null;
    }

    public Float getCreditHours(ClassAssignmentInterface.ClassAssignment a) {
        if (this.iRegistrations != null && a.getClassId() != null) {
            for (SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse response : this.iRegistrations) {
                if (!response.hasChanges()) continue;
                for (ClassAssignmentInterface.ClassAssignment ch : response.getChanges()) {
                    if (!a.getCourseId().equals(ch.getCourseId()) || ch.getCreditHour() == null || !a.getSection().equals(ch.getSection()) || a.getSection().equals(a.getParentSection())) continue;
                    return ch.getCreditHour();
                }
            }
        }
        return null;
    }

    public boolean isDrop(Long courseId) {
        if (courseId == null || this.iRegistrations == null) {
            return false;
        }
        boolean hasDrop = false;
        boolean hasAdd = false;
        for (SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse response : this.iRegistrations) {
            if (!response.hasChanges()) continue;
            for (ClassAssignmentInterface.ClassAssignment ca : response.getChanges()) {
                if (!courseId.equals(ca.getCourseId())) continue;
                switch (ca.getSpecRegOperation()) {
                    case Add: {
                        hasAdd = true;
                        break;
                    }
                    case Drop: {
                        hasDrop = true;
                    }
                }
            }
        }
        return hasDrop && !hasAdd;
    }

    public boolean canWaitList(Long courseId) {
        if (courseId == null) {
            return true;
        }
        for (SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse response : this.iRegistrations) {
            if (response.getStatus() != SpecialRegistrationInterface.SpecialRegistrationStatus.Pending || !response.hasChanges()) continue;
            for (ClassAssignmentInterface.ClassAssignment ca : response.getChanges()) {
                if (!courseId.equals(ca.getCourseId()) || ca.getSpecRegOperation() != SpecialRegistrationInterface.SpecialRegistrationOperation.Add || ca.getSpecRegStatus() != SpecialRegistrationInterface.SpecialRegistrationStatus.Pending) continue;
                return false;
            }
        }
        return true;
    }

    protected void cancel(final SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse reg) {
        if (reg != null && reg.canCancel()) {
            CourseRequestInterface.CheckCoursesResponse confirm = new CourseRequestInterface.CheckCoursesResponse();
            confirm.setConfirmation(0, GWT_MESSAGES.dialogConfirmation(), GWT_MESSAGES.buttonConfirmYes(), GWT_MESSAGES.buttonConfirmNo(), null, null);
            confirm.addConfirmation(MESSAGES.confirmOverrideRequestCancel(), 0, 1);
            if (reg.hasErrors()) {
                confirm.addConfirmation(MESSAGES.confirmOverrideRequestCancelCancelledErrors(), 0, 2);
                for (ClassAssignmentInterface.ErrorMessage e : reg.getErrors()) {
                    confirm.addMessage(null, e.getCourse(), e.getCode(), e.getMessage(), 0, 3);
                }
            }
            CourseRequestsConfirmationDialog.confirm(confirm, 0, GWT_RESOURCES.confirm(), new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(Boolean result) {
                    if (result.booleanValue()) {
                        SpecialRegistrationsPanel.this.doCancel(reg.getRequestId(), new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                            }

                            public void onSuccess(Boolean result) {
                                if (result.booleanValue()) {
                                    SpecialRegistrationsPanel.this.iTable.clearHover();
                                    for (int i = SpecialRegistrationsPanel.this.iTable.getRowCount() - 1; i > 0; --i) {
                                        if (!SpecialRegistrationsPanel.this.iTable.getData(i).equals(reg)) continue;
                                        SpecialRegistrationsPanel.this.iTable.removeRow(i);
                                    }
                                    SpecialRegistrationsPanel.this.iRegistrations.remove(reg);
                                    SpecialRegistrationsPanel.this.setVisible(!SpecialRegistrationsPanel.this.iRegistrations.isEmpty());
                                    SpecialRegistrationsPanel.this.iAllRequestsApplied.setVisible(SpecialRegistrationsPanel.this.iOpenCloseImage.getValue() != false && SpecialRegistrationsPanel.this.iTable.getRowCount() <= 1);
                                    SpecialRegistrationsPanel.this.iPanel.setVisible(SpecialRegistrationsPanel.this.iOpenCloseImage.getValue() != false && SpecialRegistrationsPanel.this.iTable.getRowCount() > 1);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    public class Table<T>
    extends UniTimeTable<T> {
        protected Set<Integer> iLastHoverRows = new HashSet<Integer>();

        public Table() {
            this.sinkEvents(128);
        }

        protected void updateHover() {
            Object data;
            String color;
            String style;
            if (!(this.iLastHoverRows.isEmpty() || this.iLastHoverRow >= 0 && this.iLastHoverRows.contains(this.iLastHoverRow))) {
                for (int row : this.iLastHoverRows) {
                    style = this.getRowFormatter().getStyleName(row);
                    if (!"unitime-TableRowSelected".equals(style)) {
                        if ("unitime-TableRowHover".equals(style)) {
                            this.getRowFormatter().setStyleName(row, null);
                        } else if ("unitime-TableRowSelectedHover".equals(style)) {
                            this.getRowFormatter().setStyleName(row, "unitime-TableRowSelected");
                        }
                    }
                    if (!this.getRowFormatter().getStyleName(row).isEmpty() || (color = (String)this.iLastHoverBackgroundColor.remove(row)) == null || color.isEmpty()) continue;
                    this.getRowFormatter().getElement(row).getStyle().setBackgroundColor(color);
                }
                this.iLastHoverRows.clear();
            }
            if (this.iLastHoverRow >= 0 && this.iLastHoverRows.isEmpty() && (data = this.getData(this.iLastHoverRow)) != null) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!data.equals(this.getData(row))) continue;
                    this.iLastHoverRows.add(row);
                    style = this.getRowFormatter().getStyleName(row);
                    if (!"unitime-TableRowSelectedHover".equals(style)) {
                        if ("unitime-TableRowSelected".equals(style)) {
                            this.getRowFormatter().setStyleName(row, "unitime-TableRowSelectedHover");
                        } else {
                            this.getRowFormatter().setStyleName(row, "unitime-TableRowHover");
                        }
                    }
                    if (style.isEmpty()) {
                        color = this.getRowFormatter().getElement(row).getStyle().getBackgroundColor();
                        if (color != null && !color.isEmpty()) {
                            this.getRowFormatter().getElement(row).getStyle().clearBackgroundColor();
                            this.iLastHoverBackgroundColor.put(row, color);
                            continue;
                        }
                        this.iLastHoverBackgroundColor.remove(row);
                        continue;
                    }
                    if (this.getRowFormatter().getElement(row).getStyle().getBackgroundColor().isEmpty()) continue;
                    color = this.getRowFormatter().getElement(row).getStyle().getBackgroundColor();
                    this.getRowFormatter().getElement(row).getStyle().clearBackgroundColor();
                    this.iLastHoverBackgroundColor.put(row, color);
                }
            }
        }

        @Override
        public void clearHover() {
            super.clearHover();
            this.updateHover();
        }

        @Override
        public void onBrowserEvent(Event event) {
            super.onBrowserEvent(event);
            this.updateHover();
        }
    }

    protected class Icon
    extends Image {
        public Icon(ImageResource image, final String text) {
            super(image);
            if (text != null && !text.isEmpty()) {
                this.setAltText(text);
                this.setTitle(text);
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        event.preventDefault();
                        event.stopPropagation();
                        UniTimeConfirmationDialog.info(text);
                    }
                });
            }
        }
    }

    protected class CreditCell
    extends HTML {
        public CreditCell(String text) {
            if (text != null && text.indexOf(124) >= 0) {
                this.setHTML(text.substring(0, text.indexOf(124)));
                this.setTitle(text.substring(text.indexOf(124) + 1).replace("\n", "<br>"));
            } else {
                this.setHTML(text == null ? "" : text.replace("\n", "<br>"));
                if (text != null) {
                    this.setTitle(text);
                }
            }
        }
    }

    protected class DateAndNoteCell
    extends Label {
        public DateAndNoteCell(Date date, String note) {
            super((String)(date == null ? (note == null ? "" : note) : sModifiedDateFormat.format(date) + (String)(note == null || note.isEmpty() ? "" : "\n" + note)));
            this.addStyleName("date-and-note");
        }
    }

    protected class DescriptionCell
    extends Label
    implements UniTimeTable.HasColSpan {
        public DescriptionCell(String text) {
            super(text == null ? "" : text);
        }

        @Override
        public int getColSpan() {
            return 7;
        }
    }
}

