/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaCheckBox;
import org.unitime.timetable.gwt.client.page.UniTimePageHeader;
import org.unitime.timetable.gwt.client.rooms.PeriodPreferencesHint;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.rooms.RoomSharingHint;
import org.unitime.timetable.gwt.client.rooms.RoomsComparator;
import org.unitime.timetable.gwt.client.widgets.ImageLink;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomsTable
extends UniTimeTable<RoomInterface.RoomDetailInterface> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private int iFlags = 0;
    private RoomInterface.RoomsColumn iSortBy = null;
    private boolean iAsc = true;
    private RoomInterface.RoomsPageMode iMode = null;
    private String iDepartment = null;
    private List<UniTimeTableHeader.Operation> iSortOperations = new ArrayList<UniTimeTableHeader.Operation>();
    private List<UniTimeTableHeader.Operation> iShowHideOperations = new ArrayList<UniTimeTableHeader.Operation>();
    private List<UniTimeTableHeader.Operation> iDepartmentOperations = new ArrayList<UniTimeTableHeader.Operation>();
    private List<UniTimeTableHeader.Operation> iOtherOperations = new ArrayList<UniTimeTableHeader.Operation>();
    private RoomInterface.RoomPropertiesInterface iProperties = null;
    private boolean iSelectable;

    public RoomsTable(RoomInterface.RoomsPageMode mode, boolean selectable) {
        this.setStyleName("unitime-Rooms");
        this.iMode = mode;
        this.iSelectable = selectable;
        this.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                final RoomsTable table = new RoomsTable(RoomsTable.this.iMode);
                table.setProperties(RoomsTable.this.iProperties);
                table.setDepartment(RoomsTable.this.iDepartment);
                for (int i = 1; i < RoomsTable.this.getRowCount(); ++i) {
                    table.addRoom((RoomInterface.RoomDetailInterface)RoomsTable.this.getData(i));
                }
                table.getElement().getStyle().setWidth(1040.0, Style.Unit.PX);
                com.google.gwt.user.client.Element headerRow = table.getRowFormatter().getElement(0);
                com.google.gwt.user.client.Element tableElement = table.getElement();
                com.google.gwt.user.client.Element thead = DOM.createTHead();
                tableElement.insertFirst((Node)thead);
                headerRow.getParentElement().removeChild((Node)headerRow);
                thead.appendChild((Node)headerRow);
                ToolBox.print(new ToolBox.Page(){

                    @Override
                    public String getName() {
                        return MESSAGES.pageRooms();
                    }

                    @Override
                    public String getUser() {
                        return UniTimePageHeader.getInstance().getMiddle().getText();
                    }

                    @Override
                    public String getSession() {
                        return UniTimePageHeader.getInstance().getRight().getText();
                    }

                    @Override
                    public Element getBody() {
                        return table.getElement();
                    }
                });
            }

            @Override
            public String getName() {
                return MESSAGES.buttonPrint();
            }

            @Override
            public boolean isApplicable() {
                return RoomsTable.this.getRowCount() > 1 && !RoomsTable.this.iSelectable;
            }

            @Override
            public boolean hasSeparator() {
                return true;
            }
        });
    }

    public RoomsTable(RoomInterface.RoomsPageMode mode) {
        this(mode, false);
    }

    public RoomsTable(RoomInterface.RoomsPageMode mode, RoomInterface.RoomPropertiesInterface properties, boolean selectable) {
        this(mode, selectable);
        this.setProperties(properties);
    }

    /*
     * WARNING - void declaration
     */
    public void setProperties(RoomInterface.RoomPropertiesInterface properties) {
        this.iProperties = properties;
        super.clearTable();
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (RoomInterface.RoomsColumn roomsColumn : RoomInterface.RoomsColumn.values()) {
            int nrCells = this.getNbrCells(roomsColumn);
            for (int idx = 0; idx < nrCells; ++idx) {
                UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(roomsColumn, idx), this.getColumnAlignment(roomsColumn, idx));
                header.add(h);
            }
        }
        if (this.iSelectable) {
            ((UniTimeTableHeader)header.get(0)).addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    for (int row = 1; row < RoomsTable.this.getRowCount(); ++row) {
                        Widget w = RoomsTable.this.getWidget(row, 0);
                        if (w != null && w instanceof CheckBox) {
                            CheckBox ch = (CheckBox)w;
                            ch.setValue(Boolean.valueOf(true));
                        }
                        RoomsTable.this.setSelected(row, true);
                    }
                }

                @Override
                public boolean isApplicable() {
                    for (int row = 1; row < RoomsTable.this.getRowCount(); ++row) {
                        CheckBox ch;
                        Widget w = RoomsTable.this.getWidget(row, 0);
                        if (w == null || !(w instanceof CheckBox) || (ch = (CheckBox)w).getValue().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.opSelectAll();
                }
            });
            ((UniTimeTableHeader)header.get(0)).addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    for (int row = 1; row < RoomsTable.this.getRowCount(); ++row) {
                        Widget w = RoomsTable.this.getWidget(row, 0);
                        if (w != null && w instanceof CheckBox) {
                            CheckBox ch = (CheckBox)w;
                            ch.setValue(Boolean.valueOf(false));
                        }
                        RoomsTable.this.setSelected(row, false);
                    }
                }

                @Override
                public boolean isApplicable() {
                    for (int row = 1; row < RoomsTable.this.getRowCount(); ++row) {
                        CheckBox ch;
                        Widget w = RoomsTable.this.getWidget(row, 0);
                        if (w == null || !(w instanceof CheckBox) || !(ch = (CheckBox)w).getValue().booleanValue()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.opClearSelection();
                }
            });
        }
        if (RoomCookie.getInstance().getFlags(this.iMode) == 0) {
            void var6_12;
            int flags = 0;
            RoomInterface.RoomsColumn[] roomsColumnArray = RoomInterface.RoomsColumn.values();
            int n = roomsColumnArray.length;
            boolean bl = false;
            while (var6_12 < n) {
                RoomInterface.RoomsColumn column2 = roomsColumnArray[var6_12];
                if (this.iMode.hasColumn(column2)) {
                    int nrCells = this.getNbrCells(column2);
                    int cellIdx = this.getCellIndex(column2);
                    for (int idx = 0; idx < nrCells; ++idx) {
                        flags += 1 << cellIdx + idx;
                    }
                }
                ++var6_12;
            }
            RoomCookie.getInstance().setFlags(this.iMode, flags);
        }
        this.addRow(null, header);
        this.iShowHideOperations.clear();
        for (final RoomInterface.RoomsColumn roomsColumn : RoomInterface.RoomsColumn.values()) {
            int nrCells = this.getNbrCells(roomsColumn);
            int cellIdx = this.getCellIndex(roomsColumn);
            for (int idx = 0; idx < nrCells; ++idx) {
                RoomInterface.RoomsColumn g;
                final int colIdx = cellIdx + idx;
                final String cName = this.getColumnName(roomsColumn, idx).replace("<br>", " ");
                UniTimeTableHeader h = (UniTimeTableHeader)header.get(colIdx);
                if (!this.hasShowHideOperation(roomsColumn)) continue;
                UniTimeTableHeader.AriaOperation op = new UniTimeTableHeader.AriaOperation(){

                    public void execute() {
                        boolean visible = RoomsTable.this.isColumnVisible(colIdx);
                        RoomsTable.this.setColumnVisible(colIdx, !visible);
                        RoomCookie.getInstance().set(RoomsTable.this.iMode, colIdx, !visible);
                    }

                    @Override
                    public boolean isApplicable() {
                        return (RoomsTable.this.iFlags & 1 << colIdx) != 0;
                    }

                    @Override
                    public boolean hasSeparator() {
                        return RoomsTable.this.iSelectable && roomsColumn == RoomInterface.RoomsColumn.EXTERNAL_ID;
                    }

                    @Override
                    public String getName() {
                        return RoomsTable.this.isColumnVisible(colIdx) ? MESSAGES.opHide(cName) : MESSAGES.opShow(cName);
                    }

                    @Override
                    public String getAriaLabel() {
                        return RoomsTable.this.isColumnVisible(colIdx) ? ARIA.opHide(cName) : ARIA.opShow(cName);
                    }
                };
                this.iShowHideOperations.add(op);
                if (colIdx > 0) {
                    ((UniTimeTableHeader)header.get(0)).addOperation(op);
                }
                if ((g = this.getShowHideGroup(roomsColumn)) == null) {
                    h.addOperation(op);
                    continue;
                }
                for (RoomInterface.RoomsColumn c : RoomInterface.RoomsColumn.values()) {
                    if (!g.equals((Object)this.getShowHideGroup(c))) continue;
                    for (int i = 0; i < this.getNbrCells(c); ++i) {
                        ((UniTimeTableHeader)header.get(this.getCellIndex(c) + i)).addOperation(op);
                    }
                }
            }
        }
        this.iDepartmentOperations.clear();
        for (Enum enum_ : DeptMode.values()) {
            UniTimeTableHeader.Operation op = new UniTimeTableHeader.Operation(){
                final /* synthetic */ DeptMode val$d;
                {
                    this.val$d = deptMode;
                }

                public void execute() {
                    RoomCookie.getInstance().setDeptMode(this.val$d.ordinal());
                    RoomsTable.this.refreshTable();
                }

                @Override
                public boolean isApplicable() {
                    return RoomsTable.this.getRowCount() > 0;
                }

                @Override
                public boolean hasSeparator() {
                    return this.val$d.ordinal() == 0;
                }

                @Override
                public String getName() {
                    if (RoomCookie.getInstance().getDeptMode() == this.val$d.ordinal()) {
                        return MESSAGES.opUncheck(this.val$d.getName());
                    }
                    return MESSAGES.opCheck(this.val$d.getName());
                }
            };
            this.iDepartmentOperations.add(op);
            for (RoomInterface.RoomsColumn c : RoomInterface.RoomsColumn.values()) {
                if (!this.hasDepartmentOperation(c)) continue;
                for (int i = 0; i < this.getNbrCells(c); ++i) {
                    ((UniTimeTableHeader)header.get(this.getCellIndex(c) + i)).addOperation(op);
                }
            }
        }
        this.iSortOperations.clear();
        for (Enum enum_ : RoomInterface.RoomsColumn.values()) {
            if (!RoomsComparator.isApplicable((RoomInterface.RoomsColumn)enum_)) continue;
            UniTimeTableHeader h = (UniTimeTableHeader)header.get(this.getCellIndex((RoomInterface.RoomsColumn)enum_));
            SortOperation op = new SortOperation(){
                final /* synthetic */ RoomInterface.RoomsColumn val$column;
                final /* synthetic */ UniTimeTableHeader val$h;
                {
                    this.val$column = roomsColumn;
                    this.val$h = uniTimeTableHeader;
                }

                public void execute() {
                    if (this.val$column == RoomsTable.this.iSortBy) {
                        RoomsTable.this.iAsc = !RoomsTable.this.iAsc;
                    } else {
                        RoomsTable.this.iSortBy = this.val$column;
                        RoomsTable.this.iAsc = true;
                    }
                    RoomCookie.getInstance().setSortRoomsBy(RoomsTable.this.getSortBy());
                    RoomsTable.this.sort();
                }

                @Override
                public boolean isApplicable() {
                    return RoomsTable.this.getRowCount() > 1 && this.val$h.isVisible();
                }

                @Override
                public boolean hasSeparator() {
                    return true;
                }

                @Override
                public String getName() {
                    return MESSAGES.opSortBy(this.getColumnName());
                }

                @Override
                public String getColumnName() {
                    return this.val$h.getHTML().replace("<br>", " ");
                }
            };
            this.iSortOperations.add(op);
            h.addOperation(op);
        }
        for (UniTimeTableHeader.Operation op : this.getOtherOperations()) {
            ((UniTimeTableHeader)header.get(0)).addOperation(op);
        }
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        this.resetVisibility();
        this.setSortBy(RoomCookie.getInstance().getRoomsSortBy());
        this.setVisible(false);
        if (this.iSelectable) {
            this.setAllowSelection(true);
            this.addMouseClickListener(new UniTimeTable.MouseClickListener<RoomInterface.RoomDetailInterface>(){

                @Override
                public void onMouseClick(UniTimeTable.TableEvent<RoomInterface.RoomDetailInterface> event) {
                    RoomsTable.this.selectRoom(event.getRow(), RoomsTable.this.isSelected(event.getRow()));
                }
            });
        }
    }

    public String getColumnName(RoomInterface.RoomsColumn column, int idx) {
        switch (column) {
            case NAME: {
                return MESSAGES.colName();
            }
            case TYPE: {
                return MESSAGES.colType();
            }
            case EXTERNAL_ID: {
                return MESSAGES.colExternalId();
            }
            case CAPACITY: {
                return MESSAGES.colCapacity();
            }
            case EXAM_CAPACITY: {
                return MESSAGES.colExaminationCapacity();
            }
            case AREA: {
                return MESSAGES.colArea(this.iProperties != null && this.iProperties.isRoomAreaInMetricUnits() ? CONSTANTS.roomAreaMetricUnitsShort() : CONSTANTS.roomAreaUnitsShort());
            }
            case COORDINATES: {
                return MESSAGES.colCoordinates();
            }
            case DISTANCE_CHECK: {
                return MESSAGES.colDistances();
            }
            case ROOM_CHECK: {
                return MESSAGES.colRoomCheck();
            }
            case MAP: {
                return MESSAGES.colMap();
            }
            case PICTURES: {
                if (idx == 0) {
                    return MESSAGES.colPictures();
                }
                return this.iProperties.getTableTypes().get(idx - 1).getAbbreviation();
            }
            case PREFERENCE: {
                return MESSAGES.colPreference();
            }
            case AVAILABILITY: {
                return MESSAGES.colAvailability();
            }
            case DEPARTMENTS: {
                return MESSAGES.colDepartments();
            }
            case CONTROL_DEPT: {
                return MESSAGES.colControl();
            }
            case EXAM_TYPES: {
                return MESSAGES.colExamTypes();
            }
            case PERIOD_PREF: {
                return MESSAGES.colPeriodPreferences();
            }
            case EVENT_DEPARTMENT: {
                return MESSAGES.colEventDepartment();
            }
            case EVENT_STATUS: {
                return MESSAGES.colEventStatus();
            }
            case EVENT_AVAILABILITY: {
                return MESSAGES.colEventAvailability();
            }
            case EVENT_MESSAGE: {
                return MESSAGES.colEventMessage();
            }
            case EVENT_EMAIL: {
                return MESSAGES.colEventEmail();
            }
            case BREAK_TIME: {
                return MESSAGES.colBreakTime();
            }
            case GROUPS: {
                return MESSAGES.colGroups();
            }
            case FEATURES: {
                if (idx == 0) {
                    return MESSAGES.colFeatures();
                }
                return this.getFeatureType(idx - 1).getAbbreviation();
            }
            case SERVICES: {
                return MESSAGES.colAvailableServices();
            }
            case PARTITION: {
                return MESSAGES.colPartitionOf();
            }
        }
        return column.name();
    }

    @Override
    public void refreshTable() {
        for (int r = 1; r < this.getRowCount(); ++r) {
            for (int c = 0; c < this.getCellCount(r); ++c) {
                Widget w = this.getWidget(r, c);
                if (!(w instanceof HasRefresh)) continue;
                ((HasRefresh)w).refresh();
            }
        }
    }

    protected HasHorizontalAlignment.HorizontalAlignmentConstant getColumnAlignment(RoomInterface.RoomsColumn column, int idx) {
        switch (column) {
            case CAPACITY: 
            case EXAM_CAPACITY: 
            case AREA: {
                return HasHorizontalAlignment.ALIGN_RIGHT;
            }
        }
        return HasHorizontalAlignment.ALIGN_LEFT;
    }

    protected boolean hasShowHideOperation(RoomInterface.RoomsColumn column) {
        switch (column) {
            case NAME: {
                return false;
            }
        }
        return true;
    }

    protected int getFlagOffset(RoomInterface.RoomsColumn column) {
        switch (column) {
            case PICTURES: {
                return this.countFeatureTypes();
            }
        }
        return 0;
    }

    protected boolean hasDepartmentOperation(RoomInterface.RoomsColumn column) {
        switch (column) {
            case DEPARTMENTS: 
            case CONTROL_DEPT: 
            case EVENT_DEPARTMENT: {
                return true;
            }
        }
        return false;
    }

    protected RoomInterface.RoomsColumn getShowHideGroup(RoomInterface.RoomsColumn column) {
        switch (column) {
            case TYPE: 
            case EXTERNAL_ID: 
            case PARTITION: {
                return RoomInterface.RoomsColumn.EXTERNAL_ID;
            }
            case CAPACITY: 
            case EXAM_CAPACITY: 
            case AREA: 
            case COORDINATES: 
            case DISTANCE_CHECK: 
            case ROOM_CHECK: {
                return RoomInterface.RoomsColumn.CAPACITY;
            }
            case PREFERENCE: 
            case AVAILABILITY: 
            case DEPARTMENTS: 
            case CONTROL_DEPT: {
                return RoomInterface.RoomsColumn.PREFERENCE;
            }
            case EVENT_DEPARTMENT: 
            case EVENT_STATUS: 
            case EVENT_AVAILABILITY: 
            case EVENT_MESSAGE: 
            case EVENT_EMAIL: 
            case BREAK_TIME: 
            case SERVICES: {
                return RoomInterface.RoomsColumn.EVENT_DEPARTMENT;
            }
            case EXAM_TYPES: 
            case PERIOD_PREF: {
                return RoomInterface.RoomsColumn.EXAM_TYPES;
            }
            case PICTURES: {
                return RoomInterface.RoomsColumn.PICTURES;
            }
            case FEATURES: {
                return RoomInterface.RoomsColumn.FEATURES;
            }
        }
        return null;
    }

    protected boolean hasFeatureTypes() {
        return this.iProperties != null && this.iProperties.getFeatureTypes() != null && !this.iProperties.getFeatureTypes().isEmpty();
    }

    protected int countFeatureTypes() {
        return this.iProperties == null ? 0 : this.iProperties.getFeatureTypes().size();
    }

    protected RoomInterface.FeatureTypeInterface getFeatureType(int index) {
        return this.iProperties.getFeatureTypes().get(index);
    }

    public List<UniTimeTableHeader.Operation> getSortOperations() {
        ArrayList<UniTimeTableHeader.Operation> operations = new ArrayList<UniTimeTableHeader.Operation>();
        for (UniTimeTableHeader.Operation operation : this.iSortOperations) {
            if (!operation.isApplicable()) continue;
            operations.add(operation);
        }
        return operations;
    }

    public List<UniTimeTableHeader.Operation> getShowHideOperations() {
        ArrayList<UniTimeTableHeader.Operation> operations = new ArrayList<UniTimeTableHeader.Operation>();
        for (UniTimeTableHeader.Operation operation : this.iShowHideOperations) {
            if (!operation.isApplicable()) continue;
            operations.add(operation);
        }
        return operations;
    }

    public boolean hasDepartmentOperations() {
        return this.isVisible(RoomInterface.RoomsColumn.EVENT_DEPARTMENT) || this.isVisible(RoomInterface.RoomsColumn.DEPARTMENTS) || this.isVisible(RoomInterface.RoomsColumn.CONTROL_DEPT);
    }

    public boolean hasOrientationOperations() {
        return this.isVisible(RoomInterface.RoomsColumn.AVAILABILITY) || this.isVisible(RoomInterface.RoomsColumn.PERIOD_PREF) || this.isVisible(RoomInterface.RoomsColumn.EVENT_AVAILABILITY);
    }

    public List<UniTimeTableHeader.Operation> getDepartmentOperations() {
        ArrayList<UniTimeTableHeader.Operation> operations = new ArrayList<UniTimeTableHeader.Operation>();
        for (UniTimeTableHeader.Operation operation : this.iDepartmentOperations) {
            if (!operation.isApplicable()) continue;
            operations.add(operation);
        }
        return operations;
    }

    public List<UniTimeTableHeader.Operation> getOtherOperations() {
        ArrayList<UniTimeTableHeader.Operation> operations = new ArrayList<UniTimeTableHeader.Operation>();
        for (UniTimeTableHeader.Operation operation : this.iOtherOperations) {
            if (!operation.isApplicable()) continue;
            operations.add(operation);
        }
        return operations;
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
        } else if (sortBy > 0) {
            this.iSortBy = RoomInterface.RoomsColumn.values()[sortBy - 1];
            this.iAsc = true;
        } else {
            this.iSortBy = RoomInterface.RoomsColumn.values()[-1 - sortBy];
            this.iAsc = false;
        }
        this.sort();
    }

    protected void addOperation(UniTimeTableHeader.Operation op) {
        this.iOtherOperations.add(op);
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        Comparator<RoomInterface.RoomDetailInterface> rc = null;
        rc = this.iSelectable && this.iSortBy == RoomInterface.RoomsColumn.NAME ? new Comparator<RoomInterface.RoomDetailInterface>(){
            private Comparator<RoomInterface.RoomDetailInterface> iRC;
            {
                this.iRC = new RoomsComparator(RoomsTable.this.iSortBy, true);
            }

            @Override
            public int compare(RoomInterface.RoomDetailInterface r1, RoomInterface.RoomDetailInterface r2) {
                boolean s2;
                boolean s1 = RoomsTable.this.isRoomSelected(r1);
                if (s1 != (s2 = RoomsTable.this.isRoomSelected(r2))) {
                    return s1 ? -1 : 1;
                }
                return this.iRC.compare(r1, r2);
            }
        } : new RoomsComparator(this.iSortBy, true);
        UniTimeTableHeader header = this.getHeader(this.getCellIndex(this.iSortBy));
        this.sort(header, rc, this.iAsc);
    }

    public void setDepartment(String department) {
        this.iDepartment = department;
    }

    protected int getNbrCells(RoomInterface.RoomsColumn column) {
        switch (column) {
            case PICTURES: {
                List<RoomInterface.AttachmentTypeInterface> types = this.iProperties.getTableTypes();
                return 1 + (types == null ? 0 : types.size());
            }
            case FEATURES: {
                return 1 + this.iProperties.getFeatureTypes().size();
            }
        }
        return 1;
    }

    protected int getCellIndex(RoomInterface.RoomsColumn column) {
        int ret = 0;
        for (RoomInterface.RoomsColumn c : RoomInterface.RoomsColumn.values()) {
            if (c.ordinal() >= column.ordinal()) continue;
            ret += this.getNbrCells(c);
        }
        return ret;
    }

    protected Widget getCell(final RoomInterface.RoomDetailInterface room, RoomInterface.RoomsColumn column, int idx) {
        if (this.iProperties == null || !this.iProperties.isCanSeeCourses()) {
            switch (column) {
                case ROOM_CHECK: {
                    if (this.iProperties != null && this.iProperties.isCanSeeEvents()) break;
                }
                case DISTANCE_CHECK: 
                case PREFERENCE: 
                case AVAILABILITY: 
                case DEPARTMENTS: 
                case CONTROL_DEPT: {
                    return null;
                }
            }
        }
        if (this.iProperties == null || !this.iProperties.isCanSeeExams()) {
            switch (column) {
                case EXAM_CAPACITY: 
                case EXAM_TYPES: 
                case PERIOD_PREF: {
                    return null;
                }
            }
        }
        if (this.iProperties == null || !this.iProperties.isCanSeeEvents()) {
            switch (column) {
                case EVENT_DEPARTMENT: 
                case EVENT_STATUS: 
                case EVENT_AVAILABILITY: 
                case EVENT_MESSAGE: 
                case EVENT_EMAIL: 
                case BREAK_TIME: 
                case SERVICES: {
                    return null;
                }
            }
        }
        switch (column) {
            case NAME: {
                if (this.iSelectable) {
                    return new SelectableRoomNameCell(room);
                }
                if (room.hasUrl()) {
                    return new ClickableRoomNameCell(room);
                }
                return new RoomNameCell(room);
            }
            case EXTERNAL_ID: {
                if (!room.hasExternalId()) {
                    return null;
                }
                return new Label(room.getExternalId());
            }
            case TYPE: {
                return new Label(room.getRoomType().getLabel());
            }
            case CAPACITY: {
                if (room.getCapacity() == null) {
                    return null;
                }
                return new IntegerCell(room.getCapacity());
            }
            case EXAM_CAPACITY: {
                if (room.getExamCapacity() == null) {
                    return null;
                }
                return new IntegerCell(room.getExamCapacity());
            }
            case AREA: {
                if (room.getArea() == null) {
                    return null;
                }
                return new RoomAreaCell(room.getArea());
            }
            case COORDINATES: {
                if (!room.hasCoordinates()) {
                    return null;
                }
                return new Label(MESSAGES.coordinates(room.getX(), room.getY()));
            }
            case DISTANCE_CHECK: {
                Image dc = new Image(!room.isIgnoreTooFar() ? RESOURCES.on() : RESOURCES.off());
                dc.setTitle(!room.isIgnoreTooFar() ? MESSAGES.infoDistanceCheckOn() : MESSAGES.infoDistanceCheckOff());
                return dc;
            }
            case ROOM_CHECK: {
                Image rc = new Image(!room.isIgnoreRoomCheck() ? RESOURCES.on() : RESOURCES.off());
                rc.setTitle(!room.isIgnoreRoomCheck() ? MESSAGES.infoRoomCheckOn() : MESSAGES.infoRoomCheckOff());
                return rc;
            }
            case PREFERENCE: {
                if (this.iDepartment != null) {
                    for (RoomInterface.DepartmentInterface department : room.getDepartments()) {
                        if (!this.iDepartment.equals(department.getDeptCode()) || department.getPreference() == null) continue;
                        return new PreferenceCell(department);
                    }
                    return null;
                }
                boolean hasPreferences = false;
                for (RoomInterface.DepartmentInterface department : room.getDepartments()) {
                    if (department.getPreference() == null) continue;
                    hasPreferences = true;
                    break;
                }
                if (hasPreferences) {
                    return new PreferenceCell(room.getDepartments());
                }
                return null;
            }
            case MAP: {
                if (!room.hasMiniMapUrl()) {
                    return null;
                }
                return new MapCell(room);
            }
            case PICTURES: {
                if (idx == 0) {
                    return room.hasPictures(null) ? new PicturesCell(room, null) : null;
                }
                RoomInterface.AttachmentTypeInterface type = this.iProperties.getTableTypes().get(idx - 1);
                return room.hasPictures(type) ? new PicturesCell(room, type) : null;
            }
            case AVAILABILITY: {
                if (room.getAvailability() == null) {
                    return null;
                }
                return new AvailabilityCell(room, false);
            }
            case DEPARTMENTS: {
                return new DepartmentCell(true, room.getDepartments(), room.getControlDepartment(), this.isAllDepartments(room));
            }
            case CONTROL_DEPT: {
                return new DepartmentCell(true, room.getControlDepartment());
            }
            case EXAM_TYPES: {
                return new ExamTypesCell(room.getUniqueId(), room.getExamTypes());
            }
            case PERIOD_PREF: {
                if (room.getPeriodPreference() == null) {
                    return null;
                }
                if (this.iDepartment != null && room.hasExamTypes()) {
                    for (RoomInterface.ExamTypeInterface type : room.getExamTypes()) {
                        if (!this.iDepartment.equals(type.getReference())) continue;
                        return new PeriodPreferenceCell(room, type);
                    }
                }
                return null;
            }
            case EVENT_DEPARTMENT: {
                if (room.getEventDepartment() == null) {
                    return null;
                }
                final DepartmentCell edc = new DepartmentCell(false, room.getEventDepartment());
                if (room.isCanSeeEventAvailability()) {
                    edc.addMouseOverHandler(new MouseOverHandler(){

                        public void onMouseOver(MouseOverEvent event) {
                            RoomSharingHint.showHint((Element)edc.getElement(), room.getUniqueId(), true);
                        }
                    });
                    edc.addMouseOutHandler(new MouseOutHandler(){

                        public void onMouseOut(MouseOutEvent event) {
                            RoomSharingHint.hideHint();
                        }
                    });
                }
                return edc;
            }
            case EVENT_STATUS: {
                if (room.getEventStatus() != null || room.getDefaultEventStatus() != null) {
                    return new StatusCell(room.getEventStatus(), room.getDefaultEventStatus());
                }
                return null;
            }
            case EVENT_AVAILABILITY: {
                if (room.getEventAvailability() == null) {
                    return null;
                }
                return new AvailabilityCell(room, true);
            }
            case EVENT_MESSAGE: {
                if (room.hasEventNote() || room.hasDefaultEventNote()) {
                    return new NoteCell(room.getEventNote(), room.getDefaultEventNote());
                }
                return null;
            }
            case EVENT_EMAIL: {
                if (room.hasEventEmail() || room.hasDefaultEventEmail()) {
                    return new NoteCell(room.getEventEmail(), room.getDefaultEventEmail());
                }
                return null;
            }
            case BREAK_TIME: {
                if (room.getBreakTime() != null || room.getDefaultBreakTime() != null) {
                    return new BreakTimeCell(room.getBreakTime(), room.getDefaultBreakTime());
                }
                return null;
            }
            case GROUPS: {
                if (room.getGroups().isEmpty()) {
                    return null;
                }
                return new GroupsCell(room.getGroups());
            }
            case FEATURES: {
                if (idx == 0) {
                    List<RoomInterface.FeatureInterface> features = room.getFeatures((Long)null);
                    if (features.isEmpty()) {
                        return null;
                    }
                    return new FeaturesCell(features);
                }
                RoomInterface.FeatureTypeInterface type = this.getFeatureType(idx - 1);
                List<RoomInterface.FeatureInterface> featuresOfType = room.getFeatures(type);
                if (featuresOfType.isEmpty()) {
                    return null;
                }
                return new FeaturesCell(featuresOfType);
            }
            case SERVICES: {
                if (!room.hasServices()) {
                    return null;
                }
                return new ServicesCell(room.getServices(), room.getEventDepartment());
            }
            case PARTITION: {
                if (room.getParent() == null) {
                    return null;
                }
                return new RoomNameCell(room.getParent());
            }
        }
        return null;
    }

    public int addRoom(RoomInterface.RoomDetailInterface room) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (RoomInterface.RoomsColumn column : RoomInterface.RoomsColumn.values()) {
            int nbrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nbrCells; ++idx) {
                Object cell = this.getCell(room, column, idx);
                if (cell == null) {
                    cell = new P();
                } else if (this.hasShowHideOperation(column)) {
                    this.show(column, idx);
                }
                widgets.add((Widget)cell);
            }
        }
        int row = this.addRow(room, widgets);
        this.getRowFormatter().setStyleName(row, "row");
        for (int col = 0; col < this.getCellCount(row); ++col) {
            this.getCellFormatter().setStyleName(row, col, "cell");
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        return row;
    }

    protected void resetVisibility() {
        for (RoomInterface.RoomsColumn column : RoomInterface.RoomsColumn.values()) {
            int nrCells = this.getNbrCells(column);
            int cellIdx = this.getCellIndex(column);
            for (int idx = 0; idx < nrCells; ++idx) {
                int colIdx = cellIdx + idx;
                this.setColumnVisible(colIdx, !this.hasShowHideOperation(column));
            }
        }
    }

    protected void show(RoomInterface.RoomsColumn column, int idx) {
        int flag;
        int colIdx = this.getCellIndex(column) + idx;
        if (RoomCookie.getInstance().get(this.iMode, colIdx) && !this.isColumnVisible(colIdx)) {
            this.setColumnVisible(colIdx, true);
        }
        if ((this.iFlags & (flag = 1 << colIdx)) == 0) {
            this.iFlags += flag;
        }
    }

    @Override
    public void clearTable(int headerRows) {
        super.clearTable(headerRows);
        this.resetVisibility();
        this.iFlags = 0;
        this.setVisible(false);
    }

    public int getFlags() {
        return this.iFlags;
    }

    public boolean isVisible(RoomInterface.RoomsColumn column) {
        return this.isColumnVisible(this.getCellIndex(column));
    }

    public static String toString(RoomInterface.DepartmentInterface d, boolean ext) {
        RoomCookie cookie = RoomCookie.getInstance();
        switch (DeptMode.values()[cookie.getDeptMode()]) {
            case ABBV: {
                return ext ? d.getExtAbbreviationWhenExist() : d.getAbbreviationOrCode();
            }
            case CODE: {
                return d.getDeptCode();
            }
            case ABBV_NAME: {
                return ext ? d.getExtAbbreviationWhenExist() + " - " + d.getExtLabelWhenExist() : d.getAbbreviationOrCode() + " - " + d.getLabel();
            }
            case CODE_NAME: {
                return ext ? d.getDeptCode() + " - " + d.getExtLabelWhenExist() : d.getDeptCode() + " - " + d.getLabel();
            }
            case NAME: {
                return ext ? d.getExtLabelWhenExist() : d.getLabel();
            }
        }
        return d.getDeptCode();
    }

    public RoomInterface.RoomDetailInterface getRoom(Long roomId) {
        if (roomId == null) {
            return null;
        }
        for (int i = 1; i < this.getRowCount(); ++i) {
            if (!roomId.equals(((RoomInterface.RoomDetailInterface)this.getData(i)).getUniqueId())) continue;
            return (RoomInterface.RoomDetailInterface)this.getData(i);
        }
        return null;
    }

    public void scrollTo(Long roomId) {
        if (roomId == null) {
            return;
        }
        for (int i = 1; i < this.getRowCount(); ++i) {
            if (!roomId.equals(((RoomInterface.RoomDetailInterface)this.getData(i)).getUniqueId())) continue;
            ToolBox.scrollToElement((Element)this.getRowFormatter().getElement(i));
        }
    }

    public RoomInterface.RoomDetailInterface getPrevious(Long roomId) {
        if (roomId == null) {
            return null;
        }
        for (int i = 2; i < this.getRowCount(); ++i) {
            if (!roomId.equals(((RoomInterface.RoomDetailInterface)this.getData(i)).getUniqueId())) continue;
            return (RoomInterface.RoomDetailInterface)this.getData(i - 1);
        }
        return null;
    }

    public RoomInterface.RoomDetailInterface getNext(Long roomId) {
        if (roomId == null) {
            return null;
        }
        for (int i = 1; i < this.getRowCount() - 1; ++i) {
            if (!roomId.equals(((RoomInterface.RoomDetailInterface)this.getData(i)).getUniqueId())) continue;
            return (RoomInterface.RoomDetailInterface)this.getData(i + 1);
        }
        return null;
    }

    public Boolean isRoomSelected(int row) {
        Widget w = this.getWidget(row, 0);
        if (w != null && w instanceof CheckBox) {
            return ((CheckBox)w).getValue();
        }
        return null;
    }

    public boolean isRoomSelected(RoomInterface.RoomDetailInterface room) {
        if (!this.iSelectable) {
            return false;
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            if (!((RoomInterface.RoomDetailInterface)this.getData(row)).getUniqueId().equals(room.getUniqueId())) continue;
            return this.isRoomSelected(row);
        }
        return false;
    }

    public int getRow(RoomInterface.RoomDetailInterface room) {
        for (int row = 1; row < this.getRowCount(); ++row) {
            if (!((RoomInterface.RoomDetailInterface)this.getData(row)).getUniqueId().equals(room.getUniqueId())) continue;
            return row;
        }
        return -1;
    }

    public void selectRoom(RoomInterface.RoomDetailInterface room, boolean value) {
        if (!this.iSelectable) {
            return;
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            if (!((RoomInterface.RoomDetailInterface)this.getData(row)).getUniqueId().equals(room.getUniqueId())) continue;
            this.selectRoom(row, value);
            break;
        }
    }

    public void selectRoom(int row, boolean value) {
        Widget w = this.getWidget(row, 0);
        if (w != null && w instanceof CheckBox) {
            ((CheckBox)w).setValue(Boolean.valueOf(value));
        }
    }

    public CheckBox getRoomSelection(int row) {
        Widget w = this.getWidget(row, 0);
        if (w != null && w instanceof CheckBox) {
            return (CheckBox)w;
        }
        return null;
    }

    public boolean isAllDepartments(RoomInterface.RoomDetailInterface room) {
        return room.getDepartments().size() > 3 && this.iProperties.getNrDepartments() == room.getDepartments().size();
    }

    public static enum DeptMode {
        CODE(MESSAGES.fieldCode()),
        ABBV(MESSAGES.fieldAbbreviation()),
        NAME(MESSAGES.fieldName()),
        ABBV_NAME(MESSAGES.fieldAbbv() + " - " + MESSAGES.fieldName()),
        CODE_NAME(MESSAGES.fieldCode() + " - " + MESSAGES.fieldName());

        private String iName;

        private DeptMode(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }
    }

    public static interface HasRefresh {
        public void refresh();
    }

    class SelectableRoomNameCell
    extends AriaCheckBox {
        SelectableRoomNameCell(final RoomInterface.RoomDetailInterface room) {
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    RoomsTable.this.setSelected(RoomsTable.this.getRow(room), (Boolean)event.getValue());
                }
            });
            this.setText(room.hasDisplayName() ? MESSAGES.label(room.getLabel(), room.getDisplayName()) : room.getLabel());
            this.setWordWrap(room.hasDisplayName());
            this.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    RoomHint.showHint((Element)SelectableRoomNameCell.this.getElement(), room.getUniqueId(), room.getPrefix(), room.getProperty("distance", null), true);
                }
            });
            this.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    RoomHint.hideHint();
                }
            });
            if (RoomsTable.this.iDepartment != null && RoomsTable.this.iProperties != null && RoomsTable.this.iProperties.isCanSeeCourses()) {
                for (RoomInterface.DepartmentInterface d : room.getDepartments()) {
                    if (!RoomsTable.this.iDepartment.equals(d.getDeptCode()) || d.getPreference() == null) continue;
                    this.getElement().getStyle().setColor(d.getPreference().getColor());
                    room.setPrefix(d.getPreference().getName());
                }
            }
        }
    }

    class ClickableRoomNameCell
    extends Anchor {
        ClickableRoomNameCell(final RoomInterface.RoomDetailInterface room) {
            super(room.hasDisplayName() ? MESSAGES.label(room.getLabel(), room.getDisplayName()) : room.getLabel(), room.hasDisplayName());
            this.setHref(room.getUrl());
            this.setTarget("_blank");
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.getNativeEvent().stopPropagation();
                }
            });
            this.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    RoomHint.showHint((Element)ClickableRoomNameCell.this.getElement(), room.getUniqueId(), room.getPrefix(), room.getProperty("distance", null), true);
                }
            });
            this.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    RoomHint.hideHint();
                }
            });
            if (RoomsTable.this.iDepartment != null && RoomsTable.this.iProperties != null && RoomsTable.this.iProperties.isCanSeeCourses()) {
                for (RoomInterface.DepartmentInterface d : room.getDepartments()) {
                    if (!RoomsTable.this.iDepartment.equals(d.getDeptCode()) || d.getPreference() == null) continue;
                    this.getElement().getStyle().setColor(d.getPreference().getColor());
                    room.setPrefix(d.getPreference().getName());
                }
            }
        }
    }

    class RoomNameCell
    extends Label {
        RoomNameCell(final RoomInterface.RoomDetailInterface room) {
            super(room.hasDisplayName() ? MESSAGES.label(room.getLabel(), room.getDisplayName()) : room.getLabel(), room.hasDisplayName());
            this.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    RoomHint.showHint((Element)RoomNameCell.this.getElement(), room.getUniqueId(), room.getPrefix(), room.getProperty("distance", null), true);
                }
            });
            this.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    RoomHint.hideHint();
                }
            });
            if (RoomsTable.this.iDepartment != null && RoomsTable.this.iProperties != null && RoomsTable.this.iProperties.isCanSeeCourses()) {
                for (RoomInterface.DepartmentInterface d : room.getDepartments()) {
                    if (!RoomsTable.this.iDepartment.equals(d.getDeptCode()) || d.getPreference() == null) continue;
                    this.getElement().getStyle().setColor(d.getPreference().getColor());
                    room.setPrefix(d.getPreference().getName());
                }
            }
        }
    }

    public static class IntegerCell
    extends Label
    implements UniTimeTable.HasCellAlignment,
    UniTimeTable.HasColSpan,
    TakesValue<Integer> {
        public IntegerCell(Integer value) {
            this.setValue(value);
        }

        public void setValue(Integer value) {
            this.setText(value == null ? "" : value.toString());
        }

        public Integer getValue() {
            return this.getText().isEmpty() ? null : Integer.valueOf(this.getText());
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }

        @Override
        public int getColSpan() {
            return 1;
        }
    }

    public static class RoomAreaCell
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        public RoomAreaCell(Double value) {
            super(value == null ? "" : MESSAGES.roomArea(value));
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    public static class PreferenceCell
    extends DepartmentCell {
        public PreferenceCell(List<RoomInterface.DepartmentInterface> departments) {
            super(true, new RoomInterface.DepartmentInterface[0]);
            boolean abbv = RoomCookie.getInstance().getDeptMode() <= 1;
            for (RoomInterface.DepartmentInterface department : departments) {
                if (department.getPreference() == null) continue;
                P p = new P("department");
                if (abbv) {
                    String prefAbbv = department.getPreference().getAbbv();
                    p.setText(MESSAGES.roomPreferenceShort(RoomsTable.toString(department, this.iExt), prefAbbv == null ? department.getPreference().getName() : prefAbbv));
                } else {
                    p.setText(MESSAGES.roomPreference(RoomsTable.toString(department, this.iExt), department.getPreference().getName()));
                }
                p.setTitle(department.getPreference().getName() + " " + department.getLabel());
                p.getElement().getStyle().setColor(department.getPreference().getColor());
                this.iP.put(department, p);
                this.add((Widget)p);
            }
        }

        public PreferenceCell(RoomInterface.DepartmentInterface department) {
            super(true, new RoomInterface.DepartmentInterface[0]);
            this.setText(department.getPreference().getName());
            this.setTitle(department.getPreference().getName() + " " + department.getLabel());
            this.getElement().getStyle().setColor(department.getPreference().getColor());
        }

        @Override
        public void refresh() {
            boolean abbv = RoomCookie.getInstance().getDeptMode() <= 1;
            for (Map.Entry e : this.iP.entrySet()) {
                RoomInterface.DepartmentInterface department = (RoomInterface.DepartmentInterface)e.getKey();
                if (abbv) {
                    String prefAbbv = department.getPreference().getAbbv();
                    ((P)((Object)e.getValue())).setText(MESSAGES.roomPreferenceShort(RoomsTable.toString(department, this.iExt), prefAbbv == null ? department.getPreference().getName() : prefAbbv));
                    continue;
                }
                ((P)((Object)e.getValue())).setText(MESSAGES.roomPreference(RoomsTable.toString(department, this.iExt), department.getPreference().getName()));
            }
        }
    }

    public static class MapCell
    extends Image {
        public MapCell(RoomInterface.RoomDetailInterface room) {
            if (room.hasMiniMapUrl()) {
                this.setStyleName("map");
                this.setUrl(room.getMiniMapUrl());
                this.setTitle(MESSAGES.titleRoomMap(room.getLabel()));
            }
        }
    }

    public static class PicturesCell
    extends P {
        public PicturesCell(RoomInterface.RoomDetailInterface room) {
            super("pictures");
            if (room.hasTablePictures()) {
                for (RoomInterface.RoomPictureInterface picture : room.getTablePictures()) {
                    this.add((Widget)(picture.getPictureType() == null || picture.getPictureType().isImage() ? new PictureCell(picture) : new LinkCell(picture)));
                }
            }
        }

        public PicturesCell(RoomInterface.RoomDetailInterface room, RoomInterface.AttachmentTypeInterface type) {
            super("pictures");
            if (room.hasPictures(type)) {
                for (RoomInterface.RoomPictureInterface picture : room.getPictures(type)) {
                    this.add((Widget)(picture.getPictureType() == null || picture.getPictureType().isImage() ? new PictureCell(picture) : new LinkCell(picture)));
                }
            }
        }
    }

    public static class AvailabilityCell
    extends P
    implements HasRefresh {
        private boolean iEvents;
        private RoomInterface.RoomDetailInterface iRoom;

        public AvailabilityCell(RoomInterface.RoomDetailInterface room, boolean events) {
            super("availability");
            this.iRoom = room;
            this.iEvents = events;
            this.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    RoomSharingHint.showHint((Element)this.getElement(), iRoom.getUniqueId(), iEvents);
                }
            });
            this.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    RoomSharingHint.hideHint();
                }
            });
            this.refresh();
        }

        @Override
        public void refresh() {
            this.clear();
            this.setHTML("");
            RoomCookie cookie = RoomCookie.getInstance();
            if (this.iEvents) {
                if (cookie.isGridAsText()) {
                    if (this.iRoom.getEventAvailability() != null) {
                        P p = new P("text");
                        p.setHTML(this.iRoom.getEventAvailability());
                        this.add((Widget)p);
                    }
                } else {
                    Image availability = new Image(GWT.getHostPageBaseURL() + "pattern?loc=" + this.iRoom.getUniqueId() + "&e=1&v=" + (cookie.areRoomsHorizontal() ? "0" : "1") + (String)(cookie.hasMode() ? "&s=" + cookie.getMode() : ""));
                    availability.setStyleName("grid");
                    this.add((Widget)availability);
                }
            } else {
                P p;
                if (cookie.isGridAsText()) {
                    if (this.iRoom.getAvailability() != null && !this.iRoom.getAvailability().isEmpty()) {
                        p = new P("text");
                        p.setHTML(this.iRoom.getAvailability());
                        this.add((Widget)p);
                    }
                } else {
                    Image availability = new Image(GWT.getHostPageBaseURL() + "pattern?loc=" + this.iRoom.getUniqueId() + "&v=" + (cookie.areRoomsHorizontal() ? "0" : "1") + (String)(cookie.hasMode() ? "&s=" + cookie.getMode() : ""));
                    availability.setStyleName("grid");
                    this.add((Widget)availability);
                }
                if (this.iRoom.getRoomSharingNote() != null && !this.iRoom.getRoomSharingNote().isEmpty()) {
                    p = new P("note");
                    p.setHTML(this.iRoom.getRoomSharingNote());
                    p.setTitle(this.iRoom.getRoomSharingNote());
                    this.add((Widget)p);
                }
            }
        }
    }

    public static class DepartmentCell
    extends P
    implements HasRefresh {
        boolean iExt;
        Map<RoomInterface.DepartmentInterface, P> iP = new HashMap<RoomInterface.DepartmentInterface, P>();

        public DepartmentCell(boolean ext, RoomInterface.DepartmentInterface ... departments) {
            super("departments");
            this.iExt = ext;
            for (RoomInterface.DepartmentInterface department : departments) {
                if (department == null) continue;
                P p = new P("department");
                p.setText(RoomsTable.toString(department, this.iExt));
                if (department.getTitle() != null) {
                    p.setTitle(department.getTitle());
                }
                if (department.getColor() != null) {
                    p.getElement().getStyle().setColor(department.getColor());
                }
                this.add((Widget)p);
                this.iP.put(department, p);
            }
        }

        public DepartmentCell(boolean ext, List<RoomInterface.DepartmentInterface> departments, RoomInterface.DepartmentInterface control, boolean all) {
            super("departments");
            this.iExt = ext;
            if (all) {
                P p = new P("department", "all");
                p.setText(MESSAGES.departmentsAllLabel());
                p.setTitle(MESSAGES.departmentsAllTitle());
                this.add((Widget)p);
            } else {
                for (RoomInterface.DepartmentInterface department : departments) {
                    P p = new P("department");
                    p.setText(RoomsTable.toString(department, this.iExt));
                    if (department.getTitle() != null) {
                        p.setTitle(department.getTitle());
                    }
                    if (department.getColor() != null) {
                        p.getElement().getStyle().setColor(department.getColor());
                    }
                    if (department.equals(control)) {
                        p.addStyleName("control");
                    }
                    this.iP.put(department, p);
                    this.add((Widget)p);
                }
            }
        }

        @Override
        public void refresh() {
            for (Map.Entry<RoomInterface.DepartmentInterface, P> e : this.iP.entrySet()) {
                e.getValue().setText(RoomsTable.toString(e.getKey(), this.iExt));
            }
        }
    }

    public static class ExamTypesCell
    extends P {
        public ExamTypesCell(final Long roomId, List<RoomInterface.ExamTypeInterface> examTypes) {
            super("exam-types");
            for (final RoomInterface.ExamTypeInterface examType : examTypes) {
                final P p = new P(examType.isFinal() ? "final" : "midterm");
                p.setText(examType.getLabel());
                p.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent event) {
                        PeriodPreferencesHint.showHint((Element)p.getElement(), roomId, examType.getId());
                    }
                });
                p.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent event) {
                        PeriodPreferencesHint.hideHint();
                    }
                });
                this.add((Widget)p);
            }
        }
    }

    public static class PeriodPreferenceCell
    extends P
    implements HasRefresh {
        private RoomInterface.RoomDetailInterface iRoom;
        private RoomInterface.ExamTypeInterface iType;

        public PeriodPreferenceCell(RoomInterface.RoomDetailInterface room, RoomInterface.ExamTypeInterface type) {
            super("periodpref");
            this.iRoom = room;
            this.iType = type;
            this.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    PeriodPreferencesHint.showHint((Element)this.getElement(), iRoom.getUniqueId(), iType.getId());
                }
            });
            this.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    RoomSharingHint.hideHint();
                }
            });
            this.refresh();
        }

        @Override
        public void refresh() {
            this.clear();
            this.setHTML("");
            RoomCookie cookie = RoomCookie.getInstance();
            if (cookie.isGridAsText() || !this.iType.isFinal()) {
                if (this.iRoom.getPeriodPreference() != null) {
                    this.setHTML(this.iRoom.getPeriodPreference());
                }
            } else {
                this.add((Widget)new Image(GWT.getHostPageBaseURL() + "pattern?loc=" + this.iRoom.getUniqueId() + "&xt=" + this.iType.getId() + "&v=" + (cookie.areRoomsHorizontal() ? "0" : "1") + (String)(cookie.hasMode() ? "&s=" + cookie.getMode() : "")));
            }
        }
    }

    public static class StatusCell
    extends P {
        public StatusCell(Integer status, Integer defaultStatus) {
            super("status");
            if (status != null) {
                this.setHTML(CONSTANTS.eventStatusAbbv()[status]);
                this.setTitle(CONSTANTS.eventStatusName()[status]);
            } else if (defaultStatus != null) {
                this.addStyleName("default");
                this.setHTML(CONSTANTS.eventStatusAbbv()[defaultStatus]);
                this.setTitle(CONSTANTS.eventStatusName()[defaultStatus]);
            } else {
                this.setHTML(CONSTANTS.eventStatusAbbv()[0]);
                this.setTitle(CONSTANTS.eventStatusName()[0]);
            }
        }
    }

    public static class NoteCell
    extends P {
        public NoteCell(String note, String defaultNote) {
            super("note");
            if (note != null) {
                this.setHTML(note.replace("\\n", "<br>"));
                this.setTitle(note);
            } else if (defaultNote != null) {
                this.addStyleName("default");
                this.setHTML(defaultNote.replace("\\n", "<br>"));
                this.setTitle(defaultNote);
            }
        }
    }

    public static class BreakTimeCell
    extends P {
        public BreakTimeCell(Integer breakTime, Integer defaultBreakTime) {
            super("break");
            if (breakTime != null) {
                if (breakTime != 0) {
                    this.setText(breakTime.toString());
                }
            } else if (defaultBreakTime != null) {
                this.addStyleName("default");
                if (defaultBreakTime != 0) {
                    this.setText(defaultBreakTime.toString());
                }
            }
        }
    }

    public static class GroupsCell
    extends P
    implements HasRefresh {
        Map<RoomInterface.GroupInterface, P> iGroups = new HashMap<RoomInterface.GroupInterface, P>();

        public GroupsCell(List<? extends RoomInterface.GroupInterface> groups) {
            this.setStyleName("groups");
            for (RoomInterface.GroupInterface groupInterface : groups) {
                P p = new P("group");
                p.setText(groupInterface.getLabel());
                if (groupInterface.getTitle() != null) {
                    p.setTitle(groupInterface.getTitle());
                }
                if (groupInterface.getDepartment() != null) {
                    p.setText(groupInterface.getLabel() + " (" + RoomsTable.toString(groupInterface.getDepartment(), true) + ")");
                    if (groupInterface.getDepartment().getColor() != null) {
                        p.getElement().getStyle().setColor(groupInterface.getDepartment().getColor());
                    }
                }
                this.iGroups.put(groupInterface, p);
                this.add((Widget)p);
            }
        }

        @Override
        public void refresh() {
            for (Map.Entry<RoomInterface.GroupInterface, P> e : this.iGroups.entrySet()) {
                P p = e.getValue();
                RoomInterface.GroupInterface group = e.getKey();
                if (group.getDepartment() == null) continue;
                p.setText(group.getLabel() + " (" + RoomsTable.toString(group.getDepartment(), true) + ")");
            }
        }
    }

    public static class FeaturesCell
    extends P
    implements HasRefresh {
        Map<RoomInterface.FeatureInterface, P> iFeatures = new HashMap<RoomInterface.FeatureInterface, P>();

        public FeaturesCell(List<? extends RoomInterface.FeatureInterface> features) {
            this.setStyleName("features");
            for (RoomInterface.FeatureInterface featureInterface : features) {
                P p = new P("feature");
                p.setText(featureInterface.getLabel());
                if (featureInterface.getTitle() != null) {
                    p.setTitle(featureInterface.getTitle());
                }
                if (featureInterface.getDepartment() != null) {
                    p.setText(featureInterface.getLabel() + " (" + RoomsTable.toString(featureInterface.getDepartment(), true) + ")");
                    if (featureInterface.getDepartment().getColor() != null) {
                        p.getElement().getStyle().setColor(featureInterface.getDepartment().getColor());
                    }
                }
                this.iFeatures.put(featureInterface, p);
                this.add((Widget)p);
            }
        }

        @Override
        public void refresh() {
            for (Map.Entry<RoomInterface.FeatureInterface, P> e : this.iFeatures.entrySet()) {
                P p = e.getValue();
                RoomInterface.FeatureInterface feature = e.getKey();
                if (feature.getDepartment() == null) continue;
                p.setText(feature.getLabel() + " (" + RoomsTable.toString(feature.getDepartment(), true) + ")");
            }
        }
    }

    public static class ServicesCell
    extends P
    implements HasRefresh {
        Map<EventInterface.EventServiceProviderInterface, P> iServices = new HashMap<EventInterface.EventServiceProviderInterface, P>();
        RoomInterface.DepartmentInterface iDepartment;

        public ServicesCell(Set<? extends EventInterface.EventServiceProviderInterface> services, RoomInterface.DepartmentInterface department) {
            this.iDepartment = department;
            this.setStyleName("services");
            for (EventInterface.EventServiceProviderInterface eventServiceProviderInterface : services) {
                P p = new P("group");
                p.setText(eventServiceProviderInterface.getLabel());
                if (eventServiceProviderInterface.hasMessage()) {
                    p.setTitle(eventServiceProviderInterface.getMessage());
                }
                if (eventServiceProviderInterface.getDepartmentId() != null && department != null) {
                    p.setText(eventServiceProviderInterface.getLabel() + " (" + RoomsTable.toString(department, true) + ")");
                }
                this.iServices.put(eventServiceProviderInterface, p);
                this.add((Widget)p);
            }
        }

        @Override
        public void refresh() {
            for (Map.Entry<EventInterface.EventServiceProviderInterface, P> e : this.iServices.entrySet()) {
                P p = e.getValue();
                EventInterface.EventServiceProviderInterface service = e.getKey();
                if (service.getDepartmentId() == null || this.iDepartment == null) continue;
                p.setText(service.getLabel() + " (" + RoomsTable.toString(this.iDepartment, true) + ")");
            }
        }
    }

    public static interface SortOperation
    extends UniTimeTableHeader.Operation,
    UniTimeTableHeader.HasColumnName {
    }

    public static interface Check {
        public boolean isChecked();
    }

    public static class LinkCell
    extends ImageLink {
        LinkCell(RoomInterface.RoomPictureInterface picture) {
            super(new Image(RESOURCES.download()), GWT.getHostPageBaseURL() + "picture?id=" + picture.getUniqueId());
            this.setStyleName("link");
            this.setTitle(picture.getName() + (String)(picture.getPictureType() == null ? "" : " (" + picture.getPictureType().getLabel() + ")"));
            this.setText(picture.getName() + (String)(picture.getPictureType() == null ? "" : " (" + picture.getPictureType().getAbbreviation() + ")"));
            this.setTarget("_blank");
            this.sinkEvents(1);
        }

        @Override
        public void onBrowserEvent(Event event) {
            if (event.getTypeInt() == 1) {
                event.stopPropagation();
            }
            super.onBrowserEvent(event);
        }
    }

    public static class PictureCell
    extends Image {
        private RoomInterface.RoomPictureInterface iPicture;
        private P iPopupWidget = null;

        public PictureCell(RoomInterface.RoomPictureInterface picture) {
            this.iPicture = picture;
            this.setStyleName("picture");
            this.setUrl(GWT.getHostPageBaseURL() + "picture?id=" + picture.getUniqueId());
            this.setAltText(picture.getName() + (String)(picture.getPictureType() == null ? "" : " (" + picture.getPictureType().getAbbreviation() + ")"));
            this.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    GwtHint.showHint((Element)this.getElement(), (Widget)this.getPopupWidget());
                }
            });
            this.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    GwtHint.hideHint();
                }
            });
        }

        protected P getPopupWidget() {
            if (this.iPopupWidget == null) {
                this.iPopupWidget = new P("unitime-RoomPictureHint");
                Image image = new Image(GWT.getHostPageBaseURL() + "picture?id=" + this.iPicture.getUniqueId());
                image.setStyleName("picture");
                this.iPopupWidget.add((Widget)image);
                P caption = new P("caption");
                caption.setText(this.iPicture.getName() + (String)(this.iPicture.getPictureType() == null ? "" : " (" + this.iPicture.getPictureType().getAbbreviation() + ")"));
                this.iPopupWidget.add((Widget)caption);
            }
            return this.iPopupWidget;
        }
    }

    public static class RoomCell
    extends Label {
        public RoomCell(RoomInterface.RoomPropertyInterface property) {
            super(property == null ? "" : property.getLabel());
            if (property != null) {
                if (property.getTitle() != null) {
                    this.setTitle(property.getTitle());
                }
                if (property.getColor() != null) {
                    this.getElement().getStyle().setColor(property.getColor());
                }
            }
        }
    }
}

