/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.Client;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.events.AcademicSessionSelectionBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageHeader;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.rooms.RoomDepartmentsEdit;
import org.unitime.timetable.gwt.client.rooms.RoomDetail;
import org.unitime.timetable.gwt.client.rooms.RoomEdit;
import org.unitime.timetable.gwt.client.rooms.RoomFilterBox;
import org.unitime.timetable.gwt.client.rooms.RoomsTable;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomsPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private AcademicSessionProvider iSession = null;
    private RoomFilterBox iFilter = null;
    private AriaButton iSearch = null;
    private AriaButton iNew = null;
    private AriaButton iMore = null;
    private AriaButton iEditRoomSharing = null;
    private RoomsTable iRoomsTable = null;
    private RoomDetail iRoomDetail = null;
    private VerticalPanel iRoomsPanel = null;
    private SimplePanel iRootPanel;
    private SimplePanel iPanel = null;
    private SimpleForm iFilterForm = null;
    private HorizontalPanel iFilterPanel = null;
    private RoomInterface.RoomsPageMode iMode = RoomInterface.RoomsPageMode.COURSES;
    private RoomInterface.RoomPropertiesInterface iProperties = null;
    private RoomEdit iRoomEdit;
    private RoomDepartmentsEdit iRoomDepartmentsEdit;
    private UniTimeHeaderPanel iHeaderPanel = null;
    private HistoryToken iHistoryToken = null;
    private boolean iInitialized = false;

    public RoomsPage() {
        if (Window.Location.getParameter((String)"mode") != null) {
            this.iMode = RoomInterface.RoomsPageMode.valueOf(Window.Location.getParameter((String)"mode").toUpperCase());
        }
        this.iHistoryToken = new HistoryToken(this.iMode);
        this.iPanel = new SimplePanel();
        this.iRoomsPanel = new VerticalPanel();
        this.iRoomsPanel.addStyleName("unitime-RoomsPanel");
        this.iRoomsPanel.setWidth("100%");
        ClickHandler clickSearch = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomsPage.this.changeUrl();
                RoomsPage.this.search(null);
            }
        };
        ClickHandler clickNew = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomsPage.this.iRoomEdit.setRoom(null);
                RoomsPage.this.iRoomEdit.show();
            }
        };
        ClickHandler clickMore = new ClickHandler(){

            public void onClick(ClickEvent event) {
                List<UniTimeTableHeader.Operation> depts;
                MenuItem item;
                List<UniTimeTableHeader.Operation> sorts;
                if (RoomsPage.this.iRoomsTable == null) {
                    return;
                }
                final PopupPanel popup = new PopupPanel(true);
                UniTimeTableHeader.MenuBarWithAccessKeys menu = new UniTimeTableHeader.MenuBarWithAccessKeys();
                if (RoomsPage.this.iProperties != null && RoomsPage.this.iProperties.isCanSaveFilterDefaults()) {
                    MenuItem item3 = new MenuItem(MESSAGES.buttonClear(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            RoomsPage.this.iFilter.setValue(RoomsPage.this.iHistoryToken.getDefaultParameter("q", ""), true);
                            RoomsPage.this.hideResults();
                            RoomsPage.this.changeUrl();
                        }
                    });
                    Roles.getMenuitemRole().setAriaLabelProperty((Element)item3.getElement(), UniTimeHeaderPanel.stripAccessKey(MESSAGES.buttonClear()));
                    menu.addItem(item3);
                    menu.addSeparator();
                }
                boolean first = true;
                List<UniTimeTableHeader.Operation> showHide = RoomsPage.this.iRoomsTable.getShowHideOperations();
                if (!showHide.isEmpty()) {
                    MenuBar submenu = new MenuBar(true);
                    for (final UniTimeTableHeader.Operation operation : showHide) {
                        MenuItem menuItem = new MenuItem(operation.getName(), true, (Scheduler.ScheduledCommand)new Command(){

                            public void execute() {
                                popup.hide();
                                operation.execute();
                            }
                        });
                        if (operation instanceof UniTimeTableHeader.AriaOperation) {
                            Roles.getMenuitemRole().setAriaLabelProperty((Element)menuItem.getElement(), ((UniTimeTableHeader.AriaOperation)operation).getAriaLabel());
                        } else {
                            Roles.getMenuitemRole().setAriaLabelProperty((Element)menuItem.getElement(), UniTimeHeaderPanel.stripAccessKey(operation.getName()));
                        }
                        submenu.addItem(menuItem);
                    }
                    MenuItem columns = new MenuItem(MESSAGES.opColumns(), submenu);
                    columns.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    menu.addItem(columns);
                    first = false;
                }
                if (!(sorts = RoomsPage.this.iRoomsTable.getSortOperations()).isEmpty()) {
                    MenuBar submenu = new MenuBar(true);
                    for (final UniTimeTableHeader.Operation operation : sorts) {
                        String name = operation.getName();
                        if (operation instanceof UniTimeTableHeader.HasColumnName) {
                            name = ((UniTimeTableHeader.HasColumnName)((Object)operation)).getColumnName();
                        }
                        item = new MenuItem(name, true, (Scheduler.ScheduledCommand)new Command(){

                            public void execute() {
                                popup.hide();
                                operation.execute();
                            }
                        });
                        if (operation instanceof UniTimeTableHeader.AriaOperation) {
                            Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), ((UniTimeTableHeader.AriaOperation)operation).getAriaLabel());
                        } else {
                            Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), UniTimeHeaderPanel.stripAccessKey(operation.getName()));
                        }
                        submenu.addItem(item);
                    }
                    MenuItem menuItem = new MenuItem(MESSAGES.opSort(), submenu);
                    menuItem.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    menu.addItem(menuItem);
                    first = false;
                }
                if (RoomsPage.this.iRoomsTable.hasDepartmentOperations() && !(depts = RoomsPage.this.iRoomsTable.getDepartmentOperations()).isEmpty()) {
                    MenuBar menuBar = new MenuBar(true);
                    for (final UniTimeTableHeader.Operation op : depts) {
                        item = new MenuItem(op.getName(), true, (Scheduler.ScheduledCommand)new Command(){

                            public void execute() {
                                popup.hide();
                                op.execute();
                            }
                        });
                        if (op instanceof UniTimeTableHeader.AriaOperation) {
                            Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), ((UniTimeTableHeader.AriaOperation)op).getAriaLabel());
                        } else {
                            Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), UniTimeHeaderPanel.stripAccessKey(op.getName()));
                        }
                        menuBar.addItem(item);
                    }
                    MenuItem menuItem = new MenuItem(MESSAGES.opDepartmentFormat(), menuBar);
                    menuItem.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    menu.addItem(menuItem);
                    first = false;
                }
                if (RoomsPage.this.iRoomsTable.hasOrientationOperations()) {
                    MenuBar orientation = null;
                    if (!RoomCookie.getInstance().isGridAsText()) {
                        if (orientation == null) {
                            orientation = new MenuBar(true);
                        }
                        MenuItem menuItem = new MenuItem(MESSAGES.opOrientationAsText(), true, (Scheduler.ScheduledCommand)new Command(){

                            public void execute() {
                                popup.hide();
                                RoomCookie.getInstance().setOrientation(true, RoomCookie.getInstance().areRoomsHorizontal());
                                RoomsPage.this.iRoomsTable.refreshTable();
                            }
                        });
                        Roles.getMenuitemRole().setAriaLabelProperty((Element)menuItem.getElement(), MESSAGES.opOrientationAsText());
                        orientation.addItem(menuItem);
                    }
                    if (RoomCookie.getInstance().isGridAsText()) {
                        if (orientation == null) {
                            orientation = new MenuBar(true);
                        }
                        MenuItem menuItem = new MenuItem(MESSAGES.opOrientationAsGrid(), true, (Scheduler.ScheduledCommand)new Command(){

                            public void execute() {
                                popup.hide();
                                RoomCookie.getInstance().setOrientation(false, RoomCookie.getInstance().areRoomsHorizontal());
                                RoomsPage.this.iRoomsTable.refreshTable();
                            }
                        });
                        Roles.getMenuitemRole().setAriaLabelProperty((Element)menuItem.getElement(), MESSAGES.opOrientationAsGrid());
                        orientation.addItem(menuItem);
                    }
                    if (!RoomCookie.getInstance().isGridAsText() && RoomCookie.getInstance().areRoomsHorizontal()) {
                        if (orientation == null) {
                            orientation = new MenuBar(true);
                        }
                        MenuItem menuItem = new MenuItem(MESSAGES.opOrientationVertical(), true, (Scheduler.ScheduledCommand)new Command(){

                            public void execute() {
                                popup.hide();
                                RoomCookie.getInstance().setOrientation(false, false);
                                RoomsPage.this.iRoomsTable.refreshTable();
                            }
                        });
                        Roles.getMenuitemRole().setAriaLabelProperty((Element)menuItem.getElement(), MESSAGES.opOrientationVertical());
                        orientation.addItem(menuItem);
                    }
                    if (!RoomCookie.getInstance().isGridAsText() && !RoomCookie.getInstance().areRoomsHorizontal()) {
                        if (orientation == null) {
                            orientation = new MenuBar(true);
                        }
                        MenuItem menuItem = new MenuItem(MESSAGES.opOrientationHorizontal(), true, (Scheduler.ScheduledCommand)new Command(){

                            public void execute() {
                                popup.hide();
                                RoomCookie.getInstance().setOrientation(false, true);
                                RoomsPage.this.iRoomsTable.refreshTable();
                            }
                        });
                        Roles.getMenuitemRole().setAriaLabelProperty((Element)menuItem.getElement(), MESSAGES.opOrientationHorizontal());
                        orientation.addItem(menuItem);
                    }
                    if (RoomsPage.this.iProperties != null && RoomsPage.this.iProperties.hasModes() && !RoomCookie.getInstance().isGridAsText()) {
                        boolean bl = true;
                        for (final RoomInterface.RoomSharingDisplayMode mode : RoomsPage.this.iProperties.getModes()) {
                            boolean bl2;
                            if (mode.toHex().equals(RoomCookie.getInstance().getMode())) continue;
                            if (orientation == null) {
                                orientation = new MenuBar(true);
                            } else if (bl2) {
                                orientation.addSeparator();
                            }
                            bl2 = false;
                            item = new MenuItem(mode.getName(), true, (Scheduler.ScheduledCommand)new Command(){

                                public void execute() {
                                    popup.hide();
                                    RoomCookie.getInstance().setMode(RoomCookie.getInstance().areRoomsHorizontal(), mode.toHex());
                                    RoomsPage.this.iRoomsTable.refreshTable();
                                }
                            });
                            Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), mode.getName());
                            orientation.addItem(item);
                        }
                    }
                    if (orientation != null) {
                        MenuItem menuItem = new MenuItem(MESSAGES.opOrientation(), orientation);
                        menuItem.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                        menu.addItem(menuItem);
                        first = false;
                    }
                }
                for (final UniTimeTableHeader.Operation operation : RoomsPage.this.iRoomsTable.getOtherOperations()) {
                    MenuItem menuItem = new MenuItem(operation.getName(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            operation.execute();
                        }
                    });
                    if (operation instanceof UniTimeTableHeader.AriaOperation) {
                        Roles.getMenuitemRole().setAriaLabelProperty((Element)menuItem.getElement(), ((UniTimeTableHeader.AriaOperation)operation).getAriaLabel());
                    } else {
                        Roles.getMenuitemRole().setAriaLabelProperty((Element)menuItem.getElement(), UniTimeHeaderPanel.stripAccessKey(operation.getName()));
                    }
                    if (operation.hasSeparator() && !first) {
                        menu.addSeparator();
                    }
                    menu.addItem(menuItem);
                    first = false;
                }
                popup.add((Widget)menu);
                popup.showRelativeTo((UIObject)event.getSource());
                menu.focus();
            }
        };
        ClickHandler clickEditRoomSharing = new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventInterface.RoomFilterRpcRequest request = (EventInterface.RoomFilterRpcRequest)RoomsPage.this.iFilter.getElementsRequest();
                request.getOptions().remove("department");
                LoadingWidget.execute(request, new AsyncCallback<EventInterface.FilterRpcResponse>(){

                    public void onFailure(Throwable caught) {
                        RoomsPage.this.iFilter.setErrorHint(MESSAGES.failedToLoadRooms(caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedToLoadRooms(caught.getMessage()), caught);
                    }

                    public void onSuccess(EventInterface.FilterRpcResponse result) {
                        RoomsPage.this.iFilter.clearHint();
                        if (result == null || result.getResults() == null || result.getResults().isEmpty()) {
                            RoomsPage.this.iFilter.setErrorHint(MESSAGES.errorNoRoomsMatchingFilter());
                            UniTimeNotifications.error(MESSAGES.errorNoRoomsMatchingFilter());
                        } else {
                            RoomsPage.this.iRoomDepartmentsEdit.setRooms(result.getResults(), RoomsPage.this.iRoomsTable.hasSortBy() ? Integer.valueOf(RoomsPage.this.iRoomsTable.getSortBy()) : null);
                            RoomsPage.this.iRoomDepartmentsEdit.show();
                        }
                    }
                }, MESSAGES.waitLoadingRooms());
            }
        };
        if (this.iMode.hasSessionSelection()) {
            this.iFilterForm = new SimpleForm();
            this.iHeaderPanel = new UniTimeHeaderPanel(MESSAGES.sectFilter());
            this.iFilterForm.addHeaderRow((Widget)this.iHeaderPanel);
            this.iSession = new AcademicSessionSelectionBox(this.iHistoryToken.getParameter("term"), "Rooms"){

                @Override
                protected void onInitializationSuccess(List<AcademicSessionSelectionBox.AcademicSession> sessions) {
                    RoomsPage.this.iFilterForm.setVisible(sessions != null && !sessions.isEmpty());
                    UniTimePageHeader.getInstance().getRight().setVisible(false);
                    UniTimePageHeader.getInstance().getRight().setPreventDefault(true);
                    RoomsPage.this.setup(this.getAcademicSessionId(), CONSTANTS.searchWhenPageIsLoaded() && (RoomsPage.this.iHistoryToken.hasParameter("id") || RoomsPage.this.iHistoryToken.hasParameter("q")));
                }

                @Override
                protected void onInitializationFailure(Throwable caught) {
                    UniTimeNotifications.error(MESSAGES.failedLoadSessions(caught.getMessage()), caught);
                }
            };
            this.iSession.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

                @Override
                public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                    RoomsPage.this.setup(event.getNewAcademicSessionId(), RoomsPage.this.iRoomsTable != null && RoomsPage.this.iRoomsTable.isVisible() && RoomsPage.this.iRoomsTable.getRowCount() > 1);
                }
            });
            this.iFilterForm.addRow(MESSAGES.propAcademicSession(), (Widget)this.iSession);
            this.iFilter = new RoomFilterBox(this.iSession);
            this.iFilterForm.addRow(MESSAGES.propRoomFilter(), (Widget)this.iFilter);
            this.iRoomsPanel.add((Widget)this.iFilterForm);
            this.iHeaderPanel.addButton("search", MESSAGES.buttonSearch(), clickSearch);
            this.iHeaderPanel.addButton("more", MESSAGES.buttonMoreOperations(), clickMore);
            this.iHeaderPanel.addButton("new", MESSAGES.buttonAddNewRoom(), clickNew);
            this.iHeaderPanel.addButton("sharing", MESSAGES.buttonEditRoomSharing(), clickEditRoomSharing);
            this.iHeaderPanel.setEnabled("more", false);
            this.iHeaderPanel.setEnabled("new", false);
            this.iHeaderPanel.setEnabled("sharing", false);
        } else {
            this.iFilterPanel = new HorizontalPanel();
            this.iFilterPanel.setSpacing(3);
            Label filterLabel = new Label(MESSAGES.propFilter());
            this.iFilterPanel.add((Widget)filterLabel);
            this.iFilterPanel.setCellVerticalAlignment((Widget)filterLabel, HasVerticalAlignment.ALIGN_MIDDLE);
            this.iSession = new Session();
            this.iFilter = new RoomFilterBox(this.iSession);
            this.iFilterPanel.add((Widget)this.iFilter);
            this.iSearch = new AriaButton(MESSAGES.buttonSearch());
            this.iSearch.addStyleName("unitime-NoPrint");
            this.iSearch.addClickHandler(clickSearch);
            this.iFilterPanel.add((Widget)this.iSearch);
            this.iMore = new AriaButton(MESSAGES.buttonMoreOperations());
            this.iMore.setEnabled(false);
            this.iMore.addStyleName("unitime-NoPrint");
            this.iMore.addClickHandler(clickMore);
            this.iFilterPanel.add((Widget)this.iMore);
            this.iNew = new AriaButton(MESSAGES.buttonAddNewRoom());
            this.iNew.setEnabled(false);
            this.iNew.addStyleName("unitime-NoPrint");
            this.iNew.addClickHandler(clickNew);
            this.iFilterPanel.add((Widget)this.iNew);
            this.iEditRoomSharing = new AriaButton(MESSAGES.buttonEditRoomSharing());
            this.iEditRoomSharing.setEnabled(false);
            this.iEditRoomSharing.setVisible(false);
            this.iEditRoomSharing.addStyleName("unitime-NoPrint");
            this.iEditRoomSharing.addClickHandler(clickEditRoomSharing);
            this.iFilterPanel.add((Widget)this.iEditRoomSharing);
            this.iRoomsPanel.add((Widget)this.iFilterPanel);
            this.iRoomsPanel.setCellHorizontalAlignment((Widget)this.iFilterPanel, HasHorizontalAlignment.ALIGN_CENTER);
            this.setup(null, CONSTANTS.searchWhenPageIsLoaded() && (this.iHistoryToken.hasParameter("id") || this.iHistoryToken.hasParameter("q")));
        }
        this.iRoomsTable = new RoomsTable(this.iMode);
        this.iRoomsTable.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
        ScrollPanel scroll = new ScrollPanel((Widget)this.iRoomsTable);
        scroll.addStyleName("scroll");
        this.iRoomsPanel.add((Widget)scroll);
        this.iRootPanel = new SimplePanel((Widget)this.iRoomsPanel);
        this.iPanel.setWidget((Widget)this.iRootPanel);
        this.initWidget((Widget)this.iPanel);
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (!RoomsPage.this.iInitialized) {
                    return;
                }
                if ("id=add".equals(event.getValue())) {
                    RoomsPage.this.iHistoryToken.parse((String)event.getValue());
                } else {
                    RoomsPage.this.iHistoryToken.reset((String)event.getValue());
                }
                RoomsPage.this.updateFilter(RoomsPage.this.iRoomsTable.isVisible());
            }
        });
        this.iRoomsTable.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                RoomsPage.this.export("rooms.pdf");
            }

            @Override
            public boolean isApplicable() {
                return RoomsPage.this.iRoomsTable.getRowCount() > 0 && RoomsPage.this.iProperties != null && RoomsPage.this.iProperties.isCanExportPdf();
            }

            @Override
            public boolean hasSeparator() {
                return false;
            }

            @Override
            public String getName() {
                return MESSAGES.opExportPDF();
            }
        });
        this.iRoomsTable.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                RoomsPage.this.export("rooms.csv");
            }

            @Override
            public boolean isApplicable() {
                return RoomsPage.this.iRoomsTable.getRowCount() > 0 && RoomsPage.this.iProperties != null && RoomsPage.this.iProperties.isCanExportCsv();
            }

            @Override
            public boolean hasSeparator() {
                return false;
            }

            @Override
            public String getName() {
                return MESSAGES.opExportCSV();
            }
        });
        this.iRoomsTable.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                RoomsPage.this.export("rooms.xls");
            }

            @Override
            public boolean isApplicable() {
                return RoomsPage.this.iRoomsTable.getRowCount() > 0 && RoomsPage.this.iProperties != null && RoomsPage.this.iProperties.isCanExportCsv();
            }

            @Override
            public boolean hasSeparator() {
                return false;
            }

            @Override
            public String getName() {
                return MESSAGES.opExportXLS();
            }
        });
        this.iRoomsTable.addMouseClickListener(new UniTimeTable.MouseClickListener<RoomInterface.RoomDetailInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<RoomInterface.RoomDetailInterface> event) {
                if (event.getData() == null || !event.getData().isCanShowDetail()) {
                    return;
                }
                RoomsPage.this.iRoomDetail.setRoom(event.getData());
                RoomsPage.this.iRoomDetail.show();
            }
        });
        this.iRoomDetail = new RoomDetail(this.iMode){

            @Override
            protected void onHide() {
                RoomsPage.this.iRootPanel.setWidget((Widget)RoomsPage.this.iRoomsPanel);
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageRooms());
                if (RoomsPage.this.iRoomsTable != null && RoomsPage.this.iRoomsTable.isVisible()) {
                    RoomsPage.this.search(this.getRoom() == null ? null : this.getRoom().getUniqueId());
                }
                RoomsPage.this.changeUrl();
            }

            @Override
            protected void onShow() {
                RoomsPage.this.iRootPanel.setWidget((Widget)RoomsPage.this.iRoomDetail);
                RoomsPage.this.changeUrl();
            }

            @Override
            protected void edit() {
                Long roomId;
                Long l = roomId = this.getRoom() == null ? null : this.getRoom().getUniqueId();
                if (roomId != null) {
                    RoomInterface.RoomFilterRpcRequest rooms = RoomsPage.this.iFilter.createRpcRequest();
                    rooms.setCommand(EventInterface.FilterRpcRequest.Command.ENUMERATE);
                    rooms.addOption("id", this.getRoom().getUniqueId().toString());
                    rooms.setSessionId(RoomsPage.this.iProperties.getAcademicSessionId());
                    LoadingWidget.execute(rooms, new AsyncCallback<EventInterface.FilterRpcResponse>(){

                        public void onFailure(Throwable caught) {
                            UniTimeNotifications.error(MESSAGES.failedToLoadRoomDetails(caught.getMessage()), caught);
                        }

                        public void onSuccess(EventInterface.FilterRpcResponse result) {
                            if (result == null || result.getResults() == null || result.getResults().isEmpty()) {
                                UniTimeNotifications.error(MESSAGES.errorRoomDoesNotExist(roomId.toString()));
                            } else {
                                RoomsPage.this.iRoomEdit.setRoom((RoomInterface.RoomDetailInterface)result.getResults().get(0));
                                RoomsPage.this.iRoomEdit.show();
                            }
                        }
                    }, MESSAGES.waitLoadingRoomDetails());
                } else {
                    this.hide();
                }
            }

            @Override
            protected RoomInterface.RoomDetailInterface getPrevious(Long roomId) {
                return RoomsPage.this.iRoomsTable == null ? null : RoomsPage.this.iRoomsTable.getPrevious(roomId);
            }

            @Override
            protected RoomInterface.RoomDetailInterface getNext(Long roomId) {
                return RoomsPage.this.iRoomsTable == null ? null : RoomsPage.this.iRoomsTable.getNext(roomId);
            }

            @Override
            protected void previous(RoomInterface.RoomDetailInterface room) {
                this.setRoom(room);
                RoomsPage.this.changeUrl();
            }

            @Override
            protected void next(RoomInterface.RoomDetailInterface room) {
                this.setRoom(room);
                RoomsPage.this.changeUrl();
            }

            @Override
            public void hide() {
                super.hide();
            }
        };
        this.iRoomEdit = new RoomEdit(this.iMode){

            @Override
            protected void onShow() {
                RoomsPage.this.iRootPanel.setWidget((Widget)RoomsPage.this.iRoomEdit);
                RoomsPage.this.changeUrl();
            }

            @Override
            protected void onHide(RoomInterface.RoomDetailInterface detail, boolean canShowDetail, String message) {
                if (!canShowDetail || detail == null && this.getRoom().getUniqueId() == null) {
                    RoomsPage.this.iRootPanel.setWidget((Widget)RoomsPage.this.iRoomsPanel);
                    UniTimePageLabel.getInstance().setPageName(MESSAGES.pageRooms());
                    if (RoomsPage.this.iRoomsTable.isVisible()) {
                        RoomsPage.this.search(detail == null ? null : detail.getUniqueId());
                    }
                } else {
                    if (detail != null) {
                        RoomsPage.this.iRoomDetail.setRoom(detail);
                    }
                    RoomsPage.this.iRoomDetail.show(message);
                }
                RoomsPage.this.changeUrl();
            }
        };
        this.iRoomDepartmentsEdit = new RoomDepartmentsEdit(){

            @Override
            protected void onShow() {
                RoomsPage.this.iRootPanel.setWidget((Widget)RoomsPage.this.iRoomDepartmentsEdit);
            }

            @Override
            protected void onHide(boolean refresh) {
                RoomsPage.this.iRootPanel.setWidget((Widget)RoomsPage.this.iRoomsPanel);
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageRooms());
                if (refresh && RoomsPage.this.iRoomsTable.isVisible()) {
                    RoomsPage.this.search(null);
                }
            }
        };
        this.iFilter.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (RoomsPage.this.iEditRoomSharing != null) {
                    RoomsPage.this.iEditRoomSharing.setEnabled(RoomsPage.this.iRoomDepartmentsEdit.setDepartmentOrExamType(RoomsPage.this.iFilter) && RoomsPage.this.iRoomDepartmentsEdit.canEdit());
                }
                if (RoomsPage.this.iHeaderPanel != null) {
                    RoomsPage.this.iHeaderPanel.setEnabled("sharing", RoomsPage.this.iProperties != null && (RoomsPage.this.iProperties.isCanEditRoomExams() || RoomsPage.this.iProperties.isCanEditDepartments()) && RoomsPage.this.iRoomDepartmentsEdit.setDepartmentOrExamType(RoomsPage.this.iFilter) && RoomsPage.this.iRoomDepartmentsEdit.canEdit());
                }
            }
        });
    }

    protected void setup(final Long sessionId, final boolean search) {
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingPage());
        RPC.execute(new RoomInterface.RoomPropertiesRequest(sessionId, this.iMode.name()), new AsyncCallback<RoomInterface.RoomPropertiesInterface>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                RoomsPage.this.iFilter.setErrorHint(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(RoomInterface.RoomPropertiesInterface result) {
                LoadingWidget.getInstance().hide();
                RoomsPage.this.iProperties = result;
                if (RoomsPage.this.iProperties.isCanSaveFilterDefaults()) {
                    RoomsPage.this.iHistoryToken.setDefaultParameter("q", result.getFilterDefault("filter"));
                    RoomsPage.this.iFilter.setDefaultValueProvider(new TakesValue<String>(){

                        public void setValue(final String value) {
                            RPC.execute(new EventInterface.SaveFilterDefaultRpcRequest(RoomsPage.this.iMode.name() + ".filter", RoomsPage.this.iFilter.getValue()), new AsyncCallback<GwtRpcResponse>(){

                                public void onFailure(Throwable caught) {
                                    UniTimeNotifications.error(MESSAGES.failedSaveAsDefault(caught.getMessage()), caught);
                                }

                                public void onSuccess(GwtRpcResponse result) {
                                    RoomsPage.this.iHistoryToken.setDefaultParameter("q", value);
                                }
                            });
                        }

                        public String getValue() {
                            return RoomsPage.this.iHistoryToken.getDefaultParameter("q", "");
                        }
                    });
                } else {
                    if (result.hasFilterDefault("filter")) {
                        RoomsPage.this.iHistoryToken.setDefaultParameter("q", result.getFilterDefault("filter"));
                    }
                    RoomsPage.this.iFilter.setDefaultValueProvider(null);
                }
                if (!RoomCookie.getInstance().hasOrientation()) {
                    RoomCookie.getInstance().setOrientation(RoomsPage.this.iProperties.isGridAsText(), RoomsPage.this.iProperties.isHorizontal());
                }
                RoomsPage.this.iRoomDetail.setProperties(RoomsPage.this.iProperties);
                RoomsPage.this.iRoomsTable.setProperties(RoomsPage.this.iProperties);
                RoomsPage.this.iRoomEdit.setProperties(RoomsPage.this.iProperties);
                RoomsPage.this.iRoomDepartmentsEdit.setProperties(RoomsPage.this.iProperties);
                if (RoomsPage.this.iSession instanceof Session) {
                    ((Session)RoomsPage.this.iSession).fireChange();
                }
                if (RoomsPage.this.iNew != null) {
                    RoomsPage.this.iNew.setEnabled(RoomsPage.this.iProperties.isCanAddRoom() || RoomsPage.this.iProperties.isCanAddNonUniversity());
                }
                if (RoomsPage.this.iHeaderPanel != null) {
                    RoomsPage.this.iHeaderPanel.setEnabled("new", RoomsPage.this.iProperties.isCanAddRoom() || RoomsPage.this.iProperties.isCanAddNonUniversity());
                }
                if (RoomsPage.this.iEditRoomSharing != null) {
                    RoomsPage.this.iEditRoomSharing.setVisible(RoomsPage.this.iProperties.isCanEditRoomExams() || RoomsPage.this.iProperties.isCanEditDepartments());
                    RoomsPage.this.iEditRoomSharing.setEnabled(RoomsPage.this.iRoomDepartmentsEdit.setDepartmentOrExamType(RoomsPage.this.iFilter) && RoomsPage.this.iRoomDepartmentsEdit.canEdit());
                }
                if (RoomsPage.this.iHeaderPanel != null) {
                    RoomsPage.this.iHeaderPanel.setEnabled("sharing", RoomsPage.this.iProperties != null && (RoomsPage.this.iProperties.isCanEditRoomExams() || RoomsPage.this.iProperties.isCanEditDepartments()) && RoomsPage.this.iRoomDepartmentsEdit.setDepartmentOrExamType(RoomsPage.this.iFilter) && RoomsPage.this.iRoomDepartmentsEdit.canEdit());
                }
                if (sessionId != null && RoomsPage.this.iSession instanceof AcademicSessionSelectionBox) {
                    RoomsPage.this.iHistoryToken.setParameter("term", ((AcademicSessionSelectionBox)RoomsPage.this.iSession).getAcademicSessionAbbreviation());
                    RoomsPage.this.iHistoryToken.mark();
                }
                RoomsPage.this.updateFilter(search);
                RoomsPage.this.iInitialized = true;
            }
        });
    }

    protected void updateFilter(boolean search) {
        this.iFilter.setValue(this.iHistoryToken.getParameter("q"), true);
        if (this.iSession instanceof AcademicSessionSelectionBox && this.iHistoryToken.isChanged("term", ((AcademicSessionSelectionBox)this.iSession).getAcademicSessionAbbreviation()) && this.iHistoryToken.getParameter("term") != null) {
            ((AcademicSessionSelectionBox)this.iSession).selectSession(this.iHistoryToken.getParameter("term"), null);
        }
        if (this.iHistoryToken.hasParameter("id")) {
            if ("add".equals(this.iHistoryToken.getParameter("id"))) {
                this.iRoomEdit.setRoom(null);
                this.iRoomEdit.show();
            } else {
                final Long roomId = Long.valueOf(this.iHistoryToken.getParameter("id"));
                RoomInterface.RoomFilterRpcRequest rooms = this.iFilter.createRpcRequest();
                rooms.setCommand(EventInterface.FilterRpcRequest.Command.ENUMERATE);
                rooms.addOption("id", roomId.toString());
                this.iFilter.setValue(this.iHistoryToken.getParameter("q"), true);
                rooms.setSessionId(this.iProperties.getAcademicSessionId());
                LoadingWidget.execute(rooms, new AsyncCallback<EventInterface.FilterRpcResponse>(){

                    public void onFailure(Throwable caught) {
                        UniTimeNotifications.error(MESSAGES.failedToLoadRoomDetails(caught.getMessage()), caught);
                    }

                    public void onSuccess(EventInterface.FilterRpcResponse result) {
                        if (result == null || result.getResults() == null || result.getResults().isEmpty()) {
                            UniTimeNotifications.error(MESSAGES.errorRoomDoesNotExist(roomId.toString()));
                        } else {
                            RoomsPage.this.iRoomDetail.setRoom((RoomInterface.RoomDetailInterface)result.getResults().get(0));
                            RoomsPage.this.iRoomDetail.show();
                        }
                    }
                }, MESSAGES.waitLoadingRoomDetails());
            }
        } else if (this.iRoomDetail != null && ((Object)((Object)this.iRoomDetail)).equals(this.iRootPanel.getWidget())) {
            this.iRoomDetail.hide();
        } else if (this.iRoomEdit != null && ((Object)((Object)this.iRoomEdit)).equals(this.iRootPanel.getWidget())) {
            this.iRoomEdit.hide(this.iRoomEdit.getRoom(), false, null);
        } else if (this.iRoomDepartmentsEdit != null && ((Object)((Object)this.iRoomDepartmentsEdit)).equals(this.iRootPanel.getWidget())) {
            this.iRoomDepartmentsEdit.hide();
        } else if (search) {
            this.search(null);
        }
    }

    protected void export(String format) {
        RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(this.query(format)), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
            }
        });
    }

    protected String query(String format) {
        Object rooms;
        RoomCookie cookie = RoomCookie.getInstance();
        int flags = this.iRoomsTable == null ? cookie.getFlags(this.iMode) : cookie.getFlags(this.iMode) & this.iRoomsTable.getFlags();
        String query = "output=" + format + "&flags=" + flags + "&sort=" + cookie.getRoomsSortBy() + "&orientation=" + (cookie.isGridAsText() ? "text" : (cookie.areRoomsHorizontal() ? "horizontal" : "vertical")) + (String)(cookie.hasMode() ? "&mode=" + cookie.getMode() : "") + "&dm=" + cookie.getDeptMode();
        if (this.iProperties.getAcademicSessionId() != null) {
            query = query + "&sid=" + this.iProperties.getAcademicSessionId();
        }
        if (((EventInterface.FilterRpcRequest)(rooms = this.iFilter.getElementsRequest())).hasOptions()) {
            for (Map.Entry<String, Set<String>> option : ((EventInterface.FilterRpcRequest)rooms).getOptions().entrySet()) {
                for (String value : option.getValue()) {
                    query = query + "&r:" + option.getKey() + "=" + URL.encodeQueryString((String)value);
                }
            }
        }
        if (((EventInterface.FilterRpcRequest)rooms).getText() != null && !((EventInterface.FilterRpcRequest)rooms).getText().isEmpty()) {
            query = query + "&r:text=" + URL.encodeQueryString((String)((EventInterface.FilterRpcRequest)rooms).getText());
        }
        return query;
    }

    protected void hideResults() {
        if (this.iRoomsTable == null) {
            return;
        }
        if (this.iMore != null) {
            this.iMore.setEnabled(false);
        }
        if (this.iHeaderPanel != null) {
            this.iHeaderPanel.setEnabled("more", false);
        }
        this.iRoomsTable.clearTable(1);
    }

    protected void search(final Long roomId) {
        if (this.iRoomsTable == null) {
            return;
        }
        this.hideResults();
        LoadingWidget.execute(this.iFilter.getElementsRequest(), new AsyncCallback<EventInterface.FilterRpcResponse>(){

            public void onFailure(Throwable caught) {
                RoomsPage.this.iFilter.setErrorHint(MESSAGES.failedToLoadRooms(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadRooms(caught.getMessage()), caught);
            }

            public void onSuccess(EventInterface.FilterRpcResponse result) {
                RoomsPage.this.iFilter.clearHint();
                if (result == null || result.getResults() == null || result.getResults().isEmpty()) {
                    RoomsPage.this.iFilter.setErrorHint(MESSAGES.errorNoRoomsMatchingFilter());
                } else {
                    FilterBox.Chip dept = RoomsPage.this.iFilter.getChip("department");
                    RoomsPage.this.iRoomsTable.setDepartment(dept == null ? null : dept.getValue());
                    for (EventInterface.FilterRpcResponse.Entity entity : result.getResults()) {
                        RoomsPage.this.iRoomsTable.addRoom((RoomInterface.RoomDetailInterface)entity);
                    }
                    RoomsPage.this.iRoomsTable.sort();
                }
                if (RoomsPage.this.iMore != null) {
                    RoomsPage.this.iMore.setEnabled(RoomsPage.this.iRoomsTable.getRowCount() > 1);
                }
                if (RoomsPage.this.iHeaderPanel != null) {
                    RoomsPage.this.iHeaderPanel.setEnabled("more", RoomsPage.this.iRoomsTable.getRowCount() > 1);
                }
                RoomsPage.this.iRoomsTable.scrollTo(roomId);
            }
        }, MESSAGES.waitLoadingRooms());
    }

    protected void changeUrl() {
        this.iHistoryToken.reset(null);
        if (this.iSession instanceof AcademicSessionSelectionBox) {
            this.iHistoryToken.setParameter("term", ((AcademicSessionSelectionBox)this.iSession).getAcademicSessionAbbreviation());
        }
        this.iHistoryToken.setParameter("q", this.iFilter.getValue());
        if (((Object)((Object)this.iRoomDetail)).equals(this.iRootPanel.getWidget())) {
            this.iHistoryToken.setParameter("id", this.iRoomDetail.getRoom().getUniqueId() == null ? "add" : this.iRoomDetail.getRoom().getUniqueId().toString());
        }
        if (((Object)((Object)this.iRoomEdit)).equals(this.iRootPanel.getWidget())) {
            this.iHistoryToken.setParameter("id", this.iRoomEdit.getRoom().getUniqueId() == null ? "add" : this.iRoomEdit.getRoom().getUniqueId().toString());
        }
        this.iHistoryToken.mark();
        Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
    }

    public static class HistoryToken {
        private RoomInterface.RoomsPageMode iMode = null;
        private Map<String, String> iParams = new HashMap<String, String>();
        private Map<String, String> iDefaults = new HashMap<String, String>();

        public HistoryToken(RoomInterface.RoomsPageMode mode) {
            this.iMode = mode;
            String query = this.iMode.getQuery();
            if (query != null) {
                for (String pair : query.split("\\&")) {
                    String key;
                    int idx = pair.indexOf(61);
                    if (idx < 0 || Window.Location.getParameter((String)(key = pair.substring(0, idx))) != null) continue;
                    this.iDefaults.put(key, URL.decodeQueryString((String)pair.substring(idx + 1)));
                }
            }
            for (Map.Entry entry : Window.Location.getParameterMap().entrySet()) {
                this.iDefaults.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            }
            String cookie = RoomCookie.getInstance().getHash(this.iMode);
            if (cookie != null) {
                for (String pair : cookie.split("\\&")) {
                    String key;
                    int idx = pair.indexOf(61);
                    if (idx < 0 || Window.Location.getParameter((String)(key = pair.substring(0, idx))) != null) continue;
                    this.iParams.put(key, URL.decodeQueryString((String)pair.substring(idx + 1)));
                }
            }
            this.parse(History.getToken());
        }

        public void reset(String token) {
            this.iParams.clear();
            this.parse(token);
        }

        public void parse(String token) {
            if (token != null && !token.isEmpty()) {
                for (String pair : token.split("\\&")) {
                    int idx = pair.indexOf(61);
                    if (idx < 0) continue;
                    this.iParams.put(pair.substring(0, idx), URL.decodeQueryString((String)pair.substring(idx + 1)));
                }
            }
        }

        public void setParameter(String key, String value) {
            if (value == null) {
                this.iParams.remove(key);
            } else {
                String defaultValue = this.iDefaults.get(key);
                if (value.equals(defaultValue)) {
                    this.iParams.remove(key);
                } else {
                    this.iParams.put(key, value);
                }
            }
        }

        public void setParameter(String key, Long value) {
            this.setParameter(key, value == null ? null : value.toString());
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(String skip) {
            Object ret = "";
            for (String key : new TreeSet<String>(this.iParams.keySet())) {
                if (key.equals(skip)) continue;
                if (!((String)ret).isEmpty()) {
                    ret = (String)ret + "&";
                }
                ret = (String)ret + key + "=" + URL.encodeQueryString((String)this.iParams.get(key));
            }
            return ret;
        }

        public String getParameter(String key, String defaultValue) {
            String value = this.getParameter(key);
            return value == null ? defaultValue : value;
        }

        public String getParameter(String key) {
            String value = this.iParams.get(key);
            return value == null ? this.iDefaults.get(key) : value;
        }

        public String getDefaultParameter(String key, String defaultValue) {
            String value = this.iDefaults.get(key);
            return value == null ? defaultValue : value;
        }

        public void setDefaultParameter(String key, String value) {
            if (value != null) {
                this.iDefaults.put(key, value);
            }
        }

        public boolean hasParameter(String key) {
            return this.getParameter(key) != null;
        }

        public boolean isChanged(String key, String value) {
            String v = this.getParameter(key);
            return v == null ? value != null : !v.equals(value);
        }

        public boolean isChanged(String key, String defaultValue, String value) {
            String v = this.getParameter(key);
            return v == null ? !defaultValue.equals(value) : !v.equals(value);
        }

        public void mark() {
            String token = this.toString();
            if (!History.getToken().equals(token)) {
                History.newItem((String)token, (boolean)false);
            }
            RoomCookie.getInstance().setHash(this.iMode, this.toString("id"));
        }
    }

    private class Session
    implements AcademicSessionProvider {
        private List<AcademicSessionProvider.AcademicSessionChangeHandler> iHandlers = new ArrayList<AcademicSessionProvider.AcademicSessionChangeHandler>();

        private Session() {
        }

        @Override
        public void selectSession(Long sessionId, AsyncCallback<Boolean> callback) {
            callback.onSuccess((Object)false);
        }

        @Override
        public String getAcademicSessionName() {
            return RoomsPage.this.iProperties == null ? null : RoomsPage.this.iProperties.getAcademicSessionName();
        }

        @Override
        public Long getAcademicSessionId() {
            return RoomsPage.this.iProperties == null ? null : RoomsPage.this.iProperties.getAcademicSessionId();
        }

        @Override
        public void addAcademicSessionChangeHandler(AcademicSessionProvider.AcademicSessionChangeHandler handler) {
            this.iHandlers.add(handler);
        }

        @Override
        public AcademicSessionProvider.AcademicSessionInfo getAcademicSessionInfo() {
            return null;
        }

        protected void fireChange() {
            AcademicSessionProvider.AcademicSessionChangeEvent event = new AcademicSessionProvider.AcademicSessionChangeEvent(){

                @Override
                public Long getNewAcademicSessionId() {
                    return RoomsPage.this.iProperties == null ? null : RoomsPage.this.iProperties.getAcademicSessionId();
                }

                @Override
                public Long getOldAcademicSessionId() {
                    return null;
                }

                @Override
                public boolean isChanged() {
                    return true;
                }
            };
            for (AcademicSessionProvider.AcademicSessionChangeHandler h : this.iHandlers) {
                h.onAcademicSessionChange(event);
            }
        }
    }
}

