/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.rooms.RoomGroupsComparator;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.rooms.RoomsTable;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomGroupsTable
extends UniTimeTable<RoomInterface.GroupInterface> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private boolean iGlobal;
    private RoomInterface.RoomGroupsColumn iSortBy = null;
    private boolean iAsc = true;

    public RoomGroupsTable(boolean isGlobal) {
        this.setStyleName("unitime-RoomGroups");
        this.iGlobal = isGlobal;
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final RoomInterface.RoomGroupsColumn column : RoomInterface.RoomGroupsColumn.values()) {
            int nrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nrCells; ++idx) {
                UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(column, idx), this.getColumnAlignment(column, idx));
                header.add(h);
            }
        }
        for (final RoomInterface.RoomGroupsColumn column : RoomInterface.RoomGroupsColumn.values()) {
            if (!RoomGroupsComparator.isApplicable(column) || this.getNbrCells(column) <= 0) continue;
            final UniTimeTableHeader h = (UniTimeTableHeader)header.get(this.getCellIndex(column));
            RoomsTable.SortOperation op = new RoomsTable.SortOperation(){

                public void execute() {
                    RoomGroupsTable.this.doSort(column);
                }

                @Override
                public boolean isApplicable() {
                    return RoomGroupsTable.this.getRowCount() > 1 && h.isVisible();
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.opSortBy(this.getColumnName());
                }

                @Override
                public String getColumnName() {
                    return h.getHTML().replace("<br>", " ");
                }
            };
            h.addOperation(op);
        }
        this.addRow(null, header);
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        this.setSortBy(RoomCookie.getInstance().getRoomGroupsSortBy());
    }

    protected void doSort(RoomInterface.RoomGroupsColumn column) {
        if (column == this.iSortBy) {
            this.iAsc = !this.iAsc;
        } else {
            this.iSortBy = column;
            this.iAsc = true;
        }
        RoomCookie.getInstance().setSortRoomGroupsBy(this.getSortBy());
        this.sort();
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
        } else if (sortBy > 0) {
            this.iSortBy = RoomInterface.RoomGroupsColumn.values()[sortBy - 1];
            this.iAsc = true;
        } else {
            this.iSortBy = RoomInterface.RoomGroupsColumn.values()[-1 - sortBy];
            this.iAsc = false;
        }
        this.sort();
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        if (this.getNbrCells(this.iSortBy) == 0) {
            this.iSortBy = RoomInterface.RoomGroupsColumn.NAME;
        }
        UniTimeTableHeader header = this.getHeader(this.getCellIndex(this.iSortBy));
        this.sort(header, new RoomGroupsComparator(this.iSortBy, true), this.iAsc);
    }

    protected int getNbrCells(RoomInterface.RoomGroupsColumn column) {
        switch (column) {
            case DEFAULT: {
                return this.iGlobal ? 1 : 0;
            }
            case DEPARTMENT: {
                return this.iGlobal ? 0 : 1;
            }
        }
        return 1;
    }

    public String getColumnName(RoomInterface.RoomGroupsColumn column, int idx) {
        switch (column) {
            case NAME: {
                return MESSAGES.colName();
            }
            case ABBREVIATION: {
                return MESSAGES.colAbbreviation();
            }
            case DEFAULT: {
                return MESSAGES.colDefault();
            }
            case DEPARTMENT: {
                return MESSAGES.colDepartment();
            }
            case ROOMS: {
                return MESSAGES.colRooms();
            }
            case DESCRIPTION: {
                return MESSAGES.colDescription();
            }
        }
        return column.name();
    }

    protected HasHorizontalAlignment.HorizontalAlignmentConstant getColumnAlignment(RoomInterface.RoomGroupsColumn column, int idx) {
        switch (column) {
            default: 
        }
        return HasHorizontalAlignment.ALIGN_LEFT;
    }

    protected int getCellIndex(RoomInterface.RoomGroupsColumn column) {
        int ret = 0;
        for (RoomInterface.RoomGroupsColumn c : RoomInterface.RoomGroupsColumn.values()) {
            if (c.ordinal() >= column.ordinal()) continue;
            ret += this.getNbrCells(c);
        }
        return ret;
    }

    protected Widget getCell(RoomInterface.GroupInterface group, RoomInterface.RoomGroupsColumn column, int idx) {
        switch (column) {
            case NAME: {
                return new Label(group.getLabel() == null ? "" : group.getLabel(), false);
            }
            case ABBREVIATION: {
                return new Label(group.getAbbreviation() == null ? "" : group.getAbbreviation(), false);
            }
            case DEFAULT: {
                if (group.isDefault()) {
                    return new Image(RESOURCES.on());
                }
                return null;
            }
            case DEPARTMENT: {
                return new RoomsTable.DepartmentCell(true, group.getDepartment());
            }
            case DESCRIPTION: {
                if (group.hasDescription()) {
                    HTML html = new HTML(group.getDescription());
                    html.setStyleName("description");
                    return html;
                }
                return null;
            }
            case ROOMS: {
                if (group.hasRooms()) {
                    return new RoomsCell(group);
                }
                return null;
            }
        }
        return null;
    }

    public int addGroup(RoomInterface.GroupInterface group) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (RoomInterface.RoomGroupsColumn column : RoomInterface.RoomGroupsColumn.values()) {
            int nbrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nbrCells; ++idx) {
                Object cell = this.getCell(group, column, idx);
                if (cell == null) {
                    cell = new P();
                }
                widgets.add((Widget)cell);
            }
        }
        int row = this.addRow(group, widgets);
        this.getRowFormatter().setStyleName(row, "row");
        for (int col = 0; col < this.getCellCount(row); ++col) {
            this.getCellFormatter().setStyleName(row, col, "cell");
        }
        return row;
    }

    @Override
    public void refreshTable() {
        for (int r = 1; r < this.getRowCount(); ++r) {
            for (int c = 0; c < this.getCellCount(r); ++c) {
                Widget w = this.getWidget(r, c);
                if (!(w instanceof UniTimeTable.HasRefresh)) continue;
                ((UniTimeTable.HasRefresh)w).refresh();
            }
        }
    }

    public RoomInterface.GroupInterface getGroup(Long groupId) {
        if (groupId == null) {
            return null;
        }
        for (int i = 1; i < this.getRowCount(); ++i) {
            if (!groupId.equals(((RoomInterface.GroupInterface)this.getData(i)).getId())) continue;
            return (RoomInterface.GroupInterface)this.getData(i);
        }
        return null;
    }

    public void scrollTo(Long groupId) {
        if (groupId == null) {
            return;
        }
        for (int i = 1; i < this.getRowCount(); ++i) {
            if (!groupId.equals(((RoomInterface.GroupInterface)this.getData(i)).getId())) continue;
            ToolBox.scrollToElement((Element)this.getRowFormatter().getElement(i));
            return;
        }
    }

    public static class RoomsCell
    extends P {
        public RoomsCell(RoomInterface.GroupInterface group) {
            super("rooms");
            if (group.hasRooms()) {
                Iterator<EventInterface.FilterRpcResponse.Entity> i = group.getRooms().iterator();
                while (i.hasNext()) {
                    EventInterface.FilterRpcResponse.Entity room = i.next();
                    this.add((Widget)new RoomCell(room, i.hasNext()));
                }
            }
        }
    }

    public static class RoomCell
    extends P {
        public RoomCell(final EventInterface.FilterRpcResponse.Entity room, boolean hasNext) {
            super("room");
            this.setText((room.getAbbreviation() != null && !room.getAbbreviation().isEmpty() ? MESSAGES.label(room.getName(), room.getAbbreviation()) : room.getName()) + (hasNext ? "," : ""));
            this.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    RoomHint.showHint((Element)this.getElement(), room.getUniqueId(), room.getProperty("prefix", null), room.getProperty("distance", null), true);
                }
            });
            this.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    RoomHint.hideHint();
                }
            });
        }
    }
}

