/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.rooms.RoomFeaturesComparator;
import org.unitime.timetable.gwt.client.rooms.RoomGroupsTable;
import org.unitime.timetable.gwt.client.rooms.RoomsTable;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomFeaturesTable
extends UniTimeTable<RoomInterface.FeatureInterface> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private boolean iGlobal;
    private RoomInterface.RoomFeaturesColumn iSortBy = null;
    private boolean iAsc = true;

    public RoomFeaturesTable(boolean isGlobal) {
        this.setStyleName("unitime-RoomFeatures");
        this.iGlobal = isGlobal;
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final RoomInterface.RoomFeaturesColumn column : RoomInterface.RoomFeaturesColumn.values()) {
            int nrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nrCells; ++idx) {
                UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(column, idx), this.getColumnAlignment(column, idx));
                header.add(h);
            }
        }
        for (final RoomInterface.RoomFeaturesColumn column : RoomInterface.RoomFeaturesColumn.values()) {
            if (!RoomFeaturesComparator.isApplicable(column) || this.getNbrCells(column) <= 0) continue;
            final UniTimeTableHeader h = (UniTimeTableHeader)header.get(this.getCellIndex(column));
            RoomsTable.SortOperation op = new RoomsTable.SortOperation(){

                public void execute() {
                    RoomFeaturesTable.this.doSort(column);
                }

                @Override
                public boolean isApplicable() {
                    return RoomFeaturesTable.this.getRowCount() > 1 && h.isVisible();
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.opSortBy(this.getColumnName());
                }

                @Override
                public String getColumnName() {
                    return h.getHTML().replace("<br>", " ");
                }
            };
            h.addOperation(op);
        }
        this.addRow(null, header);
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        this.setSortBy(RoomCookie.getInstance().getRoomGroupsSortBy());
    }

    protected void doSort(RoomInterface.RoomFeaturesColumn column) {
        if (column == this.iSortBy) {
            this.iAsc = !this.iAsc;
        } else {
            this.iSortBy = column;
            this.iAsc = true;
        }
        RoomCookie.getInstance().setSortRoomGroupsBy(this.getSortBy());
        this.sort();
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
        } else if (sortBy > 0) {
            this.iSortBy = RoomInterface.RoomFeaturesColumn.values()[sortBy - 1];
            this.iAsc = true;
        } else {
            this.iSortBy = RoomInterface.RoomFeaturesColumn.values()[-1 - sortBy];
            this.iAsc = false;
        }
        this.sort();
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        if (this.getNbrCells(this.iSortBy) == 0) {
            this.iSortBy = RoomInterface.RoomFeaturesColumn.NAME;
        }
        UniTimeTableHeader header = this.getHeader(this.getCellIndex(this.iSortBy));
        this.sort(header, new RoomFeaturesComparator(this.iSortBy, true), this.iAsc);
    }

    protected int getNbrCells(RoomInterface.RoomFeaturesColumn column) {
        switch (column) {
            case DEPARTMENT: {
                return this.iGlobal ? 0 : 1;
            }
        }
        return 1;
    }

    public String getColumnName(RoomInterface.RoomFeaturesColumn column, int idx) {
        switch (column) {
            case NAME: {
                return MESSAGES.colName();
            }
            case ABBREVIATION: {
                return MESSAGES.colAbbreviation();
            }
            case TYPE: {
                return MESSAGES.colType();
            }
            case DEPARTMENT: {
                return MESSAGES.colDepartment();
            }
            case ROOMS: {
                return MESSAGES.colRooms();
            }
            case DESCRIPTION: {
                return MESSAGES.colDescription();
            }
        }
        return column.name();
    }

    protected HasHorizontalAlignment.HorizontalAlignmentConstant getColumnAlignment(RoomInterface.RoomFeaturesColumn column, int idx) {
        switch (column) {
            default: 
        }
        return HasHorizontalAlignment.ALIGN_LEFT;
    }

    protected int getCellIndex(RoomInterface.RoomFeaturesColumn column) {
        int ret = 0;
        for (RoomInterface.RoomFeaturesColumn c : RoomInterface.RoomFeaturesColumn.values()) {
            if (c.ordinal() >= column.ordinal()) continue;
            ret += this.getNbrCells(c);
        }
        return ret;
    }

    protected Widget getCell(RoomInterface.FeatureInterface feature, RoomInterface.RoomFeaturesColumn column, int idx) {
        switch (column) {
            case NAME: {
                return new Label(feature.getLabel() == null ? "" : feature.getLabel(), false);
            }
            case ABBREVIATION: {
                return new Label(feature.getAbbreviation() == null ? "" : feature.getAbbreviation(), false);
            }
            case TYPE: {
                if (feature.getType() == null) {
                    return null;
                }
                Label type = new Label(feature.getType().getAbbreviation(), false);
                type.setTitle(feature.getType().getLabel());
                return type;
            }
            case DEPARTMENT: {
                return new RoomsTable.DepartmentCell(true, feature.getDepartment());
            }
            case DESCRIPTION: {
                if (feature.hasDescription()) {
                    HTML html = new HTML(feature.getDescription());
                    html.setStyleName("description");
                    return html;
                }
                return null;
            }
            case ROOMS: {
                if (feature.hasRooms()) {
                    return new RoomsCell(feature);
                }
                return null;
            }
        }
        return null;
    }

    public int addFeature(RoomInterface.FeatureInterface feature) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (RoomInterface.RoomFeaturesColumn column : RoomInterface.RoomFeaturesColumn.values()) {
            int nbrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nbrCells; ++idx) {
                Object cell = this.getCell(feature, column, idx);
                if (cell == null) {
                    cell = new P();
                }
                widgets.add((Widget)cell);
            }
        }
        int row = this.addRow(feature, widgets);
        this.getRowFormatter().setStyleName(row, "row");
        for (int col = 0; col < this.getCellCount(row); ++col) {
            this.getCellFormatter().setStyleName(row, col, "cell");
        }
        return row;
    }

    @Override
    public void refreshTable() {
        for (int r = 1; r < this.getRowCount(); ++r) {
            for (int c = 0; c < this.getCellCount(r); ++c) {
                Widget w = this.getWidget(r, c);
                if (!(w instanceof UniTimeTable.HasRefresh)) continue;
                ((UniTimeTable.HasRefresh)w).refresh();
            }
        }
    }

    public RoomInterface.FeatureInterface getFeature(Long featureId) {
        if (featureId == null) {
            return null;
        }
        for (int i = 1; i < this.getRowCount(); ++i) {
            if (!featureId.equals(((RoomInterface.FeatureInterface)this.getData(i)).getId())) continue;
            return (RoomInterface.FeatureInterface)this.getData(i);
        }
        return null;
    }

    public void scrollTo(Long featureId) {
        if (featureId == null) {
            return;
        }
        for (int i = 1; i < this.getRowCount(); ++i) {
            if (!featureId.equals(((RoomInterface.FeatureInterface)this.getData(i)).getId())) continue;
            ToolBox.scrollToElement((Element)this.getRowFormatter().getElement(i));
            return;
        }
    }

    public static class RoomsCell
    extends P {
        public RoomsCell(RoomInterface.FeatureInterface feature) {
            super("rooms");
            if (feature.hasRooms()) {
                Iterator<EventInterface.FilterRpcResponse.Entity> i = feature.getRooms().iterator();
                while (i.hasNext()) {
                    EventInterface.FilterRpcResponse.Entity room = i.next();
                    this.add((Widget)new RoomGroupsTable.RoomCell(room, i.hasNext()));
                }
            }
        }
    }
}

