/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class PeriodPreferencesWidget
extends Composite
implements HasValue<RoomInterface.PeriodPreferenceModel>,
SimpleForm.HasMobileScroll {
    private static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private AbsolutePanel iPanel;
    private RoomInterface.PreferenceInterface iPreference = null;
    private P iSelectedIcon = null;
    private P iSelectedTitle = null;
    private RoomInterface.PeriodPreferenceModel iModel;
    protected boolean iEditable = true;
    private CheckBox iHorizontal;
    private List<Cell> iCells = new ArrayList<Cell>();
    private boolean iShowLegend = true;

    public PeriodPreferencesWidget(boolean editable) {
        this.iEditable = editable;
        this.iPanel = new AbsolutePanel();
        this.iHorizontal = new CheckBox(MESSAGES.periodPreferenceHorizontal());
        this.iHorizontal.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                RoomCookie.getInstance().setHorizontal(PeriodPreferencesWidget.this.iHorizontal.getValue());
                PeriodPreferencesWidget.this.render();
            }
        });
        this.initWidget((Widget)this.iPanel);
    }

    public AbsolutePanel getPanel() {
        return this.iPanel;
    }

    public boolean isEditable() {
        return this.iEditable && this.iModel != null;
    }

    public void setEditable(boolean editable) {
        this.iEditable = editable;
    }

    public boolean isShowLegend() {
        return this.iShowLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.iShowLegend = showLegend;
    }

    public boolean isEditable(RoomInterface.PreferenceInterface preference) {
        return this.isEditable() && preference.isEditable();
    }

    public boolean isEditable(int day, int slot) {
        return this.isEditable() && this.iModel.getPeriod(day, slot) != null;
    }

    public RoomInterface.PeriodPreferenceModel getModel() {
        return this.iModel;
    }

    public boolean isHorizontal() {
        return this.iHorizontal.getValue();
    }

    public void setHorizontal(boolean horizontal) {
        this.iHorizontal.setValue(Boolean.valueOf(horizontal));
        RoomCookie.getInstance().setHorizontal(horizontal);
        this.render();
    }

    public void setModel(RoomInterface.PeriodPreferenceModel model) {
        this.iModel = model;
        if (RoomCookie.getInstance().hasOrientation()) {
            this.iHorizontal.setValue(Boolean.valueOf(RoomCookie.getInstance().areRoomsHorizontal()));
        } else {
            this.iHorizontal.setValue(Boolean.valueOf(model.isDefaultHorizontal()));
        }
        this.iPreference = this.iModel.getSelectedPreference();
        if (this.iPreference == null) {
            this.iPreference = this.iModel.getPreferences().get(0);
        }
        this.render();
    }

    public void insert(final RootPanel panel, Long eventAvailability) {
        String[] ids = panel.getElement().getInnerHTML().trim().split(":");
        Long locationId = Long.valueOf(ids[0]);
        Long examTypeId = Long.valueOf(ids[1]);
        RPC.execute(RoomInterface.PeriodPreferenceRequest.load(locationId, examTypeId), new AsyncCallback<RoomInterface.PeriodPreferenceModel>(){

            public void onFailure(Throwable caught) {
                UniTimeNotifications.error(MESSAGES.failedToLoadPeriodPreferences(caught.getMessage()));
            }

            public void onSuccess(RoomInterface.PeriodPreferenceModel result) {
                panel.getElement().setInnerText(null);
                PeriodPreferencesWidget.this.setModel(result);
                panel.add((Widget)PeriodPreferencesWidget.this);
                panel.setVisible(true);
            }
        });
    }

    public static String slot2short(int slot) {
        int h = slot / 12;
        if (h > 24) {
            h -= 24;
        }
        int m = 5 * (slot % 12);
        if (CONSTANTS.useAmPm()) {
            return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
        }
        return h + ":" + (m < 10 ? "0" : "") + m;
    }

    static int firstDayOfWeek(int year, int month) {
        return (6 + new Date(year - 1900, month - 1, 1).getDay()) % 7;
    }

    static int daysInMonth(int year, int month) {
        return new Date(year + (month == 12 ? 1 : 0) - 1900, (month == 12 ? 1 : month + 1) - 1, 0).getDate();
    }

    static int weekNumber(int year, int month) {
        Date d = new Date(year - 1900, month - 1, 1);
        while (d.getDay() != CalendarUtil.getStartingDayOfWeek()) {
            d.setDate(d.getDate() - 1);
        }
        int y = d.getYear();
        int week = 0;
        while (d.getYear() == y) {
            d.setDate(d.getDate() - 7);
            ++week;
        }
        return week;
    }

    static int startingDayOfWeek() {
        return (6 + CalendarUtil.getStartingDayOfWeek()) % 7;
    }

    static Date getDate(Date firstDate, int offset) {
        Date d = new Date(firstDate.getTime());
        if (offset != 0) {
            CalendarUtil.addDaysToDate((Date)d, (int)offset);
        }
        return d;
    }

    protected void render() {
        this.iPanel.clear();
        this.iCells.clear();
        if (this.iModel.getExamType().isFinal() || !CONSTANTS.displayMidtermPeriodPreferencesAsCalendar()) {
            this.iPanel.setStyleName("unitime-RoomSharingWidget");
            DateTimeFormat f1 = DateTimeFormat.getFormat((String)CONSTANTS.examPeriodPreferenceDateFormat()[0]);
            DateTimeFormat f2 = DateTimeFormat.getFormat((String)CONSTANTS.examPeriodPreferenceDateFormat()[1]);
            DateTimeFormat fm = DateTimeFormat.getFormat((String)"MMMM yyyy");
            P horizonal = new P("horizontal");
            horizonal.add((Widget)this.iHorizontal);
            this.iPanel.add((Widget)horizonal);
            boolean splitByMonths = this.iModel.getDays().size() > 15;
            P container = null;
            if (splitByMonths) {
                container = new P("container");
                this.iPanel.add((Widget)container);
            }
            HashSet<String> months = new HashSet<String>();
            do {
                days = this.iModel.getDays();
                String month = null;
                if (splitByMonths) {
                    days = new TreeSet<Integer>();
                    for (int day : this.iModel.getDays()) {
                        Date date = PeriodPreferencesWidget.getDate(this.iModel.getFirstDate(), day);
                        String m = fm.format(date);
                        if (m.equals(month)) {
                            days.add(day);
                            continue;
                        }
                        if (month != null || !months.add(m)) continue;
                        month = m;
                        days.add(day);
                    }
                    if (month == null) break;
                }
                P table = new P(splitByMonths ? "intable" : "table");
                if (splitByMonths) {
                    container.add((Widget)table);
                    P title = new P("title");
                    title.setText(month);
                    table.add((Widget)title);
                } else {
                    this.iPanel.add((Widget)table);
                }
                P box = new P("box");
                table.add((Widget)box);
                P header = new P("row");
                box.add((Widget)header);
                P corner = new P("cell", "corner", this.isEditable() ? "clickable" : null);
                corner.setHTML(MESSAGES.roomSharingCorner());
                header.add((Widget)corner);
                final ArrayList<Cell> thisPage = new ArrayList<Cell>();
                if (this.isHorizontal()) {
                    if (container != null) {
                        container.addStyleName("orientation-horizontal");
                    }
                    HashMap thisSlot = new HashMap();
                    var16_23 = this.iModel.getSlots().iterator();
                    while (var16_23.hasNext()) {
                        slot = (Integer)var16_23.next();
                        p = new P("cell", "time", this.isEditable() ? "clickable" : null);
                        p.setHTML(MESSAGES.roomSharingTimeHeader(PeriodPreferencesWidget.slot2short(slot), PeriodPreferencesWidget.slot2short(slot + this.iModel.getLength(slot))));
                        final ArrayList t = new ArrayList();
                        thisSlot.put(slot, t);
                        header.add((Widget)p);
                        if (!this.isEditable()) continue;
                        p.addMouseDownHandler(new MouseDownHandler(){

                            public void onMouseDown(MouseDownEvent event) {
                                for (Cell d : t) {
                                    d.setOption(PeriodPreferencesWidget.this.iPreference);
                                }
                            }
                        });
                    }
                    var16_23 = days.iterator();
                    while (var16_23.hasNext()) {
                        day = (Integer)var16_23.next();
                        line = new P("row");
                        box.add((Widget)line);
                        d = new P("cell", "day", this.isEditable() ? "clickable" : null);
                        Date date = PeriodPreferencesWidget.getDate(this.iModel.getFirstDate(), day);
                        d.setHTML(f1.format(date) + "<br>" + f2.format(date));
                        line.add((Widget)d);
                        final ArrayList<Cell> thisDay = new ArrayList<Cell>();
                        for (int slot : this.iModel.getSlots()) {
                            p = new Cell(day, slot, date, this.iModel.getPeriod(day, slot));
                            line.add((Widget)p);
                            ((List)thisSlot.get(slot)).add(p);
                            thisPage.add(p);
                            thisDay.add(p);
                            this.iCells.add(p);
                        }
                        if (!this.isEditable()) continue;
                        d.addMouseDownHandler(new MouseDownHandler(){

                            public void onMouseDown(MouseDownEvent event) {
                                for (Cell d : thisDay) {
                                    d.setOption(PeriodPreferencesWidget.this.iPreference);
                                }
                            }
                        });
                    }
                } else {
                    if (container != null) {
                        container.addStyleName("orientation-vertical");
                    }
                    HashMap thisDay = new HashMap();
                    var16_23 = days.iterator();
                    while (var16_23.hasNext()) {
                        day = (Integer)var16_23.next();
                        p = new P("cell", "time", this.isEditable() ? "clickable" : null);
                        Date date = PeriodPreferencesWidget.getDate(this.iModel.getFirstDate(), day);
                        p.setHTML(f1.format(date) + "<br>" + f2.format(date));
                        final ArrayList t = new ArrayList();
                        thisDay.put(day, t);
                        header.add((Widget)p);
                        if (!this.isEditable()) continue;
                        p.addMouseDownHandler(new MouseDownHandler(){

                            public void onMouseDown(MouseDownEvent event) {
                                for (Cell d : t) {
                                    d.setOption(PeriodPreferencesWidget.this.iPreference);
                                }
                            }
                        });
                    }
                    var16_23 = this.iModel.getSlots().iterator();
                    while (var16_23.hasNext()) {
                        slot = (Integer)var16_23.next();
                        line = new P("row");
                        box.add((Widget)line);
                        d = new P("cell", "day", this.isEditable() ? "clickable" : null);
                        d.setHTML(MESSAGES.roomSharingTimeHeader(PeriodPreferencesWidget.slot2short(slot), PeriodPreferencesWidget.slot2short(slot + this.iModel.getLength(slot))));
                        line.add((Widget)d);
                        final ArrayList<Cell> thisSlot = new ArrayList<Cell>();
                        Iterator iterator = days.iterator();
                        while (iterator.hasNext()) {
                            int day = (Integer)iterator.next();
                            Date date = PeriodPreferencesWidget.getDate(this.iModel.getFirstDate(), day);
                            p = new Cell(day, slot, date, this.iModel.getPeriod(day, slot));
                            line.add((Widget)p);
                            thisSlot.add(p);
                            thisPage.add(p);
                            ((List)thisDay.get(day)).add(p);
                            this.iCells.add(p);
                        }
                        if (!this.isEditable()) continue;
                        d.addMouseDownHandler(new MouseDownHandler(){

                            public void onMouseDown(MouseDownEvent event) {
                                for (Cell d : thisSlot) {
                                    d.setOption(PeriodPreferencesWidget.this.iPreference);
                                }
                            }
                        });
                    }
                }
                if (!this.isEditable()) continue;
                corner.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        for (Cell d : thisPage) {
                            d.setOption(PeriodPreferencesWidget.this.iPreference);
                        }
                    }
                });
            } while (splitByMonths);
        } else {
            this.iPanel.setStyleName("unitime-DateSelector");
            DateTimeFormat format = DateTimeFormat.getFormat((String)"MMMM yyyy");
            P table = new P();
            table.getElement().getStyle().setProperty("display", "inline-table");
            this.iPanel.add((Widget)table);
            Iterator<Object> iterator = this.iModel.getSlots().iterator();
            while (iterator.hasNext()) {
                int slot = iterator.next();
                String last = null;
                P row = new P();
                row.getElement().getStyle().setProperty("display", "table-row");
                table.add((Widget)row);
                SingleMonth m = null;
                days = this.iModel.getDays().iterator();
                while (days.hasNext()) {
                    int day = (Integer)days.next();
                    Date d = PeriodPreferencesWidget.getDate(this.iModel.getFirstDate(), day);
                    if (format.format(d).equals(last)) continue;
                    last = format.format(d);
                    m = new SingleMonth(format.format(d) + " (" + PeriodPreferencesWidget.slot2short(slot) + " - " + PeriodPreferencesWidget.slot2short(slot + this.iModel.getLength(slot)) + ")", d, slot);
                    m.getElement().getStyle().setProperty("display", "table-cell");
                    row.add((Widget)m);
                }
            }
        }
        if (!this.isShowLegend() && !this.isEditable()) {
            return;
        }
        P legend = new P("legend");
        this.iPanel.add((Widget)legend);
        P box = new P("box");
        legend.add((Widget)box);
        this.iSelectedIcon = null;
        this.iSelectedTitle = null;
        for (final RoomInterface.PreferenceInterface option : this.iModel.getPreferences()) {
            P line = new P("row");
            final P icon = new P("cell", this.isEditable(option) ? "clickable" : null);
            if (box.getWidgetCount() == 0) {
                icon.addStyleName("first");
            }
            icon.getElement().getStyle().setBackgroundColor(option.getColor());
            line.add((Widget)icon);
            final P title = new P("title", this.isEditable(option) ? "editable-title" : null);
            title.setHTML(option.getName());
            line.add((Widget)title);
            if (this.isEditable(option) && option.equals(this.iPreference)) {
                icon.addStyleName("selected");
                title.addStyleName("selected-title");
                this.iSelectedIcon = icon;
                this.iSelectedTitle = title;
            }
            if (this.isEditable(option)) {
                MouseDownHandler md = new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        if (PeriodPreferencesWidget.this.iModel.isReqConfirmation()) {
                            if (option.getCode().equals("R")) {
                                if (PeriodPreferencesWidget.this.iModel.hasPreference()) {
                                    UniTimeConfirmationDialog.alert(MESSAGES.warnPreferenceUseRequired());
                                }
                            } else if (!option.getCode().equals("0") && PeriodPreferencesWidget.this.iModel.hasRequired()) {
                                UniTimeConfirmationDialog.alert(MESSAGES.warnPreferenceUseNotRequired());
                            }
                        }
                        PeriodPreferencesWidget.this.iPreference = option;
                        PeriodPreferencesWidget.this.iModel.setSelectedPreference(option);
                        if (PeriodPreferencesWidget.this.iSelectedIcon != null) {
                            PeriodPreferencesWidget.this.iSelectedIcon.removeStyleName("selected");
                        }
                        if (PeriodPreferencesWidget.this.iSelectedTitle != null) {
                            PeriodPreferencesWidget.this.iSelectedTitle.removeStyleName("selected-title");
                        }
                        icon.addStyleName("selected");
                        title.addStyleName("selected-title");
                        PeriodPreferencesWidget.this.iSelectedIcon = icon;
                        PeriodPreferencesWidget.this.iSelectedTitle = title;
                    }
                };
                icon.addMouseDownHandler(md);
                title.addMouseDownHandler(md);
            }
            box.add((Widget)line);
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<RoomInterface.PeriodPreferenceModel> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public RoomInterface.PeriodPreferenceModel getValue() {
        return this.getModel();
    }

    public void setValue(RoomInterface.PeriodPreferenceModel value) {
        this.setValue(value, false);
    }

    public void setValue(RoomInterface.PeriodPreferenceModel value, boolean fireEvents) {
        this.setModel(value);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }

    public void insert(final RootPanel panel) {
        String pattern = null;
        pattern = panel.getElement().getFirstChildElement() != null ? Hidden.wrap((Element)panel.getElement().getFirstChildElement()).getValue() : panel.getElement().getInnerText().trim();
        Long examTypeId = Long.valueOf(pattern.substring(0, pattern.indexOf(58)));
        RPC.execute(RoomInterface.PeriodPreferenceRequest.loadForExam(null, examTypeId), new AsyncCallback<RoomInterface.PeriodPreferenceModel>(){

            public void onFailure(Throwable caught) {
                UniTimeNotifications.error(caught);
            }

            public void onSuccess(RoomInterface.PeriodPreferenceModel model) {
                if (panel.getElement().getFirstChildElement() != null) {
                    final Hidden pattern = Hidden.wrap((Element)panel.getElement().getFirstChildElement());
                    model.setPattern(pattern.getValue());
                    PeriodPreferencesWidget.this.addValueChangeHandler(new ValueChangeHandler<RoomInterface.PeriodPreferenceModel>(){

                        public void onValueChange(ValueChangeEvent<RoomInterface.PeriodPreferenceModel> event) {
                            pattern.setValue(((RoomInterface.PeriodPreferenceModel)event.getValue()).getPattern());
                        }
                    });
                    PeriodPreferencesWidget.this.iEditable = true;
                } else {
                    String pattern = panel.getElement().getInnerText().trim();
                    panel.getElement().setInnerText(null);
                    model.setPattern(pattern);
                    PeriodPreferencesWidget.this.iEditable = false;
                }
                PeriodPreferencesWidget.this.setModel(model);
                panel.add((Widget)PeriodPreferencesWidget.this);
                panel.setVisible(true);
            }
        });
    }

    private class Cell
    extends P {
        private int iDay;
        private int iSlot;
        private Date iDate;
        private RoomInterface.PeriodInterface iPeriod;

        Cell(int day, int slot, Date date, RoomInterface.PeriodInterface period) {
            super("cell", "item", PeriodPreferencesWidget.this.isEditable() && period != null ? "clickable" : null, period == null ? "disabled" : null, period != null && PeriodPreferencesWidget.this.iModel.isAssigned(period) ? "highlight" : null);
            this.iDay = day;
            this.iSlot = slot;
            this.iDate = date;
            this.iPeriod = period;
            if (period != null) {
                RoomInterface.PreferenceInterface preference = PeriodPreferencesWidget.this.iModel.getPreference(day, slot);
                if (preference == null) {
                    this.getElement().getStyle().clearBackgroundColor();
                    this.setHTML("");
                    this.setTitle("");
                } else {
                    this.getElement().getStyle().setBackgroundColor(preference.getColor());
                    this.setTitle(DateTimeFormat.getFormat((String)CONSTANTS.examPeriodDateFormat()).format(date) + " " + PeriodPreferencesWidget.slot2short(slot) + (String)(period == null ? "" : " - " + PeriodPreferencesWidget.slot2short(slot + period.getLength())) + ": " + preference.getName());
                }
                if (PeriodPreferencesWidget.this.isEditable()) {
                    this.addMouseDownHandler(new MouseDownHandler(){

                        public void onMouseDown(MouseDownEvent event) {
                            Cell.this.setOption(PeriodPreferencesWidget.this.iPreference);
                        }
                    });
                }
            }
        }

        public RoomInterface.PeriodInterface getPeriod() {
            return this.iPeriod;
        }

        public void setOption(RoomInterface.PreferenceInterface preference) {
            this.setOption(preference, true);
        }

        public void setOption(RoomInterface.PreferenceInterface preference, boolean fireChangeEvent) {
            if (!PeriodPreferencesWidget.this.isEditable() || this.iPeriod == null) {
                return;
            }
            if (preference != null && fireChangeEvent) {
                if (preference.getCode().equals("R")) {
                    if (PeriodPreferencesWidget.this.iModel.hasPreference()) {
                        RoomInterface.PreferenceInterface p = PeriodPreferencesWidget.this.iModel.getPreference("0");
                        for (Cell cell : PeriodPreferencesWidget.this.iCells) {
                            RoomInterface.PreferenceInterface pref;
                            if (cell.getPeriod() == null || (pref = PeriodPreferencesWidget.this.iModel.getPreference(cell.getPeriod().getDay(), cell.getPeriod().getStartSlot())) == null) continue;
                            cell.setOption(p, false);
                        }
                    }
                } else if (!preference.getCode().equals("0") && PeriodPreferencesWidget.this.iModel.hasRequired()) {
                    RoomInterface.PreferenceInterface p = PeriodPreferencesWidget.this.iModel.getDefaultPreference();
                    for (Cell cell : PeriodPreferencesWidget.this.iCells) {
                        RoomInterface.PreferenceInterface pref;
                        if (cell.getPeriod() == null || (pref = PeriodPreferencesWidget.this.iModel.getPreference(cell.getPeriod().getDay(), cell.getPeriod().getStartSlot())) == null) continue;
                        cell.setOption(p, false);
                    }
                }
            }
            PeriodPreferencesWidget.this.iModel.setPreference(this.iDay, this.iSlot, preference);
            if (preference == null) {
                this.getElement().getStyle().clearBackgroundColor();
                this.setHTML("");
                this.setTitle("");
            } else {
                this.getElement().getStyle().setBackgroundColor(preference.getColor());
                this.setTitle(DateTimeFormat.getFormat((String)CONSTANTS.examPeriodDateFormat()).format(this.iDate) + " " + PeriodPreferencesWidget.slot2short(this.iSlot) + " - " + PeriodPreferencesWidget.slot2short(this.iSlot + this.iPeriod.getLength()) + ": " + preference.getName());
            }
            if (fireChangeEvent) {
                ValueChangeEvent.fire((HasValueChangeHandlers)PeriodPreferencesWidget.this, (Object)PeriodPreferencesWidget.this.getValue());
            }
        }
    }

    private class SingleMonth
    extends AbsolutePanel {
        SingleMonth(String title, Date date, int slot) {
            int i;
            date.setDate(1);
            int year = Integer.parseInt(DateTimeFormat.getFormat((String)"yyyy").format(date));
            int month = Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(date));
            int firstDayOfWeek = (6 + date.getDay()) % 7;
            int nrDays = PeriodPreferencesWidget.daysInMonth(year, month);
            int firstWeekNumber = PeriodPreferencesWidget.weekNumber(year, month);
            this.addStyleName("month");
            if (title != null) {
                P p = new P("title");
                p.setText(title);
                this.add((Widget)p);
            }
            P box = new P("box");
            this.add((Widget)box);
            P header = new P("row");
            box.add((Widget)header);
            P corner = new P("cell", "corner");
            header.add((Widget)corner);
            for (int i2 = 0; i2 < 7; ++i2) {
                P h = new P("cell", "dow");
                h.setText(CONSTANTS.days()[(i2 + PeriodPreferencesWidget.startingDayOfWeek()) % 7]);
                header.add((Widget)h);
            }
            int weekNumber = firstWeekNumber;
            P line = new P("row");
            box.add((Widget)line);
            P week = new P("cell", "week");
            week.setText(String.valueOf(weekNumber++));
            line.add((Widget)week);
            int idx = 0;
            int blanks = (firstDayOfWeek + 7 - PeriodPreferencesWidget.startingDayOfWeek()) % 7;
            for (i = 0; i < blanks; ++i) {
                line.add((Widget)new P("cell", i + 1 == blanks ? "last-blank" : "blank"));
                ++idx;
            }
            for (i = 1; i <= nrDays; ++i) {
                if (i > 1 && idx % 7 == 0) {
                    if (idx == 7 && month == 1 && weekNumber > 50) {
                        weekNumber = 1;
                    }
                    line = new P("row");
                    box.add((Widget)line);
                    week = new P("cell", "week");
                    week.setText(String.valueOf(weekNumber++));
                    line.add((Widget)week);
                }
                int day = CalendarUtil.getDaysBetween((Date)PeriodPreferencesWidget.this.iModel.getFirstDate(), (Date)date);
                RoomInterface.PeriodInterface period = PeriodPreferencesWidget.this.iModel.getPeriod(day, slot);
                D d = new D(day, slot, date, period);
                line.add((Widget)d);
                ++idx;
                date = CalendarUtil.copyDate((Date)date);
                CalendarUtil.addDaysToDate((Date)date, (int)1);
            }
        }
    }

    private class D
    extends P {
        private int iDay;
        private int iSlot;
        private Date iDate;
        private RoomInterface.PeriodInterface iPeriod;

        private D(int day, int slot, Date date, RoomInterface.PeriodInterface period) {
            super("cell", "day", PeriodPreferencesWidget.this.isEditable() && period != null ? "clickable" : null, period == null ? "unavailable" : null);
            this.iDay = day;
            this.iSlot = slot;
            this.iDate = date;
            this.iPeriod = period;
            this.setText(DateTimeFormat.getFormat((String)"d").format(date));
            if (period != null) {
                RoomInterface.PreferenceInterface preference = PeriodPreferencesWidget.this.iModel.getPreference(day, slot);
                if (preference == null) {
                    this.getElement().getStyle().clearBackgroundColor();
                    this.setTitle("");
                } else {
                    this.getElement().getStyle().setBackgroundColor(preference.getColor());
                    this.setTitle(DateTimeFormat.getFormat((String)CONSTANTS.examPeriodDateFormat()).format(date) + " " + PeriodPreferencesWidget.slot2short(slot) + (String)(period == null ? "" : " - " + PeriodPreferencesWidget.slot2short(slot + period.getLength())) + ": " + preference.getName());
                }
                if (PeriodPreferencesWidget.this.isEditable()) {
                    this.addMouseDownHandler(new MouseDownHandler(){

                        public void onMouseDown(MouseDownEvent event) {
                            D.this.setOption(PeriodPreferencesWidget.this.iPreference);
                        }
                    });
                }
            }
        }

        public void setOption(RoomInterface.PreferenceInterface preference) {
            if (!PeriodPreferencesWidget.this.isEditable() || this.iPeriod == null) {
                return;
            }
            PeriodPreferencesWidget.this.iModel.setPreference(this.iDay, this.iSlot, preference);
            if (preference == null) {
                this.getElement().getStyle().clearBackgroundColor();
                this.setTitle("");
            } else {
                this.getElement().getStyle().setBackgroundColor(preference.getColor());
                this.setTitle(DateTimeFormat.getFormat((String)CONSTANTS.examPeriodDateFormat()).format(this.iDate) + " " + PeriodPreferencesWidget.slot2short(this.iSlot) + " - " + PeriodPreferencesWidget.slot2short(this.iSlot + this.iPeriod.getLength()) + ": " + preference.getName());
            }
            ValueChangeEvent.fire((HasValueChangeHandlers)PeriodPreferencesWidget.this, (Object)PeriodPreferencesWidget.this.getValue());
        }
    }
}

