/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.offerings.ClassSetupTable;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.ClassSetupInterface;

public class MultipleClassSetupPage
extends Composite {
    protected static final GwtMessages GWTMSG = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final CourseMessages MESSAGES = (CourseMessages)GWT.create(CourseMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimpleForm iForm = new SimpleForm();
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private ListBox iInstructionalMethod;
    private CheckBox iUnlimited;
    private NumberBox iLimit;
    private Map<Long, SubpartLimit> iSubpartLimits;
    private Map<Long, SnapshotLimit> iSnapshotLimits;
    private ClassSetupTable iTable;
    private CheckBox iVariableLimits;
    private int iLimitRow;
    private P iError;
    private ClassSetupInterface iData;

    public MultipleClassSetupPage() {
        this.iForm.addStyleName("unitime-MultipleClassSetup");
        LoadingWidget.getInstance().show(GWTMSG.waitLoadingData());
        ClassSetupInterface request = new ClassSetupInterface(ClassSetupInterface.Operation.LOAD, Long.valueOf(Window.Location.getParameter((String)"id")));
        RPC.execute(request, new AsyncCallback<ClassSetupInterface>(){

            public void onSuccess(ClassSetupInterface result) {
                MultipleClassSetupPage.this.initPage(result);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        MultipleClassSetupPage.this.iHeader.setEnabled("back", true);
                        MultipleClassSetupPage.this.iHeader.setEnabled("update", true);
                        LoadingWidget.getInstance().hide();
                    }
                });
            }

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                UniTimeNotifications.error(GWTMSG.failedLoadData(caught.getMessage()), caught);
                MultipleClassSetupPage.this.iHeader = new UniTimeHeaderPanel("");
                MultipleClassSetupPage.this.iForm.addHeaderRow((Widget)MultipleClassSetupPage.this.iHeader);
                MultipleClassSetupPage.this.iError = new P("error-table");
                P eh = new P("error-header");
                eh.setText(GWTMSG.failedLoadData(""));
                MultipleClassSetupPage.this.iError.add((Widget)eh);
                P em = new P("error-message");
                em.setText(caught.getMessage());
                MultipleClassSetupPage.this.iError.add((Widget)em);
                MultipleClassSetupPage.this.iForm.addRow((Widget)MultipleClassSetupPage.this.iError);
                MultipleClassSetupPage.this.iHeader.addButton("back", GWTMSG.buttonBack(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        History.back();
                    }
                });
                MultipleClassSetupPage.this.iForm.addBottomRow((Widget)MultipleClassSetupPage.this.iHeader.clonePanel());
                ToolBox.checkAccess(caught);
            }
        });
        this.initWidget((Widget)this.iForm);
    }

    protected void initPage(ClassSetupInterface data) {
        this.iData = data;
        this.iHeader = new UniTimeHeaderPanel(data.getName());
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iHeader.addButton("update", GWTMSG.buttonUpdate(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                MultipleClassSetupPage.this.iHeader.setEnabled("back", false);
                MultipleClassSetupPage.this.iHeader.setEnabled("update", false);
                LoadingWidget.getInstance().show(GWTMSG.waitSavingData());
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        if (MultipleClassSetupPage.this.validate()) {
                            MultipleClassSetupPage.this.iData.setOperation(ClassSetupInterface.Operation.SAVE);
                            RPC.execute(MultipleClassSetupPage.this.iData, new AsyncCallback<ClassSetupInterface>(){

                                public void onSuccess(ClassSetupInterface result) {
                                    ToolBox.open("instructionalOfferingDetail.action?op=view&io=" + MultipleClassSetupPage.this.iData.getOfferingId() + "#ioc" + MultipleClassSetupPage.this.iData.getConfigId());
                                }

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(GWTMSG.failedSave(caught.getMessage()), caught);
                                    ToolBox.checkAccess(caught);
                                    MultipleClassSetupPage.this.iHeader.setEnabled("update", true);
                                    MultipleClassSetupPage.this.iHeader.setEnabled("back", true);
                                    MultipleClassSetupPage.this.iError.clear();
                                    P eh = new P("error-header");
                                    eh.setText(GWTMSG.failedSave(""));
                                    MultipleClassSetupPage.this.iError.add((Widget)eh);
                                    P em = new P("error-message");
                                    em.setText(caught.getMessage());
                                    MultipleClassSetupPage.this.iError.add((Widget)em);
                                    MultipleClassSetupPage.this.iError.setVisible(true);
                                }
                            });
                        } else {
                            LoadingWidget.getInstance().hide();
                            MultipleClassSetupPage.this.iHeader.setEnabled("update", true);
                            MultipleClassSetupPage.this.iHeader.setEnabled("back", true);
                        }
                    }
                });
            }
        });
        this.iHeader.addButton("back", GWTMSG.buttonBack(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                MultipleClassSetupPage.this.iHeader.setEnabled("back", false);
                MultipleClassSetupPage.this.iHeader.setEnabled("update", false);
                ToolBox.open("instructionalOfferingDetail.action?op=view&io=" + MultipleClassSetupPage.this.iData.getOfferingId() + "#ioc" + MultipleClassSetupPage.this.iData.getConfigId());
            }
        });
        this.iHeader.setEnabled("update", false);
        this.iHeader.setEnabled("back", false);
        this.iError = new P("error-table");
        this.iForm.addRow((Widget)this.iError);
        this.iError.setVisible(false);
        if (this.iData.hasInstructionalMethods()) {
            if (this.iData.isInstructionalMethodEditable()) {
                this.iInstructionalMethod = new ListBox();
                for (ClassSetupInterface.Reference im : this.iData.getInstructionalMethods()) {
                    this.iInstructionalMethod.addItem(im.getLabel(), im.getId().toString());
                    if (!im.getId().equals(this.iData.getInstructionalMethodId())) continue;
                    this.iInstructionalMethod.setSelectedIndex(this.iInstructionalMethod.getItemCount() - 1);
                }
                this.iForm.addRow(MESSAGES.propertyInstructionalMethod(), (Widget)this.iInstructionalMethod);
                this.iInstructionalMethod.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        String id = MultipleClassSetupPage.this.iInstructionalMethod.getValue(MultipleClassSetupPage.this.iInstructionalMethod.getSelectedIndex());
                        if (id == null || id.isEmpty()) {
                            MultipleClassSetupPage.this.iData.setInstructionalMethodId(null);
                        } else {
                            MultipleClassSetupPage.this.iData.setInstructionalMethodId(Long.valueOf(id));
                        }
                    }
                });
            } else {
                ClassSetupInterface.Reference im = this.iData.getInstructionalMethod(this.iData.getInstructionalMethodId());
                if (im != null) {
                    this.iForm.addRow(MESSAGES.propertyInstructionalMethod(), (Widget)new Label(im.getLabel()));
                }
            }
        }
        if (this.iData.isEditUnlimited()) {
            this.iUnlimited = new CheckBox();
            this.iUnlimited.setValue(this.iData.isUnlimited());
            this.iForm.addRow(MESSAGES.propertyUnlimitedEnrollment(), (Widget)this.iUnlimited);
            this.iUnlimited.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    MultipleClassSetupPage.this.iData.setUnlimited((Boolean)event.getValue());
                    MultipleClassSetupPage.this.updateCounts();
                }
            });
        } else if (Boolean.TRUE.equals(this.iData.isUnlimited())) {
            Image on = new Image(RESOURCES.on());
            on.setTitle(MESSAGES.titleUnlimitedEnrollment());
            this.iForm.addRow(MESSAGES.propertyUnlimitedEnrollment(), (Widget)on);
        }
        this.iLimit = new NumberBox();
        this.iLimit.setValue(Boolean.TRUE.equals(this.iData.isUnlimited()) ? null : this.iData.getLimit());
        this.iLimit.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                MultipleClassSetupPage.this.iData.setLimit(MultipleClassSetupPage.this.iLimit.toInteger());
                MultipleClassSetupPage.this.updateCounts();
            }
        });
        this.iLimitRow = this.iForm.addRow(MESSAGES.propertyConfigurationLimit(), (Widget)this.iLimit);
        if (this.iData.isCanEditSchedulingDisclaimer()) {
            P disclaimerPanel = null;
            final TextArea disclaimer = new TextArea();
            disclaimer.setHeight("66px");
            disclaimer.setWidth("100%");
            if (this.iData.hasStdSchedDisclaimers()) {
                disclaimerPanel = new P("scheduling-disclaimer");
                final ListBox box = new ListBox();
                for (ClassSetupInterface.Reference r : this.iData.getStdSchedDisclaimers()) {
                    box.addItem(r.getReference(), r.getId().toString());
                    if (!this.iData.hasSchedulingDisclaimer() || !this.iData.getSchedulingDisclaimer().equals(r.getLabel())) continue;
                    box.setSelectedIndex(box.getItemCount() - 1);
                }
                if (box.getSelectedIndex() <= 0) {
                    if (this.iData.hasSchedulingDisclaimer()) {
                        box.setSelectedIndex(box.getItemCount() - 1);
                    } else {
                        disclaimer.setEnabled(false);
                        disclaimer.setVisible(false);
                    }
                } else {
                    disclaimer.setEnabled(false);
                }
                box.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        ClassSetupInterface.Reference disc = MultipleClassSetupPage.this.iData.getStdSchedDisclaimer(Long.valueOf(box.getSelectedValue()));
                        if (disc.getId() == -1L) {
                            disclaimer.setEnabled(false);
                            disclaimer.setVisible(false);
                            disclaimer.setText("");
                            MultipleClassSetupPage.this.iData.setSchedulingDisclaimer(null);
                        } else if (disc.getId() == -2L) {
                            disclaimer.setEnabled(true);
                            disclaimer.setVisible(true);
                        } else {
                            disclaimer.setEnabled(false);
                            disclaimer.setVisible(true);
                            disclaimer.setText(disc.getLabel());
                            MultipleClassSetupPage.this.iData.setSchedulingDisclaimer(disc.getLabel());
                        }
                    }
                });
                disclaimerPanel.add((Widget)box);
            }
            if (this.iData.hasSchedulingDisclaimer()) {
                disclaimer.setText(this.iData.getSchedulingDisclaimer());
            }
            if (disclaimerPanel == null) {
                this.iForm.addRow(MESSAGES.propertySchedulingDisclaimer(), (Widget)disclaimer);
            } else {
                disclaimerPanel.add((Widget)disclaimer);
                this.iForm.addRow(MESSAGES.propertySchedulingDisclaimer(), (Widget)disclaimerPanel);
            }
            disclaimer.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    MultipleClassSetupPage.this.iData.setSchedulingDisclaimer((String)event.getValue());
                }
            });
        } else if (this.iData.hasSchedulingDisclaimer()) {
            Label disclaimer = new Label(this.iData.getSchedulingDisclaimer());
            disclaimer.addStyleName("note");
            this.iForm.addRow(MESSAGES.propertySchedulingDisclaimer(), (Widget)disclaimer);
        }
        P topSubpartLimits = new P("subpart-limits");
        P bottomSubpartLimits = new P("subpart-limits");
        P topSnapshotLimits = new P("subpart-limits");
        P bottomSnapshotLimits = new P("subpart-limits");
        this.iSubpartLimits = new HashMap<Long, SubpartLimit>();
        this.iSnapshotLimits = new HashMap<Long, SnapshotLimit>();
        for (ClassSetupInterface.ClassLine line : this.iData.getClassLines()) {
            SnapshotLimit snapshot;
            SubpartLimit limit = this.iSubpartLimits.get(line.getSubpartId());
            if (limit == null) {
                limit = new SubpartLimit(line.getSubpartId());
                this.iSubpartLimits.put(line.getSubpartId(), limit);
                topSubpartLimits.add((Widget)limit.iTop);
                bottomSubpartLimits.add((Widget)limit.iBottom);
            }
            if (!this.iData.isDisplaySnapshotLimit() || !this.iData.isEditSnapshotLimits() || (snapshot = this.iSnapshotLimits.get(line.getSubpartId())) != null) continue;
            snapshot = new SnapshotLimit(line.getSubpartId());
            this.iSnapshotLimits.put(line.getSubpartId(), snapshot);
            topSnapshotLimits.add((Widget)snapshot.iTop);
            bottomSnapshotLimits.add((Widget)snapshot.iBottom);
        }
        this.iForm.addRow(MESSAGES.propertySchedulingSubpartLimits(), (Widget)topSubpartLimits);
        if (this.iData.isDisplaySnapshotLimit() && this.iData.isEditSnapshotLimits()) {
            this.iForm.addRow(MESSAGES.propertySchedulingSubpartSnapshotLimits(), (Widget)topSnapshotLimits);
        }
        if (this.iData.isDisplayOptionForMaxLimit()) {
            this.iVariableLimits = new CheckBox(MESSAGES.labelAllowVariableLimits());
            this.iVariableLimits.setValue(Boolean.valueOf(this.iData.isDisplayMaxLimit()));
            this.iVariableLimits.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    MultipleClassSetupPage.this.iData.setDisplayMaxLimit((Boolean)event.getValue());
                    MultipleClassSetupPage.this.updateTable();
                }
            });
            this.iForm.addRow("", (Widget)this.iVariableLimits);
        }
        this.iTable = new ClassSetupTable(data){

            @Override
            protected void onLimitChange() {
                MultipleClassSetupPage.this.updateCounts();
            }
        };
        this.iForm.addRow((Widget)this.iTable);
        this.iForm.addRow(MESSAGES.propertySchedulingSubpartLimits(), (Widget)bottomSubpartLimits);
        if (this.iData.isDisplaySnapshotLimit() && this.iData.isEditSnapshotLimits()) {
            this.iForm.addRow(MESSAGES.propertySchedulingSubpartSnapshotLimits(), (Widget)bottomSnapshotLimits);
        }
        this.iFooter = this.iHeader.clonePanel("");
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.updateCounts();
    }

    protected void updateCounts() {
        this.iForm.getRowFormatter().setVisible(this.iLimitRow, this.iData.isUnlimited() == false);
        if (this.iVariableLimits != null) {
            this.iVariableLimits.setVisible(this.iData.isUnlimited() == false);
            boolean hasVariable = false;
            for (ClassSetupInterface.ClassLine line : this.iData.getClassLines()) {
                if (line.getMinClassLimit() == null || line.getMaxClassLimit() == null || line.getMinClassLimit().equals(line.getMaxClassLimit())) continue;
                hasVariable = true;
            }
            this.iVariableLimits.setEnabled(!hasVariable);
        }
        for (SubpartLimit limit : this.iSubpartLimits.values()) {
            limit.update();
        }
        for (SnapshotLimit snapshot : this.iSnapshotLimits.values()) {
            snapshot.update();
        }
        this.iTable.setUnlimited(this.iData.isUnlimited());
    }

    protected void updateTable() {
        int instIdx = this.iTable.getIndex(ClassSetupInterface.ClassSetupColumn.DISPLAY_INSTRUCTOR);
        int schdIdx = this.iTable.getIndex(ClassSetupInterface.ClassSetupColumn.STUDENT_SCHEDULING);
        int limitIdx = this.iTable.getIndex(ClassSetupInterface.ClassSetupColumn.LIMIT);
        for (int i = 0; i < this.iTable.getRowCount(); ++i) {
            Widget w;
            ClassSetupInterface.ClassLine line = (ClassSetupInterface.ClassLine)this.iTable.getData(i);
            if (line == null || line.getCancelled().booleanValue()) continue;
            if (instIdx >= 0 && (w = this.iTable.getWidget(i, instIdx)) != null && w instanceof CheckBox) {
                ((CheckBox)w).setValue(line.getDisplayInstructors());
            }
            if (schdIdx >= 0 && (w = this.iTable.getWidget(i, schdIdx)) != null && w instanceof CheckBox) {
                ((CheckBox)w).setValue(line.getEnabledForStudentScheduling());
            }
            if (limitIdx < 0 || (w = this.iTable.getWidget(i, limitIdx)) == null || !(w instanceof ClassSetupTable.ClassLimit)) continue;
            ((ClassSetupTable.ClassLimit)w).setMaxVisible(this.iData.isDisplayMaxLimit());
        }
        UniTimeTableHeader h = this.iTable.getHeader(this.iTable.getIndex(ClassSetupInterface.ClassSetupColumn.LIMIT));
        h.setHTML(this.iTable.getColumnName(ClassSetupInterface.ClassSetupColumn.LIMIT));
    }

    /*
     * WARNING - void declaration
     */
    private boolean validate() {
        Integer l;
        ClassSetupInterface.ClassLine parent;
        TreeSet<String> errors = new TreeSet<String>();
        for (ClassSetupInterface.ClassLine classLine : this.iData.getClassLines()) {
            classLine.setError(null);
            if (classLine.getMinClassLimit() == null || classLine.getMaxClassLimit() == null) {
                classLine.addError(MESSAGES.errorRequiredField(MESSAGES.columnLimit()));
                errors.add(MESSAGES.errorRequiredField(MESSAGES.columnLimit()));
                continue;
            }
            if (classLine.getMinClassLimit() <= classLine.getMaxClassLimit()) continue;
            classLine.addError(MESSAGES.errorMaxLessThanMinLimit(classLine.getLabel()));
            errors.add(MESSAGES.errorMaxLessThanMinLimit(classLine.getLabel()));
        }
        if (!this.iData.isUnlimited().booleanValue()) {
            Object parentSubpartId = null;
            for (ClassSetupInterface.Reference reference : this.iData.getSubparts()) {
                int maxLimit = 0;
                HashMap<Long, Integer> maxLimitPerParent = new HashMap<Long, Integer>();
                for (ClassSetupInterface.ClassLine line : this.iData.getClassLines()) {
                    if (!reference.getId().equals(line.getSubpartId())) continue;
                    if (parentSubpartId == null && line.getParentId() != null) {
                        parent = this.iData.getClassLine(line.getParentId());
                        Object object = parentSubpartId = parent == null ? null : parent.getSubpartId();
                    }
                    if (line.getMaxClassLimit() == null) continue;
                    if (line.getParentId() != null) {
                        l = (Integer)maxLimitPerParent.get(line.getParentId());
                        maxLimitPerParent.put(line.getParentId(), (l == null ? 0 : l) + line.getMaxClassLimit());
                    }
                    maxLimit += line.getMaxClassLimit().intValue();
                }
                for (ClassSetupInterface.ClassLine line : this.iData.getClassLines()) {
                    if (!reference.getId().equals(line.getSubpartId()) || (parent = this.iData.getClassLine(line.getParentId())) == null) continue;
                    Integer limit = (Integer)maxLimitPerParent.get(line.getParentId());
                    if (parent.getMaxClassLimit() == null || parent.getMaxClassLimit() <= (limit == null ? 0 : limit)) continue;
                    if (this.iData.isDisplayMaxLimit()) {
                        line.addError(MESSAGES.errorTotalMaxChildrenAtLeastMaxParent());
                        errors.add(MESSAGES.errorTotalMaxChildrenAtLeastMaxParent());
                        continue;
                    }
                    line.addError(MESSAGES.errorLimitsChildClasses());
                    errors.add(MESSAGES.errorLimitsChildClasses());
                }
                if (!this.iData.isValidateLimits() || parentSubpartId != null || maxLimit >= this.iLimit.toInteger()) continue;
                if (this.iData.isDisplayMaxLimit()) {
                    errors.add(MESSAGES.errorMaxLimitsTotalTooLow());
                    for (ClassSetupInterface.ClassLine line : this.iData.getClassLines()) {
                        if (!reference.getId().equals(line.getSubpartId())) continue;
                        line.addError(MESSAGES.errorMaxLimitsTotalTooLow());
                    }
                    continue;
                }
                errors.add(MESSAGES.errorLimitsForTopLevelClassesTooLow());
                for (ClassSetupInterface.ClassLine line : this.iData.getClassLines()) {
                    if (!reference.getId().equals(line.getSubpartId())) continue;
                    line.addError(MESSAGES.errorLimitsForTopLevelClassesTooLow());
                }
            }
        }
        for (ClassSetupInterface.Reference reference : this.iData.getSubparts()) {
            void var4_11;
            boolean bl = false;
            Long parentSubpartId = null;
            HashMap<Long, Integer> classesPerParent = new HashMap<Long, Integer>();
            for (ClassSetupInterface.ClassLine line : this.iData.getClassLines()) {
                if (!reference.getId().equals(line.getSubpartId())) continue;
                if (parentSubpartId == null && line.getParentId() != null) {
                    parent = this.iData.getClassLine(line.getParentId());
                    parentSubpartId = parent == null ? null : parent.getSubpartId();
                }
                ++var4_11;
                if (line.getParentId() == null) continue;
                l = (Integer)classesPerParent.get(line.getParentId());
                classesPerParent.put(line.getParentId(), (l == null ? 0 : l) + 1);
            }
            if (var4_11 == false) {
                errors.add(MESSAGES.errorEachSubpartMustHaveClass());
            }
            if (parentSubpartId == null) continue;
            for (ClassSetupInterface.ClassLine line : this.iData.getClassLines()) {
                Integer children;
                if (!reference.getId().equals(parentSubpartId) || (children = (Integer)classesPerParent.get(line.getClassId())) != null) continue;
                errors.add(MESSAGES.errorClassMustHaveChildClasses(line.getLabel()));
                line.addError(MESSAGES.errorClassMustHaveChildClasses(line.getLabel()));
            }
        }
        this.iTable.updateButtons();
        this.updateCounts();
        if (errors.isEmpty()) {
            this.iError.clear();
            this.iError.setVisible(false);
        } else {
            this.iError.clear();
            P eh = new P("error-header");
            eh.setText(MESSAGES.formValidationErrors());
            this.iError.add((Widget)eh);
            for (String string : errors) {
                P em = new P("error-message");
                em.setHTML(string);
                this.iError.add((Widget)em);
            }
            this.iError.setVisible(true);
        }
        return errors.isEmpty();
    }

    private class SubpartLimit {
        private Long iSubpartId;
        private int iIndent;
        private String iName = "";
        private Label iTopCounter;
        private Label iBottomCounter;
        private CheckBox iTopDisplayInstructors;
        private CheckBox iBottomDisplayInstructors;
        private CheckBox iTopStudentScheduling;
        private CheckBox iBottomStudentScheduling;
        private P iTop;
        private P iBottom;

        SubpartLimit(Long subpartId) {
            this.iSubpartId = subpartId;
            this.iTopCounter = new Label("0");
            this.iTopCounter.addStyleName("subpart-counter");
            this.iBottomCounter = new Label("0");
            this.iBottomCounter.addStyleName("subpart-counter");
            this.iTopStudentScheduling = new CheckBox();
            this.iBottomStudentScheduling = new CheckBox();
            this.iBottomStudentScheduling.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    SubpartLimit.this.iTopStudentScheduling.setValue((Boolean)event.getValue(), true);
                }
            });
            this.iTopStudentScheduling.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    SubpartLimit.this.iBottomStudentScheduling.setValue((Boolean)event.getValue());
                    for (ClassSetupInterface.ClassLine line : MultipleClassSetupPage.this.iData.getClassLines()) {
                        if (!line.isEditable() || !line.getSubpartId().equals(SubpartLimit.this.iSubpartId)) continue;
                        line.setEnabledForStudentScheduling((Boolean)event.getValue());
                    }
                    MultipleClassSetupPage.this.updateTable();
                }
            });
            this.iTopDisplayInstructors = new CheckBox();
            this.iBottomDisplayInstructors = new CheckBox();
            this.iBottomDisplayInstructors.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    SubpartLimit.this.iTopDisplayInstructors.setValue((Boolean)event.getValue(), true);
                }
            });
            this.iTopDisplayInstructors.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    SubpartLimit.this.iBottomDisplayInstructors.setValue((Boolean)event.getValue());
                    for (ClassSetupInterface.ClassLine line : MultipleClassSetupPage.this.iData.getClassLines()) {
                        if (!line.isEditable() || !line.getSubpartId().equals(SubpartLimit.this.iSubpartId)) continue;
                        line.setDisplayInstructors((Boolean)event.getValue());
                    }
                    MultipleClassSetupPage.this.updateTable();
                }
            });
            this.iTop = new P("subpart-limit");
            this.iBottom = new P("subpart-limit");
            this.update();
        }

        public void update() {
            int minLimit = 0;
            int maxLimit = 0;
            int canceled = 0;
            int nbrUnchecked = 0;
            int nbrHidden = 0;
            int nbrEditable = 0;
            HashMap<Long, Integer> limitPerParent = new HashMap<Long, Integer>();
            HashMap<Long, Integer> limitPerParentAll = new HashMap<Long, Integer>();
            for (ClassSetupInterface.ClassLine line : MultipleClassSetupPage.this.iData.getClassLines()) {
                if (!this.iSubpartId.equals(line.getSubpartId())) continue;
                this.iName = line.getSubpartLabel() + ":";
                this.iIndent = line.getIndent();
                if (line.getParentId() != null && line.getMaxClassLimit() != null) {
                    Integer la = (Integer)limitPerParentAll.get(line.getParentId());
                    limitPerParentAll.put(line.getParentId(), (la == null ? 0 : la) + line.getMaxClassLimit());
                    Integer l = (Integer)limitPerParent.get(line.getParentId());
                    if (!line.getCancelled().booleanValue()) {
                        limitPerParent.put(line.getParentId(), (l == null ? 0 : l) + line.getMaxClassLimit());
                    }
                }
                if (line.getCancelled().booleanValue()) {
                    if (line.getMaxClassLimit() == null) continue;
                    canceled += line.getMaxClassLimit().intValue();
                    continue;
                }
                if (line.getMinClassLimit() != null) {
                    minLimit += line.getMinClassLimit().intValue();
                }
                if (line.getMaxClassLimit() != null) {
                    maxLimit += line.getMaxClassLimit().intValue();
                }
                if (!Boolean.TRUE.equals(line.getEnabledForStudentScheduling())) {
                    ++nbrUnchecked;
                }
                if (!Boolean.TRUE.equals(line.getDisplayInstructors())) {
                    ++nbrHidden;
                }
                if (!line.isEditable()) continue;
                ++nbrEditable;
            }
            if (MultipleClassSetupPage.this.iData.isUnlimited().booleanValue()) {
                this.iTopCounter.setText("\u221e");
                this.iBottomCounter.setText("\u221e");
            } else if (minLimit == maxLimit || !MultipleClassSetupPage.this.iData.isDisplayMaxLimit()) {
                this.iTopCounter.setText(String.valueOf(minLimit));
                this.iBottomCounter.setText(String.valueOf(minLimit));
            } else {
                this.iTopCounter.setText(minLimit + " - " + maxLimit);
                this.iBottomCounter.setText(minLimit + " - " + maxLimit);
            }
            if (MultipleClassSetupPage.this.iLimit.toInteger() == null || MultipleClassSetupPage.this.iLimit.toInteger() > maxLimit + canceled) {
                this.iTopCounter.addStyleName("limit-too-low");
                this.iBottomCounter.addStyleName("limit-too-low");
                this.iTopCounter.removeStyleName("limit-too-low-cancel");
                this.iBottomCounter.removeStyleName("limit-too-low-cancel");
            } else if (MultipleClassSetupPage.this.iLimit.toInteger() == null || MultipleClassSetupPage.this.iLimit.toInteger() > maxLimit) {
                this.iTopCounter.addStyleName("limit-too-low-cancel");
                this.iBottomCounter.addStyleName("limit-too-low-cancel");
                this.iTopCounter.removeStyleName("limit-too-low");
                this.iBottomCounter.removeStyleName("limit-too-low");
            } else {
                this.iTopCounter.removeStyleName("limit-too-low");
                this.iBottomCounter.removeStyleName("limit-too-low");
                this.iTopCounter.removeStyleName("limit-too-low-cancel");
                this.iBottomCounter.removeStyleName("limit-too-low-cancel");
            }
            if (MultipleClassSetupPage.this.iTable != null) {
                for (int row = 1; row < MultipleClassSetupPage.this.iTable.getRowCount(); ++row) {
                    ClassSetupInterface.ClassLine line;
                    line = (ClassSetupInterface.ClassLine)MultipleClassSetupPage.this.iTable.getData(row);
                    if (!this.iSubpartId.equals(line.getSubpartId())) continue;
                    boolean badLimit = false;
                    boolean badLimitCancel = false;
                    if (!MultipleClassSetupPage.this.iData.isUnlimited().booleanValue()) {
                        if (line.getMinClassLimit() == null || line.getMaxClassLimit() == null) {
                            badLimit = true;
                        }
                        if (MultipleClassSetupPage.this.iLimit.toInteger() == null || MultipleClassSetupPage.this.iLimit.toInteger() > maxLimit + canceled) {
                            badLimit = true;
                        }
                        if (MultipleClassSetupPage.this.iLimit.toInteger() == null || MultipleClassSetupPage.this.iLimit.toInteger() > maxLimit) {
                            badLimitCancel = true;
                        }
                        if (line.getParentId() != null) {
                            Integer allLimit = (Integer)limitPerParentAll.get(line.getParentId());
                            Integer limit = (Integer)limitPerParent.get(line.getParentId());
                            ClassSetupInterface.ClassLine parent = MultipleClassSetupPage.this.iData.getClassLine(line.getParentId());
                            if ((parent.getMaxClassLimit() == null ? 0 : parent.getMaxClassLimit()) > (allLimit == null ? 0 : allLimit)) {
                                badLimit = true;
                            } else if ((parent.getMaxClassLimit() == null ? 0 : parent.getMaxClassLimit()) > (limit == null ? 0 : limit)) {
                                badLimitCancel = true;
                            }
                        }
                    }
                    Widget w = MultipleClassSetupPage.this.iTable.getWidget(row, MultipleClassSetupPage.this.iTable.getIndex(ClassSetupInterface.ClassSetupColumn.LIMIT));
                    if (badLimit) {
                        w.addStyleName("bad-limit");
                        w.removeStyleName("bad-limit-cancel");
                        continue;
                    }
                    if (badLimitCancel) {
                        w.removeStyleName("bad-limit");
                        if (line.getCancelled().booleanValue()) continue;
                        w.addStyleName("bad-limit-cancel");
                        continue;
                    }
                    w.removeStyleName("bad-limit");
                    w.removeStyleName("bad-limit-cancel");
                }
            }
            if (nbrHidden == 0) {
                this.iTopDisplayInstructors.setValue(Boolean.valueOf(true));
                this.iBottomDisplayInstructors.setValue(Boolean.valueOf(true));
            } else {
                this.iTopDisplayInstructors.setValue(Boolean.valueOf(false));
                this.iBottomDisplayInstructors.setValue(Boolean.valueOf(false));
            }
            if (nbrUnchecked == 0) {
                this.iTopStudentScheduling.setValue(Boolean.valueOf(true));
                this.iBottomStudentScheduling.setValue(Boolean.valueOf(true));
            } else {
                this.iTopStudentScheduling.setValue(Boolean.valueOf(false));
                this.iTopStudentScheduling.setValue(Boolean.valueOf(false));
            }
            this.iTopDisplayInstructors.setEnabled(nbrEditable > 0);
            this.iBottomDisplayInstructors.setEnabled(nbrEditable > 0);
            this.iTopStudentScheduling.setEnabled(nbrEditable > 0);
            this.iBottomStudentScheduling.setEnabled(nbrEditable > 0);
            this.iTop.clear();
            P label = new P("subpart-label");
            label.setText(this.iName);
            label.getElement().getStyle().setPaddingLeft((double)(this.iIndent * 20), Style.Unit.PX);
            this.iTop.add((Widget)label);
            this.iTop.add((Widget)this.iTopCounter);
            if (MultipleClassSetupPage.this.iData.isDisplayInstructors() && nbrEditable > 0) {
                label = new P("display-instructors-label");
                label.setText(MESSAGES.propertyDisplayInstructors());
                this.iTop.add((Widget)label);
                this.iTop.add((Widget)this.iTopDisplayInstructors);
            }
            if (MultipleClassSetupPage.this.iData.isDisplayEnabledForStudentScheduling() && nbrEditable > 0) {
                label = new P("student-scheduling-label");
                label.setText(MESSAGES.propertyEnabledForStudentScheduling());
                this.iTop.add((Widget)label);
                this.iTop.add((Widget)this.iTopStudentScheduling);
            }
            this.iBottom.clear();
            label = new P("subpart-label");
            label.setText(this.iName);
            label.getElement().getStyle().setPaddingLeft((double)(this.iIndent * 20), Style.Unit.PX);
            this.iBottom.add((Widget)label);
            this.iBottom.add((Widget)this.iBottomCounter);
            if (MultipleClassSetupPage.this.iData.isDisplayInstructors() && nbrEditable > 0) {
                label = new P("display-instructors-label");
                label.setText(MESSAGES.propertyDisplayInstructors());
                this.iBottom.add((Widget)label);
                this.iBottom.add((Widget)this.iBottomDisplayInstructors);
            }
            if (MultipleClassSetupPage.this.iData.isDisplayEnabledForStudentScheduling() && nbrEditable > 0) {
                label = new P("student-scheduling-label");
                label.setText(MESSAGES.propertyEnabledForStudentScheduling());
                this.iBottom.add((Widget)label);
                this.iBottom.add((Widget)this.iBottomStudentScheduling);
            }
        }
    }

    private class SnapshotLimit {
        private Long iSubpartId;
        private int iIndent;
        private String iName = "";
        private Label iTopCounter;
        private Label iBottomCounter;
        private P iTop;
        private P iBottom;

        SnapshotLimit(Long subpartId) {
            this.iSubpartId = subpartId;
            this.iTopCounter = new Label("0");
            this.iTopCounter.addStyleName("subpart-counter");
            this.iBottomCounter = new Label("0");
            this.iBottomCounter.addStyleName("subpart-counter");
            this.iTop = new P("subpart-limit");
            this.iBottom = new P("subpart-limit");
            this.update();
        }

        public void update() {
            int snapshot = 0;
            for (ClassSetupInterface.ClassLine line : MultipleClassSetupPage.this.iData.getClassLines()) {
                if (!this.iSubpartId.equals(line.getSubpartId())) continue;
                this.iName = line.getSubpartLabel() + ":";
                this.iIndent = line.getIndent();
                if (line.getCancelled().booleanValue() || line.getSnapshotLimit() == null) continue;
                snapshot += line.getSnapshotLimit().intValue();
            }
            if (MultipleClassSetupPage.this.iData.isUnlimited().booleanValue()) {
                this.iTopCounter.setText("\u221e");
                this.iBottomCounter.setText("\u221e");
            } else {
                this.iTopCounter.setText(String.valueOf(snapshot));
                this.iBottomCounter.setText(String.valueOf(snapshot));
            }
            this.iTop.clear();
            P label = new P("subpart-label");
            label.setText(this.iName);
            label.getElement().getStyle().setPaddingLeft((double)(this.iIndent * 20), Style.Unit.PX);
            this.iTop.add((Widget)label);
            this.iTop.add((Widget)this.iTopCounter);
            this.iBottom.clear();
            label = new P("subpart-label");
            label.setText(this.iName);
            label.getElement().getStyle().setPaddingLeft((double)(this.iIndent * 20), Style.Unit.PX);
            this.iBottom.add((Widget)label);
            this.iBottom.add((Widget)this.iBottomCounter);
        }
    }
}

