/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.ClassSetupInterface;

public class ClassSetupTable
extends UniTimeTable<ClassSetupInterface.ClassLine> {
    protected static final CourseMessages MESSAGES = (CourseMessages)GWT.create(CourseMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private ClassSetupInterface iData;
    private NumberFormat sRoomRatioFormat = NumberFormat.getFormat((String)"##0.0##");

    public ClassSetupTable(ClassSetupInterface data) {
        this.iData = data;
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (ClassSetupInterface.ClassSetupColumn col : ClassSetupInterface.ClassSetupColumn.values()) {
            if (!this.isColumnVisible(col)) continue;
            UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(col));
            header.add(h);
            h.setHorizontalAlignment(this.getColumnAlighment(col));
        }
        this.addRow(null, header);
        this.setData(data.getClassLines());
        this.setUnlimited(data.isUnlimited());
    }

    protected List<Widget> generateRow(ClassSetupInterface.ClassLine clazz) {
        ArrayList<Widget> line = new ArrayList<Widget>();
        for (ClassSetupInterface.ClassSetupColumn col : ClassSetupInterface.ClassSetupColumn.values()) {
            if (!this.isColumnVisible(col) || clazz.getCancelled().booleanValue() && !this.isCellVisibleWhenCancelled(col)) continue;
            Widget w = this.getColumnWidget(col, clazz);
            line.add(w);
        }
        return line;
    }

    protected void addRow(ClassSetupInterface.ClassLine clazz) {
        this.addRow(clazz, this.generateRow(clazz));
    }

    public void setData(List<ClassSetupInterface.ClassLine> classes) {
        this.clearTable(1);
        if (classes != null) {
            for (ClassSetupInterface.ClassLine clazz : classes) {
                this.addRow(clazz);
            }
        }
    }

    public void updateButtons() {
        for (int row = 1; row < this.getRowCount(); ++row) {
            for (int col = 0; col < this.getCellCount(row); ++col) {
                Widget w = this.getWidget(row, col);
                if (w == null || !(w instanceof HasUpdate)) continue;
                ((HasUpdate)w).update(row);
            }
        }
    }

    protected void onLimitChange() {
    }

    public void setUnlimited(Boolean unlimited) {
        if (Boolean.TRUE.equals(unlimited)) {
            for (ClassSetupInterface.ClassSetupColumn col : ClassSetupInterface.ClassSetupColumn.values()) {
                int idx = this.getIndex(col);
                if (idx < 0) continue;
                this.setColumnVisible(idx, this.isColumnVisibleWhenUnlimited(col));
            }
        } else {
            for (ClassSetupInterface.ClassSetupColumn col : ClassSetupInterface.ClassSetupColumn.values()) {
                int idx = this.getIndex(col);
                if (idx < 0) continue;
                this.setColumnVisible(idx, true);
            }
        }
    }

    public boolean isColumnVisibleWhenUnlimited(ClassSetupInterface.ClassSetupColumn column) {
        switch (column) {
            case SNAPSHOT: 
            case LIMIT: 
            case ROOM: 
            case ROOM_CAP: 
            case NBR_ROOMS: 
            case ROOM_RATIO: 
            case SPLIT_ATTENDANCE: {
                return false;
            }
        }
        return true;
    }

    public boolean isCellVisibleWhenCancelled(ClassSetupInterface.ClassSetupColumn column) {
        switch (column) {
            case SNAPSHOT: 
            case NBR_ROOMS: 
            case ROOM_RATIO: 
            case SPLIT_ATTENDANCE: 
            case DEPARTMENT: 
            case DATE_PATTERN: 
            case LMS: 
            case DISPLAY_INSTRUCTOR: 
            case STUDENT_SCHEDULING: {
                return false;
            }
        }
        return true;
    }

    public boolean isColumnVisible(ClassSetupInterface.ClassSetupColumn column) {
        switch (column) {
            case SNAPSHOT: {
                return this.iData.isDisplaySnapshotLimit();
            }
            case LMS: {
                return this.iData.isDisplayLms();
            }
            case DISPLAY_INSTRUCTOR: {
                return this.iData.isDisplayInstructors();
            }
            case STUDENT_SCHEDULING: {
                return this.iData.isDisplayEnabledForStudentScheduling();
            }
            case EXTERNAL_ID: {
                return this.iData.isDisplayExternalId() || this.iData.isEditExternalId();
            }
            case ENROLLMENT: {
                return this.iData.isDisplayEnrollments();
            }
            case ROOM: 
            case ROOM_CAP: 
            case TIME: 
            case DATE: {
                return this.iData.isHasTimeRooms();
            }
            case INSTRUCTOR: {
                return this.iData.isHasInstructors();
            }
        }
        return true;
    }

    public String getColumnName(ClassSetupInterface.ClassSetupColumn column) {
        switch (column) {
            case ERROR: {
                return "";
            }
            case CLASS_NAME: {
                return "";
            }
            case EXTERNAL_ID: {
                return MESSAGES.columnExternalId();
            }
            case BUTTONS: {
                return "";
            }
            case ENROLLMENT: {
                return MESSAGES.columnEnroll();
            }
            case CANCELLED: {
                return "";
            }
            case SNAPSHOT: {
                return MESSAGES.columnSnapshotLimitBr();
            }
            case LIMIT: {
                if (this.iData.isDisplayMaxLimit()) {
                    return MESSAGES.columnLimit() + "<br>" + MESSAGES.columnMin() + " - " + MESSAGES.columnMax();
                }
                return MESSAGES.columnLimit();
            }
            case ROOM_RATIO: {
                return MESSAGES.columnRoomRatioBr();
            }
            case NBR_ROOMS: {
                return MESSAGES.columnNbrRms();
            }
            case SPLIT_ATTENDANCE: {
                return MESSAGES.columnSplitAttnd();
            }
            case DEPARTMENT: {
                return MESSAGES.columnManagingDepartment();
            }
            case DATE_PATTERN: {
                return MESSAGES.columnDatePattern();
            }
            case LMS: {
                return MESSAGES.columnLms();
            }
            case DISPLAY_INSTRUCTOR: {
                return MESSAGES.columnDisplayInstr();
            }
            case STUDENT_SCHEDULING: {
                return MESSAGES.columnStudentScheduling();
            }
            case TIME: {
                return MESSAGES.columnAssignedTime();
            }
            case DATE: {
                return MESSAGES.columnAssignedDatePattern();
            }
            case ROOM: {
                return MESSAGES.columnAssignedRoom();
            }
            case ROOM_CAP: {
                return MESSAGES.columnAssignedRoomCap();
            }
            case INSTRUCTOR: {
                return MESSAGES.columnInstructors();
            }
        }
        return column.name();
    }

    public HasHorizontalAlignment.HorizontalAlignmentConstant getColumnAlighment(ClassSetupInterface.ClassSetupColumn column) {
        switch (column) {
            case LIMIT: {
                return HasHorizontalAlignment.ALIGN_CENTER;
            }
            case ROOM_CAP: {
                return HasHorizontalAlignment.ALIGN_RIGHT;
            }
        }
        return HasHorizontalAlignment.ALIGN_LEFT;
    }

    public int getIndex(ClassSetupInterface.ClassSetupColumn column) {
        if (!this.isColumnVisible(column)) {
            return -1;
        }
        int index = 0;
        for (ClassSetupInterface.ClassSetupColumn c : ClassSetupInterface.ClassSetupColumn.values()) {
            if (c.ordinal() >= column.ordinal() || !this.isColumnVisible(c)) continue;
            ++index;
        }
        return index;
    }

    protected void updateLine(ClassSetupInterface.ClassLine line) {
        for (int row = 1; row < this.getRowCount(); ++row) {
            if (!line.getClassId().equals(((ClassSetupInterface.ClassLine)this.getData(row)).getClassId())) continue;
            this.setRow(row, line, this.generateRow(line));
            break;
        }
    }

    protected int getRow(ClassSetupInterface.ClassLine line) {
        if (line == null) {
            return -1;
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            if (!line.equals(this.getData(row))) continue;
            return row;
        }
        return -1;
    }

    protected boolean focus(Widget w) {
        if (w instanceof Focusable) {
            ((Focusable)w).setFocus(true);
            return true;
        }
        return false;
    }

    protected void cancelClass(ClassSetupInterface.ClassLine line, boolean cancel) {
        if (cancel == line.getCancelled() || !line.isCanCancel()) {
            return;
        }
        for (ClassSetupInterface.ClassLine l : this.iData.getLines(line)) {
            if (l.isCanCancel()) {
                l.setCancelled(cancel);
            }
            int row = this.getRow(l);
            this.setRow(this.insertRow(row), l, this.generateRow(l));
            this.removeRow(row + 1);
        }
        this.updateButtons();
        this.onLimitChange();
        P buttons = (P)this.getWidget(this.getRow(line), this.getIndex(ClassSetupInterface.ClassSetupColumn.BUTTONS));
        this.focus(buttons.getWidget(4));
    }

    protected void deleteClass(ClassSetupInterface.ClassLine line) {
        int row = this.getRow(line);
        List<ClassSetupInterface.ClassLine> deletes = this.iData.getLines(line);
        this.iData.getClassLines().removeAll(deletes);
        for (int idx = 0; idx < deletes.size(); ++idx) {
            this.removeRow(row);
        }
        this.updateButtons();
        this.onLimitChange();
        if (row >= this.getRowCount()) {
            row = this.getRowCount() - 1;
        }
        P buttons = (P)this.getWidget(row, this.getIndex(ClassSetupInterface.ClassSetupColumn.BUTTONS));
        this.focus(buttons.getWidget(2));
    }

    protected void duplicateClass(ClassSetupInterface.ClassLine line) {
        HashMap<Long, Long> parents = new HashMap<Long, Long>();
        HashSet<Long> ids = new HashSet<Long>();
        ArrayList<ClassSetupInterface.ClassLine> copies = new ArrayList<ClassSetupInterface.ClassLine>();
        int row = -1;
        for (int i = 0; i < this.iData.getClassLines().size(); ++i) {
            ClassSetupInterface.ClassLine copy;
            ClassSetupInterface.ClassLine l = this.iData.getClassLines().get(i);
            if (l.equals(line)) {
                copy = this.iData.copy(l);
                copies.add(copy);
                parents.put(l.getClassId(), copy.getClassId());
                ids.add(l.getClassId());
                row = i + 1;
                continue;
            }
            if (l.getParentId() == null || !ids.contains(l.getParentId())) continue;
            ids.add(l.getClassId());
            row = i + 1;
            if (!Boolean.FALSE.equals(l.getCancelled()) || !parents.containsKey(l.getParentId())) continue;
            copy = this.iData.copy(l);
            copy.setParentId((Long)parents.get(l.getParentId()));
            parents.put(l.getClassId(), copy.getClassId());
            copies.add(copy);
        }
        this.iData.getClassLines().addAll(row, copies);
        int idx = 0;
        for (ClassSetupInterface.ClassLine l : copies) {
            this.setRow(this.insertRow(row + 1 + idx++), l, this.generateRow(l));
        }
        this.updateButtons();
        this.onLimitChange();
        P buttons = (P)this.getWidget(row + 1, this.getIndex(ClassSetupInterface.ClassSetupColumn.BUTTONS));
        this.focus(buttons.getWidget(3));
    }

    protected void moveClassUp(ClassSetupInterface.ClassLine line) {
        int subIdx = this.iData.getSubpartIndex(line.getSubpartId());
        ClassSetupInterface.ClassLine newParent = this.iData.getClassLine(this.iData.getPreviousParentId(line));
        if (newParent == null) {
            return;
        }
        List<ClassSetupInterface.ClassLine> data = this.iData.getLines(line);
        List<ClassSetupInterface.ClassLine> parents = this.iData.getLines(newParent);
        ClassSetupInterface.ClassLine prev = null;
        for (ClassSetupInterface.ClassLine l : parents) {
            if (prev == null) {
                prev = l;
                continue;
            }
            if (!newParent.getClassId().equals(l.getParentId()) || this.iData.getSubpartIndex(l.getSubpartId()) > subIdx) continue;
            prev = this.iData.getLastLine(l);
        }
        int oldRow = this.iData.getClassLines().indexOf(line) + 1;
        this.iData.getClassLines().removeAll(data);
        for (int idx = 0; idx < data.size(); ++idx) {
            this.removeRow(oldRow);
        }
        line.setParentId(newParent.getClassId());
        int newRow = this.iData.getClassLines().indexOf(prev) + 1;
        this.iData.getClassLines().addAll(newRow, data);
        int idx = 0;
        for (ClassSetupInterface.ClassLine l : data) {
            this.setRow(this.insertRow(newRow + 1 + idx++), l, this.generateRow(l));
        }
        this.updateButtons();
        this.onLimitChange();
        P buttons = (P)this.getWidget(newRow + 1, this.getIndex(ClassSetupInterface.ClassSetupColumn.BUTTONS));
        if (!this.focus(buttons.getWidget(0))) {
            this.focus(buttons.getWidget(1));
        }
    }

    protected void moveClassDown(ClassSetupInterface.ClassLine line) {
        int subIdx = this.iData.getSubpartIndex(line.getSubpartId());
        ClassSetupInterface.ClassLine newParent = this.iData.getClassLine(this.iData.getNextParentId(line));
        if (newParent == null) {
            return;
        }
        List<ClassSetupInterface.ClassLine> parents = this.iData.getLines(newParent);
        List<ClassSetupInterface.ClassLine> data = this.iData.getLines(line);
        ClassSetupInterface.ClassLine prev = null;
        for (ClassSetupInterface.ClassLine l : parents) {
            if (prev == null) {
                prev = l;
                continue;
            }
            if (!newParent.getClassId().equals(l.getParentId()) || this.iData.getSubpartIndex(l.getSubpartId()) >= subIdx) continue;
            prev = this.iData.getLastLine(l);
        }
        int oldRow = this.iData.getClassLines().indexOf(line) + 1;
        this.iData.getClassLines().removeAll(data);
        for (int idx = 0; idx < data.size(); ++idx) {
            this.removeRow(oldRow);
        }
        line.setParentId(newParent.getClassId());
        int newRow = this.iData.getClassLines().indexOf(prev) + 1;
        this.iData.getClassLines().addAll(newRow, data);
        int idx = 0;
        for (ClassSetupInterface.ClassLine l : data) {
            this.setRow(this.insertRow(newRow + 1 + idx++), l, this.generateRow(l));
        }
        this.updateButtons();
        this.onLimitChange();
        P buttons = (P)this.getWidget(newRow + 1, this.getIndex(ClassSetupInterface.ClassSetupColumn.BUTTONS));
        if (!this.focus(buttons.getWidget(1))) {
            this.focus(buttons.getWidget(0));
        }
    }

    public Widget getColumnWidget(ClassSetupInterface.ClassSetupColumn column, final ClassSetupInterface.ClassLine line) {
        switch (column) {
            case ERROR: {
                Error error = new Error(line);
                error.update(this.getRowCount());
                return error;
            }
            case CLASS_NAME: {
                Label className = new Label(line.getLabel());
                className.getElement().getStyle().setPaddingLeft((double)(20 * line.getIndent()), Style.Unit.PX);
                className.addStyleName("class-name");
                if (!line.isEditable() || line.getCancelled().booleanValue()) {
                    className.addStyleName("not-editable");
                }
                return className;
            }
            case BUTTONS: {
                Buttons buttons = new Buttons();
                int row = this.getRowCount();
                Operation up = new Operation(line, RESOURCES.orderUp(), MESSAGES.titleMoveClassUp(), 0, new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ClassSetupTable.this.moveClassUp(line);
                    }
                }, new Check(){

                    @Override
                    public boolean check(ClassSetupInterface.ClassLine line) {
                        return ClassSetupTable.this.iData.getPreviousParentId(line) != null && ClassSetupTable.this.iData.canMoveAway(line);
                    }
                });
                up.update(row);
                buttons.add((Widget)up);
                Operation down = new Operation(line, RESOURCES.orderDown(), MESSAGES.titleMoveClassDown(), 1, new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ClassSetupTable.this.moveClassDown(line);
                    }
                }, new Check(){

                    @Override
                    public boolean check(ClassSetupInterface.ClassLine line) {
                        return ClassSetupTable.this.iData.getNextParentId(line) != null && ClassSetupTable.this.iData.canMoveAway(line);
                    }
                });
                down.update(row);
                buttons.add((Widget)down);
                Operation delete = new Operation(line, RESOURCES.delete(), MESSAGES.titleRemoveClassFromIO(), 2, new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ClassSetupTable.this.deleteClass(line);
                    }
                }, new Check(){

                    @Override
                    public boolean check(ClassSetupInterface.ClassLine line) {
                        return ClassSetupTable.this.iData.canDelete(line);
                    }
                });
                delete.update(row);
                buttons.add((Widget)delete);
                Operation add = new Operation(line, RESOURCES.add(), MESSAGES.titleAddClassToIO(), 3, new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ClassSetupTable.this.duplicateClass(line);
                    }
                }, new Check(){

                    @Override
                    public boolean check(ClassSetupInterface.ClassLine line) {
                        return Boolean.FALSE.equals(line.getCancelled());
                    }
                });
                add.update(row);
                buttons.add((Widget)add);
                MultiOperation cancel = new MultiOperation(line, new ImageResource[]{RESOURCES.reopenClass(), RESOURCES.cancelClass()}, new String[]{MESSAGES.titleReopenClass(), MESSAGES.titleCancelClass()}, 4, new ClickHandler[]{new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ClassSetupTable.this.cancelClass(line, false);
                    }
                }, new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ClassSetupTable.this.cancelClass(line, true);
                    }
                }}, new MultiCheck(){

                    @Override
                    public int check(ClassSetupInterface.ClassLine line) {
                        if (ClassSetupTable.this.iData.canCancel(line)) {
                            if (line.getCancelled().booleanValue()) {
                                return 0;
                            }
                            return 1;
                        }
                        return -1;
                    }
                });
                cancel.update(row);
                buttons.add((Widget)cancel);
                return buttons;
            }
            case ENROLLMENT: {
                Label enrollment = new Label(line.getEnrollment() == null ? "" : line.getEnrollment().toString());
                enrollment.addStyleName("class-enrollment");
                if (!line.isEditable() || line.getCancelled().booleanValue()) {
                    enrollment.addStyleName("not-editable");
                }
                return enrollment;
            }
            case CANCELLED: {
                if (line.getCancelled().booleanValue()) {
                    return new Cancelled(line);
                }
                return new Label();
            }
            case LIMIT: {
                ClassLimit limit = new ClassLimit(line);
                limit.update(this.getRowCount());
                return limit;
            }
            case SNAPSHOT: {
                if (this.iData.isEditSnapshotLimits()) {
                    final MyNumberBox snapshot = new MyNumberBox(9000);
                    snapshot.setMaxLength(5);
                    snapshot.setWidth("40px");
                    snapshot.setValue(line.getSnapshotLimit());
                    snapshot.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                        public void onValueChange(ValueChangeEvent<String> event) {
                            try {
                                line.setSnapshotLimit(Integer.parseInt((String)event.getValue()));
                            }
                            catch (NumberFormatException e) {
                                line.setSnapshotLimit(null);
                                snapshot.setText("");
                            }
                            ClassSetupTable.this.onLimitChange();
                        }
                    });
                    snapshot.addStyleName("class-snapshot");
                    snapshot.setReadOnly(!line.isEditable() || line.getCancelled() != false);
                    snapshot.update(this.getRowCount());
                    return snapshot;
                }
                Label snapshot = new Label(line.getSnapshotLimit() == null ? "" : line.getSnapshotLimit().toString());
                snapshot.addStyleName("class-snapshot");
                return snapshot;
            }
            case ROOM_RATIO: {
                final MyNumberBox roomRatio = new MyNumberBox(10000);
                roomRatio.setDecimal(true);
                roomRatio.setMaxLength(6);
                roomRatio.setWidth("40px");
                roomRatio.addStyleName("class-room-ratio");
                roomRatio.setValue(this.sRoomRatioFormat.format(line.getRoomRatio() == null ? 1.0 : (double)line.getRoomRatio().floatValue()));
                roomRatio.setReadOnly(!line.isEditable());
                roomRatio.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        try {
                            line.setRoomRatio(Float.valueOf((float)NumberFormat.getDecimalFormat().parse((String)event.getValue())));
                        }
                        catch (NumberFormatException e) {
                            try {
                                line.setRoomRatio(Float.valueOf(Float.parseFloat((String)event.getValue())));
                            }
                            catch (NumberFormatException f) {
                                line.setRoomRatio(Float.valueOf(1.0f));
                            }
                        }
                        roomRatio.setValue(ClassSetupTable.this.sRoomRatioFormat.format((Number)line.getRoomRatio()));
                    }
                });
                roomRatio.update(this.getRowCount());
                return roomRatio;
            }
            case NBR_ROOMS: {
                final MyNumberBox nbrRooms = new MyNumberBox(11000);
                nbrRooms.setMaxLength(5);
                nbrRooms.setDecimal(false);
                nbrRooms.setWidth("40px");
                nbrRooms.addStyleName("class-nbr-rooms");
                nbrRooms.setValue(line.getNumberOfRooms());
                nbrRooms.setReadOnly(!line.isEditable());
                nbrRooms.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        try {
                            line.setNumberOfRooms(Integer.parseInt((String)event.getValue()));
                        }
                        catch (NumberFormatException e) {
                            line.setNumberOfRooms(1);
                            nbrRooms.setText("1");
                        }
                        CheckBox splitAttendance = (CheckBox)ClassSetupTable.this.getWidget(ClassSetupTable.this.getRowForWidget((Widget)nbrRooms), ClassSetupTable.this.getIndex(ClassSetupInterface.ClassSetupColumn.SPLIT_ATTENDANCE));
                        splitAttendance.setEnabled(line.getNumberOfRooms() != null && line.getNumberOfRooms() > 1);
                        if (!splitAttendance.isEnabled() && splitAttendance.getValue().booleanValue()) {
                            splitAttendance.setValue(Boolean.valueOf(false), true);
                        }
                    }
                });
                nbrRooms.update(this.getRowCount());
                return nbrRooms;
            }
            case SPLIT_ATTENDANCE: {
                MyCheckBox splitAttendance = new MyCheckBox(12000);
                splitAttendance.setValue(line.getSplitAttendance());
                splitAttendance.addStyleName("class-split-attendace");
                splitAttendance.setEnabled(line.isEditable() && line.getNumberOfRooms() != null && line.getNumberOfRooms() > 1);
                splitAttendance.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        line.setSplitAttendance((Boolean)event.getValue());
                    }
                });
                splitAttendance.update(this.getRowCount());
                return splitAttendance;
            }
            case DEPARTMENT: {
                final MyListBox department = new MyListBox(13000);
                department.addStyleName("class-department");
                department.setWidth("150px");
                for (ClassSetupInterface.Reference d : this.iData.getDepartments()) {
                    if (d.isSelectable() || d.getId().equals(line.getDepartmentId())) {
                        department.addItem(d.getLabel(), d.getId().toString());
                    }
                    if (!d.getId().equals(line.getDepartmentId())) continue;
                    department.setSelectedIndex(department.getItemCount() - 1);
                }
                department.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        line.setDepartmentId(Long.valueOf(department.getSelectedValue()));
                    }
                });
                department.setEnabled(line.isEditable());
                department.update(this.getRowCount());
                return department;
            }
            case DATE_PATTERN: {
                final MyListBox datePattern = new MyListBox(14000);
                datePattern.setWidth("150px");
                datePattern.addStyleName("class-date-pattern");
                ClassSetupInterface.Subpart subpart = this.iData.getSubpart(line.getSubpartId());
                datePattern.addItem(MESSAGES.dropDefaultDatePattern() + (String)(subpart != null && subpart.hasDefaultDatePatternName() ? " (" + subpart.getDefaultDatePatternName() + ")" : ""), "-1");
                if (line.getDatePatternId() == null) {
                    datePattern.setSelectedIndex(0);
                }
                for (ClassSetupInterface.Reference d : this.iData.getDatePatterns()) {
                    if (d.isSelectable() || d.getId().equals(line.getDatePatternId())) {
                        datePattern.addItem(d.getLabel(), d.getId().toString());
                    }
                    if (!d.getId().equals(line.getDatePatternId())) continue;
                    datePattern.setSelectedIndex(datePattern.getItemCount() - 1);
                }
                datePattern.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        String dp = datePattern.getSelectedValue();
                        if (dp == null || dp.isEmpty()) {
                            line.setDatePatternId(null);
                        } else {
                            line.setDatePatternId(Long.valueOf(dp));
                        }
                    }
                });
                datePattern.setEnabled(line.isEditable() && line.isEditableDatePattern());
                datePattern.update(this.getRowCount());
                return datePattern;
            }
            case DISPLAY_INSTRUCTOR: {
                MyCheckBox displayInstructor = new MyCheckBox(16000);
                displayInstructor.addStyleName("class-display-instructor");
                displayInstructor.setValue(line.getDisplayInstructors());
                displayInstructor.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        line.setDisplayInstructors((Boolean)event.getValue());
                        ClassSetupTable.this.onLimitChange();
                    }
                });
                displayInstructor.setEnabled(line.isEditable());
                displayInstructor.update(this.getRowCount());
                return displayInstructor;
            }
            case STUDENT_SCHEDULING: {
                MyCheckBox studentScheduling = new MyCheckBox(17000);
                studentScheduling.addStyleName("class-display-instructor");
                studentScheduling.setValue(line.getEnabledForStudentScheduling());
                studentScheduling.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        line.setEnabledForStudentScheduling((Boolean)event.getValue());
                        ClassSetupTable.this.onLimitChange();
                    }
                });
                studentScheduling.setEnabled(line.isEditable());
                studentScheduling.update(this.getRowCount());
                return studentScheduling;
            }
            case EXTERNAL_ID: {
                MyTextBox extId = new MyTextBox(1000);
                extId.addStyleName("class-external-id");
                extId.setMaxLength(40);
                extId.setWidth("135px");
                extId.setValue(line.getExternalId() == null ? "" : line.getExternalId());
                extId.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        if (event.getValue() == null || ((String)event.getValue()).isEmpty()) {
                            line.setExternalId(null);
                        } else {
                            line.setExternalId((String)event.getValue());
                        }
                    }
                });
                if (line.getCancelled().booleanValue()) {
                    extId.addStyleName("not-editable");
                }
                extId.setReadOnly(!line.isEditable() || !this.iData.isEditExternalId());
                extId.update(this.getRowCount());
                return extId;
            }
            case LMS: {
                final MyListBox lms = new MyListBox(15000);
                lms.addStyleName("class-lms");
                lms.setWidth("150px");
                for (ClassSetupInterface.Reference d : this.iData.getLMSs()) {
                    if (d.isSelectable() || d.getId().equals(line.getLMS())) {
                        lms.addItem(d.getLabel(), d.getId().toString());
                    }
                    if (!d.getId().equals(line.getLMS())) continue;
                    lms.setSelectedIndex(lms.getItemCount() - 1);
                }
                lms.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        String id = lms.getSelectedValue();
                        if (id == null || id.isEmpty()) {
                            line.setLMS(null);
                        } else {
                            line.setLMS(Long.valueOf(id));
                        }
                    }
                });
                lms.setEnabled(line.isEditable());
                lms.update(15000);
                return lms;
            }
            case TIME: {
                HTML time = new HTML(line.getTime() == null ? "" : line.getTime());
                time.addStyleName("class-time");
                if (line.getCancelled().booleanValue()) {
                    time.addStyleName("class-cancelled");
                } else if (!line.isEditable()) {
                    time.addStyleName("not-editable");
                }
                return time;
            }
            case DATE: {
                HTML date = new HTML(line.getDate() == null ? "" : line.getDate());
                date.addStyleName("class-date");
                if (line.getCancelled().booleanValue()) {
                    date.addStyleName("class-cancelled");
                } else if (!line.isEditable()) {
                    date.addStyleName("not-editable");
                }
                return date;
            }
            case ROOM: {
                P rooms = new P("class-room");
                if (line.hasRooms()) {
                    for (final ClassSetupInterface.Reference room : line.getRooms()) {
                        final Label roomLabel = new Label(room.getLabel());
                        roomLabel.addMouseOverHandler(new MouseOverHandler(){

                            public void onMouseOver(MouseOverEvent event) {
                                RoomHint.showHint((Element)roomLabel.getElement(), room.getId(), null, null, true);
                            }
                        });
                        roomLabel.addMouseOutHandler(new MouseOutHandler(){

                            public void onMouseOut(MouseOutEvent event) {
                                RoomHint.hideHint();
                            }
                        });
                        rooms.add((Widget)roomLabel);
                    }
                }
                if (line.getCancelled().booleanValue()) {
                    rooms.addStyleName("class-cancelled");
                } else if (!line.isEditable()) {
                    rooms.addStyleName("not-editable");
                }
                return rooms;
            }
            case ROOM_CAP: {
                P roomsCap = new P("class-room-cap");
                if (line.hasRooms()) {
                    for (final ClassSetupInterface.Reference room : line.getRooms()) {
                        final Label roomCap = new Label(room.getReference());
                        roomCap.addMouseOverHandler(new MouseOverHandler(){

                            public void onMouseOver(MouseOverEvent event) {
                                RoomHint.showHint((Element)roomCap.getElement(), room.getId(), null, null, true);
                            }
                        });
                        roomCap.addMouseOutHandler(new MouseOutHandler(){

                            public void onMouseOut(MouseOutEvent event) {
                                RoomHint.hideHint();
                            }
                        });
                        roomsCap.add((Widget)roomCap);
                    }
                }
                if (line.getCancelled().booleanValue()) {
                    roomsCap.addStyleName("class-cancelled");
                } else if (!line.isEditable()) {
                    roomsCap.addStyleName("not-editable");
                }
                return roomsCap;
            }
            case INSTRUCTOR: {
                HTML instructor = new HTML(line.getInstructor() == null ? "" : line.getInstructor());
                instructor.addStyleName("class-instructor");
                if (line.getCancelled().booleanValue()) {
                    instructor.addStyleName("class-cancelled");
                } else if (!line.isEditable()) {
                    instructor.addStyleName("not-editable");
                }
                return instructor;
            }
        }
        return null;
    }

    private static interface HasUpdate {
        public void update(int var1);
    }

    private class Error
    extends P
    implements HasUpdate {
        private ClassSetupInterface.ClassLine iLine;
        private Image iError;

        Error(ClassSetupInterface.ClassLine line) {
            super("class-error");
            this.iLine = line;
            this.iError = new Image(RESOURCES.attention());
            this.iError.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    UniTimeConfirmationDialog.alert(Error.this.iLine.getError());
                }
            });
        }

        @Override
        public void update(int row) {
            this.clear();
            if (this.iLine.hasError()) {
                this.iError.setTitle(this.iLine.getError());
                this.add((Widget)this.iError);
            }
        }
    }

    private class Buttons
    extends P
    implements HasUpdate {
        private Buttons() {
            super("class-buttons");
        }

        @Override
        public void update(int row) {
            for (int i = 0; i < this.getWidgetCount(); ++i) {
                ((HasUpdate)this.getWidget(i)).update(row);
            }
        }
    }

    private class Operation
    extends P
    implements HasUpdate,
    Focusable {
        private Image iBlank;
        private ImageButton iButton;
        private ClassSetupInterface.ClassLine iLine;
        private int iButtonIndex;
        private ClickHandler iClickHandler;
        private Check iCheck;
        private boolean iLastCheck = false;

        private Operation(ClassSetupInterface.ClassLine line, ImageResource image, String title, int buttonIndex, ClickHandler click, Check check) {
            this.iButton = new ImageButton(image);
            this.iButton.setTitle(title);
            this.iButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (ClassSetupTable.this.isEnabled()) {
                        Operation.this.iClickHandler.onClick(event);
                    }
                }
            });
            this.iBlank = new Image(RESOURCES.blank());
            this.iLine = line;
            this.iClickHandler = click;
            this.iCheck = check;
            this.iButtonIndex = buttonIndex;
            this.add((Widget)this.iBlank);
        }

        @Override
        public void update(int row) {
            boolean check = this.iCheck.check(this.iLine);
            if (check != this.iLastCheck) {
                this.iLastCheck = check;
                this.clear();
                if (this.iLastCheck) {
                    this.add((Widget)this.iButton);
                } else {
                    this.add((Widget)this.iBlank);
                }
            }
            if (check) {
                this.iButton.setTabIndex(2000 + 5 * row + this.iButtonIndex);
            }
        }

        public void setFocus(boolean focus) {
            if (this.iLastCheck) {
                this.iButton.setFocus(focus);
            }
        }

        public int getTabIndex() {
            if (this.iLastCheck) {
                return this.iButton.getTabIndex();
            }
            return -1;
        }

        public void setAccessKey(char key) {
            this.iButton.setAccessKey(key);
        }

        public void setTabIndex(int index) {
            this.iButton.setTabIndex(index);
        }
    }

    private static interface Check {
        public boolean check(ClassSetupInterface.ClassLine var1);
    }

    private class MultiOperation
    extends P
    implements HasUpdate,
    Focusable {
        private ClassSetupInterface.ClassLine iLine;
        private Image iBlank = new Image(RESOURCES.blank());
        private ImageButton[] iButton;
        private int iButtonIndex;
        protected ClickHandler[] iClickHandler;
        protected MultiCheck iCheck;
        protected int iLastCheck = -1;

        private MultiOperation(ClassSetupInterface.ClassLine line, ImageResource[] image, String[] title, int buttonIndex, ClickHandler[] click, MultiCheck check) {
            this.iButton = new ImageButton[image.length];
            for (int i = 0; i < image.length; ++i) {
                this.iButton[i] = new ImageButton(image[i]);
                this.iButton[i].setTitle(title[i]);
                this.iButton[i].addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (MultiOperation.this.iLastCheck >= 0) {
                            MultiOperation.this.iClickHandler[MultiOperation.this.iLastCheck].onClick(event);
                        }
                    }
                });
            }
            this.iLine = line;
            this.iClickHandler = click;
            this.iCheck = check;
            this.iButtonIndex = buttonIndex;
            this.add((Widget)this.iBlank);
        }

        @Override
        public void update(int row) {
            int check = this.iCheck.check(this.iLine);
            if (check != this.iLastCheck) {
                this.iLastCheck = check;
                this.clear();
                if (this.iLastCheck >= 0) {
                    this.add((Widget)this.iButton[this.iLastCheck]);
                } else {
                    this.add((Widget)this.iBlank);
                }
            }
            if (check >= 0) {
                this.iButton[this.iLastCheck].setTabIndex(2000 + 5 * row + this.iButtonIndex);
            }
        }

        public void setFocus(boolean focus) {
            if (this.iLastCheck >= 0) {
                this.iButton[this.iLastCheck].setFocus(focus);
            }
        }

        public int getTabIndex() {
            if (this.iLastCheck >= 0) {
                return this.iButton[this.iLastCheck].getTabIndex();
            }
            return -1;
        }

        public void setAccessKey(char key) {
            for (int i = 0; i < this.iButton.length; ++i) {
                this.iButton[i].setAccessKey(key);
            }
        }

        public void setTabIndex(int index) {
            if (this.iLastCheck >= 0) {
                this.iButton[this.iLastCheck].setTabIndex(index);
            }
        }
    }

    private static interface MultiCheck {
        public int check(ClassSetupInterface.ClassLine var1);
    }

    private class Cancelled
    extends Label
    implements UniTimeTable.HasColSpan {
        private Cancelled(ClassSetupInterface.ClassLine line) {
            this.addStyleName("class-cancelled");
            this.setText(MESSAGES.classNoteCancelled(line.getLabel()));
        }

        @Override
        public int getColSpan() {
            int colSpan = 1;
            for (ClassSetupInterface.ClassSetupColumn c : ClassSetupInterface.ClassSetupColumn.values()) {
                if (!ClassSetupTable.this.isColumnVisible(c) || ClassSetupTable.this.isCellVisibleWhenCancelled(c)) continue;
                ++colSpan;
            }
            return colSpan;
        }
    }

    class ClassLimit
    extends P
    implements HasUpdate {
        private NumberBox iMin;
        private NumberBox iMax;

        ClassLimit(final ClassSetupInterface.ClassLine line) {
            super("class-limit");
            this.iMin = new NumberBox();
            this.iMin.setMaxLength(5);
            this.iMin.setValue(line.getMinClassLimit());
            this.iMin.setReadOnly(!line.isEditable() || line.getCancelled() != false);
            this.iMin.setWidth("40px");
            if (line.getCancelled().booleanValue()) {
                this.iMin.addStyleName("class-cancelled");
            }
            this.add((Widget)this.iMin);
            this.iMax = new NumberBox();
            this.iMax.setMaxLength(5);
            this.iMax.setValue(line.getMaxClassLimit());
            this.iMax.setReadOnly(!line.isEditable() || line.getCancelled() != false);
            this.iMax.setWidth("40px");
            this.iMax.getElement().getStyle().setMarginLeft(2.0, Style.Unit.PX);
            this.iMax.setVisible(ClassSetupTable.this.iData.isDisplayMaxLimit());
            if (line.getCancelled().booleanValue()) {
                this.iMax.addStyleName("class-cancelled");
            }
            this.add((Widget)this.iMax);
            this.iMin.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    try {
                        line.setMinClassLimit(Integer.parseInt((String)event.getValue()));
                    }
                    catch (NumberFormatException e) {
                        line.setMinClassLimit(null);
                        ClassLimit.this.iMin.setText("");
                    }
                    line.setMaxClassLimit(line.getMinClassLimit());
                    ClassLimit.this.iMax.setText(ClassLimit.this.iMin.getText());
                    ClassSetupTable.this.onLimitChange();
                }
            });
            this.iMax.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    try {
                        line.setMaxClassLimit(Integer.parseInt((String)event.getValue()));
                    }
                    catch (NumberFormatException e) {
                        line.setMaxClassLimit(line.getMinClassLimit());
                        ClassLimit.this.iMax.setValue(line.getMaxClassLimit());
                    }
                    if (line.getMaxClassLimit() != null && line.getMinClassLimit() != null && line.getMaxClassLimit() < line.getMinClassLimit()) {
                        line.setMaxClassLimit(line.getMinClassLimit());
                        ClassLimit.this.iMax.setValue(line.getMaxClassLimit());
                    }
                    ClassSetupTable.this.onLimitChange();
                }
            });
        }

        public void setMaxVisible(boolean visible) {
            this.iMax.setVisible(visible);
        }

        @Override
        public void update(int row) {
            this.iMin.setTabIndex(7000 + 2 * row);
            this.iMax.setTabIndex(7000 + 2 * row + 1);
        }
    }

    private class MyNumberBox
    extends NumberBox
    implements HasUpdate {
        private int iBaseIndex;

        MyNumberBox(int baseIndex) {
            this.iBaseIndex = baseIndex;
        }

        @Override
        public void update(int row) {
            this.setTabIndex(this.iBaseIndex + row);
        }
    }

    private class MyCheckBox
    extends CheckBox
    implements HasUpdate {
        private int iBaseIndex;

        MyCheckBox(int baseIndex) {
            this.iBaseIndex = baseIndex;
        }

        @Override
        public void update(int row) {
            this.setTabIndex(this.iBaseIndex + row);
        }
    }

    private class MyListBox
    extends ListBox
    implements HasUpdate {
        private int iBaseIndex;

        MyListBox(int baseIndex) {
            this.iBaseIndex = baseIndex;
        }

        @Override
        public void update(int row) {
            this.setTabIndex(this.iBaseIndex + row);
        }
    }

    private class MyTextBox
    extends UniTimeTextBox
    implements HasUpdate {
        private int iBaseIndex;

        MyTextBox(int baseIndex) {
            this.iBaseIndex = baseIndex;
        }

        @Override
        public void update(int row) {
            this.setTabIndex(this.iBaseIndex + row);
        }
    }
}

