/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor.survey;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.admin.AdminCookie;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyInterface;
import org.unitime.timetable.gwt.client.rooms.RoomsTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class InstructorRequirementsTable
extends UniTimeTable<InstructorSurveyInterface.CourseRequirement> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private List<InstructorSurveyInterface.CustomField> iCustomFields;
    private boolean iCrossList;
    private Column iSortBy = null;
    private boolean iAsc = true;
    private int iCustom = 0;

    public InstructorRequirementsTable(final InstructorSurveyInterface.InstructorRequirementData data) {
        this.iCustomFields = data.getCustomFields();
        this.iCrossList = data.isCrossList();
        this.addStyleName("unitime-InstructorSurveyCourseTable");
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final Column col : Column.values()) {
            for (int i = 0; i < this.getColSpan(col); ++i) {
                final UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(col, i));
                final int index = i;
                if (CourseRequirementComparator.isApplicable(col)) {
                    RoomsTable.SortOperation op = new RoomsTable.SortOperation(){

                        public void execute() {
                            InstructorRequirementsTable.this.doSort(col, index);
                        }

                        @Override
                        public boolean isApplicable() {
                            return InstructorRequirementsTable.this.getRowCount() > 1 && h.isVisible();
                        }

                        @Override
                        public boolean hasSeparator() {
                            return false;
                        }

                        @Override
                        public String getName() {
                            return MESSAGES.opSortBy(this.getColumnName());
                        }

                        @Override
                        public String getColumnName() {
                            return h.getHTML().replace("<br>", " ");
                        }
                    };
                    h.addOperation(op);
                }
                header.add(h);
            }
        }
        this.addRow(null, header);
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        this.setSortBy(AdminCookie.getInstance().getSortCourseRequirements());
        this.setData(data.getInstructorRequirements());
        this.addMouseClickListener(new UniTimeTable.MouseClickListener<InstructorSurveyInterface.CourseRequirement>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<InstructorSurveyInterface.CourseRequirement> event) {
                if (event.getData() == null) {
                    return;
                }
                if (data.isAdmin()) {
                    UniTimeFrameDialog.openDialog(MESSAGES.sectInstructorSurvey(), "instructorSurvey?menu=hide&id=" + event.getData().getExternalId(), "900", "90%");
                } else if (event.getData().getInstructorId() != null) {
                    ToolBox.open("instructorDetail.action?instructorId=" + event.getData().getInstructorId());
                }
            }
        });
    }

    public void addRow(InstructorSurveyInterface.CourseRequirement course) {
        ArrayList<Widget> line = new ArrayList<Widget>();
        for (Column col : Column.values()) {
            for (int i = 0; i < this.getColSpan(col); ++i) {
                line.add(this.getColumnWidget(col, course, i));
            }
        }
        this.addRow(course, line);
    }

    public void setData(List<InstructorSurveyInterface.CourseRequirement> courses) {
        this.clearTable(1);
        if (courses != null) {
            for (InstructorSurveyInterface.CourseRequirement course : courses) {
                this.addRow(course);
            }
        }
        this.sort();
    }

    public int getColSpan(Column column) {
        switch (column) {
            case CUSTOM: {
                return this.iCustomFields == null ? 0 : this.iCustomFields.size();
            }
            case COURSE: {
                return this.iCrossList ? 1 : 0;
            }
        }
        return 1;
    }

    public String getColumnName(Column column, int index) {
        switch (column) {
            case COURSE: {
                return MESSAGES.colCourse();
            }
            case INSTRUCTOR: {
                return MESSAGES.colInstructor();
            }
            case CUSTOM: {
                return this.iCustomFields.get(index).getName();
            }
            case DIST: {
                return MESSAGES.colDistribution();
            }
            case TIME: {
                return MESSAGES.colTime();
            }
            case ROOM: {
                return MESSAGES.colRoom();
            }
            case OTHER: {
                return MESSAGES.colOtherPref();
            }
        }
        return column.name();
    }

    public Widget getColumnWidget(Column column, InstructorSurveyInterface.CourseRequirement course, int index) {
        switch (column) {
            case COURSE: {
                Label courseLabel = new Label(course.getCourseName());
                if (course.hasCourseTitle()) {
                    courseLabel.setTitle(course.getCourseTitle());
                }
                return courseLabel;
            }
            case INSTRUCTOR: {
                Label instructorLabel = new Label(course.getInstructorName());
                return instructorLabel;
            }
            case ROOM: {
                HTML roomHtml = new HTML(course.getRoomHtml() == null ? "" : course.getRoomHtml());
                roomHtml.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.PRE_WRAP);
                return roomHtml;
            }
            case TIME: {
                HTML timeHtml = new HTML(course.getTimeHtml() == null ? "" : course.getTimeHtml());
                timeHtml.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.PRE_WRAP);
                return timeHtml;
            }
            case DIST: {
                HTML distHtml = new HTML(course.getDistHtml() == null ? "" : course.getDistHtml());
                distHtml.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.PRE_WRAP);
                return distHtml;
            }
            case OTHER: {
                Label otherLabel = new Label(course.getNote() == null ? "" : course.getNote());
                otherLabel.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.PRE_WRAP);
                return otherLabel;
            }
            case CUSTOM: {
                InstructorSurveyInterface.CustomField cf = this.iCustomFields.get(index);
                Label custom = new Label();
                if (course != null && course.hasCustomField(cf)) {
                    custom.setText(course.getCustomField(cf));
                }
                custom.getElement().getStyle().setProperty("max-width", 6.77 * (double)cf.getLength(), Style.Unit.PX);
                custom.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.PRE_WRAP);
                return custom;
            }
        }
        return null;
    }

    protected void doSort(Column column, int index) {
        if (column == this.iSortBy && index == this.iCustom) {
            this.iAsc = !this.iAsc;
        } else {
            this.iSortBy = column;
            this.iCustom = index;
            this.iAsc = true;
        }
        AdminCookie.getInstance().setSortCourseRequirements(this.getSortBy());
        this.sort();
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        if (this.iSortBy == Column.CUSTOM) {
            return this.iAsc ? Column.values().length + this.iCustom + 1 : -Column.values().length - this.iCustom - 1;
        }
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
            this.iCustom = 0;
        } else if (sortBy > 0) {
            if (sortBy >= Column.values().length) {
                this.iCustom = sortBy - Column.values().length - 1;
                this.iSortBy = Column.CUSTOM;
                this.iAsc = true;
            } else {
                this.iSortBy = Column.values()[sortBy - 1];
                this.iAsc = true;
                this.iCustom = 0;
            }
        } else if (-sortBy >= Column.values().length) {
            this.iCustom = -sortBy - Column.values().length - 1;
            this.iSortBy = Column.CUSTOM;
            this.iAsc = true;
        } else {
            this.iSortBy = Column.values()[-1 - sortBy];
            this.iAsc = false;
            this.iCustom = 0;
        }
        this.sort();
    }

    public UniTimeTableHeader getHeader(Column column, int index) {
        int offset = 0;
        for (Column c : Column.values()) {
            if (c == column) break;
            offset += this.getColSpan(c);
        }
        return this.getHeader(offset + index);
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        UniTimeTableHeader header = this.getHeader(this.iSortBy, this.iCustom);
        InstructorSurveyInterface.CustomField cf = this.iCustom >= 0 && this.iCustomFields != null && this.iCustom < this.iCustomFields.size() ? this.iCustomFields.get(this.iCustom) : null;
        this.sort(header, new CourseRequirementComparator(this.iSortBy, cf, true), this.iAsc);
    }

    public static enum Column {
        INSTRUCTOR,
        COURSE,
        CUSTOM,
        TIME,
        ROOM,
        DIST,
        OTHER;

    }

    public static class CourseRequirementComparator
    implements Comparator<InstructorSurveyInterface.CourseRequirement> {
        private Column iColumn;
        private boolean iAsc;
        private InstructorSurveyInterface.CustomField iCustomField;

        public CourseRequirementComparator(Column column, InstructorSurveyInterface.CustomField cf, boolean asc) {
            this.iColumn = column;
            this.iAsc = asc;
            this.iCustomField = cf;
        }

        public int compareById(InstructorSurveyInterface.CourseRequirement r1, InstructorSurveyInterface.CourseRequirement r2) {
            return this.compare(r1.getId(), r2.getId());
        }

        public int compareByName(InstructorSurveyInterface.CourseRequirement r1, InstructorSurveyInterface.CourseRequirement r2) {
            return this.compare(r1.getCourseName(), r2.getCourseName());
        }

        public int compareByCustom(InstructorSurveyInterface.CourseRequirement r1, InstructorSurveyInterface.CourseRequirement r2) {
            if (this.iCustomField != null) {
                return this.compare(r1.getCustomField(this.iCustomField), r2.getCustomField(this.iCustomField));
            }
            return 0;
        }

        public int compareByOther(InstructorSurveyInterface.CourseRequirement r1, InstructorSurveyInterface.CourseRequirement r2) {
            return this.compare(r1.getNote(), r2.getNote());
        }

        public int compareByInstructor(InstructorSurveyInterface.CourseRequirement r1, InstructorSurveyInterface.CourseRequirement r2) {
            return this.compare(r1.getInstructorName(), r2.getInstructorName());
        }

        public int compareByDist(InstructorSurveyInterface.CourseRequirement r1, InstructorSurveyInterface.CourseRequirement r2) {
            return this.compare(r1.getDist(), r2.getDist());
        }

        public int compareByTime(InstructorSurveyInterface.CourseRequirement r1, InstructorSurveyInterface.CourseRequirement r2) {
            return this.compare(r1.getTime(), r2.getTime());
        }

        public int compareByRoom(InstructorSurveyInterface.CourseRequirement r1, InstructorSurveyInterface.CourseRequirement r2) {
            return this.compare(r1.getRoom(), r2.getRoom());
        }

        protected int compareByColumn(InstructorSurveyInterface.CourseRequirement r1, InstructorSurveyInterface.CourseRequirement r2) {
            switch (this.iColumn) {
                case COURSE: {
                    return this.compareByName(r1, r2);
                }
                case CUSTOM: {
                    return this.compareByCustom(r1, r2);
                }
                case DIST: {
                    return this.compareByDist(r1, r2);
                }
                case TIME: {
                    return this.compareByTime(r1, r2);
                }
                case ROOM: {
                    return this.compareByRoom(r1, r2);
                }
                case INSTRUCTOR: {
                    return this.compareByInstructor(r1, r2);
                }
                case OTHER: {
                    return this.compareByOther(r1, r2);
                }
            }
            return this.compareByName(r1, r2);
        }

        public static boolean isApplicable(Column column) {
            switch (column) {
                case CUSTOM: 
                case COURSE: 
                case INSTRUCTOR: 
                case DIST: 
                case TIME: 
                case ROOM: 
                case OTHER: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compare(InstructorSurveyInterface.CourseRequirement r1, InstructorSurveyInterface.CourseRequirement r2) {
            int cmp = this.compareByColumn(r1, r2);
            if (cmp == 0) {
                cmp = this.compareByInstructor(r1, r2);
            }
            if (cmp == 0) {
                cmp = this.compareByName(r1, r2);
            }
            if (cmp == 0) {
                cmp = this.compareByCustom(r1, r2);
            }
            if (cmp == 0) {
                cmp = this.compareById(r1, r2);
            }
            return this.iAsc ? cmp : -cmp;
        }

        @Override
        protected int compare(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
        }

        @Override
        protected int compare(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }
    }
}

