/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.instructor.InstructorCookie;
import org.unitime.timetable.gwt.client.instructor.TeachingAssignmentsTable;
import org.unitime.timetable.gwt.client.instructor.TeachingRequestsFilterBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.FilterPanel;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class TeachingAssignmentsPage
extends SimpleForm {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private FilterPanel iFilterPanel = new FilterPanel();
    private TeachingRequestsFilterBox iFilterBox;
    private TeachingAssignmentsTable iTable;
    private Button iSearch;
    private Button iExportCSV;
    private Button iExportPDF;

    public TeachingAssignmentsPage() {
        Label filterLabel = new Label(MESSAGES.propDepartment());
        this.iFilterPanel.addLeft((Widget)filterLabel);
        this.iFilterBox = new TeachingRequestsFilterBox(null);
        this.iFilterPanel.addLeft((Widget)this.iFilterBox);
        this.iSearch = new Button(UniTimeHeaderPanel.stripAccessKey(MESSAGES.buttonSearch()));
        Character searchAccessKey = UniTimeHeaderPanel.guessAccessKey(MESSAGES.buttonSearch());
        if (searchAccessKey != null) {
            this.iSearch.setAccessKey(searchAccessKey.charValue());
        }
        this.iSearch.addStyleName("unitime-NoPrint");
        this.iFilterPanel.addRight((Widget)this.iSearch);
        this.iSearch.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TeachingAssignmentsPage.this.search();
            }
        });
        this.iExportCSV = new Button(UniTimeHeaderPanel.stripAccessKey(MESSAGES.buttonExportCSV()));
        Character exportCsvAccessKey = UniTimeHeaderPanel.guessAccessKey(MESSAGES.buttonExportCSV());
        if (exportCsvAccessKey != null) {
            this.iExportCSV.setAccessKey(exportCsvAccessKey.charValue());
        }
        this.iExportCSV.addStyleName("unitime-NoPrint");
        this.iFilterPanel.addRight((Widget)this.iExportCSV);
        this.iExportCSV.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TeachingAssignmentsPage.this.export("teaching-assignments.csv");
            }
        });
        this.iExportPDF = new Button(UniTimeHeaderPanel.stripAccessKey(MESSAGES.buttonExportPDF()));
        Character exportPdfAccessKey = UniTimeHeaderPanel.guessAccessKey(MESSAGES.buttonExportPDF());
        if (exportPdfAccessKey != null) {
            this.iExportPDF.setAccessKey(exportCsvAccessKey.charValue());
        }
        this.iExportPDF.addStyleName("unitime-NoPrint");
        this.iFilterPanel.addRight((Widget)this.iExportPDF);
        this.iExportPDF.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TeachingAssignmentsPage.this.export("teaching-assignments.pdf");
            }
        });
        this.addHeaderRow((Widget)this.iFilterPanel);
        this.iTable = new TeachingAssignmentsTable(){

            @Override
            protected void onAssignmentChanged(List<InstructorInterface.AssignmentInfo> assignments) {
                if (TeachingAssignmentsPage.this.iTable.isVisible()) {
                    TeachingAssignmentsPage.this.search();
                }
            }
        };
        this.iTable.setVisible(false);
        this.addRow((Widget)this.iTable);
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingPage());
        RPC.execute(new InstructorInterface.TeachingRequestsPagePropertiesRequest(), new AsyncCallback<InstructorInterface.TeachingRequestsPagePropertiesResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                TeachingAssignmentsPage.this.iFilterBox.setErrorHint(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(InstructorInterface.TeachingRequestsPagePropertiesResponse result) {
                LoadingWidget.getInstance().hide();
                TeachingAssignmentsPage.this.iTable.setProperties(result);
                FilterBox.Chip department = TeachingAssignmentsPage.this.iFilterBox.getChip("department");
                if (department != null) {
                    boolean match = false;
                    for (InstructorInterface.DepartmentInterface d : result.getDepartments()) {
                        if (!d.getDeptCode().equalsIgnoreCase(department.getValue())) continue;
                        match = true;
                    }
                    if (!match) {
                        TeachingAssignmentsPage.this.iFilterBox.setValue("", true);
                    }
                }
                if (result.getLastDepartmentId() != null && TeachingAssignmentsPage.this.iFilterBox.getValue().isEmpty()) {
                    for (InstructorInterface.DepartmentInterface d : result.getDepartments()) {
                        if (!d.getId().equals(result.getLastDepartmentId())) continue;
                        TeachingAssignmentsPage.this.iFilterBox.setValue("department:\"" + d.getDeptCode() + "\"", true);
                        break;
                    }
                }
            }
        });
        if (Window.Location.getHash() != null && Window.Location.getHash().length() > 1) {
            this.iFilterBox.setValue(URL.decode((String)Window.Location.getHash().substring(1)), true);
            this.search();
        } else {
            String q = InstructorCookie.getInstance().getQuery(null);
            if (q != null && !q.isEmpty()) {
                this.iFilterBox.setValue(q, true);
            }
        }
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (event.getValue() != null && !((String)event.getValue()).isEmpty()) {
                    TeachingAssignmentsPage.this.iFilterBox.setValue(((String)event.getValue()).replace("%20", " "), true);
                    TeachingAssignmentsPage.this.search();
                }
            }
        });
    }

    void search() {
        History.newItem((String)this.iFilterBox.getValue(), (boolean)false);
        InstructorCookie.getInstance().setQuery(null, this.iFilterBox.getValue());
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingTeachingAssignments());
        InstructorInterface.TeachingRequestsFilterRpcRequest filter = (InstructorInterface.TeachingRequestsFilterRpcRequest)this.iFilterBox.getElementsRequest();
        RPC.execute(new InstructorInterface.TeachingAssignmentsPageRequest(filter), new AsyncCallback<GwtRpcResponseList<InstructorInterface.InstructorInfo>>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                TeachingAssignmentsPage.this.iFilterBox.setErrorHint(MESSAGES.failedToLoadTeachingAssignments(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadTeachingAssignments(caught.getMessage()), caught);
            }

            public void onSuccess(GwtRpcResponseList<InstructorInterface.InstructorInfo> result) {
                LoadingWidget.getInstance().hide();
                TeachingAssignmentsPage.this.iTable.populate(result);
                TeachingAssignmentsPage.this.iTable.setVisible(true);
            }
        });
    }

    void export(String type) {
        RoomCookie cookie = RoomCookie.getInstance();
        String query = "output=" + type;
        Object requests = this.iFilterBox.getElementsRequest();
        if (((EventInterface.FilterRpcRequest)requests).hasOptions()) {
            for (Map.Entry<String, Set<String>> option : ((EventInterface.FilterRpcRequest)requests).getOptions().entrySet()) {
                for (String value : option.getValue()) {
                    query = query + "&r:" + option.getKey() + "=" + URL.encodeQueryString((String)value);
                }
            }
        }
        if (((EventInterface.FilterRpcRequest)requests).getText() != null && !((EventInterface.FilterRpcRequest)requests).getText().isEmpty()) {
            query = query + "&r:text=" + URL.encodeQueryString((String)((EventInterface.FilterRpcRequest)requests).getText());
        }
        query = query + "&sort=" + InstructorCookie.getInstance().getSortTeachingAssignmentsBy() + "&columns=" + InstructorCookie.getInstance().getTeachingAssignmentsColumns() + "&grid=" + (cookie.isGridAsText() ? "0" : "1") + "&vertical=" + (cookie.areRoomsHorizontal() ? "0" : "1") + (String)(cookie.hasMode() ? "&mode=" + cookie.getMode() : "");
        RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(query), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
            }
        });
    }

    public static class SingleTeachingAssingment {
        InstructorInterface.InstructorInfo iInstructor;
        InstructorInterface.TeachingRequestInfo iRequest;

        public SingleTeachingAssingment(InstructorInterface.InstructorInfo instructor, InstructorInterface.TeachingRequestInfo request) {
            this.iInstructor = instructor;
            this.iRequest = request;
        }

        public boolean hasInstructor() {
            return this.iInstructor != null;
        }

        public InstructorInterface.InstructorInfo getInstructor() {
            return this.iInstructor;
        }

        public boolean hasRequest() {
            return this.iRequest != null;
        }

        public InstructorInterface.TeachingRequestInfo getRequest() {
            return this.iRequest;
        }
    }
}

