/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.instructor.TeachingAssignmentsWidget;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyWidget;
import org.unitime.timetable.gwt.client.page.UniTimeNavigation;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.StudentScheduleTable;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.client.tables.TableWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class InstructorDetailPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel = new SimpleForm(2);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private int iPreferencesRow = -1;
    private InstructorInterface.InstructorDetailResponse iResponse;

    public InstructorDetailPage() {
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-InstructorDetailPage");
        this.initWidget((Widget)this.iRootPanel);
        this.iHeader = new UniTimeHeaderPanel();
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        String id = Window.Location.getParameter((String)"id");
        if (id == null) {
            id = Window.Location.getParameter((String)"instructorId");
        }
        if (id == null || id.isEmpty()) {
            LoadingWidget.getInstance().hide();
            this.iHeader.setErrorMessage(COURSE.errorNoInstructorId());
        } else {
            this.load(Long.valueOf(id), null);
        }
        this.iHeader.addButton("edit", COURSE.actionEditInstructor(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "instructorInfoEdit.action?instructorId=" + InstructorDetailPage.this.iResponse.getInstructorId());
            }
        });
        this.iHeader.setEnabled("edit", false);
        this.iHeader.getButton("edit").setAccessKey(COURSE.accessEditInstructor().charAt(0));
        this.iHeader.getButton("edit").setTitle(COURSE.titleEditInstructor(COURSE.accessEditInstructor()));
        this.iHeader.addButton("assignment", COURSE.actionEditInstructorAssignmentPreferences(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "instructorAssignmentPref.action?instructorId=" + InstructorDetailPage.this.iResponse.getInstructorId());
            }
        });
        this.iHeader.setEnabled("assignment", false);
        this.iHeader.getButton("assignment").setAccessKey(COURSE.accessEditInstructorAssignmentPreferences().charAt(0));
        this.iHeader.getButton("assignment").setTitle(COURSE.titleEditInstructorAssignmentPreferences(COURSE.accessEditInstructorAssignmentPreferences()));
        this.iHeader.addButton("preferences", COURSE.actionEditInstructorPreferences(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "instructorPrefEdit.action?instructorId=" + InstructorDetailPage.this.iResponse.getInstructorId());
            }
        });
        this.iHeader.setEnabled("preferences", false);
        this.iHeader.getButton("preferences").setAccessKey(COURSE.accessEditInstructorPreferences().charAt(0));
        this.iHeader.getButton("preferences").setTitle(COURSE.titleEditInstructorPreferences(COURSE.accessEditInstructorPreferences()));
        this.iHeader.addButton("survey", COURSE.actionInstructorSurvey(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                UniTimeFrameDialog.openDialog(COURSE.actionInstructorSurvey(), "instructorSurvey?menu=hide&id=" + InstructorDetailPage.this.iResponse.getExternalId(), "900", "90%");
            }
        });
        this.iHeader.setEnabled("survey", false);
        this.iHeader.getButton("survey").setAccessKey(COURSE.accessInstructorSurvey().charAt(0));
        this.iHeader.getButton("survey").setTitle(COURSE.titleInstructorSurvey(COURSE.accessInstructorSurvey()));
        this.iHeader.addButton("previous", COURSE.actionPreviousInstructor(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "instructor?id=" + InstructorDetailPage.this.iResponse.getPreviousId());
            }
        });
        this.iHeader.setEnabled("previous", false);
        this.iHeader.getButton("previous").setAccessKey(COURSE.accessPreviousInstructor().charAt(0));
        this.iHeader.getButton("previous").setTitle(COURSE.titlePreviousInstructor(COURSE.accessPreviousInstructor()));
        this.iHeader.addButton("next", COURSE.actionNextInstructor(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "instructor?id=" + InstructorDetailPage.this.iResponse.getNextId());
            }
        });
        this.iHeader.setEnabled("next", false);
        this.iHeader.getButton("next").setAccessKey(COURSE.accessNextInstructor().charAt(0));
        this.iHeader.getButton("next").setTitle(COURSE.titleNextInstructor(COURSE.accessNextInstructor()));
        this.iHeader.addButton("back", COURSE.actionBackToInstructors(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "back.action?uri=" + URL.encodeQueryString((String)InstructorDetailPage.this.iResponse.getBackUrl()) + "&backId=" + InstructorDetailPage.this.iResponse.getInstructorId() + "&backType=PreferenceGroup");
            }
        });
        this.iHeader.setEnabled("back", false);
        this.iHeader.getButton("back").setAccessKey(COURSE.accessBackToInstructors().charAt(0));
        this.iFooter = this.iHeader.clonePanel();
    }

    protected void load(Long instructorId, InstructorInterface.InstructorDetailRequest.Action action) {
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
        InstructorInterface.InstructorDetailRequest req = new InstructorInterface.InstructorDetailRequest();
        req.setInstructorId(instructorId);
        req.setAction(action);
        req.setBackId(Window.Location.getParameter((String)"backId"));
        req.setBackType(Window.Location.getParameter((String)"backType"));
        RPC.execute(req, new AsyncCallback<InstructorInterface.InstructorDetailResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                InstructorDetailPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(InstructorInterface.InstructorDetailResponse response) {
                UniTimeHeaderPanel hp;
                InstructorDetailPage.this.iResponse = response;
                if (response.hasUrl()) {
                    ToolBox.open(GWT.getHostPageBaseURL() + response.getUrl());
                    return;
                }
                LoadingWidget.getInstance().hide();
                InstructorDetailPage.this.iPanel.clear();
                InstructorDetailPage.this.iPanel.addHeaderRow((Widget)InstructorDetailPage.this.iHeader);
                InstructorDetailPage.this.iHeader.setHeaderTitle(response.getInstructorName());
                if (response.hasExternalId()) {
                    InstructorDetailPage.this.iPanel.addRow(COURSE.propertyExternalId(), (Widget)new Label(response.getExternalId()));
                }
                if (response.hasDepartmentFilter()) {
                    FilterInterface.FilterParameterInterface param = response.getDepartmentFilter();
                    final ListBox list = new ListBox();
                    list.setMultipleSelect(param.isMultiSelect());
                    for (FilterInterface.ListItem item : param.getOptions()) {
                        list.addItem(item.getText(), item.getValue());
                        if (param.isMultiSelect()) {
                            list.setItemSelected(list.getItemCount() - 1, param.isDefaultItem(item));
                            continue;
                        }
                        if (!param.isDefaultItem(item)) continue;
                        list.setSelectedIndex(list.getItemCount() - 1);
                    }
                    list.addChangeHandler(new ChangeHandler(){

                        public void onChange(ChangeEvent event) {
                            if (list.getSelectedIndex() >= 0) {
                                ToolBox.open(GWT.getHostPageBaseURL() + "instructor?id=" + list.getValue(list.getSelectedIndex()));
                            }
                        }
                    });
                    InstructorDetailPage.this.iPanel.addRow(param.getLabel(), (Widget)list);
                }
                if (response.hasProperties()) {
                    for (TableInterface.PropertyInterface property : response.getProperties().getProperties()) {
                        InstructorDetailPage.this.iPanel.addRow(property.getName(), (Widget)new TableWidget.CellWidget(property.getCell(), true));
                    }
                }
                if (response.hasOperation("has-survey")) {
                    InstructorDetailPage.this.iPreferencesRow = InstructorDetailPage.this.iPanel.addRow((Widget)new InstructorSurveyWidget().forInstructorId(response.getInstructorId()));
                }
                if (response.hasClasses()) {
                    hp = new UniTimeHeaderPanel(response.getClasses().getName());
                    InstructorDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    InstructorDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getClasses()));
                }
                if (response.hasExaminations()) {
                    hp = new UniTimeHeaderPanel(response.getExaminations().getName());
                    InstructorDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    InstructorDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getExaminations()));
                }
                if (response.hasEvents()) {
                    hp = new UniTimeHeaderPanel(response.getEvents().getName());
                    InstructorDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    InstructorDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getEvents()));
                }
                if (response.hasPreferences()) {
                    hp = new UniTimeHeaderPanel(COURSE.sectionTitlePreferences());
                    hp.setCollapsible(!"0".equals(ToolBox.getSessionCookie("Instructor.Preferences")));
                    hp.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

                        public void onValueChange(ValueChangeEvent<Boolean> e) {
                            InstructorDetailPage.this.iPanel.getRowFormatter().setVisible(InstructorDetailPage.this.iPreferencesRow, ((Boolean)e.getValue()).booleanValue());
                            ToolBox.setSessionCookie("Instructor.Preferences", (Boolean)e.getValue() != false ? "1" : "0");
                        }
                    });
                    InstructorDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    InstructorDetailPage.this.iPreferencesRow = InstructorDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getPreferences()));
                    InstructorDetailPage.this.iPanel.getRowFormatter().setVisible(InstructorDetailPage.this.iPreferencesRow, hp.isCollapsible().booleanValue());
                }
                if (response.hasExternalId()) {
                    InstructorDetailPage.this.iPanel.addRow((Widget)new StudentScheduleTable(true, true, false).forStudent(response.getExternalId()));
                }
                if (response.hasOperation("teaching-assignments")) {
                    InstructorDetailPage.this.iPanel.addRow((Widget)new TeachingAssignmentsWidget().forInstructorId(response.getInstructorId()));
                }
                if (response.hasLastChanges()) {
                    hp = new UniTimeHeaderPanel(response.getLastChanges().getName());
                    InstructorDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    InstructorDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getLastChanges()));
                }
                InstructorDetailPage.this.iPanel.addBottomRow((Widget)InstructorDetailPage.this.iFooter);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        Element e;
                        String token = Window.Location.getHash();
                        if ((token != null && (token.startsWith("#A") || token.equals("#back")) || token.startsWith("#ioc")) && (e = Document.get().getElementById(token.substring(1))) != null) {
                            ToolBox.scrollToElement(e);
                        }
                        if ((e = Document.get().getElementById("back")) != null) {
                            ToolBox.scrollToElement(e);
                        }
                    }
                });
                for (String op : InstructorDetailPage.this.iHeader.getOperations()) {
                    InstructorDetailPage.this.iHeader.setEnabled(op, response.hasOperation(op));
                }
                UniTimeNavigation.getInstance().refresh();
            }
        });
    }
}

