/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.exams;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.exams.ExamsInterface;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.client.offerings.PreferenceEditWidget;
import org.unitime.timetable.gwt.client.page.UniTimeNavigation;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.client.tables.TableWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class ExamEditPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final ExaminationMessages EXAM = (ExaminationMessages)GWT.create(ExaminationMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel = new SimpleForm(2);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private ExamsInterface.ExamEditResponse iData;
    private UniTimeTable<PrefGroupEditInterface.IdLabel> iInstructors;
    private UniTimeTable<ExamsInterface.ExamObjectInterface> iOwners;
    private PreferenceEditWidget iPreferences;

    public ExamEditPage() {
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-ExamEditPage");
        this.initWidget((Widget)this.iRootPanel);
        this.iHeader = new UniTimeHeaderPanel();
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        String id = Window.Location.getParameter((String)"id");
        if (id == null) {
            id = Window.Location.getParameter((String)"examId");
        }
        boolean clone = "true".equalsIgnoreCase(Window.Location.getParameter((String)"clone"));
        this.load(id != null && !id.isEmpty() ? Long.valueOf(id) : null, clone ? PrefGroupEditInterface.Operation.CLONE_EXAM : PrefGroupEditInterface.Operation.GET, true, null);
        this.iHeader.addButton("save", EXAM.actionExamSave(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ExamEditPage.this.update();
                if (ExamEditPage.this.validate()) {
                    ExamEditPage.this.load(ExamEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.UPDATE, true, null);
                }
            }
        });
        this.iHeader.getButton("save").setTitle(EXAM.titleExamSave());
        this.iHeader.getButton("save").setAccessKey(EXAM.actionExamSave().charAt(0));
        this.iHeader.setEnabled("save", false);
        this.iHeader.addButton("update", EXAM.actionExamUpdate(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ExamEditPage.this.update();
                if (ExamEditPage.this.validate()) {
                    ExamEditPage.this.load(ExamEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.UPDATE, true, null);
                }
            }
        });
        this.iHeader.getButton("update").setTitle(EXAM.titleExamUpdate());
        this.iHeader.getButton("update").setAccessKey(EXAM.actionExamUpdate().charAt(0));
        this.iHeader.setEnabled("update", false);
        this.iHeader.addButton("clear", EXAM.actionClearExamPreferences(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ExamEditPage.this.update();
                ExamEditPage.this.load(ExamEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.CLEAR_EXAM_PREFS, true, null);
            }
        });
        this.iHeader.getButton("clear").setTitle(EXAM.titleClearExamPreferences());
        this.iHeader.getButton("clear").setAccessKey(EXAM.accessClearExamPreferences().charAt(0));
        this.iHeader.setEnabled("clear", false);
        this.iHeader.addButton("previous", EXAM.actionExamPrevious(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ExamEditPage.this.update();
                if (ExamEditPage.this.validate()) {
                    ExamEditPage.this.load(ExamEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.PREVIOUS, true, null);
                }
            }
        });
        this.iHeader.getButton("previous").setTitle(EXAM.titleExamPrevious());
        this.iHeader.getButton("previous").setAccessKey(EXAM.accessExamPrevious().charAt(0));
        this.iHeader.setEnabled("previous", false);
        this.iHeader.addButton("next", EXAM.actionExamNext(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ExamEditPage.this.update();
                if (ExamEditPage.this.validate()) {
                    ExamEditPage.this.load(ExamEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.NEXT, true, null);
                }
            }
        });
        this.iHeader.getButton("next").setTitle(EXAM.titleExamNext());
        this.iHeader.getButton("next").setAccessKey(EXAM.accessExamNext().charAt(0));
        this.iHeader.setEnabled("next", false);
        this.iHeader.addButton("back", EXAM.actionBatckToDetail(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ExamEditPage.this.iData.hasBackUrl()) {
                    ToolBox.open(GWT.getHostPageBaseURL() + ExamEditPage.this.iData.getBackUrl());
                } else if (ExamEditPage.this.iData.getId() != null) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "examination?id=" + ExamEditPage.this.iData.getId());
                } else {
                    ToolBox.open(GWT.getHostPageBaseURL() + "examinations");
                }
            }
        });
        this.iHeader.getButton("back").setTitle(EXAM.titleExamBack().replace("%%", id == null || id.isEmpty() ? MESSAGES.pageExaminations() : MESSAGES.pageExaminationDetail()));
        this.iHeader.getButton("back").setAccessKey(EXAM.accessExamBack().charAt(0));
        this.iFooter = this.iHeader.clonePanel();
    }

    protected void update() {
        if (this.iPreferences != null) {
            this.iPreferences.update();
        }
        if (this.iInstructors != null) {
            this.iData.setExamInstructors(this.iInstructors.getData());
        }
        if (this.iData.hasExamObjects()) {
            this.iData.getExamObjects().clear();
        }
        if (this.iOwners != null) {
            for (ExamsInterface.ExamObjectInterface doi : this.iOwners.getData()) {
                this.iData.addExamObject(doi);
            }
        }
    }

    protected void load(Long examId, final PrefGroupEditInterface.Operation op, final boolean showLoading, final Command command) {
        if (showLoading) {
            LoadingWidget.getInstance().show(op == PrefGroupEditInterface.Operation.UPDATE || op == PrefGroupEditInterface.Operation.NEXT || op == PrefGroupEditInterface.Operation.PREVIOUS ? MESSAGES.waitSavingData() : MESSAGES.waitLoadingData());
        }
        ExamsInterface.ExamEditRequest req = new ExamsInterface.ExamEditRequest();
        req.setOperation(op);
        if (op != null && this.iData != null) {
            this.update();
            req.setPayLoad(this.iData);
            req.setId(this.iData.getId());
        }
        if (this.iData == null) {
            req.setId(examId);
            req.setFirstType(Window.Location.getParameter((String)"firstType"));
            req.setFirstId(Window.Location.getParameter((String)"firstId"));
        }
        RPC.execute(req, new AsyncCallback<ExamsInterface.ExamEditResponse>(){

            public void onFailure(Throwable caught) {
                if (showLoading) {
                    LoadingWidget.getInstance().hide();
                }
                ExamEditPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(ExamsInterface.ExamEditResponse response) {
                if (response.hasUrl()) {
                    ToolBox.open(GWT.getHostPageBaseURL() + response.getUrl());
                    return;
                }
                if (showLoading) {
                    LoadingWidget.getInstance().hide();
                }
                if (op == PrefGroupEditInterface.Operation.EXAM_OWNERS) {
                    ExamEditPage.this.iData.setExamInstructors(response.getExamInstructors());
                    ExamEditPage.this.iData.setInstructors(response.getInstructors());
                    ExamEditPage.this.iInstructors.clearTable();
                    PrefGroupEditInterface.IdLabel last = null;
                    if (ExamEditPage.this.iData.hasInstructors() && ExamEditPage.this.iData.hasExamInstructors()) {
                        for (PrefGroupEditInterface.IdLabel instructor : ExamEditPage.this.iData.getExamInstructors()) {
                            ExamEditPage.this.iInstructors.addRow(instructor, ExamEditPage.this.toLine(instructor));
                            last = instructor;
                        }
                    }
                    if (last == null || last.getId() != null) {
                        PrefGroupEditInterface.IdLabel blank = new PrefGroupEditInterface.IdLabel();
                        ExamEditPage.this.iInstructors.addRow(blank, ExamEditPage.this.toLine(blank));
                    }
                    return;
                }
                ExamEditPage.this.iData = response;
                ExamEditPage.this.iPanel.clear();
                ExamEditPage.this.iHeader.setHeaderTitle(response.getLabel() == null ? "" : response.getLabel());
                ExamEditPage.this.iPanel.addHeaderRow((Widget)ExamEditPage.this.iHeader);
                if (response.hasProperties()) {
                    for (TableInterface.PropertyInterface property : response.getProperties().getProperties()) {
                        ExamEditPage.this.iPanel.addRow(property.getName(), (Widget)new TableWidget.CellWidget(property.getCell(), true));
                    }
                }
                TextBox name = new TextBox();
                if (response.getName() != null) {
                    name.setText(response.getName());
                }
                name.setMaxLength(100);
                name.setWidth("400px");
                ExamEditPage.this.iPanel.addRow(EXAM.propExamName(), (Widget)name);
                name.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> e) {
                        ExamEditPage.this.iData.setName((String)e.getValue());
                    }
                });
                if (ExamEditPage.this.iData.hasExamTypes()) {
                    final ListBox examType = new ListBox();
                    for (PrefGroupEditInterface.IdLabel id : ExamEditPage.this.iData.getExamTypes()) {
                        examType.addItem(id.getLabel(), id.getId().toString());
                        if (!id.getId().equals(ExamEditPage.this.iData.getExamTypeId())) continue;
                        examType.setSelectedIndex(examType.getItemCount() - 1);
                    }
                    ExamEditPage.this.iPanel.addRow(EXAM.propExamType(), (Widget)examType);
                    examType.addChangeHandler(new ChangeHandler(){

                        public void onChange(ChangeEvent e) {
                            ExamEditPage.this.iData.setExamType(Long.valueOf(examType.getSelectedValue()));
                            ExamEditPage.this.load(ExamEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.EXAM_TYPE, false, null);
                        }
                    });
                } else if (ExamEditPage.this.iData.getExamType() != null) {
                    ExamEditPage.this.iPanel.addRow(EXAM.propExamType(), (Widget)new Label(ExamEditPage.this.iData.getExamType().getLabel()));
                }
                final NumberBox length = new NumberBox();
                length.setDecimal(false);
                length.setNegative(false);
                length.setValue(ExamEditPage.this.iData.getLength());
                ExamEditPage.this.iPanel.addRow(EXAM.propExamLength(), (Widget)length);
                length.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> e) {
                        ExamEditPage.this.iData.setLength(length.toInteger());
                    }
                });
                final ListBox seatingType = new ListBox();
                seatingType.addItem(EXAM.seatingNormal());
                seatingType.addItem(EXAM.seatingExam());
                seatingType.setSelectedIndex(ExamEditPage.this.iData.isExamSeating() ? 1 : 0);
                ExamEditPage.this.iPanel.addRow(EXAM.propExamSeatingType(), (Widget)seatingType);
                seatingType.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent e) {
                        ExamEditPage.this.iData.setExamSeating(seatingType.getSelectedIndex() == 1);
                        ExamEditPage.this.load(ExamEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.EXAM_SEATING, false, null);
                    }
                });
                final NumberBox maxRooms = new NumberBox();
                maxRooms.setDecimal(false);
                maxRooms.setNegative(false);
                maxRooms.setValue(ExamEditPage.this.iData.getMaxRooms());
                ExamEditPage.this.iPanel.addRow(EXAM.propExamMaxRooms(), (Widget)maxRooms);
                maxRooms.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> e) {
                        ExamEditPage.this.iData.setMaxRooms(maxRooms.toInteger());
                    }
                });
                final NumberBox size = new NumberBox();
                size.setDecimal(false);
                size.setNegative(false);
                size.setValue(ExamEditPage.this.iData.getSize());
                P sizeBox = new P("exam-size");
                sizeBox.add((Widget)size);
                sizeBox.add((Widget)new Label(ExamEditPage.this.iData.isSizeUseLimitInsteadOfEnrollment() ? EXAM.noteBlankSizeEnrolledStudents() : EXAM.noteBlankSizeEnrolledStudents()));
                ExamEditPage.this.iPanel.addRow(EXAM.propExamSize(), (Widget)sizeBox);
                size.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> e) {
                        ExamEditPage.this.iData.setSize(size.toInteger());
                    }
                });
                final NumberBox printOffset = new NumberBox();
                printOffset.setDecimal(false);
                printOffset.setNegative(true);
                printOffset.setValue(ExamEditPage.this.iData.getPrintOffset());
                P printOffsetBox = new P("print-offset");
                printOffsetBox.add((Widget)printOffset);
                printOffsetBox.add((Widget)new Label(EXAM.noteExamPrintOffset()));
                ExamEditPage.this.iPanel.addRow(EXAM.propExamPrintOffset(), (Widget)printOffsetBox);
                printOffset.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> e) {
                        ExamEditPage.this.iData.setPrintOffset(printOffset.toInteger());
                    }
                });
                if (ExamEditPage.this.iInstructors == null) {
                    ExamEditPage.this.iInstructors = new UniTimeTable();
                } else {
                    ExamEditPage.this.iInstructors.clearTable();
                }
                if (ExamEditPage.this.iData.hasInstructors()) {
                    PrefGroupEditInterface.IdLabel last = null;
                    if (ExamEditPage.this.iData.hasExamInstructors()) {
                        for (PrefGroupEditInterface.IdLabel instructor : ExamEditPage.this.iData.getExamInstructors()) {
                            ExamEditPage.this.iInstructors.addRow(instructor, ExamEditPage.this.toLine(instructor));
                            last = instructor;
                        }
                    }
                    if (last == null || last.getId() != null) {
                        PrefGroupEditInterface.IdLabel blank = new PrefGroupEditInterface.IdLabel();
                        ExamEditPage.this.iInstructors.addRow(blank, ExamEditPage.this.toLine(blank));
                    }
                }
                ExamEditPage.this.iPanel.addRow(EXAM.propExamInstructors(), (Widget)ExamEditPage.this.iInstructors);
                UniTimeHeaderPanel notesPanel = new UniTimeHeaderPanel(EXAM.sectExamNotes());
                ExamEditPage.this.iPanel.addHeaderRow((Widget)notesPanel);
                TextArea reqestNotes = new TextArea();
                reqestNotes.setHeight("66px");
                reqestNotes.setWidth("100%");
                if (response.hasNotes()) {
                    reqestNotes.setText(response.getNotes());
                }
                ExamEditPage.this.iPanel.addRow((Widget)reqestNotes);
                reqestNotes.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        ExamEditPage.this.iData.setNotes((String)event.getValue());
                    }
                });
                if (response.hasTimetable()) {
                    UniTimeHeaderPanel hp = new UniTimeHeaderPanel(response.getTimetable().getName());
                    ExamEditPage.this.iPanel.addHeaderRow((Widget)hp);
                    ExamEditPage.this.iPanel.addRow((Widget)new TableWidget(response.getTimetable()));
                }
                ExamEditPage.this.iOwners = new UniTimeTable();
                UniTimeHeaderPanel header = new UniTimeHeaderPanel(EXAM.sectExamOwners());
                ExamEditPage.this.iPanel.addHeaderRow((Widget)header);
                header.addButton("add", EXAM.actionAddObject(), new ClickHandler(){

                    public void onClick(ClickEvent e) {
                        ExamsInterface.ExamObjectInterface doi = new ExamsInterface.ExamObjectInterface();
                        ExamEditPage.this.iOwners.addRow(doi, ExamEditPage.this.toClassRow(doi));
                    }
                });
                ExamEditPage.this.iPanel.addRow((Widget)ExamEditPage.this.iOwners);
                if (ExamEditPage.this.iData.hasExamObjects()) {
                    for (ExamsInterface.ExamObjectInterface doi : ExamEditPage.this.iData.getExamObjects()) {
                        ExamEditPage.this.iOwners.addRow(doi, ExamEditPage.this.toClassRow(doi));
                    }
                }
                if (ExamEditPage.this.iOwners.getRowCount() == 0) {
                    ExamsInterface.ExamObjectInterface doi = new ExamsInterface.ExamObjectInterface();
                    ExamEditPage.this.iOwners.addRow(doi, ExamEditPage.this.toClassRow(doi));
                }
                ExamEditPage.this.iPreferences = new PreferenceEditWidget();
                ExamEditPage.this.iPreferences.setValue(response);
                ExamEditPage.this.iPanel.addRow((Widget)ExamEditPage.this.iPreferences);
                ExamEditPage.this.iPanel.addBottomRow((Widget)ExamEditPage.this.iFooter);
                UniTimeNavigation.getInstance().refresh();
                ExamEditPage.this.iHeader.setEnabled("save", response.getId() == null);
                ExamEditPage.this.iHeader.setEnabled("update", response.getId() != null);
                ExamEditPage.this.iHeader.setEnabled("previous", response.getPreviousId() != null);
                ExamEditPage.this.iHeader.setEnabled("next", response.getNextId() != null);
                ExamEditPage.this.iHeader.setEnabled("clear", response.canClearPrefs());
                if (op == PrefGroupEditInterface.Operation.EXAM_TYPE) {
                    length.setFocus(true);
                } else if (op == PrefGroupEditInterface.Operation.EXAM_SEATING) {
                    maxRooms.setFocus(true);
                }
                if (response.hasBackTitle()) {
                    ExamEditPage.this.iHeader.getButton("back").setTitle(EXAM.titleExamBack().replace("%%", response.getBackTitle()));
                }
                if (command != null) {
                    command.execute();
                }
            }
        });
    }

    protected List<Widget> toLine(final PrefGroupEditInterface.IdLabel ci) {
        ArrayList<Widget> ret = new ArrayList<Widget>();
        final ListBox instructor = new ListBox();
        instructor.addItem("-", "");
        for (PrefGroupEditInterface.IdLabel i : this.iData.getInstructors()) {
            instructor.addItem(i.getLabel(), i.getId().toString());
            if (!i.getId().equals(ci.getId())) continue;
            instructor.setSelectedIndex(instructor.getItemCount() - 1);
        }
        instructor.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                String id = instructor.getSelectedValue();
                if (id.isEmpty()) {
                    ci.setId(null);
                    ci.setLabel(null);
                } else {
                    ci.setId(Long.valueOf(id));
                    ci.setLabel(instructor.getSelectedItemText());
                    int row = ExamEditPage.this.iInstructors.getRowForWidget((Widget)instructor);
                    if (row == ExamEditPage.this.iInstructors.getRowCount() - 1) {
                        PrefGroupEditInterface.IdLabel blank = new PrefGroupEditInterface.IdLabel();
                        ExamEditPage.this.iInstructors.addRow(blank, ExamEditPage.this.toLine(blank));
                    }
                }
            }
        });
        ret.add((Widget)instructor);
        final ImageButton delete = new ImageButton(RESOURCES.delete());
        delete.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int row = ExamEditPage.this.iInstructors.getRowForWidget((Widget)delete);
                if (row >= 0) {
                    ExamEditPage.this.iInstructors.removeRow(row);
                }
                if (ExamEditPage.this.iInstructors.getRowCount() == 0 || ExamEditPage.this.iInstructors.getData(ExamEditPage.this.iInstructors.getRowCount() - 1).getId() != null) {
                    PrefGroupEditInterface.IdLabel blank = new PrefGroupEditInterface.IdLabel();
                    ExamEditPage.this.iInstructors.addRow(blank, ExamEditPage.this.toLine(blank));
                }
            }
        });
        ret.add((Widget)delete);
        return ret;
    }

    public boolean validate() {
        this.iHeader.clearMessage();
        if (this.iData.getLength() == null || this.iData.getLength() <= 0) {
            this.iHeader.setErrorMessage(EXAM.errorZeroExamLength());
            return false;
        }
        if (this.iData.getMaxRooms() != null && this.iData.getMaxRooms() < 0) {
            this.iHeader.setErrorMessage(EXAM.errorNegativeMaxNbrRooms());
            return false;
        }
        if (this.iData.hasNotes() && this.iData.getNotes().length() > 999) {
            this.iHeader.setErrorMessage(EXAM.errorNotesLongerThan999());
            return false;
        }
        if (this.iInstructors != null) {
            HashSet<Long> instructors = new HashSet<Long>();
            for (PrefGroupEditInterface.IdLabel ci : this.iInstructors.getData()) {
                UniTimeNotifications.info("HERE " + String.valueOf(ci));
                if (ci.getId() == null || instructors.add(ci.getId())) continue;
                this.iHeader.setErrorMessage(EXAM.errorDuplicateExamInstructors());
                return false;
            }
        }
        int count = 0;
        HashSet<String> selections = new HashSet<String>();
        for (int row = 0; row < this.iOwners.getRowCount(); ++row) {
            ExamsInterface.ExamObjectInterface doi = this.iOwners.getData(row);
            if (doi.isValid()) {
                if (!selections.add(doi.getId())) {
                    this.iHeader.setErrorMessage(EXAM.errorInvalidOwnerSelectionDP());
                    return false;
                }
                ++count;
                continue;
            }
            if (row + 1 >= this.iOwners.getRowCount()) continue;
            this.iHeader.setErrorMessage(EXAM.errorInvalidOwnerSelectionDP());
            return false;
        }
        if (count <= 0) {
            this.iHeader.setErrorMessage(EXAM.errorNoExamOwners());
            return false;
        }
        String error = this.iPreferences.validate();
        if (error != null) {
            this.iHeader.setErrorMessage(error);
            return false;
        }
        return true;
    }

    protected List<Widget> toClassRow(final ExamsInterface.ExamObjectInterface doi) {
        final ArrayList<Widget> row = new ArrayList<Widget>();
        final ListBox subject = new ListBox();
        subject.addItem("-", "");
        subject.setWidth("90px");
        row.add((Widget)subject);
        final ListBox course = new ListBox();
        course.addItem("-", "");
        course.setWidth("470px");
        row.add((Widget)course);
        final ListBox subpart = new ListBox();
        subpart.addItem("-", "");
        subpart.setWidth("150px");
        row.add((Widget)subpart);
        final ListBox clazz = new ListBox();
        clazz.addItem("-", "");
        clazz.setWidth("150px");
        row.add((Widget)clazz);
        for (PrefGroupEditInterface.IdLabel s : this.iData.getSubjects()) {
            subject.addItem(s.getLabel(), s.getId().toString());
            if (!s.getId().equals(doi.getSubjectId())) continue;
            subject.setSelectedIndex(subject.getItemCount() - 1);
        }
        if (doi.getSubjectId() != null && subject.getSelectedIndex() <= 0) {
            subject.addItem(doi.getSubject(), doi.getSubjectId().toString());
            subject.setSelectedIndex(subject.getItemCount() - 1);
            subject.setEnabled(false);
            course.setEnabled(false);
            subject.setEnabled(false);
            clazz.setEnabled(false);
        }
        subject.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                doi.setSubjectId(subject.getSelectedIndex() <= 0 ? null : Long.valueOf(subject.getSelectedValue()));
                doi.setCourseId(null);
                doi.setSubpartId(null);
                doi.setClassId(null);
                ExamEditPage.this.subjectChanged(row, doi);
            }
        });
        course.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                doi.setCourseId(course.getSelectedIndex() <= 0 ? null : Long.valueOf(course.getSelectedValue()));
                doi.setSubpartId(null);
                doi.setClassId(null);
                ExamEditPage.this.courseChanged(row, doi);
                ExamEditPage.this.load(ExamEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.EXAM_OWNERS, false, null);
            }
        });
        subpart.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                doi.setSubpartId(subpart.getSelectedIndex() <= 0 ? null : Long.valueOf(subpart.getSelectedValue()));
                doi.setClassId(null);
                ExamEditPage.this.subpartChanged(row, doi);
            }
        });
        clazz.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                doi.setClassId(clazz.getSelectedIndex() <= 0 ? null : Long.valueOf(clazz.getSelectedValue()));
                if (doi.getClassId() != null && ExamEditPage.this.iOwners.getRowForWidget((Widget)clazz) == ExamEditPage.this.iOwners.getRowCount() - 1) {
                    ExamsInterface.ExamObjectInterface doi2 = new ExamsInterface.ExamObjectInterface();
                    ExamEditPage.this.iOwners.addRow(doi2, ExamEditPage.this.toClassRow(doi2));
                }
            }
        });
        if (subject.getSelectedIndex() <= 0 && subject.getItemCount() == 2) {
            subject.setSelectedIndex(1);
            doi.setSubjectId(subject.getSelectedIndex() <= 0 ? null : Long.valueOf(subject.getSelectedValue()));
        }
        if (subject.getSelectedIndex() > 0) {
            this.subjectChanged(row, doi);
        }
        final ImageButton delete = new ImageButton(RESOURCES.delete());
        delete.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent e) {
                int row = ExamEditPage.this.iOwners.getRowForWidget((Widget)delete);
                ExamEditPage.this.iOwners.removeRow(row);
                ExamEditPage.this.load(ExamEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.EXAM_OWNERS, false, null);
            }
        });
        row.add((Widget)delete);
        return row;
    }

    protected void subjectChanged(final List<Widget> row, final ExamsInterface.ExamObjectInterface doi) {
        final ListBox course = (ListBox)row.get(1);
        ListBox subpart = (ListBox)row.get(2);
        ListBox clazz = (ListBox)row.get(3);
        course.clear();
        course.addItem("-", "");
        subpart.clear();
        subpart.addItem("-", "");
        clazz.clear();
        clazz.addItem("-", "");
        if (doi.getSubjectId() != null) {
            ExamsInterface.ExamLookupCourses req = new ExamsInterface.ExamLookupCourses();
            req.setSubjectId(doi.getSubjectId());
            RPC.execute(req, new AsyncCallback<GwtRpcResponseList<PrefGroupEditInterface.IdLabel>>(){

                public void onFailure(Throwable e) {
                    UniTimeNotifications.error(e.getMessage(), e);
                }

                public void onSuccess(GwtRpcResponseList<PrefGroupEditInterface.IdLabel> list) {
                    course.clear();
                    course.addItem("-", "");
                    for (PrefGroupEditInterface.IdLabel item : list) {
                        course.addItem(item.getLabel(), item.getId().toString());
                        if (!item.getId().equals(doi.getCourseId())) continue;
                        course.setSelectedIndex(course.getItemCount() - 1);
                        ExamEditPage.this.courseChanged(row, doi);
                    }
                    if (course.getSelectedIndex() <= 0 && course.getItemCount() == 2) {
                        course.setSelectedIndex(1);
                        doi.setCourseId(course.getSelectedIndex() <= 0 ? null : Long.valueOf(course.getSelectedValue()));
                        ExamEditPage.this.courseChanged(row, doi);
                        ExamEditPage.this.load(ExamEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.EXAM_OWNERS, false, null);
                    }
                }
            });
        }
    }

    protected void courseChanged(final List<Widget> row, final ExamsInterface.ExamObjectInterface doi) {
        final ListBox subpart = (ListBox)row.get(2);
        ListBox clazz = (ListBox)row.get(3);
        subpart.clear();
        subpart.addItem("-", "");
        clazz.clear();
        clazz.addItem("-", "");
        if (doi.getCourseId() != null) {
            ExamsInterface.ExamLookupSubparts req = new ExamsInterface.ExamLookupSubparts();
            req.setCourseId(doi.getCourseId());
            RPC.execute(req, new AsyncCallback<GwtRpcResponseList<PrefGroupEditInterface.IdLabel>>(){

                public void onFailure(Throwable e) {
                    UniTimeNotifications.error(e.getMessage(), e);
                }

                public void onSuccess(GwtRpcResponseList<PrefGroupEditInterface.IdLabel> list) {
                    subpart.clear();
                    subpart.addItem("-", "");
                    for (PrefGroupEditInterface.IdLabel item : list) {
                        subpart.addItem(item.getLabel(), item.getId().toString());
                        if (!item.getId().equals(doi.getSubpartId())) continue;
                        subpart.setSelectedIndex(subpart.getItemCount() - 1);
                        ExamEditPage.this.subpartChanged(row, doi);
                    }
                    if (subpart.getSelectedIndex() <= 0) {
                        subpart.setSelectedIndex(1);
                        doi.setSubpartId(subpart.getSelectedIndex() <= 0 ? null : Long.valueOf(subpart.getSelectedValue()));
                        ExamEditPage.this.subpartChanged(row, doi);
                    }
                }
            });
        }
    }

    protected void subpartChanged(List<Widget> row, final ExamsInterface.ExamObjectInterface doi) {
        final ListBox clazz = (ListBox)row.get(3);
        clazz.clear();
        clazz.addItem(EXAM.examOwnerNotApplicable(), "");
        if (doi.getSubpartId() != null) {
            if (doi.getSubpartId() >= 0L) {
                ExamsInterface.ExamLookupClasses req = new ExamsInterface.ExamLookupClasses();
                req.setCourseId(doi.getCourseId());
                req.setSubpartId(doi.getSubpartId());
                RPC.execute(req, new AsyncCallback<GwtRpcResponseList<PrefGroupEditInterface.IdLabel>>(){

                    public void onFailure(Throwable e) {
                        UniTimeNotifications.error(e.getMessage(), e);
                    }

                    public void onSuccess(GwtRpcResponseList<PrefGroupEditInterface.IdLabel> list) {
                        clazz.clear();
                        clazz.addItem("-", "");
                        for (PrefGroupEditInterface.IdLabel item : list) {
                            clazz.addItem(item.getLabel(), item.getId().toString());
                            if (!item.getId().equals(doi.getClassId())) continue;
                            clazz.setSelectedIndex(clazz.getItemCount() - 1);
                        }
                        if (clazz.getSelectedIndex() <= 0 && clazz.getItemCount() == 2) {
                            clazz.setSelectedIndex(1);
                            doi.setClassId(clazz.getSelectedIndex() <= 0 ? null : Long.valueOf(clazz.getSelectedValue()));
                            if (doi.getClassId() != null && ExamEditPage.this.iOwners.getRowForWidget((Widget)clazz) == ExamEditPage.this.iOwners.getRowCount() - 1) {
                                ExamsInterface.ExamObjectInterface doi2 = new ExamsInterface.ExamObjectInterface();
                                ExamEditPage.this.iOwners.addRow(doi2, ExamEditPage.this.toClassRow(doi2));
                            }
                        }
                    }
                });
            } else if (doi.isValid() && this.iOwners.getRowForWidget((Widget)clazz) == this.iOwners.getRowCount() - 1) {
                ExamsInterface.ExamObjectInterface blank = new ExamsInterface.ExamObjectInterface();
                this.iOwners.addRow(blank, this.toClassRow(blank));
            }
        }
    }
}

