/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.exams;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.exams.ExamsInterface;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class ExamDistributionsEditPage
extends Composite {
    private static final ExaminationMessages EXAM = (ExaminationMessages)GWT.create(ExaminationMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private UniTimeHeaderPanel iExamsHeader;
    private ExamsInterface.ExamDistributionEditResponse iData;
    private UniTimeTable<ExamsInterface.ExamDistributionObjectInterface> iExams;
    private ListBox iDistrubutionType;
    private ListBox iExamType;
    private ListBox iPreference;
    private HTML iDistributionDesc;

    public ExamDistributionsEditPage() {
        Long id = null;
        if (Window.Location.getParameter((String)"id") != null) {
            id = Long.valueOf(Window.Location.getParameter((String)"id"));
        } else if (Window.Location.getParameter((String)"distPrefId") != null) {
            id = Long.valueOf(Window.Location.getParameter((String)"distPrefId"));
        } else if (Window.Location.getParameter((String)"dp") != null) {
            id = Long.valueOf(Window.Location.getParameter((String)"dp"));
        }
        this.iPanel = new SimpleForm();
        this.iHeader = new UniTimeHeaderPanel(id == null ? EXAM.sectionAddDistributionPreference() : EXAM.sectionEditDistributionPreference());
        this.iHeader.addButton("save", EXAM.actionSaveNewDistributionPreference(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                String error = ExamDistributionsEditPage.this.validate();
                if (error == null) {
                    ExamDistributionsEditPage.this.iHeader.clearMessage();
                    ExamDistributionsEditPage.this.update();
                } else {
                    ExamDistributionsEditPage.this.iHeader.setErrorMessage(error);
                }
            }
        });
        this.iHeader.getButton("save").setAccessKey(EXAM.accessSaveNewDistributionPreference().charAt(0));
        this.iHeader.getButton("save").setTitle(EXAM.titleSaveNewDistributionPreference(EXAM.accessSaveNewDistributionPreference()));
        this.iHeader.setEnabled("save", false);
        this.iHeader.addButton("update", EXAM.actionUpdateDistributionPreference(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                String error = ExamDistributionsEditPage.this.validate();
                if (error == null) {
                    ExamDistributionsEditPage.this.iHeader.clearMessage();
                    ExamDistributionsEditPage.this.update();
                } else {
                    ExamDistributionsEditPage.this.iHeader.setErrorMessage(error);
                }
            }
        });
        this.iHeader.setEnabled("update", false);
        this.iHeader.getButton("save").setAccessKey(EXAM.accessUpdateDistributionPreference().charAt(0));
        this.iHeader.getButton("save").setTitle(EXAM.titleUpdateDistributionPreference(EXAM.accessUpdateDistributionPreference()));
        this.iHeader.addButton("delete", EXAM.actionDeleteDistributionPreference(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                if (ExamDistributionsEditPage.this.iData.isConfirms()) {
                    UniTimeConfirmationDialog.confirm(EXAM.confirmDeleteDistributionPreference(), new Command(){

                        public void execute() {
                            ExamDistributionsEditPage.this.delete();
                        }
                    });
                } else {
                    ExamDistributionsEditPage.this.delete();
                }
            }
        });
        this.iHeader.setEnabled("delete", false);
        this.iHeader.getButton("delete").setAccessKey(EXAM.accessDeleteDistributionPreference().charAt(0));
        this.iHeader.getButton("delete").setTitle(EXAM.titleDeleteDistributionPreference(EXAM.accessDeleteDistributionPreference()));
        this.iHeader.addButton("back", EXAM.actionBackDistributionPreference(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                if (ExamDistributionsEditPage.this.iData.getBackUrl() != null) {
                    ToolBox.open(GWT.getHostPageBaseURL() + ExamDistributionsEditPage.this.iData.getBackUrl());
                } else {
                    ToolBox.open(GWT.getHostPageBaseURL() + "distributions" + (String)(ExamDistributionsEditPage.this.iData.getPreferenceId() == null ? "" : "?backId=" + ExamDistributionsEditPage.this.iData.getPreferenceId() + "&backType=DistributionPref"));
                }
            }
        });
        this.iHeader.setEnabled("back", false);
        this.iHeader.getButton("back").setAccessKey(EXAM.accessBackDistributionPreference().charAt(0));
        this.iHeader.getButton("back").setTitle(EXAM.titleBackDistributionPreference(EXAM.accessBackDistributionPreference()));
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        this.iFooter = this.iHeader.clonePanel();
        this.iFooter.setHeaderTitle("");
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-DistributionsEditPage");
        this.initWidget((Widget)this.iRootPanel);
        ExamsInterface.ExamDistributionEditRequest request = new ExamsInterface.ExamDistributionEditRequest();
        request.setPreferenceId(id);
        if (Window.Location.getParameter((String)"typeId") != null) {
            request.setTypeId(Long.valueOf(Window.Location.getParameter((String)"type")));
        }
        if (Window.Location.getParameter((String)"examId") != null) {
            request.setExamId(Long.valueOf(Window.Location.getParameter((String)"examId")));
        }
        LoadingWidget.showLoading(MESSAGES.waitLoadingData());
        RPC.execute(request, new AsyncCallback<ExamsInterface.ExamDistributionEditResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.hideLoading();
                ExamDistributionsEditPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(ExamsInterface.ExamDistributionEditResponse response) {
                LoadingWidget.hideLoading();
                ExamDistributionsEditPage.this.iData = response;
                ExamDistributionsEditPage.this.populate();
            }
        });
    }

    protected String validate() {
        if (this.iData.getExamTypeId() == null) {
            return EXAM.messageNoExamType();
        }
        if (this.iData.getDistTypeId() == null) {
            return EXAM.errorSelectDistributionType();
        }
        if (this.iData.getPrefLevelId() == null) {
            return EXAM.errorSelectPreferenceLevel();
        }
        int count = 0;
        HashSet<Long> selections = new HashSet<Long>();
        for (int row = 0; row < this.iExams.getRowCount(); ++row) {
            ExamsInterface.ExamDistributionObjectInterface doi = this.iExams.getData(row);
            if (doi.getExamId() != null) {
                if (!selections.add(doi.getExamId())) {
                    return EXAM.errorInvalidClassSelectionDP();
                }
                ++count;
                continue;
            }
            if (row + 1 >= this.iExams.getRowCount()) continue;
            return EXAM.errorInvalidClassSelectionDP();
        }
        if (count <= 1) {
            return EXAM.errorInvalidClassSelectionDPMinTwoExams();
        }
        return null;
    }

    protected void update() {
        ExamsInterface.ExamDistributionEditRequest request = new ExamsInterface.ExamDistributionEditRequest();
        request.setPreferenceId(this.iData.getPreferenceId());
        if (this.iData.hasDistributionObjects()) {
            this.iData.getDistributionObjects().clear();
        }
        for (ExamsInterface.ExamDistributionObjectInterface doi : this.iExams.getData()) {
            if (doi.getExamId() == null) continue;
            this.iData.addDistributionObject(doi);
        }
        request.setData(this.iData);
        request.setOperation(ExamsInterface.ExamDistributionEditRequest.Operation.SAVE);
        LoadingWidget.showLoading(MESSAGES.waitSavingRecord());
        RPC.execute(request, new AsyncCallback<ExamsInterface.ExamDistributionEditResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.hideLoading();
                ExamDistributionsEditPage.this.iHeader.setErrorMessage(caught.getMessage());
                UniTimeNotifications.error(caught.getMessage(), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(ExamsInterface.ExamDistributionEditResponse response) {
                LoadingWidget.hideLoading();
                if (ExamDistributionsEditPage.this.iData.getBackUrl() != null) {
                    ToolBox.open(GWT.getHostPageBaseURL() + ExamDistributionsEditPage.this.iData.getBackUrl() + (ExamDistributionsEditPage.this.iData.getBackUrl().contains("?") ? "&" : "?") + "backId=" + response.getPreferenceId() + "&backType=DistributionPref");
                } else {
                    ToolBox.open(GWT.getHostPageBaseURL() + "examDistributions?backId=" + response.getPreferenceId() + "&backType=DistributionPref");
                }
            }
        });
    }

    protected void delete() {
        ExamsInterface.ExamDistributionEditRequest request = new ExamsInterface.ExamDistributionEditRequest();
        request.setPreferenceId(this.iData.getPreferenceId());
        this.iData.setDistributionObjects(this.iExams.getData());
        request.setOperation(ExamsInterface.ExamDistributionEditRequest.Operation.DELETE);
        LoadingWidget.showLoading(MESSAGES.waitDeletingRecord());
        RPC.execute(request, new AsyncCallback<ExamsInterface.ExamDistributionEditResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.hideLoading();
                ExamDistributionsEditPage.this.iHeader.setErrorMessage(caught.getMessage());
                UniTimeNotifications.error(caught.getMessage(), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(ExamsInterface.ExamDistributionEditResponse response) {
                LoadingWidget.hideLoading();
                if (ExamDistributionsEditPage.this.iData.getBackUrl() != null) {
                    ToolBox.open(GWT.getHostPageBaseURL() + ExamDistributionsEditPage.this.iData.getBackUrl());
                } else {
                    ToolBox.open(GWT.getHostPageBaseURL() + "examDistributions");
                }
            }
        });
    }

    protected void populate() {
        PrefGroupEditInterface.IdLabel dt2;
        this.iExamType = new ListBox();
        this.iExamType.getElement().getStyle().setProperty("min-width", "30px");
        for (PrefGroupEditInterface.IdLabel st : this.iData.getExamTypes()) {
            this.iExamType.addItem(st.getLabel(), st.getId().toString());
            if (!st.getId().equals(this.iData.getExamTypeId())) continue;
            this.iExamType.setSelectedIndex(this.iExamType.getItemCount() - 1);
        }
        if (this.iData.getExamTypeId() == null) {
            this.iData.setExamTypeId(Long.valueOf(this.iExamType.getSelectedValue()));
        }
        if (this.iData.getExamTypes().size() == 1) {
            this.iExamType.setEnabled(false);
        }
        this.iExamType.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                Long id = ExamDistributionsEditPage.this.iExamType.getSelectedValue().isEmpty() ? null : Long.valueOf(ExamDistributionsEditPage.this.iExamType.getSelectedValue());
                ExamDistributionsEditPage.this.iData.setExamTypeId(id);
                while (ExamDistributionsEditPage.this.iExams.getRowCount() > 0) {
                    ExamDistributionsEditPage.this.iExams.removeRow(0);
                }
                ExamsInterface.ExamDistributionObjectInterface doi = new ExamsInterface.ExamDistributionObjectInterface();
                ExamDistributionsEditPage.this.iExams.addRow(doi, ExamDistributionsEditPage.this.toClassRow(doi));
                ExamDistributionsEditPage.this.iExamsHeader.setHeaderTitle(EXAM.sectionExaminationsInDistribution(ExamDistributionsEditPage.this.iExamType.getSelectedItemText()));
            }
        });
        this.iPanel.addRow(EXAM.propExamType(), (Widget)this.iExamType);
        this.iDistrubutionType = new ListBox();
        this.iDistrubutionType.addItem(EXAM.itemSelect(), "");
        this.iDistrubutionType.getElement().getStyle().setProperty("min-width", "300px");
        this.iDistributionDesc = new HTML();
        this.iDistributionDesc.addStyleName("unitime-Description");
        for (PrefGroupEditInterface.IdLabel dt2 : this.iData.getDistTypes()) {
            this.iDistrubutionType.addItem(dt2.getLabel(), dt2.getId().toString());
            if (!dt2.getId().equals(this.iData.getDistTypeId())) continue;
            this.iDistrubutionType.setSelectedIndex(this.iDistrubutionType.getItemCount() - 1);
            this.iDistributionDesc.setHTML(dt2.getDescription() == null ? "" : dt2.getDescription());
        }
        this.iDistrubutionType.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                PrefGroupEditInterface.IdLabel dt;
                Long id = ExamDistributionsEditPage.this.iDistrubutionType.getSelectedValue().isEmpty() ? null : Long.valueOf(ExamDistributionsEditPage.this.iDistrubutionType.getSelectedValue());
                ExamDistributionsEditPage.this.iData.setDistTypeId(id);
                PrefGroupEditInterface.IdLabel idLabel = dt = id == null ? null : ExamDistributionsEditPage.this.iData.getDistType(id);
                if (dt != null) {
                    ExamDistributionsEditPage.this.iDistributionDesc.setHTML(dt.getDescription() == null ? "" : dt.getDescription());
                } else {
                    ExamDistributionsEditPage.this.iDistributionDesc.setHTML("");
                }
                ExamDistributionsEditPage.this.iPreference.clear();
                ExamDistributionsEditPage.this.iPreference.addItem(EXAM.itemSelect(), "");
                for (PrefGroupEditInterface.IdLabel st : ExamDistributionsEditPage.this.iData.getPrefLevels()) {
                    if (!dt.getAllowedPrefs().contains(st.getDescription())) continue;
                    ExamDistributionsEditPage.this.iPreference.addItem(st.getLabel(), st.getId().toString());
                    if (!st.getId().equals(ExamDistributionsEditPage.this.iData.getPrefLevelId())) continue;
                    ExamDistributionsEditPage.this.iPreference.setSelectedIndex(ExamDistributionsEditPage.this.iPreference.getItemCount() - 1);
                }
                ExamDistributionsEditPage.this.iData.setPrefLevelId(ExamDistributionsEditPage.this.iPreference.getSelectedValue().isEmpty() ? null : Long.valueOf(ExamDistributionsEditPage.this.iPreference.getSelectedValue()));
            }
        });
        P dtp = new P();
        dtp.add((Widget)this.iDistrubutionType);
        dtp.add((Widget)this.iDistributionDesc);
        this.iPanel.addRow(EXAM.propertyDistributionType(), (Widget)dtp);
        this.iPreference = new ListBox();
        this.iPreference.getElement().getStyle().setProperty("min-width", "300px");
        this.iPreference.addItem(EXAM.itemSelect(), "");
        dt2 = this.iData.getDistTypeId() == null ? null : this.iData.getDistType(this.iData.getDistTypeId());
        for (PrefGroupEditInterface.IdLabel st : this.iData.getPrefLevels()) {
            if (dt2 != null && !dt2.getAllowedPrefs().contains(st.getDescription())) continue;
            this.iPreference.addItem(st.getLabel(), st.getId().toString());
            if (!st.getId().equals(this.iData.getPrefLevelId())) continue;
            this.iPreference.setSelectedIndex(this.iPreference.getItemCount() - 1);
        }
        this.iPreference.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                ExamDistributionsEditPage.this.iData.setPrefLevelId(ExamDistributionsEditPage.this.iPreference.getSelectedValue().isEmpty() ? null : Long.valueOf(ExamDistributionsEditPage.this.iPreference.getSelectedValue()));
            }
        });
        this.iPanel.addRow(EXAM.propertyDistributionPreference(), (Widget)this.iPreference);
        this.iExams = new UniTimeTable();
        this.iExamsHeader = new UniTimeHeaderPanel(EXAM.sectionExaminationsInDistribution(this.iExamType.getSelectedItemText()));
        this.iPanel.addHeaderRow((Widget)this.iExamsHeader);
        this.iExamsHeader.addButton("add", EXAM.actionAddExamToDistribution(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                ExamsInterface.ExamDistributionObjectInterface doi = new ExamsInterface.ExamDistributionObjectInterface();
                ExamDistributionsEditPage.this.iExams.addRow(doi, ExamDistributionsEditPage.this.toClassRow(doi));
                ExamDistributionsEditPage.this.updateButtons();
            }
        });
        this.iPanel.addRow((Widget)this.iExams);
        if (this.iData.hasDistributionObjects()) {
            for (ExamsInterface.ExamDistributionObjectInterface doi : this.iData.getDistributionObjects()) {
                this.iExams.addRow(doi, this.toClassRow(doi));
            }
        }
        if (this.iExams.getRowCount() == 0) {
            ExamsInterface.ExamDistributionObjectInterface doi = new ExamsInterface.ExamDistributionObjectInterface();
            if (Window.Location.getParameter((String)"subjectId") != null) {
                doi.setSubjectId(Long.valueOf(Window.Location.getParameter((String)"subjectId")));
            }
            this.iExams.addRow(doi, this.toClassRow(doi));
        }
        this.updateButtons();
        this.iPanel.addBottomRow((Widget)this.iFooter);
        this.iHeader.setEnabled("save", this.iData.getPreferenceId() == null);
        this.iHeader.setEnabled("update", this.iData.getPreferenceId() != null);
        this.iHeader.setEnabled("delete", this.iData.getPreferenceId() != null && this.iData.isCanDelete());
        this.iHeader.setEnabled("back", true);
    }

    protected void updateButtons() {
        for (int i = 0; i < this.iExams.getRowCount(); ++i) {
            ImageButton up = (ImageButton)this.iExams.getWidget(i, 3);
            ImageButton down = (ImageButton)this.iExams.getWidget(i, 4);
            ImageButton delete = (ImageButton)this.iExams.getWidget(i, 5);
            up.setVisible(i > 0);
            down.setVisible(i + 1 < this.iExams.getRowCount());
            delete.setVisible(this.iExams.getRowCount() > 1);
        }
    }

    protected List<Widget> toClassRow(final ExamsInterface.ExamDistributionObjectInterface doi) {
        final ArrayList<Widget> row = new ArrayList<Widget>();
        final ListBox subject = new ListBox();
        subject.addItem("-", "");
        subject.setWidth("100px");
        row.add((Widget)subject);
        final ListBox course = new ListBox();
        course.addItem("-", "");
        course.setWidth("400px");
        row.add((Widget)course);
        final ListBox exam = new ListBox();
        exam.addItem("-", "");
        exam.setWidth("400px");
        row.add((Widget)exam);
        for (PrefGroupEditInterface.IdLabel s : this.iData.getSubjects()) {
            subject.addItem(s.getLabel(), s.getId().toString());
            if (!s.getId().equals(doi.getSubjectId())) continue;
            subject.setSelectedIndex(subject.getItemCount() - 1);
        }
        if (doi.getSubjectId() != null && subject.getSelectedIndex() <= 0) {
            subject.addItem(doi.getSubject(), doi.getSubjectId().toString());
            subject.setSelectedIndex(subject.getItemCount() - 1);
            subject.setEnabled(false);
            course.setEnabled(false);
            subject.setEnabled(false);
            exam.setEnabled(false);
        }
        subject.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                doi.setSubjectId(subject.getSelectedIndex() <= 0 ? null : Long.valueOf(subject.getSelectedValue()));
                ExamDistributionsEditPage.this.subjectChanged(row, doi);
            }
        });
        course.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                doi.setCourseId(course.getSelectedIndex() <= 0 ? null : Long.valueOf(course.getSelectedValue()));
                ExamDistributionsEditPage.this.courseChanged(row, doi);
            }
        });
        exam.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                doi.setExamId(Long.valueOf(exam.getSelectedValue()));
                if (doi.getExamId() != null && ExamDistributionsEditPage.this.iExams.getRowForWidget((Widget)exam) == ExamDistributionsEditPage.this.iExams.getRowCount() - 1) {
                    ExamsInterface.ExamDistributionObjectInterface doi2 = new ExamsInterface.ExamDistributionObjectInterface();
                    ExamDistributionsEditPage.this.iExams.addRow(doi2, ExamDistributionsEditPage.this.toClassRow(doi2));
                    ExamDistributionsEditPage.this.updateButtons();
                }
            }
        });
        if (subject.getSelectedIndex() <= 0 && subject.getItemCount() == 2) {
            subject.setSelectedIndex(1);
            doi.setSubjectId(subject.getSelectedIndex() <= 0 ? null : Long.valueOf(subject.getSelectedValue()));
        }
        if (subject.getSelectedIndex() > 0) {
            this.subjectChanged(row, doi);
        }
        final ImageButton up = new ImageButton(RESOURCES.orderUp());
        up.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent e) {
                int row = ExamDistributionsEditPage.this.iExams.getRowForWidget((Widget)up);
                if (row > 0) {
                    ExamDistributionsEditPage.this.iExams.swapRows(row - 1, row);
                }
                ExamDistributionsEditPage.this.updateButtons();
            }
        });
        row.add((Widget)up);
        final ImageButton down = new ImageButton(RESOURCES.orderDown());
        down.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent e) {
                int row = ExamDistributionsEditPage.this.iExams.getRowForWidget((Widget)down);
                if (row + 1 < ExamDistributionsEditPage.this.iExams.getRowCount()) {
                    ExamDistributionsEditPage.this.iExams.swapRows(row, row + 1);
                }
                ExamDistributionsEditPage.this.updateButtons();
            }
        });
        row.add((Widget)down);
        final ImageButton delete = new ImageButton(RESOURCES.delete());
        delete.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent e) {
                int row = ExamDistributionsEditPage.this.iExams.getRowForWidget((Widget)delete);
                ExamDistributionsEditPage.this.iExams.removeRow(row);
                ExamDistributionsEditPage.this.updateButtons();
            }
        });
        row.add((Widget)delete);
        return row;
    }

    protected void subjectChanged(final List<Widget> row, final ExamsInterface.ExamDistributionObjectInterface doi) {
        final ListBox course = (ListBox)row.get(1);
        ListBox exam = (ListBox)row.get(2);
        course.clear();
        course.addItem("-", "");
        exam.clear();
        exam.addItem("-", "");
        if (doi.getSubjectId() != null) {
            ExamsInterface.ExamDistributionsLookupCourses req = new ExamsInterface.ExamDistributionsLookupCourses();
            req.setSubjectId(doi.getSubjectId());
            RPC.execute(req, new AsyncCallback<GwtRpcResponseList<PrefGroupEditInterface.IdLabel>>(){

                public void onFailure(Throwable e) {
                    UniTimeNotifications.error(e.getMessage(), e);
                }

                public void onSuccess(GwtRpcResponseList<PrefGroupEditInterface.IdLabel> list) {
                    course.clear();
                    course.addItem("-", "");
                    for (PrefGroupEditInterface.IdLabel item : list) {
                        course.addItem(item.getLabel(), item.getId().toString());
                        if (!item.getId().equals(doi.getCourseId())) continue;
                        course.setSelectedIndex(course.getItemCount() - 1);
                        ExamDistributionsEditPage.this.courseChanged(row, doi);
                    }
                    if (course.getSelectedIndex() <= 0 && course.getItemCount() == 2) {
                        course.setSelectedIndex(1);
                        doi.setCourseId(course.getSelectedIndex() <= 0 ? null : Long.valueOf(course.getSelectedValue()));
                        ExamDistributionsEditPage.this.courseChanged(row, doi);
                    }
                }
            });
        }
    }

    protected void courseChanged(List<Widget> row, final ExamsInterface.ExamDistributionObjectInterface doi) {
        final ListBox exam = (ListBox)row.get(2);
        exam.clear();
        exam.addItem("-", "");
        if (doi.getCourseId() != null) {
            ExamsInterface.ExamDistributionsLookupExams req = new ExamsInterface.ExamDistributionsLookupExams();
            req.setExamTypeId(this.iData.getExamTypeId());
            req.setCourseId(doi.getCourseId());
            RPC.execute(req, new AsyncCallback<GwtRpcResponseList<PrefGroupEditInterface.IdLabel>>(){

                public void onFailure(Throwable e) {
                    UniTimeNotifications.error(e.getMessage(), e);
                }

                public void onSuccess(GwtRpcResponseList<PrefGroupEditInterface.IdLabel> list) {
                    exam.clear();
                    exam.addItem("-", "");
                    for (PrefGroupEditInterface.IdLabel item : list) {
                        exam.addItem(item.getLabel(), item.getId().toString());
                        if (!item.getId().equals(doi.getExamId())) continue;
                        exam.setSelectedIndex(exam.getItemCount() - 1);
                    }
                    if (exam.getSelectedIndex() <= 0 && exam.getItemCount() == 2) {
                        exam.setSelectedIndex(1);
                        doi.setExamId(exam.getSelectedIndex() <= 0 ? null : Long.valueOf(exam.getSelectedValue()));
                    }
                }
            });
        }
    }
}

