/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.curricula;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.timetable.gwt.client.events.UniTimeFilterBox;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CurriculumInterface;
import org.unitime.timetable.gwt.shared.EventInterface;

public class CurriculumFilterBox
extends UniTimeFilterBox<CurriculumInterface.CurriculumFilterRpcRequest> {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private ListBox iDepartments;
    private FilterBox.CustomFilter iOther = null;

    public CurriculumFilterBox() {
        super(null);
        this.setShowSuggestionsOnFocus(false);
        this.iDepartments = new ListBox();
        this.iDepartments.setMultipleSelect(false);
        this.iDepartments.setWidth("100%");
        this.addFilter(new FilterBox.CustomFilter("department", MESSAGES.tagDepartment(), new Widget[]{this.iDepartments}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    FilterBox.Chip oldChip = CurriculumFilterBox.this.getChip("department");
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    for (int i = 0; i < CurriculumFilterBox.this.iDepartments.getItemCount(); ++i) {
                        FilterBox.Chip chip = new FilterBox.Chip("department", CurriculumFilterBox.this.iDepartments.getValue(i)).withTranslatedCommand(MESSAGES.tagDepartment());
                        String name = CurriculumFilterBox.this.iDepartments.getItemText(i);
                        if (CurriculumFilterBox.this.iDepartments.getValue(i).toLowerCase().startsWith(text.toLowerCase())) {
                            suggestions.add(new FilterBox.Suggestion(name, chip, oldChip));
                            continue;
                        }
                        if (text.length() <= 2 || !name.toLowerCase().contains(" " + text.toLowerCase()) && !name.toLowerCase().contains(" (" + text.toLowerCase())) continue;
                        suggestions.add(new FilterBox.Suggestion(name, chip, oldChip));
                    }
                    callback.onSuccess(suggestions);
                }
            }
        });
        this.iDepartments.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FilterBox.Chip newChip;
                FilterBox.Chip oldChip = CurriculumFilterBox.this.getChip("department");
                FilterBox.Chip chip = newChip = CurriculumFilterBox.this.iDepartments.getSelectedIndex() <= 0 ? null : new FilterBox.Chip("department", CurriculumFilterBox.this.iDepartments.getValue(CurriculumFilterBox.this.iDepartments.getSelectedIndex())).withTranslatedCommand(MESSAGES.tagDepartment());
                if (oldChip != null) {
                    if (newChip == null) {
                        CurriculumFilterBox.this.removeChip(oldChip, true);
                    } else if (!oldChip.getValue().equals(newChip.getValue())) {
                        CurriculumFilterBox.this.removeChip(oldChip, false);
                        CurriculumFilterBox.this.addChip(newChip, true);
                    }
                } else if (newChip != null) {
                    CurriculumFilterBox.this.addChip(newChip, true);
                }
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("area", MESSAGES.tagAcademicArea(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("major", MESSAGES.tagMajor(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("classification", MESSAGES.tagClassification(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("curriculum", MESSAGES.tagCurriculum(), new String[0]));
        final TextBox curriculum = new TextBox();
        curriculum.setStyleName("unitime-TextArea");
        curriculum.setMaxLength(100);
        curriculum.setWidth("200px");
        this.iOther = new FilterBox.CustomFilter("other", MESSAGES.tagOther(), new Widget[]{new Label(MESSAGES.propCurriculum()), curriculum});
        this.addFilter(this.iOther);
        curriculum.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                boolean removed = CurriculumFilterBox.this.removeChip(new FilterBox.Chip("curriculum", null), false);
                if (curriculum.getText().isEmpty()) {
                    if (removed) {
                        CurriculumFilterBox.this.fireValueChangeEvent();
                    }
                } else {
                    CurriculumFilterBox.this.addChip(new FilterBox.Chip("curriculum", curriculum.getText()).withTranslatedCommand(MESSAGES.tagCurriculum()), true);
                }
            }
        });
        this.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (!CurriculumFilterBox.this.isFilterPopupShowing()) {
                    FilterBox.Chip chip;
                    CurriculumFilterBox.this.iDepartments.setSelectedIndex(0);
                    for (int i = 1; i < CurriculumFilterBox.this.iDepartments.getItemCount(); ++i) {
                        String value = CurriculumFilterBox.this.iDepartments.getValue(i);
                        if (!CurriculumFilterBox.this.hasChip(new FilterBox.Chip("department", value))) continue;
                        CurriculumFilterBox.this.iDepartments.setSelectedIndex(i);
                        break;
                    }
                    if ((chip = CurriculumFilterBox.this.getChip("curriculum")) == null) {
                        curriculum.setText("");
                    } else {
                        curriculum.setText(chip.getValue());
                    }
                }
                CurriculumFilterBox.this.init(false, CurriculumFilterBox.this.getAcademicSessionId(), new Command(){

                    public void execute() {
                        if (CurriculumFilterBox.this.isFilterPopupShowing()) {
                            CurriculumFilterBox.this.showFilterPopup();
                        }
                    }
                });
            }
        });
    }

    @Override
    protected boolean populateFilter(FilterBox.Filter filter, List<EventInterface.FilterRpcResponse.Entity> entities) {
        if ("department".equals(filter.getCommand())) {
            this.iDepartments.clear();
            this.iDepartments.addItem(MESSAGES.itemAllDepartments(), "");
            if (entities != null) {
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    this.iDepartments.addItem(entity.getName() + " (" + entity.getCount() + ")", entity.getAbbreviation());
                }
            }
            this.iDepartments.setSelectedIndex(0);
            FilterBox.Chip dept = this.getChip("department");
            if (dept != null) {
                for (int i = 1; i < this.iDepartments.getItemCount(); ++i) {
                    if (!dept.getValue().equals(this.iDepartments.getValue(i))) continue;
                    this.iDepartments.setSelectedIndex(i);
                    break;
                }
            }
            return true;
        }
        if (filter != null && filter instanceof FilterBox.StaticSimpleFilter) {
            FilterBox.StaticSimpleFilter simple = (FilterBox.StaticSimpleFilter)filter;
            ArrayList<FilterBox.Chip> chips = new ArrayList<FilterBox.Chip>();
            if (entities != null) {
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    chips.add(new FilterBox.Chip(filter.getCommand(), entity.getAbbreviation()).withLabel(entity.getName()).withCount(entity.getCount()).withTranslatedCommand(filter.getLabel()).withTranslatedValue(entity.getProperty("translated-value", null)));
                }
            }
            simple.setValues(chips);
            return true;
        }
        return false;
    }

    @Override
    public CurriculumInterface.CurriculumFilterRpcRequest createRpcRequest() {
        return new CurriculumInterface.CurriculumFilterRpcRequest();
    }
}

