/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.aria;

import com.google.gwt.aria.client.Id;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.aria.client.SelectedValue;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TabBar;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;

public class AriaTabBar
extends TabBar {
    private static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static RegExp sStripAcessKeyRegExp = RegExp.compile((String)"(.*)<u>(\\w)</u>(.*)", (String)"i");

    public AriaTabBar() {
        this.getElement().setId(DOM.createUniqueId());
        Roles.getPresentationRole().set(this.getElement().getFirstChildElement());
    }

    public Element getTabElement(int index) {
        return ((Widget)this.getTab(index)).getElement();
    }

    protected void insertTabWidget(Widget widget, int beforeIndex) {
        super.insertTabWidget(widget, beforeIndex);
        Roles.getTabRole().setAriaSelectedState(this.getTabElement(beforeIndex), SelectedValue.FALSE);
        this.getTabElement(beforeIndex).setId(DOM.createUniqueId());
        Id[] ids = new Id[this.getTabCount()];
        for (int i = 0; i < this.getTabCount(); ++i) {
            Roles.getTabRole().setAriaLabelProperty(this.getTabElement(i), ARIA.tabNotSelected(1 + i, this.getTabCount(), this.getTabLabel(i)));
            ids[i] = Id.of((Element)this.getTabElement(i));
        }
        Roles.getTablistRole().setAriaOwnsProperty((Element)this.getElement(), ids);
    }

    public void removeTab(int index) {
        super.removeTab(index);
        Id[] ids = new Id[this.getTabCount()];
        for (int i = 0; i < this.getTabCount(); ++i) {
            Roles.getTabRole().setAriaLabelProperty(this.getTabElement(i), ARIA.tabNotSelected(1 + i, this.getTabCount(), this.getTabLabel(i)));
            ids[i] = Id.of((Element)this.getTabElement(i));
        }
        Roles.getTablistRole().setAriaOwnsProperty((Element)this.getElement(), ids);
        if (this.getSelectedTab() >= 0) {
            Roles.getTabRole().setAriaSelectedState(this.getTabElement(this.getSelectedTab()), SelectedValue.TRUE);
            Roles.getTabRole().setAriaLabelProperty(this.getTabElement(this.getSelectedTab()), ARIA.tabSelected(1 + this.getSelectedTab(), this.getTabCount(), this.getTabLabel(this.getSelectedTab())));
        }
    }

    public boolean selectTab(int index, boolean fireEvents) {
        if (this.getSelectedTab() >= 0) {
            Roles.getTabRole().setAriaSelectedState(this.getTabElement(this.getSelectedTab()), SelectedValue.FALSE);
            Roles.getTabRole().setAriaLabelProperty(this.getTabElement(this.getSelectedTab()), ARIA.tabNotSelected(1 + this.getSelectedTab(), this.getTabCount(), this.getTabLabel(this.getSelectedTab())));
        }
        boolean ret = super.selectTab(index, fireEvents);
        if (this.getSelectedTab() >= 0) {
            Roles.getTabRole().setAriaSelectedState(this.getTabElement(this.getSelectedTab()), SelectedValue.TRUE);
            Roles.getTabRole().setAriaLabelProperty(this.getTabElement(this.getSelectedTab()), ARIA.tabSelected(1 + this.getSelectedTab(), this.getTabCount(), this.getTabLabel(this.getSelectedTab())));
            if (fireEvents) {
                AriaStatus.getInstance().setHTML(ARIA.onTabSelected(this.getTabLabel(this.getSelectedTab())));
            }
        }
        return ret;
    }

    public String getTabLabel(int index) {
        String html = this.getTabHTML(index);
        if (html == null || html.isEmpty()) {
            return "";
        }
        MatchResult result = sStripAcessKeyRegExp.exec(html);
        return result == null ? html : result.getGroup(1) + result.getGroup(2) + result.getGroup(3);
    }

    public void setRestWidget(Widget rest) {
        HorizontalPanel panel = (HorizontalPanel)this.getWidget();
        rest.addStyleName("gwt-TabBarRest");
        rest.setHeight("100%");
        panel.remove(panel.getWidgetCount() - 1);
        panel.add(rest);
        panel.setCellWidth(rest, "100%");
        AriaTabBar.setStyleName((Element)rest.getElement().getParentElement(), (String)"gwt-TabBarRest-wrapper");
    }
}

