/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.unitime.timetable.gwt.client.Components;
import org.unitime.timetable.gwt.client.Pages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.Triggers;
import org.unitime.timetable.gwt.client.page.SolverWarnings;
import org.unitime.timetable.gwt.client.page.UniTimeMenu;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseBoolean;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.MenuInterface;

public class Client
implements EntryPoint {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    public static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    public static List<GwtPageChangedHandler> iGwtPageChangedHandlers = new ArrayList<GwtPageChangedHandler>();
    public static Logger sLogger = Logger.getLogger(Client.class.getName());
    private Timer iPageLoadingTimer;

    public void onModuleLoad() {
        GWT.setUncaughtExceptionHandler((GWT.UncaughtExceptionHandler)new GWT.UncaughtExceptionHandler(){

            public void onUncaughtException(Throwable e) {
                Throwable u = ToolBox.unwrap(e);
                sLogger.log(Level.WARNING, MESSAGES.failedUncaughtException(u.getMessage()), u);
            }
        });
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Client.this.onModuleLoadDeferred();
            }
        });
    }

    public void onModuleLoadDeferred() {
        GWT.runAsync((RunAsyncCallback)new RunAsyncCallback(){

            public void onSuccess() {
                for (Triggers t : Triggers.values()) {
                    t.register();
                }
                Client.callGwtOnLoadIfExists();
            }

            public void onFailure(Throwable reason) {
            }
        });
        if (RootPanel.get((String)"UniTimeGWT:Body") != null) {
            LoadingWidget.getInstance().show(MESSAGES.waitLoadingPage());
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    Client.this.initPageAsync(ToolBox.getPage());
                }
            });
        }
        for (final Components c : Components.values()) {
            NodeList<Element> x;
            final RootPanel p = RootPanel.get((String)c.id());
            if (p != null) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        Client.this.initComponentAsync(p, c);
                    }
                });
            }
            if (p != null || !c.isMultiple() || (x = Client.getElementsByName(c.id())) == null || x.getLength() <= 0) continue;
            for (int i = 0; i < x.getLength(); ++i) {
                Element e = (Element)x.getItem(i);
                e.setId(DOM.createUniqueId());
                final RootPanel q = RootPanel.get((String)e.getId());
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        Client.this.initComponentAsync(q, c);
                    }
                });
            }
        }
        Window.addWindowClosingHandler((Window.ClosingHandler)new Window.ClosingHandler(){

            public void onWindowClosing(Window.ClosingEvent event) {
                if (Client.isLoadingDisplayed() || LoadingWidget.getInstance().isShowing()) {
                    return;
                }
                LoadingWidget.showLoading(MESSAGES.waitPlease());
                Client.this.iPageLoadingTimer = new Timer(){

                    public void run() {
                        RPC.execute(new MenuInterface.IsSessionBusyRpcRequest(), new AsyncCallback<GwtRpcResponseBoolean>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.hideLoading();
                            }

                            public void onSuccess(GwtRpcResponseBoolean result) {
                                if (result.getValue().booleanValue()) {
                                    Client.this.iPageLoadingTimer.schedule(500);
                                } else {
                                    LoadingWidget.hideLoading();
                                }
                            }
                        });
                    }
                };
                Client.this.iPageLoadingTimer.schedule(500);
            }
        });
    }

    public void initPageAsync(final String page) {
        GWT.runAsync((RunAsyncCallback)new RunAsyncCallback(){

            public void onSuccess() {
                Client.this.init(page);
                LoadingWidget.getInstance().hide();
            }

            public void onFailure(Throwable reason) {
                Label error = new Label(MESSAGES.failedToLoadPage(reason.getMessage()));
                error.setStyleName("unitime-ErrorMessage");
                RootPanel loading = RootPanel.get((String)"UniTimeGWT:Loading");
                if (loading != null) {
                    loading.setVisible(false);
                }
                RootPanel.get((String)"UniTimeGWT:Body").add((Widget)error);
                LoadingWidget.getInstance().hide();
                UniTimeNotifications.error(MESSAGES.failedToLoadPage(reason.getMessage()), reason);
            }
        });
    }

    public void init(String page) {
        try {
            RootPanel loading = RootPanel.get((String)"UniTimeGWT:Loading");
            if (loading != null) {
                loading.setVisible(false);
            }
            for (Pages p : Pages.values()) {
                if (!p.name().equals(page)) continue;
                LoadingWidget.getInstance().setMessage(MESSAGES.waitLoading(p.name(MESSAGES)));
                UniTimePageLabel.getInstance().setPageName(p.name(MESSAGES));
                Window.setTitle((String)("UniTime " + CONSTANTS.version() + "| " + p.name(MESSAGES)));
                RootPanel.get((String)"UniTimeGWT:Body").add(p.widget());
                if (p.getSolverWarningType() != null) {
                    new SolverWarnings(RootPanel.get((String)"UniTimeGWT:SolverWarnings"), p.getSolverWarningType());
                }
                return;
            }
            Label error = new Label(page == null ? MESSAGES.failedToLoadPageNotProvided() : MESSAGES.failedToLoadPageNotRegistered(page));
            error.setStyleName("unitime-ErrorMessage");
            RootPanel.get((String)"UniTimeGWT:Body").add((Widget)error);
        }
        catch (Exception e) {
            Label error = new Label(MESSAGES.failedToLoadPage(e.getMessage()));
            error.setStyleName("unitime-ErrorMessage");
            RootPanel.get((String)"UniTimeGWT:Body").add((Widget)error);
            UniTimeNotifications.error(MESSAGES.failedToLoadPage(e.getMessage()), e);
        }
    }

    public void initComponentAsync(final RootPanel panel, final Components comp) {
        GWT.runAsync((RunAsyncCallback)new RunAsyncCallback(){

            public void onSuccess() {
                comp.insert(panel);
            }

            public void onFailure(Throwable reason) {
            }
        });
    }

    public static void addGwtPageChangedHandler(GwtPageChangedHandler h) {
        iGwtPageChangedHandlers.add(h);
    }

    public static void fireGwtPageChanged(GwtPageChangeEvent event) {
        for (GwtPageChangedHandler h : iGwtPageChangedHandlers) {
            h.onChange(event);
        }
    }

    public static native void callGwtOnLoadIfExists();

    public static void reloadMenu() {
        for (Components c : Components.values()) {
            RootPanel p = RootPanel.get((String)c.id());
            if (p == null) continue;
            for (int i = 0; i < p.getWidgetCount(); ++i) {
                if (!(p.getWidget(i) instanceof UniTimeMenu)) continue;
                ((UniTimeMenu)p.getWidget(i)).reload();
            }
        }
    }

    public static final native NodeList<Element> getElementsByName(String var0);

    static final native boolean isLoadingDisplayed();

    public static interface GwtPageChangedHandler {
        public void onChange(GwtPageChangeEvent var1);
    }

    public static class GwtPageChangeEvent {
    }
}

