/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.InstructionalOfferingListFormInterface;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassCourseComparator;

public class InstructionalOfferingListForm
implements UniTimeForm,
InstructionalOfferingListFormInterface {
    private static final long serialVersionUID = -6985831814265952068L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private Map<Long, TreeSet<InstructionalOffering>> instructionalOfferings;
    private Collection<SubjectArea> subjectAreas;
    private String[] subjectAreaIds;
    private String courseNbr;
    private Boolean showNotOffered;
    private String buttonAction;
    private String subjectAreaAbbv;
    private Boolean isControl;
    private String ctrlInstrOfferingId;
    private Boolean divSec;
    private Boolean demand;
    private Boolean projectedDemand;
    private Boolean minPerWk;
    private Boolean limit;
    private Boolean snapshotLimit;
    private Boolean roomLimit;
    private Boolean manager;
    private Boolean datePattern;
    private Boolean timePattern;
    private Boolean preferences;
    private Boolean instructor;
    private Boolean timetable;
    private Boolean credit;
    private Boolean subpartCredit;
    private Boolean schedulePrintNote;
    private Boolean note;
    private Boolean consent;
    private Boolean title;
    private Boolean exams;
    private Boolean fundingDepartment;
    private String sortBy;
    private Boolean instructorAssignment;
    private Boolean lms;
    private String waitlist;
    private Boolean waitlistMode;

    public String getCtrlInstrOfferingId() {
        return this.ctrlInstrOfferingId;
    }

    public void setCtrlInstrOfferingId(String ctrlInstrOfferingId) {
        this.ctrlInstrOfferingId = ctrlInstrOfferingId;
    }

    public Boolean getIsControl() {
        return this.isControl;
    }

    public void setIsControl(Boolean isControl) {
        this.isControl = isControl;
    }

    public String getSubjectAreaAbbv() {
        return this.subjectAreaAbbv;
    }

    public void setSubjectAreaAbbv(String subjectAreaAbbv) {
        this.subjectAreaAbbv = subjectAreaAbbv;
    }

    public String getButtonAction() {
        return this.buttonAction;
    }

    public void setButtonAction(String buttonAction) {
        this.buttonAction = buttonAction;
    }

    public String getCourseNbr() {
        return this.courseNbr;
    }

    public void setCourseNbr(String courseNbr) {
        if (ApplicationProperty.CourseOfferingNumberUpperCase.isTrue()) {
            courseNbr = courseNbr.toUpperCase();
        }
        this.courseNbr = courseNbr;
    }

    public String[] getSubjectAreaIds() {
        return this.subjectAreaIds;
    }

    public void setSubjectAreaIds(String[] subjectAreaIds) {
        this.subjectAreaIds = subjectAreaIds;
    }

    @Override
    public void reset() {
        this.courseNbr = "";
        this.instructionalOfferings = null;
        this.subjectAreas = new ArrayList<SubjectArea>();
        this.divSec = false;
        this.demand = false;
        this.projectedDemand = false;
        this.minPerWk = false;
        this.limit = false;
        this.snapshotLimit = false;
        this.roomLimit = false;
        this.manager = false;
        this.datePattern = false;
        this.timePattern = false;
        this.preferences = false;
        this.instructor = false;
        this.timetable = false;
        this.credit = false;
        this.subpartCredit = false;
        this.schedulePrintNote = false;
        this.note = false;
        this.title = false;
        this.consent = false;
        this.exams = false;
        this.fundingDepartment = false;
        this.instructorAssignment = false;
        this.lms = false;
        this.waitlist = null;
        this.waitlistMode = null;
        this.sortBy = ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME);
    }

    public Map<Long, TreeSet<InstructionalOffering>> getInstructionalOfferings() {
        return this.instructionalOfferings;
    }

    public TreeSet<InstructionalOffering> getInstructionalOfferings(Long subjectAreaId) {
        return this.instructionalOfferings == null ? null : this.instructionalOfferings.get(subjectAreaId);
    }

    public void setInstructionalOfferings(Map<Long, TreeSet<InstructionalOffering>> instructionalOfferings) {
        this.instructionalOfferings = instructionalOfferings;
    }

    public Collection<SubjectArea> getSubjectAreas() {
        return this.subjectAreas;
    }

    public void setSubjectAreas(Collection<SubjectArea> subjectAreas) {
        this.subjectAreas = subjectAreas;
    }

    public Boolean getShowNotOffered() {
        return this.showNotOffered;
    }

    public void setShowNotOffered(Boolean showNotOffered) {
        this.showNotOffered = showNotOffered;
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.subjectAreaIds == null || this.subjectAreaIds.length == 0) {
            action.addFieldError("subjectAreaIds", MSG.errorSubjectRequired());
        }
    }

    @Override
    public Boolean getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(Boolean datePattern) {
        this.datePattern = datePattern;
    }

    @Override
    public Boolean getDemand() {
        return this.demand;
    }

    public void setDemand(Boolean demand) {
        this.demand = demand;
    }

    @Override
    public Boolean getDivSec() {
        return this.divSec;
    }

    public void setDivSec(Boolean divSec) {
        this.divSec = divSec;
    }

    @Override
    public Boolean getInstructor() {
        return this.instructor;
    }

    public void setInstructor(Boolean instructor) {
        this.instructor = instructor;
    }

    @Override
    public Boolean getLimit() {
        return this.limit;
    }

    public void setLimit(Boolean limit) {
        this.limit = limit;
    }

    @Override
    public Boolean getSnapshotLimit() {
        return this.snapshotLimit;
    }

    public void setSnapshotLimit(Boolean snapshotLimit) {
        this.snapshotLimit = snapshotLimit;
    }

    @Override
    public Boolean getManager() {
        return this.manager;
    }

    public void setManager(Boolean manager) {
        this.manager = manager;
    }

    @Override
    public Boolean getMinPerWk() {
        return this.minPerWk;
    }

    public void setMinPerWk(Boolean minPerWk) {
        this.minPerWk = minPerWk;
    }

    @Override
    public Boolean getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Boolean preferences) {
        this.preferences = preferences;
    }

    @Override
    public Boolean getProjectedDemand() {
        return this.projectedDemand;
    }

    public void setProjectedDemand(Boolean projectedDemand) {
        this.projectedDemand = projectedDemand;
    }

    @Override
    public Boolean getRoomLimit() {
        return this.roomLimit;
    }

    public void setRoomLimit(Boolean roomLimit) {
        this.roomLimit = roomLimit;
    }

    @Override
    public Boolean getTimePattern() {
        return this.timePattern;
    }

    public void setTimePattern(Boolean timePattern) {
        this.timePattern = timePattern;
    }

    @Override
    public Boolean getTimetable() {
        return this.timetable;
    }

    public void setTimetable(Boolean timetable) {
        this.timetable = timetable;
    }

    @Override
    public Boolean getCredit() {
        return this.credit;
    }

    public void setCredit(Boolean credit) {
        this.credit = credit;
    }

    @Override
    public Boolean getSubpartCredit() {
        return this.subpartCredit;
    }

    public void setSubpartCredit(Boolean subpartCredit) {
        this.subpartCredit = subpartCredit;
    }

    @Override
    public Boolean getSchedulePrintNote() {
        return this.schedulePrintNote;
    }

    public void setSchedulePrintNote(Boolean schedulePrintNote) {
        this.schedulePrintNote = schedulePrintNote;
    }

    @Override
    public Boolean getNote() {
        return this.note;
    }

    public void setNote(Boolean note) {
        this.note = note;
    }

    @Override
    public Boolean getConsent() {
        return this.consent;
    }

    public void setConsent(Boolean consent) {
        this.consent = consent;
    }

    @Override
    public Boolean getTitle() {
        return this.title;
    }

    public void setTitle(Boolean title) {
        this.title = title;
    }

    @Override
    public Boolean getExams() {
        return this.exams;
    }

    public void setExams(Boolean exams) {
        this.exams = exams;
    }

    public void setFundingDepartment(Boolean fundingDepartment) {
        this.fundingDepartment = fundingDepartment;
    }

    @Override
    public Boolean getInstructorAssignment() {
        return this.instructorAssignment;
    }

    public void setInstructorAssignment(Boolean instructorAssignment) {
        this.instructorAssignment = instructorAssignment;
    }

    @Override
    public String getWaitlist() {
        return this.waitlist;
    }

    public void setWaitlist(String waitlist) {
        this.waitlist = waitlist;
    }

    @Override
    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String[] getSortByOptions() {
        return ClassCourseComparator.getNames();
    }

    public Boolean getEnrollmentInformation() {
        return this.getDemand() != false && this.getProjectedDemand() != false && this.getLimit() != false && this.getRoomLimit() != false;
    }

    public void setEnrollmentInformation() {
    }

    public Boolean getDateTimeInformation() {
        return this.getDatePattern() != false && this.getMinPerWk() != false && this.getTimePattern() != false;
    }

    public void setDateTimeInformation() {
    }

    public Boolean getCatalogInformation() {
        return Boolean.valueOf(this.getTitle() != false && this.getCredit() != false && this.getSubpartCredit() != false && this.getConsent() != false && this.getSchedulePrintNote() != false) != false && this.getLms() != false;
    }

    public void setCatalogInformation() {
    }

    public boolean areAllCoursesGiven() {
        return !(this.getCourseNbr() != null && !this.getCourseNbr().isEmpty() || !"A".equals(this.getWaitlist()) && this.getWaitlist() != null && !this.getWaitlist().isEmpty());
    }

    @Override
    public Boolean getFundingDepartment() {
        return this.fundingDepartment;
    }

    @Override
    public Boolean getLms() {
        return this.lms;
    }

    public void setLms(Boolean lms) {
        this.lms = lms;
    }

    @Override
    public Boolean getWaitlistMode() {
        return this.waitlistMode;
    }

    public void setWaitlistMode(Boolean waitlistMode) {
        this.waitlistMode = waitlistMode;
    }

    public int getSubjectAreaListSize() {
        return Math.min(7, this.getSubjectAreas().size());
    }
}

