/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.util.ComboBoxLookup;

public class ExamsForm
implements UniTimeForm {
    private static final long serialVersionUID = 8434268097497866325L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static final ExaminationMessages XMSG = Localization.create(ExaminationMessages.class);
    private String iOp = null;
    private Long iSession = null;
    private String iSubjectArea = null;
    private Collection<ComboBoxLookup> iSubjectAreas = null;
    private List<ComboBoxLookup> iSessions = null;
    private String iTable = null;
    private int iNrColumns;
    private int iNrRows;
    private Long iExamType;
    private String iMessage;
    private String iUser;
    private String iPassword;

    @Override
    public void validate(UniTimeAction action) {
    }

    @Override
    public void reset() {
        this.iOp = null;
        this.iTable = null;
        this.iNrColumns = 0;
        this.iNrRows = 0;
        this.iExamType = null;
        this.iSession = null;
        this.iUser = null;
        this.iPassword = null;
        this.iMessage = null;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getSubjectArea() {
        return this.iSubjectArea;
    }

    public void setSubjectArea(String subjectArea) {
        this.iSubjectArea = subjectArea;
    }

    public Collection<ComboBoxLookup> getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public Long getSession() {
        return this.iSession;
    }

    public void setSession(Long session) {
        this.iSession = session;
    }

    public Collection<ComboBoxLookup> getSessions() {
        return this.iSessions;
    }

    public Boolean canDisplayAllSubjectsAtOnce() {
        Boolean displayAll = false;
        if (this.iSession != null) {
            String queryStr = "select count(e) from Exam e where e.session.uniqueId = :sessionId";
            int count = ((Number)SessionDAO.getInstance().getSession().createQuery(queryStr, Number.class).setParameter("sessionId", (Object)this.iSession).setCacheable(true).uniqueResult()).intValue();
            if (count <= 300) {
                displayAll = true;
            }
        }
        return displayAll;
    }

    public void load(HttpSession session) {
        this.setSubjectArea(session.getAttribute("Exams.subjectArea") == null ? null : (String)session.getAttribute("Exams.subjectArea"));
        this.iSessions = new ArrayList<ComboBoxLookup>();
        this.setSession(session.getAttribute("Exams.session") == null ? null : (Long)session.getAttribute("Exams.session"));
        Long lastSessionId = null;
        boolean hasSession = false;
        for (Session s : Session.getAllSessions()) {
            if (s.getStatusType() == null || !s.canNoRoleReportExamFinal() && !s.canNoRoleReportExamMidterm() || !Exam.hasTimetable(s.getUniqueId())) continue;
            lastSessionId = s.getUniqueId();
            if (s.getUniqueId().equals(this.getSession())) {
                hasSession = true;
            }
            this.iSessions.add(new ComboBoxLookup(s.getLabel(), s.getUniqueId().toString()));
        }
        if (!hasSession) {
            this.setSession(null);
            this.setSubjectArea(null);
        }
        if (this.getSession() == null && lastSessionId != null) {
            this.setSession(lastSessionId);
        }
        this.iSubjectAreas = new ArrayList<ComboBoxLookup>();
        if (this.canDisplayAllSubjectsAtOnce().booleanValue()) {
            this.iSubjectAreas.add(new ComboBoxLookup(MSG.allSubjects(), "--ALL--"));
        } else if ("--ALL--".equals(this.iSubjectArea)) {
            this.iSubjectArea = null;
        }
        boolean hasSubject = false;
        if (this.iSession != null) {
            for (SubjectArea subject : SubjectArea.getAllSubjectAreas(this.iSession)) {
                if (subject.getSubjectAreaAbbreviation().equals(this.iSubjectArea)) {
                    hasSubject = true;
                }
                this.iSubjectAreas.add(new ComboBoxLookup(subject.getSubjectAreaAbbreviation(), subject.getSubjectAreaAbbreviation()));
            }
        }
        if (!hasSubject && !"--ALL--".equals(this.iSubjectArea)) {
            this.iSubjectArea = null;
        }
        this.setExamType(session.getAttribute("Exams.examType") == null ? this.iExamType : (Long)session.getAttribute("Exams.examType"));
    }

    public void save(HttpSession session) {
        if (this.getSubjectArea() == null) {
            session.removeAttribute("Exams.subjectArea");
        } else {
            session.setAttribute("Exams.subjectArea", (Object)this.getSubjectArea());
        }
        session.setAttribute("Exams.examType", (Object)this.getExamType());
        if (this.getSession() == null) {
            session.removeAttribute("Exams.session");
        } else {
            session.setAttribute("Exams.session", (Object)this.getSession());
        }
    }

    public void setTable(String table, int cols, int rows) {
        this.iTable = table;
        this.iNrColumns = cols;
        this.iNrRows = rows;
    }

    public String getTable() {
        return this.iTable;
    }

    public int getNrRows() {
        return this.iNrRows;
    }

    public int getNrColumns() {
        return this.iNrColumns;
    }

    public Long getExamType() {
        return this.iExamType;
    }

    public void setExamType(Long type) {
        this.iExamType = type;
    }

    public String getUsername() {
        return this.iUser;
    }

    public void setUsername(String user) {
        this.iUser = user;
    }

    public String getPassword() {
        return this.iPassword;
    }

    public void setPassword(String password) {
        this.iPassword = password;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public String getExamTypeLabel() {
        ExamType type = this.iExamType == null ? null : (ExamType)ExamTypeDAO.getInstance().get(this.iExamType);
        return type == null ? "" : type.getLabel();
    }

    public boolean isFinals() {
        ExamType type = this.iExamType == null ? null : (ExamType)ExamTypeDAO.getInstance().get(this.iExamType);
        return type == null || type.getType() == 0;
    }

    public String getSessionLabel() {
        if (this.iSessions == null) {
            return "";
        }
        for (ComboBoxLookup s : this.iSessions) {
            if (!Long.valueOf(s.getValue()).equals(this.getSession())) continue;
            return s.getLabel();
        }
        return "";
    }

    public String getEmptyMessage() {
        if (this.getSession() == null) {
            return XMSG.infoNoExaminationsAvailable();
        }
        if (this.getSubjectArea() == null || this.getSubjectArea().isEmpty()) {
            if (XMSG.buttonApply().equals(this.iOp)) {
                return XMSG.infoNoSubjectAreaSelected();
            }
            return null;
        }
        if ("--ALL--".equals(this.getSubjectArea())) {
            return XMSG.infoNoExaminationsAvailableForSession(this.getExamTypeLabel(), this.getSessionLabel());
        }
        return XMSG.infoNoExaminationsAvailableForSubject(this.getExamTypeLabel(), this.getSubjectArea());
    }
}

