/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.ClassListFormInterface;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.util.Constants;

public class ClassListForm
implements UniTimeForm,
ClassListFormInterface {
    private static final long serialVersionUID = -6985831814265952068L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private Collection<Class_> classes;
    private Collection<SubjectArea> subjectAreas;
    private String[] subjectAreaIds;
    private String courseNbr;
    private String buttonAction;
    private String subjectAreaAbbv;
    private String ctrlInstrOfferingId;
    private Boolean demandIsVisible;
    private Boolean demand;
    private Boolean limit;
    private Boolean snapshotLimit;
    private Boolean roomLimit;
    private Boolean timePattern;
    private Boolean datePattern;
    private Boolean instructor;
    private Boolean preferences;
    private Boolean timetable;
    private Boolean manager;
    private Boolean fundingDepartment;
    private Boolean divSec;
    private Boolean schedulePrintNote;
    private Boolean note;
    private Boolean exams;
    private Boolean instructorAssignment;
    private Boolean lms;
    private boolean includeCancelledClasses;
    private boolean filterNeedInstructor;
    private String sortBy;
    private String filterAssignedRoom;
    private String filterInstructor;
    private String filterManager;
    private String filterIType;
    private boolean filterAssignedTimeMon;
    private boolean filterAssignedTimeTue;
    private boolean filterAssignedTimeWed;
    private boolean filterAssignedTimeThu;
    private boolean filterAssignedTimeFri;
    private boolean filterAssignedTimeSat;
    private boolean filterAssignedTimeSun;
    private String filterAssignedTimeHour;
    private String filterAssignedTimeMin;
    private String filterAssignedTimeAmPm;
    private String filterAssignedTimeLength;
    private boolean sortByKeepSubparts;
    private boolean showCrossListedClasses;
    private boolean returnAllControlClassesForSubjects;
    private boolean sessionInLLREditStatus;

    public String getCtrlInstrOfferingId() {
        return this.ctrlInstrOfferingId;
    }

    public void setCtrlInstrOfferingId(String ctrlInstrOfferingId) {
        this.ctrlInstrOfferingId = ctrlInstrOfferingId;
    }

    public String getSubjectAreaAbbv() {
        return this.subjectAreaAbbv;
    }

    public void setSubjectAreaAbbv(String subjectAreaAbbv) {
        this.subjectAreaAbbv = subjectAreaAbbv;
    }

    public String getButtonAction() {
        return this.buttonAction;
    }

    public void setButtonAction(String buttonAction) {
        this.buttonAction = buttonAction;
    }

    @Override
    public String getCourseNbr() {
        return this.courseNbr;
    }

    public void setCourseNbr(String courseNbr) {
        this.courseNbr = courseNbr;
    }

    @Override
    public String[] getSubjectAreaIds() {
        return this.subjectAreaIds;
    }

    public void setSubjectAreaIds(String[] subjectAreaIds) {
        this.subjectAreaIds = subjectAreaIds;
    }

    @Override
    public void reset() {
        this.courseNbr = "";
        this.classes = new ArrayList<Class_>();
        this.subjectAreas = new ArrayList<SubjectArea>();
        this.subjectAreaIds = new String[0];
        this.demandIsVisible = false;
        this.demand = false;
        this.limit = false;
        this.snapshotLimit = false;
        this.roomLimit = false;
        this.datePattern = false;
        this.timePattern = false;
        this.instructor = false;
        this.preferences = false;
        this.timetable = false;
        this.manager = false;
        this.fundingDepartment = false;
        this.divSec = false;
        this.schedulePrintNote = false;
        this.note = false;
        this.exams = false;
        this.instructorAssignment = false;
        this.lms = false;
        this.includeCancelledClasses = false;
        this.filterNeedInstructor = false;
        this.sortBy = ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME);
        this.filterInstructor = "";
        this.filterManager = "";
        this.filterAssignedRoom = "";
        this.filterIType = "";
        this.filterAssignedTimeMon = false;
        this.filterAssignedTimeTue = false;
        this.filterAssignedTimeWed = false;
        this.filterAssignedTimeThu = false;
        this.filterAssignedTimeFri = false;
        this.filterAssignedTimeSat = false;
        this.filterAssignedTimeSun = false;
        this.filterAssignedTimeHour = "";
        this.filterAssignedTimeMin = "";
        this.filterAssignedTimeAmPm = "";
        this.filterAssignedTimeLength = "";
        this.sortByKeepSubparts = false;
        this.showCrossListedClasses = false;
        this.returnAllControlClassesForSubjects = false;
        this.sessionInLLREditStatus = false;
    }

    public Collection<Class_> getClasses() {
        return this.classes;
    }

    public void setClasses(Collection<Class_> classes) {
        this.classes = classes;
    }

    public Collection<SubjectArea> getSubjectAreas() {
        return this.subjectAreas;
    }

    public void setSubjectAreas(Collection<SubjectArea> subjectAreas) {
        this.subjectAreas = subjectAreas;
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.subjectAreaIds == null || this.subjectAreaIds.length == 0) {
            action.addFieldError("subjectAreaIds", MSG.errorSubjectRequired());
        }
    }

    @Override
    public Boolean getInstructor() {
        return this.instructor;
    }

    public void setInstructor(Boolean instructor) {
        this.instructor = instructor;
    }

    @Override
    public Boolean getLimit() {
        return this.limit;
    }

    public void setLimit(Boolean limit) {
        this.limit = limit;
    }

    @Override
    public Boolean getSnapshotLimit() {
        return this.snapshotLimit;
    }

    public void setSnapshotLimit(Boolean snapshotLimit) {
        this.snapshotLimit = snapshotLimit;
    }

    @Override
    public Boolean getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Boolean preferences) {
        this.preferences = preferences;
    }

    @Override
    public Boolean getRoomLimit() {
        return this.roomLimit;
    }

    public void setRoomLimit(Boolean roomLimit) {
        this.roomLimit = roomLimit;
    }

    @Override
    public Boolean getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(Boolean datePattern) {
        this.datePattern = datePattern;
    }

    @Override
    public Boolean getTimePattern() {
        return this.timePattern;
    }

    public void setTimePattern(Boolean timePattern) {
        this.timePattern = timePattern;
    }

    @Override
    public Boolean getTimetable() {
        return this.timetable;
    }

    public void setTimetable(Boolean timetable) {
        this.timetable = timetable;
    }

    @Override
    public String getSortBy() {
        return this.sortBy;
    }

    @Override
    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String[] getSortByOptions() {
        return ClassCourseComparator.getNames();
    }

    @Override
    public String getFilterManager() {
        return this.filterManager;
    }

    @Override
    public void setFilterManager(String filterManager) {
        this.filterManager = filterManager;
    }

    @Override
    public String[] getFilterManagers() {
        return this.filterManager == null ? new String[]{} : this.filterManager.split(",");
    }

    @Override
    public void setFilterManagers(String[] filterManagers) {
        this.filterManager = "";
        if (filterManagers != null) {
            for (String filterManager : filterManagers) {
                this.filterManager = this.filterManager + (this.filterManager.isEmpty() ? "" : ",") + filterManager;
            }
        }
    }

    @Override
    public String getFilterAssignedRoom() {
        return this.filterAssignedRoom;
    }

    @Override
    public void setFilterAssignedRoom(String filterAssignedRoom) {
        this.filterAssignedRoom = filterAssignedRoom;
    }

    @Override
    public String getFilterInstructor() {
        return this.filterInstructor;
    }

    public void setFilterInstructor(String filterInstructor) {
        this.filterInstructor = filterInstructor;
    }

    @Override
    public String getFilterIType() {
        return this.filterIType;
    }

    @Override
    public void setFilterIType(String filterIType) {
        this.filterIType = filterIType;
    }

    public boolean getFilterAssignedTimeMon() {
        return this.filterAssignedTimeMon;
    }

    public void setFilterAssignedTimeMon(boolean filterAssignedTimeMon) {
        this.filterAssignedTimeMon = filterAssignedTimeMon;
    }

    public boolean getFilterAssignedTimeTue() {
        return this.filterAssignedTimeTue;
    }

    public void setFilterAssignedTimeTue(boolean filterAssignedTimeTue) {
        this.filterAssignedTimeTue = filterAssignedTimeTue;
    }

    public boolean getFilterAssignedTimeWed() {
        return this.filterAssignedTimeWed;
    }

    public void setFilterAssignedTimeWed(boolean filterAssignedTimeWed) {
        this.filterAssignedTimeWed = filterAssignedTimeWed;
    }

    public boolean getFilterAssignedTimeThu() {
        return this.filterAssignedTimeThu;
    }

    public void setFilterAssignedTimeThu(boolean filterAssignedTimeThu) {
        this.filterAssignedTimeThu = filterAssignedTimeThu;
    }

    public boolean getFilterAssignedTimeFri() {
        return this.filterAssignedTimeFri;
    }

    public void setFilterAssignedTimeFri(boolean filterAssignedTimeFri) {
        this.filterAssignedTimeFri = filterAssignedTimeFri;
    }

    public boolean getFilterAssignedTimeSat() {
        return this.filterAssignedTimeSat;
    }

    public void setFilterAssignedTimeSat(boolean filterAssignedTimeSat) {
        this.filterAssignedTimeSat = filterAssignedTimeSat;
    }

    public boolean getFilterAssignedTimeSun() {
        return this.filterAssignedTimeSun;
    }

    public void setFilterAssignedTimeSun(boolean filterAssignedTimeSun) {
        this.filterAssignedTimeSun = filterAssignedTimeSun;
    }

    public String getFilterAssignedTimeHour() {
        return this.filterAssignedTimeHour;
    }

    public void setFilterAssignedTimeHour(String filterAssignedTimeHour) {
        this.filterAssignedTimeHour = filterAssignedTimeHour;
    }

    public String getFilterAssignedTimeMin() {
        return this.filterAssignedTimeMin;
    }

    public void setFilterAssignedTimeMin(String filterAssignedTimeMin) {
        this.filterAssignedTimeMin = filterAssignedTimeMin;
    }

    public String getFilterAssignedTimeAmPm() {
        return this.filterAssignedTimeAmPm;
    }

    public void setFilterAssignedTimeAmPm(String filterAssignedTimeAmPm) {
        this.filterAssignedTimeAmPm = filterAssignedTimeAmPm;
    }

    public String getFilterAssignedTimeLength() {
        return "0".equals(this.filterAssignedTimeLength) ? "" : this.filterAssignedTimeLength;
    }

    public void setFilterAssignedTimeLength(String filterAssignedTimeLength) {
        this.filterAssignedTimeLength = filterAssignedTimeLength;
    }

    public String[] getFilterAssignedTimeHours() {
        return new String[]{"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
    }

    public String[] getFilterAssignedTimeMins() {
        return new String[]{"", "00", "05", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
    }

    public String[] getFilterAssignedTimeAmPms() {
        return new String[]{"", MSG.timeAm(), MSG.timePm()};
    }

    public String[] getFilterAssignedTimeLengths() {
        String[] ret = new String[41];
        ret[0] = "";
        for (int i = 1; i < ret.length; ++i) {
            ret[i] = String.valueOf(5 * i);
        }
        return ret;
    }

    @Override
    public int getFilterDayCode() {
        int dayCode = 0;
        if (this.filterAssignedTimeMon) {
            dayCode += Constants.DAY_CODES[0];
        }
        if (this.filterAssignedTimeTue) {
            dayCode += Constants.DAY_CODES[1];
        }
        if (this.filterAssignedTimeWed) {
            dayCode += Constants.DAY_CODES[2];
        }
        if (this.filterAssignedTimeThu) {
            dayCode += Constants.DAY_CODES[3];
        }
        if (this.filterAssignedTimeFri) {
            dayCode += Constants.DAY_CODES[4];
        }
        if (this.filterAssignedTimeSat) {
            dayCode += Constants.DAY_CODES[5];
        }
        if (this.filterAssignedTimeSun) {
            dayCode += Constants.DAY_CODES[6];
        }
        return dayCode;
    }

    @Override
    public void setFilterDayCode(int dayCode) {
        if (dayCode >= 0) {
            this.filterAssignedTimeMon = (dayCode & Constants.DAY_CODES[0]) != 0;
            this.filterAssignedTimeTue = (dayCode & Constants.DAY_CODES[1]) != 0;
            this.filterAssignedTimeWed = (dayCode & Constants.DAY_CODES[2]) != 0;
            this.filterAssignedTimeThu = (dayCode & Constants.DAY_CODES[3]) != 0;
            this.filterAssignedTimeFri = (dayCode & Constants.DAY_CODES[4]) != 0;
            this.filterAssignedTimeSat = (dayCode & Constants.DAY_CODES[5]) != 0;
            this.filterAssignedTimeSun = (dayCode & Constants.DAY_CODES[6]) != 0;
        } else {
            this.filterAssignedTimeMon = false;
            this.filterAssignedTimeTue = false;
            this.filterAssignedTimeWed = false;
            this.filterAssignedTimeThu = false;
            this.filterAssignedTimeFri = false;
            this.filterAssignedTimeSat = false;
            this.filterAssignedTimeSun = false;
        }
    }

    @Override
    public int getFilterStartSlot() {
        try {
            boolean morn;
            int hour = Integer.parseInt(this.filterAssignedTimeHour);
            int min = Integer.parseInt(this.filterAssignedTimeMin);
            boolean bl = morn = !MSG.timePm().equals(this.filterAssignedTimeAmPm);
            if (hour == 12) {
                hour = 0;
            }
            int startTime = (hour + (morn ? 0 : 12)) % 24 * 60 + min;
            return (startTime - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public void setFilterStartSlot(int startSlot) {
        if (startSlot >= 0) {
            int startMin = startSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
            int min = startMin % 60;
            int startHour = startMin / 60;
            boolean morn = startHour < 12;
            int hour = startHour % 12;
            if (hour == 0) {
                hour = 12;
            }
            this.filterAssignedTimeHour = String.valueOf(hour);
            this.filterAssignedTimeMin = (min < 10 ? "0" : "") + min;
            this.filterAssignedTimeAmPm = morn ? MSG.timeAm() : MSG.timePm();
        } else {
            this.filterAssignedTimeHour = "";
            this.filterAssignedTimeMin = "";
            this.filterAssignedTimeAmPm = "";
        }
    }

    @Override
    public int getFilterLength() {
        try {
            return Integer.parseInt(this.filterAssignedTimeLength);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public void setFilterLength(int length) {
        this.filterAssignedTimeLength = length >= 0 ? String.valueOf(length) : "";
    }

    @Override
    public boolean getSortByKeepSubparts() {
        return this.sortByKeepSubparts;
    }

    @Override
    public void setSortByKeepSubparts(boolean sortByKeepSubparts) {
        this.sortByKeepSubparts = sortByKeepSubparts;
    }

    @Override
    public boolean isReturnAllControlClassesForSubjects() {
        return this.returnAllControlClassesForSubjects;
    }

    public void setReturnAllControlClassesForSubjects(boolean returnAllControlClassesForSubjects) {
        this.returnAllControlClassesForSubjects = returnAllControlClassesForSubjects;
    }

    public boolean isSessionInLLREditStatus() {
        return this.sessionInLLREditStatus;
    }

    public void setSessionInLLREditStatus(boolean sessionInLLREditStatus) {
        this.sessionInLLREditStatus = sessionInLLREditStatus;
    }

    @Override
    public Boolean getDemand() {
        return this.demand;
    }

    @Override
    public Boolean getProjectedDemand() {
        return false;
    }

    @Override
    public Boolean getMinPerWk() {
        return false;
    }

    @Override
    public Boolean getDivSec() {
        return this.divSec;
    }

    public void setDivSec(Boolean divSec) {
        this.divSec = divSec;
    }

    @Override
    public Boolean getManager() {
        return this.manager;
    }

    @Override
    public Boolean getFundingDepartment() {
        return this.fundingDepartment;
    }

    public void setManager(Boolean manager) {
        this.manager = manager;
    }

    @Override
    public Boolean getCredit() {
        return false;
    }

    @Override
    public Boolean getSubpartCredit() {
        return false;
    }

    @Override
    public Boolean getSchedulePrintNote() {
        return this.schedulePrintNote;
    }

    public void setSchedulePrintNote(Boolean schedulePrintNote) {
        this.schedulePrintNote = schedulePrintNote;
    }

    @Override
    public Boolean getNote() {
        return this.note;
    }

    public void setNote(Boolean note) {
        this.note = note;
    }

    @Override
    public Boolean getExams() {
        return this.exams;
    }

    public void setExams(Boolean exams) {
        this.exams = exams;
    }

    @Override
    public Boolean getConsent() {
        return false;
    }

    @Override
    public Boolean getTitle() {
        return false;
    }

    public void setDemand(Boolean demand) {
        this.demand = demand;
    }

    public Boolean getDemandIsVisible() {
        return this.demandIsVisible;
    }

    public void setDemandIsVisible(Boolean demandIsVisible) {
        this.demandIsVisible = demandIsVisible;
    }

    @Override
    public boolean getShowCrossListedClasses() {
        return this.showCrossListedClasses;
    }

    @Override
    public void setShowCrossListedClasses(boolean showCrossListedClasses) {
        this.showCrossListedClasses = showCrossListedClasses;
    }

    @Override
    public boolean getIncludeCancelledClasses() {
        return this.includeCancelledClasses;
    }

    public void setIncludeCancelledClasses(boolean includeCancelledClasses) {
        this.includeCancelledClasses = includeCancelledClasses;
    }

    public void setFundingDepartment(Boolean fundingDepartment) {
        this.fundingDepartment = fundingDepartment;
    }

    @Override
    public Boolean getInstructorAssignment() {
        return this.instructorAssignment;
    }

    public void setInstructorAssignment(Boolean instructorAssignment) {
        this.instructorAssignment = instructorAssignment;
    }

    @Override
    public Boolean getLms() {
        return this.lms;
    }

    public void setLms(Boolean lms) {
        this.lms = lms;
    }

    @Override
    public boolean getFilterNeedInstructor() {
        return this.filterNeedInstructor;
    }

    public void setFilterNeedInstructor(boolean filterNeedInstructor) {
        this.filterNeedInstructor = filterNeedInstructor;
    }

    @Override
    public String getWaitlist() {
        return null;
    }

    @Override
    public Boolean getWaitlistMode() {
        return false;
    }

    public int getSubjectAreaListSize() {
        return Math.min(7, this.getSubjectAreas().size());
    }
}

